/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Customer's consent for the owner change request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Consent implements SdkPojo, Serializable, ToCopyableBuilder<Consent.Builder, Consent> {
    private static final SdkField<Double> MAX_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxPrice").getter(getter(Consent::maxPrice)).setter(setter(Builder::maxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Currency").getter(getter(Consent::currency)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_PRICE_FIELD,
            CURRENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double maxPrice;

    private final String currency;

    private Consent(BuilderImpl builder) {
        this.maxPrice = builder.maxPrice;
        this.currency = builder.currency;
    }

    /**
     * <p>
     * Maximum amount the customer agreed to accept.
     * </p>
     * 
     * @return Maximum amount the customer agreed to accept.
     */
    public final Double maxPrice() {
        return maxPrice;
    }

    /**
     * <p>
     * Currency for the <code>MaxPrice</code>.
     * </p>
     * 
     * @return Currency for the <code>MaxPrice</code>.
     */
    public final String currency() {
        return currency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(currency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Consent)) {
            return false;
        }
        Consent other = (Consent) obj;
        return Objects.equals(maxPrice(), other.maxPrice()) && Objects.equals(currency(), other.currency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Consent").add("MaxPrice", maxPrice()).add("Currency", currency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxPrice":
            return Optional.ofNullable(clazz.cast(maxPrice()));
        case "Currency":
            return Optional.ofNullable(clazz.cast(currency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Consent, T> g) {
        return obj -> g.apply((Consent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Consent> {
        /**
         * <p>
         * Maximum amount the customer agreed to accept.
         * </p>
         * 
         * @param maxPrice
         *        Maximum amount the customer agreed to accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPrice(Double maxPrice);

        /**
         * <p>
         * Currency for the <code>MaxPrice</code>.
         * </p>
         * 
         * @param currency
         *        Currency for the <code>MaxPrice</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currency(String currency);
    }

    static final class BuilderImpl implements Builder {
        private Double maxPrice;

        private String currency;

        private BuilderImpl() {
        }

        private BuilderImpl(Consent model) {
            maxPrice(model.maxPrice);
            currency(model.currency);
        }

        public final Double getMaxPrice() {
            return maxPrice;
        }

        public final void setMaxPrice(Double maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(Double maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public Consent build() {
            return new Consent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
