/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a delegation signer (DS) record that was created in the registry by <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AssociateDelegationSignerToDomain.html"
 * >AssociateDelegationSignerToDomain</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnssecSigningAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DnssecSigningAttributes.Builder, DnssecSigningAttributes> {
    private static final SdkField<Integer> ALGORITHM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Algorithm").getter(getter(DnssecSigningAttributes::algorithm)).setter(setter(Builder::algorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Algorithm").build()).build();

    private static final SdkField<Integer> FLAGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Flags")
            .getter(getter(DnssecSigningAttributes::flags)).setter(setter(Builder::flags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flags").build()).build();

    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicKey").getter(getter(DnssecSigningAttributes::publicKey)).setter(setter(Builder::publicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, FLAGS_FIELD,
            PUBLIC_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer algorithm;

    private final Integer flags;

    private final String publicKey;

    private DnssecSigningAttributes(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.flags = builder.flags;
        this.publicKey = builder.publicKey;
    }

    /**
     * <p>
     * Algorithm which was used to generate the digest from the public key.
     * </p>
     * 
     * @return Algorithm which was used to generate the digest from the public key.
     */
    public final Integer algorithm() {
        return algorithm;
    }

    /**
     * <p>
     * Defines the type of key. It can be either a KSK (key-signing-key, value 257) or ZSK (zone-signing-key, value
     * 256). Using KSK is always encouraged. Only use ZSK if your DNS provider isn't Route 53 and you don’t have KSK
     * available.
     * </p>
     * <p>
     * If you have KSK and ZSK keys, always use KSK to create a delegations signer (DS) record. If you have ZSK keys
     * only – use ZSK to create a DS record.
     * </p>
     * 
     * @return Defines the type of key. It can be either a KSK (key-signing-key, value 257) or ZSK (zone-signing-key,
     *         value 256). Using KSK is always encouraged. Only use ZSK if your DNS provider isn't Route 53 and you
     *         don’t have KSK available.</p>
     *         <p>
     *         If you have KSK and ZSK keys, always use KSK to create a delegations signer (DS) record. If you have ZSK
     *         keys only – use ZSK to create a DS record.
     */
    public final Integer flags() {
        return flags;
    }

    /**
     * <p>
     * The base64-encoded public key part of the key pair that is passed to the registry.
     * </p>
     * 
     * @return The base64-encoded public key part of the key pair that is passed to the registry.
     */
    public final String publicKey() {
        return publicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithm());
        hashCode = 31 * hashCode + Objects.hashCode(flags());
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnssecSigningAttributes)) {
            return false;
        }
        DnssecSigningAttributes other = (DnssecSigningAttributes) obj;
        return Objects.equals(algorithm(), other.algorithm()) && Objects.equals(flags(), other.flags())
                && Objects.equals(publicKey(), other.publicKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnssecSigningAttributes").add("Algorithm", algorithm()).add("Flags", flags())
                .add("PublicKey", publicKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Algorithm":
            return Optional.ofNullable(clazz.cast(algorithm()));
        case "Flags":
            return Optional.ofNullable(clazz.cast(flags()));
        case "PublicKey":
            return Optional.ofNullable(clazz.cast(publicKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnssecSigningAttributes, T> g) {
        return obj -> g.apply((DnssecSigningAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnssecSigningAttributes> {
        /**
         * <p>
         * Algorithm which was used to generate the digest from the public key.
         * </p>
         * 
         * @param algorithm
         *        Algorithm which was used to generate the digest from the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithm(Integer algorithm);

        /**
         * <p>
         * Defines the type of key. It can be either a KSK (key-signing-key, value 257) or ZSK (zone-signing-key, value
         * 256). Using KSK is always encouraged. Only use ZSK if your DNS provider isn't Route 53 and you don’t have KSK
         * available.
         * </p>
         * <p>
         * If you have KSK and ZSK keys, always use KSK to create a delegations signer (DS) record. If you have ZSK keys
         * only – use ZSK to create a DS record.
         * </p>
         * 
         * @param flags
         *        Defines the type of key. It can be either a KSK (key-signing-key, value 257) or ZSK (zone-signing-key,
         *        value 256). Using KSK is always encouraged. Only use ZSK if your DNS provider isn't Route 53 and you
         *        don’t have KSK available.</p>
         *        <p>
         *        If you have KSK and ZSK keys, always use KSK to create a delegations signer (DS) record. If you have
         *        ZSK keys only – use ZSK to create a DS record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flags(Integer flags);

        /**
         * <p>
         * The base64-encoded public key part of the key pair that is passed to the registry.
         * </p>
         * 
         * @param publicKey
         *        The base64-encoded public key part of the key pair that is passed to the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);
    }

    static final class BuilderImpl implements Builder {
        private Integer algorithm;

        private Integer flags;

        private String publicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DnssecSigningAttributes model) {
            algorithm(model.algorithm);
            flags(model.flags);
            publicKey(model.publicKey);
        }

        public final Integer getAlgorithm() {
            return algorithm;
        }

        public final void setAlgorithm(Integer algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(Integer algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public final Integer getFlags() {
            return flags;
        }

        public final void setFlags(Integer flags) {
            this.flags = flags;
        }

        @Override
        public final Builder flags(Integer flags) {
            this.flags = flags;
            return this;
        }

        public final String getPublicKey() {
            return publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public DnssecSigningAttributes build() {
            return new DnssecSigningAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
