/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GetDomainDetail response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainDetailResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<GetDomainDetailResponse.Builder, GetDomainDetailResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetDomainDetailResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<List<Nameserver>> NAMESERVERS_FIELD = SdkField
            .<List<Nameserver>> builder(MarshallingType.LIST)
            .memberName("Nameservers")
            .getter(getter(GetDomainDetailResponse::nameservers))
            .setter(setter(Builder::nameservers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nameservers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Nameserver> builder(MarshallingType.SDK_POJO)
                                            .constructor(Nameserver::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoRenew").getter(getter(GetDomainDetailResponse::autoRenew)).setter(setter(Builder::autoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()).build();

    private static final SdkField<ContactDetail> ADMIN_CONTACT_FIELD = SdkField.<ContactDetail> builder(MarshallingType.SDK_POJO)
            .memberName("AdminContact").getter(getter(GetDomainDetailResponse::adminContact))
            .setter(setter(Builder::adminContact)).constructor(ContactDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminContact").build()).build();

    private static final SdkField<ContactDetail> REGISTRANT_CONTACT_FIELD = SdkField
            .<ContactDetail> builder(MarshallingType.SDK_POJO).memberName("RegistrantContact")
            .getter(getter(GetDomainDetailResponse::registrantContact)).setter(setter(Builder::registrantContact))
            .constructor(ContactDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantContact").build()).build();

    private static final SdkField<ContactDetail> TECH_CONTACT_FIELD = SdkField.<ContactDetail> builder(MarshallingType.SDK_POJO)
            .memberName("TechContact").getter(getter(GetDomainDetailResponse::techContact)).setter(setter(Builder::techContact))
            .constructor(ContactDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechContact").build()).build();

    private static final SdkField<Boolean> ADMIN_PRIVACY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AdminPrivacy").getter(getter(GetDomainDetailResponse::adminPrivacy))
            .setter(setter(Builder::adminPrivacy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminPrivacy").build()).build();

    private static final SdkField<Boolean> REGISTRANT_PRIVACY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RegistrantPrivacy").getter(getter(GetDomainDetailResponse::registrantPrivacy))
            .setter(setter(Builder::registrantPrivacy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantPrivacy").build()).build();

    private static final SdkField<Boolean> TECH_PRIVACY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TechPrivacy").getter(getter(GetDomainDetailResponse::techPrivacy)).setter(setter(Builder::techPrivacy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechPrivacy").build()).build();

    private static final SdkField<String> REGISTRAR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrarName").getter(getter(GetDomainDetailResponse::registrarName))
            .setter(setter(Builder::registrarName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrarName").build()).build();

    private static final SdkField<String> WHO_IS_SERVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhoIsServer").getter(getter(GetDomainDetailResponse::whoIsServer)).setter(setter(Builder::whoIsServer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhoIsServer").build()).build();

    private static final SdkField<String> REGISTRAR_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrarUrl").getter(getter(GetDomainDetailResponse::registrarUrl))
            .setter(setter(Builder::registrarUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrarUrl").build()).build();

    private static final SdkField<String> ABUSE_CONTACT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AbuseContactEmail").getter(getter(GetDomainDetailResponse::abuseContactEmail))
            .setter(setter(Builder::abuseContactEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbuseContactEmail").build()).build();

    private static final SdkField<String> ABUSE_CONTACT_PHONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AbuseContactPhone").getter(getter(GetDomainDetailResponse::abuseContactPhone))
            .setter(setter(Builder::abuseContactPhone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbuseContactPhone").build()).build();

    private static final SdkField<String> REGISTRY_DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryDomainId").getter(getter(GetDomainDetailResponse::registryDomainId))
            .setter(setter(Builder::registryDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryDomainId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(GetDomainDetailResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedDate").getter(getter(GetDomainDetailResponse::updatedDate)).setter(setter(Builder::updatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedDate").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate").getter(getter(GetDomainDetailResponse::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final SdkField<String> RESELLER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Reseller").getter(getter(GetDomainDetailResponse::reseller)).setter(setter(Builder::reseller))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reseller").build()).build();

    private static final SdkField<String> DNS_SEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DnsSec")
            .getter(getter(GetDomainDetailResponse::dnsSec)).setter(setter(Builder::dnsSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSec").build()).build();

    private static final SdkField<List<String>> STATUS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatusList")
            .getter(getter(GetDomainDetailResponse::statusList))
            .setter(setter(Builder::statusList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DnssecKey>> DNSSEC_KEYS_FIELD = SdkField
            .<List<DnssecKey>> builder(MarshallingType.LIST)
            .memberName("DnssecKeys")
            .getter(getter(GetDomainDetailResponse::dnssecKeys))
            .setter(setter(Builder::dnssecKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnssecKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DnssecKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(DnssecKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            NAMESERVERS_FIELD, AUTO_RENEW_FIELD, ADMIN_CONTACT_FIELD, REGISTRANT_CONTACT_FIELD, TECH_CONTACT_FIELD,
            ADMIN_PRIVACY_FIELD, REGISTRANT_PRIVACY_FIELD, TECH_PRIVACY_FIELD, REGISTRAR_NAME_FIELD, WHO_IS_SERVER_FIELD,
            REGISTRAR_URL_FIELD, ABUSE_CONTACT_EMAIL_FIELD, ABUSE_CONTACT_PHONE_FIELD, REGISTRY_DOMAIN_ID_FIELD,
            CREATION_DATE_FIELD, UPDATED_DATE_FIELD, EXPIRATION_DATE_FIELD, RESELLER_FIELD, DNS_SEC_FIELD, STATUS_LIST_FIELD,
            DNSSEC_KEYS_FIELD));

    private final String domainName;

    private final List<Nameserver> nameservers;

    private final Boolean autoRenew;

    private final ContactDetail adminContact;

    private final ContactDetail registrantContact;

    private final ContactDetail techContact;

    private final Boolean adminPrivacy;

    private final Boolean registrantPrivacy;

    private final Boolean techPrivacy;

    private final String registrarName;

    private final String whoIsServer;

    private final String registrarUrl;

    private final String abuseContactEmail;

    private final String abuseContactPhone;

    private final String registryDomainId;

    private final Instant creationDate;

    private final Instant updatedDate;

    private final Instant expirationDate;

    private final String reseller;

    private final String dnsSec;

    private final List<String> statusList;

    private final List<DnssecKey> dnssecKeys;

    private GetDomainDetailResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.nameservers = builder.nameservers;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
        this.registrarName = builder.registrarName;
        this.whoIsServer = builder.whoIsServer;
        this.registrarUrl = builder.registrarUrl;
        this.abuseContactEmail = builder.abuseContactEmail;
        this.abuseContactPhone = builder.abuseContactPhone;
        this.registryDomainId = builder.registryDomainId;
        this.creationDate = builder.creationDate;
        this.updatedDate = builder.updatedDate;
        this.expirationDate = builder.expirationDate;
        this.reseller = builder.reseller;
        this.dnsSec = builder.dnsSec;
        this.statusList = builder.statusList;
        this.dnssecKeys = builder.dnssecKeys;
    }

    /**
     * <p>
     * The name of a domain.
     * </p>
     * 
     * @return The name of a domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Nameservers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNameservers() {
        return nameservers != null && !(nameservers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name servers of the domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNameservers} method.
     * </p>
     * 
     * @return The name servers of the domain.
     */
    public final List<Nameserver> nameservers() {
        return nameservers;
    }

    /**
     * <p>
     * Specifies whether the domain registration is set to renew automatically.
     * </p>
     * 
     * @return Specifies whether the domain registration is set to renew automatically.
     */
    public final Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * <p>
     * Provides details about the domain administrative contact.
     * </p>
     * 
     * @return Provides details about the domain administrative contact.
     */
    public final ContactDetail adminContact() {
        return adminContact;
    }

    /**
     * <p>
     * Provides details about the domain registrant.
     * </p>
     * 
     * @return Provides details about the domain registrant.
     */
    public final ContactDetail registrantContact() {
        return registrantContact;
    }

    /**
     * <p>
     * Provides details about the domain technical contact.
     * </p>
     * 
     * @return Provides details about the domain technical contact.
     */
    public final ContactDetail techContact() {
        return techContact;
    }

    /**
     * <p>
     * Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>, WHOIS
     * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or
     * for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>, WHOIS queries return
     * the information that you entered for the admin contact.
     * </p>
     * 
     * @return Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
     *         WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
     *         domains) or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
     *         WHOIS queries return the information that you entered for the admin contact.
     */
    public final Boolean adminPrivacy() {
        return adminPrivacy;
    }

    /**
     * <p>
     * Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>, WHOIS
     * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or
     * for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>, WHOIS queries return
     * the information that you entered for the registrant contact (domain owner).
     * </p>
     * 
     * @return Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
     *         WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
     *         domains) or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
     *         WHOIS queries return the information that you entered for the registrant contact (domain owner).
     */
    public final Boolean registrantPrivacy() {
        return registrantPrivacy;
    }

    /**
     * <p>
     * Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>, WHOIS
     * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or
     * for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>, WHOIS queries return
     * the information that you entered for the technical contact.
     * </p>
     * 
     * @return Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
     *         WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
     *         domains) or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
     *         WHOIS queries return the information that you entered for the technical contact.
     */
    public final Boolean techPrivacy() {
        return techPrivacy;
    }

    /**
     * <p>
     * Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD are
     * registered by Amazon Registrar. All other domains are registered by our registrar associate, Gandi. The value for
     * domains that are registered by Gandi is <code>"GANDI SAS"</code>.
     * </p>
     * 
     * @return Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD
     *         are registered by Amazon Registrar. All other domains are registered by our registrar associate, Gandi.
     *         The value for domains that are registered by Gandi is <code>"GANDI SAS"</code>.
     */
    public final String registrarName() {
        return registrarName;
    }

    /**
     * <p>
     * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     * </p>
     * 
     * @return The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     */
    public final String whoIsServer() {
        return whoIsServer;
    }

    /**
     * <p>
     * Web address of the registrar.
     * </p>
     * 
     * @return Web address of the registrar.
     */
    public final String registrarUrl() {
        return registrarUrl;
    }

    /**
     * <p>
     * Email address to contact to report incorrect contact information for a domain, to report that the domain is being
     * used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
     * </p>
     * 
     * @return Email address to contact to report incorrect contact information for a domain, to report that the domain
     *         is being used to send spam, to report that someone is cybersquatting on a domain name, or report some
     *         other type of abuse.
     */
    public final String abuseContactEmail() {
        return abuseContactEmail;
    }

    /**
     * <p>
     * Phone number for reporting abuse.
     * </p>
     * 
     * @return Phone number for reporting abuse.
     */
    public final String abuseContactPhone() {
        return abuseContactPhone;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String registryDomainId() {
        return registryDomainId;
    }

    /**
     * <p>
     * The date when the domain was created as found in the response to a WHOIS query. The date and time is in Unix time
     * format and Coordinated Universal time (UTC).
     * </p>
     * 
     * @return The date when the domain was created as found in the response to a WHOIS query. The date and time is in
     *         Unix time format and Coordinated Universal time (UTC).
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The last updated date of the domain as found in the response to a WHOIS query. The date and time is in Unix time
     * format and Coordinated Universal time (UTC).
     * </p>
     * 
     * @return The last updated date of the domain as found in the response to a WHOIS query. The date and time is in
     *         Unix time format and Coordinated Universal time (UTC).
     */
    public final Instant updatedDate() {
        return updatedDate;
    }

    /**
     * <p>
     * The date when the registration for the domain is set to expire. The date and time is in Unix time format and
     * Coordinated Universal time (UTC).
     * </p>
     * 
     * @return The date when the registration for the domain is set to expire. The date and time is in Unix time format
     *         and Coordinated Universal time (UTC).
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * Reseller of the domain. Domains registered or transferred using Route 53 domains will have <code>"Amazon"</code>
     * as the reseller.
     * </p>
     * 
     * @return Reseller of the domain. Domains registered or transferred using Route 53 domains will have
     *         <code>"Amazon"</code> as the reseller.
     */
    public final String reseller() {
        return reseller;
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * 
     * @return Deprecated.
     */
    public final String dnsSec() {
        return dnsSec;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatusList() {
        return statusList != null && !(statusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
     * </p>
     * <p>
     * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
     * status codes that tell you the status of a variety of operations on a domain name, for example, registering a
     * domain name, transferring a domain name to another registrar, renewing the registration for a domain name, and so
     * on. All registrars use this same set of status codes.
     * </p>
     * <p>
     * For a current list of domain name status codes and an explanation of what each code means, go to the <a
     * href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the
     * ICANN website; web searches sometimes return an old version of the document.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusList} method.
     * </p>
     * 
     * @return An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status
     *         codes.</p>
     *         <p>
     *         ICANN, the organization that maintains a central database of domain names, has developed a set of domain
     *         name status codes that tell you the status of a variety of operations on a domain name, for example,
     *         registering a domain name, transferring a domain name to another registrar, renewing the registration for
     *         a domain name, and so on. All registrars use this same set of status codes.
     *         </p>
     *         <p>
     *         For a current list of domain name status codes and an explanation of what each code means, go to the <a
     *         href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on
     *         the ICANN website; web searches sometimes return an old version of the document.)
     */
    public final List<String> statusList() {
        return statusList;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnssecKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDnssecKeys() {
        return dnssecKeys != null && !(dnssecKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains information about the DNSSEC configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnssecKeys} method.
     * </p>
     * 
     * @return A complex type that contains information about the DNSSEC configuration.
     */
    public final List<DnssecKey> dnssecKeys() {
        return dnssecKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasNameservers() ? nameservers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(techContact());
        hashCode = 31 * hashCode + Objects.hashCode(adminPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(registrantPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(techPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(registrarName());
        hashCode = 31 * hashCode + Objects.hashCode(whoIsServer());
        hashCode = 31 * hashCode + Objects.hashCode(registrarUrl());
        hashCode = 31 * hashCode + Objects.hashCode(abuseContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(abuseContactPhone());
        hashCode = 31 * hashCode + Objects.hashCode(registryDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(updatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(reseller());
        hashCode = 31 * hashCode + Objects.hashCode(dnsSec());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusList() ? statusList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDnssecKeys() ? dnssecKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainDetailResponse)) {
            return false;
        }
        GetDomainDetailResponse other = (GetDomainDetailResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && hasNameservers() == other.hasNameservers()
                && Objects.equals(nameservers(), other.nameservers()) && Objects.equals(autoRenew(), other.autoRenew())
                && Objects.equals(adminContact(), other.adminContact())
                && Objects.equals(registrantContact(), other.registrantContact())
                && Objects.equals(techContact(), other.techContact()) && Objects.equals(adminPrivacy(), other.adminPrivacy())
                && Objects.equals(registrantPrivacy(), other.registrantPrivacy())
                && Objects.equals(techPrivacy(), other.techPrivacy()) && Objects.equals(registrarName(), other.registrarName())
                && Objects.equals(whoIsServer(), other.whoIsServer()) && Objects.equals(registrarUrl(), other.registrarUrl())
                && Objects.equals(abuseContactEmail(), other.abuseContactEmail())
                && Objects.equals(abuseContactPhone(), other.abuseContactPhone())
                && Objects.equals(registryDomainId(), other.registryDomainId())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(updatedDate(), other.updatedDate())
                && Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(reseller(), other.reseller())
                && Objects.equals(dnsSec(), other.dnsSec()) && hasStatusList() == other.hasStatusList()
                && Objects.equals(statusList(), other.statusList()) && hasDnssecKeys() == other.hasDnssecKeys()
                && Objects.equals(dnssecKeys(), other.dnssecKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDomainDetailResponse").add("DomainName", domainName())
                .add("Nameservers", hasNameservers() ? nameservers() : null).add("AutoRenew", autoRenew())
                .add("AdminContact", adminContact() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RegistrantContact", registrantContact() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TechContact", techContact() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AdminPrivacy", adminPrivacy()).add("RegistrantPrivacy", registrantPrivacy())
                .add("TechPrivacy", techPrivacy()).add("RegistrarName", registrarName()).add("WhoIsServer", whoIsServer())
                .add("RegistrarUrl", registrarUrl())
                .add("AbuseContactEmail", abuseContactEmail() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AbuseContactPhone", abuseContactPhone() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RegistryDomainId", registryDomainId()).add("CreationDate", creationDate())
                .add("UpdatedDate", updatedDate()).add("ExpirationDate", expirationDate()).add("Reseller", reseller())
                .add("DnsSec", dnsSec()).add("StatusList", hasStatusList() ? statusList() : null)
                .add("DnssecKeys", hasDnssecKeys() ? dnssecKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Nameservers":
            return Optional.ofNullable(clazz.cast(nameservers()));
        case "AutoRenew":
            return Optional.ofNullable(clazz.cast(autoRenew()));
        case "AdminContact":
            return Optional.ofNullable(clazz.cast(adminContact()));
        case "RegistrantContact":
            return Optional.ofNullable(clazz.cast(registrantContact()));
        case "TechContact":
            return Optional.ofNullable(clazz.cast(techContact()));
        case "AdminPrivacy":
            return Optional.ofNullable(clazz.cast(adminPrivacy()));
        case "RegistrantPrivacy":
            return Optional.ofNullable(clazz.cast(registrantPrivacy()));
        case "TechPrivacy":
            return Optional.ofNullable(clazz.cast(techPrivacy()));
        case "RegistrarName":
            return Optional.ofNullable(clazz.cast(registrarName()));
        case "WhoIsServer":
            return Optional.ofNullable(clazz.cast(whoIsServer()));
        case "RegistrarUrl":
            return Optional.ofNullable(clazz.cast(registrarUrl()));
        case "AbuseContactEmail":
            return Optional.ofNullable(clazz.cast(abuseContactEmail()));
        case "AbuseContactPhone":
            return Optional.ofNullable(clazz.cast(abuseContactPhone()));
        case "RegistryDomainId":
            return Optional.ofNullable(clazz.cast(registryDomainId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "UpdatedDate":
            return Optional.ofNullable(clazz.cast(updatedDate()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "Reseller":
            return Optional.ofNullable(clazz.cast(reseller()));
        case "DnsSec":
            return Optional.ofNullable(clazz.cast(dnsSec()));
        case "StatusList":
            return Optional.ofNullable(clazz.cast(statusList()));
        case "DnssecKeys":
            return Optional.ofNullable(clazz.cast(dnssecKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainDetailResponse, T> g) {
        return obj -> g.apply((GetDomainDetailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDomainDetailResponse> {
        /**
         * <p>
         * The name of a domain.
         * </p>
         * 
         * @param domainName
         *        The name of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name servers of the domain.
         * </p>
         * 
         * @param nameservers
         *        The name servers of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Collection<Nameserver> nameservers);

        /**
         * <p>
         * The name servers of the domain.
         * </p>
         * 
         * @param nameservers
         *        The name servers of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Nameserver... nameservers);

        /**
         * <p>
         * The name servers of the domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53domains.model.Nameserver.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.route53domains.model.Nameserver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53domains.model.Nameserver.Builder#build()} is called immediately
         * and its result is passed to {@link #nameservers(List<Nameserver>)}.
         * 
         * @param nameservers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53domains.model.Nameserver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nameservers(java.util.Collection<Nameserver>)
         */
        Builder nameservers(Consumer<Nameserver.Builder>... nameservers);

        /**
         * <p>
         * Specifies whether the domain registration is set to renew automatically.
         * </p>
         * 
         * @param autoRenew
         *        Specifies whether the domain registration is set to renew automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * Provides details about the domain administrative contact.
         * </p>
         * 
         * @param adminContact
         *        Provides details about the domain administrative contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminContact(ContactDetail adminContact);

        /**
         * <p>
         * Provides details about the domain administrative contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactDetail.Builder} avoiding the need
         * to create one manually via {@link ContactDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #adminContact(ContactDetail)}.
         * 
         * @param adminContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminContact(ContactDetail)
         */
        default Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return adminContact(ContactDetail.builder().applyMutation(adminContact).build());
        }

        /**
         * <p>
         * Provides details about the domain registrant.
         * </p>
         * 
         * @param registrantContact
         *        Provides details about the domain registrant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantContact(ContactDetail registrantContact);

        /**
         * <p>
         * Provides details about the domain registrant.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactDetail.Builder} avoiding the need
         * to create one manually via {@link ContactDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #registrantContact(ContactDetail)}.
         * 
         * @param registrantContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrantContact(ContactDetail)
         */
        default Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return registrantContact(ContactDetail.builder().applyMutation(registrantContact).build());
        }

        /**
         * <p>
         * Provides details about the domain technical contact.
         * </p>
         * 
         * @param techContact
         *        Provides details about the domain technical contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techContact(ContactDetail techContact);

        /**
         * <p>
         * Provides details about the domain technical contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactDetail.Builder} avoiding the need
         * to create one manually via {@link ContactDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #techContact(ContactDetail)}.
         * 
         * @param techContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #techContact(ContactDetail)
         */
        default Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return techContact(ContactDetail.builder().applyMutation(techContact).build());
        }

        /**
         * <p>
         * Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
         * WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
         * domains) or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
         * WHOIS queries return the information that you entered for the admin contact.
         * </p>
         * 
         * @param adminPrivacy
         *        Specifies whether contact information is concealed from WHOIS queries. If the value is
         *        <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar
         *        (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the
         *        value is <code>false</code>, WHOIS queries return the information that you entered for the admin
         *        contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPrivacy(Boolean adminPrivacy);

        /**
         * <p>
         * Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
         * WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
         * domains) or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
         * WHOIS queries return the information that you entered for the registrant contact (domain owner).
         * </p>
         * 
         * @param registrantPrivacy
         *        Specifies whether contact information is concealed from WHOIS queries. If the value is
         *        <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar
         *        (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the
         *        value is <code>false</code>, WHOIS queries return the information that you entered for the registrant
         *        contact (domain owner).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantPrivacy(Boolean registrantPrivacy);

        /**
         * <p>
         * Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
         * WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
         * domains) or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
         * WHOIS queries return the information that you entered for the technical contact.
         * </p>
         * 
         * @param techPrivacy
         *        Specifies whether contact information is concealed from WHOIS queries. If the value is
         *        <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar
         *        (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the
         *        value is <code>false</code>, WHOIS queries return the information that you entered for the technical
         *        contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techPrivacy(Boolean techPrivacy);

        /**
         * <p>
         * Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD are
         * registered by Amazon Registrar. All other domains are registered by our registrar associate, Gandi. The value
         * for domains that are registered by Gandi is <code>"GANDI SAS"</code>.
         * </p>
         * 
         * @param registrarName
         *        Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org
         *        TLD are registered by Amazon Registrar. All other domains are registered by our registrar associate,
         *        Gandi. The value for domains that are registered by Gandi is <code>"GANDI SAS"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrarName(String registrarName);

        /**
         * <p>
         * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
         * </p>
         * 
         * @param whoIsServer
         *        The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whoIsServer(String whoIsServer);

        /**
         * <p>
         * Web address of the registrar.
         * </p>
         * 
         * @param registrarUrl
         *        Web address of the registrar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrarUrl(String registrarUrl);

        /**
         * <p>
         * Email address to contact to report incorrect contact information for a domain, to report that the domain is
         * being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type
         * of abuse.
         * </p>
         * 
         * @param abuseContactEmail
         *        Email address to contact to report incorrect contact information for a domain, to report that the
         *        domain is being used to send spam, to report that someone is cybersquatting on a domain name, or
         *        report some other type of abuse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abuseContactEmail(String abuseContactEmail);

        /**
         * <p>
         * Phone number for reporting abuse.
         * </p>
         * 
         * @param abuseContactPhone
         *        Phone number for reporting abuse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abuseContactPhone(String abuseContactPhone);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param registryDomainId
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryDomainId(String registryDomainId);

        /**
         * <p>
         * The date when the domain was created as found in the response to a WHOIS query. The date and time is in Unix
         * time format and Coordinated Universal time (UTC).
         * </p>
         * 
         * @param creationDate
         *        The date when the domain was created as found in the response to a WHOIS query. The date and time is
         *        in Unix time format and Coordinated Universal time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The last updated date of the domain as found in the response to a WHOIS query. The date and time is in Unix
         * time format and Coordinated Universal time (UTC).
         * </p>
         * 
         * @param updatedDate
         *        The last updated date of the domain as found in the response to a WHOIS query. The date and time is in
         *        Unix time format and Coordinated Universal time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedDate(Instant updatedDate);

        /**
         * <p>
         * The date when the registration for the domain is set to expire. The date and time is in Unix time format and
         * Coordinated Universal time (UTC).
         * </p>
         * 
         * @param expirationDate
         *        The date when the registration for the domain is set to expire. The date and time is in Unix time
         *        format and Coordinated Universal time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * Reseller of the domain. Domains registered or transferred using Route 53 domains will have
         * <code>"Amazon"</code> as the reseller.
         * </p>
         * 
         * @param reseller
         *        Reseller of the domain. Domains registered or transferred using Route 53 domains will have
         *        <code>"Amazon"</code> as the reseller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reseller(String reseller);

        /**
         * <p>
         * Deprecated.
         * </p>
         * 
         * @param dnsSec
         *        Deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsSec(String dnsSec);

        /**
         * <p>
         * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
         * </p>
         * <p>
         * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
         * status codes that tell you the status of a variety of operations on a domain name, for example, registering a
         * domain name, transferring a domain name to another registrar, renewing the registration for a domain name,
         * and so on. All registrars use this same set of status codes.
         * </p>
         * <p>
         * For a current list of domain name status codes and an explanation of what each code means, go to the <a
         * href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the
         * ICANN website; web searches sometimes return an old version of the document.)
         * </p>
         * 
         * @param statusList
         *        An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status
         *        codes.</p>
         *        <p>
         *        ICANN, the organization that maintains a central database of domain names, has developed a set of
         *        domain name status codes that tell you the status of a variety of operations on a domain name, for
         *        example, registering a domain name, transferring a domain name to another registrar, renewing the
         *        registration for a domain name, and so on. All registrars use this same set of status codes.
         *        </p>
         *        <p>
         *        For a current list of domain name status codes and an explanation of what each code means, go to the
         *        <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
         *        (Search on the ICANN website; web searches sometimes return an old version of the document.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(Collection<String> statusList);

        /**
         * <p>
         * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
         * </p>
         * <p>
         * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
         * status codes that tell you the status of a variety of operations on a domain name, for example, registering a
         * domain name, transferring a domain name to another registrar, renewing the registration for a domain name,
         * and so on. All registrars use this same set of status codes.
         * </p>
         * <p>
         * For a current list of domain name status codes and an explanation of what each code means, go to the <a
         * href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the
         * ICANN website; web searches sometimes return an old version of the document.)
         * </p>
         * 
         * @param statusList
         *        An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status
         *        codes.</p>
         *        <p>
         *        ICANN, the organization that maintains a central database of domain names, has developed a set of
         *        domain name status codes that tell you the status of a variety of operations on a domain name, for
         *        example, registering a domain name, transferring a domain name to another registrar, renewing the
         *        registration for a domain name, and so on. All registrars use this same set of status codes.
         *        </p>
         *        <p>
         *        For a current list of domain name status codes and an explanation of what each code means, go to the
         *        <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
         *        (Search on the ICANN website; web searches sometimes return an old version of the document.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(String... statusList);

        /**
         * <p>
         * A complex type that contains information about the DNSSEC configuration.
         * </p>
         * 
         * @param dnssecKeys
         *        A complex type that contains information about the DNSSEC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnssecKeys(Collection<DnssecKey> dnssecKeys);

        /**
         * <p>
         * A complex type that contains information about the DNSSEC configuration.
         * </p>
         * 
         * @param dnssecKeys
         *        A complex type that contains information about the DNSSEC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnssecKeys(DnssecKey... dnssecKeys);

        /**
         * <p>
         * A complex type that contains information about the DNSSEC configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53domains.model.DnssecKey.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.route53domains.model.DnssecKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53domains.model.DnssecKey.Builder#build()} is called immediately
         * and its result is passed to {@link #dnssecKeys(List<DnssecKey>)}.
         * 
         * @param dnssecKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53domains.model.DnssecKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnssecKeys(java.util.Collection<DnssecKey>)
         */
        Builder dnssecKeys(Consumer<DnssecKey.Builder>... dnssecKeys);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private String domainName;

        private List<Nameserver> nameservers = DefaultSdkAutoConstructList.getInstance();

        private Boolean autoRenew;

        private ContactDetail adminContact;

        private ContactDetail registrantContact;

        private ContactDetail techContact;

        private Boolean adminPrivacy;

        private Boolean registrantPrivacy;

        private Boolean techPrivacy;

        private String registrarName;

        private String whoIsServer;

        private String registrarUrl;

        private String abuseContactEmail;

        private String abuseContactPhone;

        private String registryDomainId;

        private Instant creationDate;

        private Instant updatedDate;

        private Instant expirationDate;

        private String reseller;

        private String dnsSec;

        private List<String> statusList = DefaultSdkAutoConstructList.getInstance();

        private List<DnssecKey> dnssecKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainDetailResponse model) {
            super(model);
            domainName(model.domainName);
            nameservers(model.nameservers);
            autoRenew(model.autoRenew);
            adminContact(model.adminContact);
            registrantContact(model.registrantContact);
            techContact(model.techContact);
            adminPrivacy(model.adminPrivacy);
            registrantPrivacy(model.registrantPrivacy);
            techPrivacy(model.techPrivacy);
            registrarName(model.registrarName);
            whoIsServer(model.whoIsServer);
            registrarUrl(model.registrarUrl);
            abuseContactEmail(model.abuseContactEmail);
            abuseContactPhone(model.abuseContactPhone);
            registryDomainId(model.registryDomainId);
            creationDate(model.creationDate);
            updatedDate(model.updatedDate);
            expirationDate(model.expirationDate);
            reseller(model.reseller);
            dnsSec(model.dnsSec);
            statusList(model.statusList);
            dnssecKeys(model.dnssecKeys);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final List<Nameserver.Builder> getNameservers() {
            List<Nameserver.Builder> result = NameserverListCopier.copyToBuilder(this.nameservers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNameservers(Collection<Nameserver.BuilderImpl> nameservers) {
            this.nameservers = NameserverListCopier.copyFromBuilder(nameservers);
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver... nameservers) {
            nameservers(Arrays.asList(nameservers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Consumer<Nameserver.Builder>... nameservers) {
            nameservers(Stream.of(nameservers).map(c -> Nameserver.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final ContactDetail.Builder getAdminContact() {
            return adminContact != null ? adminContact.toBuilder() : null;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return registrantContact != null ? registrantContact.toBuilder() : null;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final ContactDetail.Builder getTechContact() {
            return techContact != null ? techContact.toBuilder() : null;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final Boolean getAdminPrivacy() {
            return adminPrivacy;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final Boolean getRegistrantPrivacy() {
            return registrantPrivacy;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final Boolean getTechPrivacy() {
            return techPrivacy;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final String getRegistrarName() {
            return registrarName;
        }

        public final void setRegistrarName(String registrarName) {
            this.registrarName = registrarName;
        }

        @Override
        public final Builder registrarName(String registrarName) {
            this.registrarName = registrarName;
            return this;
        }

        public final String getWhoIsServer() {
            return whoIsServer;
        }

        public final void setWhoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
        }

        @Override
        public final Builder whoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
            return this;
        }

        public final String getRegistrarUrl() {
            return registrarUrl;
        }

        public final void setRegistrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
        }

        @Override
        public final Builder registrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
            return this;
        }

        public final String getAbuseContactEmail() {
            return abuseContactEmail;
        }

        public final void setAbuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
        }

        @Override
        public final Builder abuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
            return this;
        }

        public final String getAbuseContactPhone() {
            return abuseContactPhone;
        }

        public final void setAbuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
        }

        @Override
        public final Builder abuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
            return this;
        }

        public final String getRegistryDomainId() {
            return registryDomainId;
        }

        public final void setRegistryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
        }

        @Override
        public final Builder registryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getUpdatedDate() {
            return updatedDate;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getReseller() {
            return reseller;
        }

        public final void setReseller(String reseller) {
            this.reseller = reseller;
        }

        @Override
        public final Builder reseller(String reseller) {
            this.reseller = reseller;
            return this;
        }

        public final String getDnsSec() {
            return dnsSec;
        }

        public final void setDnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
        }

        @Override
        public final Builder dnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
            return this;
        }

        public final Collection<String> getStatusList() {
            if (statusList instanceof SdkAutoConstructList) {
                return null;
            }
            return statusList;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
        }

        @Override
        public final Builder statusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(String... statusList) {
            statusList(Arrays.asList(statusList));
            return this;
        }

        public final List<DnssecKey.Builder> getDnssecKeys() {
            List<DnssecKey.Builder> result = DnssecKeyListCopier.copyToBuilder(this.dnssecKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDnssecKeys(Collection<DnssecKey.BuilderImpl> dnssecKeys) {
            this.dnssecKeys = DnssecKeyListCopier.copyFromBuilder(dnssecKeys);
        }

        @Override
        public final Builder dnssecKeys(Collection<DnssecKey> dnssecKeys) {
            this.dnssecKeys = DnssecKeyListCopier.copy(dnssecKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnssecKeys(DnssecKey... dnssecKeys) {
            dnssecKeys(Arrays.asList(dnssecKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnssecKeys(Consumer<DnssecKey.Builder>... dnssecKeys) {
            dnssecKeys(Stream.of(dnssecKeys).map(c -> DnssecKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDomainDetailResponse build() {
            return new GetDomainDetailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
