/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>RenewDomain</code> request includes the number of years that you want to renew for and the current expiration
 * year.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenewDomainRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<RenewDomainRequest.Builder, RenewDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(RenewDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Integer> DURATION_IN_YEARS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInYears").getter(getter(RenewDomainRequest::durationInYears))
            .setter(setter(Builder::durationInYears))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInYears").build()).build();

    private static final SdkField<Integer> CURRENT_EXPIRY_YEAR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentExpiryYear").getter(getter(RenewDomainRequest::currentExpiryYear))
            .setter(setter(Builder::currentExpiryYear))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentExpiryYear").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DURATION_IN_YEARS_FIELD, CURRENT_EXPIRY_YEAR_FIELD));

    private final String domainName;

    private final Integer durationInYears;

    private final Integer currentExpiryYear;

    private RenewDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.durationInYears = builder.durationInYears;
        this.currentExpiryYear = builder.currentExpiryYear;
    }

    /**
     * <p>
     * The name of the domain that you want to renew.
     * </p>
     * 
     * @return The name of the domain that you want to renew.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The number of years that you want to renew the domain for. The maximum number of years depends on the top-level
     * domain. For the range of valid values for your domain, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The number of years that you want to renew the domain for. The maximum number of years depends on the
     *         top-level domain. For the range of valid values for your domain, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
     *         Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
     *         <p>
     *         Default: 1
     */
    public final Integer durationInYears() {
        return durationInYears;
    }

    /**
     * <p>
     * The year when the registration for the domain is set to expire. This value must match the current expiration date
     * for the domain.
     * </p>
     * 
     * @return The year when the registration for the domain is set to expire. This value must match the current
     *         expiration date for the domain.
     */
    public final Integer currentExpiryYear() {
        return currentExpiryYear;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(durationInYears());
        hashCode = 31 * hashCode + Objects.hashCode(currentExpiryYear());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewDomainRequest)) {
            return false;
        }
        RenewDomainRequest other = (RenewDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(durationInYears(), other.durationInYears())
                && Objects.equals(currentExpiryYear(), other.currentExpiryYear());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenewDomainRequest").add("DomainName", domainName()).add("DurationInYears", durationInYears())
                .add("CurrentExpiryYear", currentExpiryYear()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DurationInYears":
            return Optional.ofNullable(clazz.cast(durationInYears()));
        case "CurrentExpiryYear":
            return Optional.ofNullable(clazz.cast(currentExpiryYear()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenewDomainRequest, T> g) {
        return obj -> g.apply((RenewDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RenewDomainRequest> {
        /**
         * <p>
         * The name of the domain that you want to renew.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to renew.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The number of years that you want to renew the domain for. The maximum number of years depends on the
         * top-level domain. For the range of valid values for your domain, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
         * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param durationInYears
         *        The number of years that you want to renew the domain for. The maximum number of years depends on the
         *        top-level domain. For the range of valid values for your domain, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInYears(Integer durationInYears);

        /**
         * <p>
         * The year when the registration for the domain is set to expire. This value must match the current expiration
         * date for the domain.
         * </p>
         * 
         * @param currentExpiryYear
         *        The year when the registration for the domain is set to expire. This value must match the current
         *        expiration date for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentExpiryYear(Integer currentExpiryYear);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private Integer durationInYears;

        private Integer currentExpiryYear;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewDomainRequest model) {
            super(model);
            domainName(model.domainName);
            durationInYears(model.durationInYears);
            currentExpiryYear(model.currentExpiryYear);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getDurationInYears() {
            return durationInYears;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final Integer getCurrentExpiryYear() {
            return currentExpiryYear;
        }

        public final void setCurrentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
        }

        @Override
        public final Builder currentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RenewDomainRequest build() {
            return new RenewDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
