/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In the response to a <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html"
 * >GetResolverEndpoint</a> request, information about the IP addresses that the Resolver endpoint uses for DNS queries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpAddressResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<IpAddressResponse.Builder, IpAddressResponse> {
    private static final SdkField<String> IP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("IpId")
            .getter(getter(IpAddressResponse::ipId)).setter(setter(Builder::ipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(IpAddressResponse::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ip")
            .getter(getter(IpAddressResponse::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(IpAddressResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(IpAddressResponse::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(IpAddressResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModificationTime").getter(getter(IpAddressResponse::modificationTime))
            .setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ID_FIELD, SUBNET_ID_FIELD,
            IP_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipId;

    private final String subnetId;

    private final String ip;

    private final String status;

    private final String statusMessage;

    private final String creationTime;

    private final String modificationTime;

    private IpAddressResponse(BuilderImpl builder) {
        this.ipId = builder.ipId;
        this.subnetId = builder.subnetId;
        this.ip = builder.ip;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    /**
     * <p>
     * The ID of one IP address.
     * </p>
     * 
     * @return The ID of one IP address.
     */
    public final String ipId() {
        return ipId;
    }

    /**
     * <p>
     * The ID of one subnet.
     * </p>
     * 
     * @return The ID of one subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * One IP address that the Resolver endpoint uses for DNS queries.
     * </p>
     * 
     * @return One IP address that the Resolver endpoint uses for DNS queries.
     */
    public final String ip() {
        return ip;
    }

    /**
     * <p>
     * A status code that gives the current status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IpAddressStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status code that gives the current status of the request.
     * @see IpAddressStatus
     */
    public final IpAddressStatus status() {
        return IpAddressStatus.fromValue(status);
    }

    /**
     * <p>
     * A status code that gives the current status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IpAddressStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status code that gives the current status of the request.
     * @see IpAddressStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message that provides additional information about the status of the request.
     * </p>
     * 
     * @return A message that provides additional information about the status of the request.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the IP address was created, in Unix time format and Coordinated Universal Time
     *         (UTC).
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time
     * (UTC).
     * </p>
     * 
     * @return The date and time that the IP address was last modified, in Unix time format and Coordinated Universal
     *         Time (UTC).
     */
    public final String modificationTime() {
        return modificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddressResponse)) {
            return false;
        }
        IpAddressResponse other = (IpAddressResponse) obj;
        return Objects.equals(ipId(), other.ipId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(ip(), other.ip()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modificationTime(), other.modificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpAddressResponse").add("IpId", ipId()).add("SubnetId", subnetId()).add("Ip", ip())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("CreationTime", creationTime())
                .add("ModificationTime", modificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpId":
            return Optional.ofNullable(clazz.cast(ipId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpAddressResponse, T> g) {
        return obj -> g.apply((IpAddressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpAddressResponse> {
        /**
         * <p>
         * The ID of one IP address.
         * </p>
         * 
         * @param ipId
         *        The ID of one IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipId(String ipId);

        /**
         * <p>
         * The ID of one subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of one subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * One IP address that the Resolver endpoint uses for DNS queries.
         * </p>
         * 
         * @param ip
         *        One IP address that the Resolver endpoint uses for DNS queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * <p>
         * A status code that gives the current status of the request.
         * </p>
         * 
         * @param status
         *        A status code that gives the current status of the request.
         * @see IpAddressStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status code that gives the current status of the request.
         * </p>
         * 
         * @param status
         *        A status code that gives the current status of the request.
         * @see IpAddressStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressStatus
         */
        Builder status(IpAddressStatus status);

        /**
         * <p>
         * A message that provides additional information about the status of the request.
         * </p>
         * 
         * @param statusMessage
         *        A message that provides additional information about the status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the IP address was created, in Unix time format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the IP address was last modified, in Unix time format and Coordinated Universal
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(String modificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String ipId;

        private String subnetId;

        private String ip;

        private String status;

        private String statusMessage;

        private String creationTime;

        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddressResponse model) {
            ipId(model.ipId);
            subnetId(model.subnetId);
            ip(model.ip);
            status(model.status);
            statusMessage(model.statusMessage);
            creationTime(model.creationTime);
            modificationTime(model.modificationTime);
        }

        public final String getIpId() {
            return ipId;
        }

        public final void setIpId(String ipId) {
            this.ipId = ipId;
        }

        @Override
        public final Builder ipId(String ipId) {
            this.ipId = ipId;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getIp() {
            return ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IpAddressStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        @Override
        public IpAddressResponse build() {
            return new IpAddressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
