/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a <code>PutResolverRulePolicy</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResolverRulePolicyResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<PutResolverRulePolicyResponse.Builder, PutResolverRulePolicyResponse> {
    private static final SdkField<Boolean> RETURN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnValue").getter(getter(PutResolverRulePolicyResponse::returnValue))
            .setter(setter(Builder::returnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_VALUE_FIELD));

    private final Boolean returnValue;

    private PutResolverRulePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
    }

    /**
     * <p>
     * Whether the <code>PutResolverRulePolicy</code> request was successful.
     * </p>
     * 
     * @return Whether the <code>PutResolverRulePolicy</code> request was successful.
     */
    public final Boolean returnValue() {
        return returnValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(returnValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResolverRulePolicyResponse)) {
            return false;
        }
        PutResolverRulePolicyResponse other = (PutResolverRulePolicyResponse) obj;
        return Objects.equals(returnValue(), other.returnValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResolverRulePolicyResponse").add("ReturnValue", returnValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReturnValue":
            return Optional.ofNullable(clazz.cast(returnValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResolverRulePolicyResponse, T> g) {
        return obj -> g.apply((PutResolverRulePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutResolverRulePolicyResponse> {
        /**
         * <p>
         * Whether the <code>PutResolverRulePolicy</code> request was successful.
         * </p>
         * 
         * @param returnValue
         *        Whether the <code>PutResolverRulePolicy</code> request was successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private Boolean returnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResolverRulePolicyResponse model) {
            super(model);
            returnValue(model.returnValue);
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        @Override
        public PutResolverRulePolicyResponse build() {
            return new PutResolverRulePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
