/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that displays information about one destination that CloudWatch RUM sends extended metrics to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDestinationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricDestinationSummary.Builder, MetricDestinationSummary> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(MetricDestinationSummary::destinationAsString))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(MetricDestinationSummary::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(MetricDestinationSummary::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            DESTINATION_ARN_FIELD, IAM_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destination;

    private final String destinationArn;

    private final String iamRoleArn;

    private MetricDestinationSummary(BuilderImpl builder) {
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.iamRoleArn = builder.iamRoleArn;
    }

    /**
     * <p>
     * Specifies whether the destination is <code>CloudWatch</code> or <code>Evidently</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return Specifies whether the destination is <code>CloudWatch</code> or <code>Evidently</code>.
     * @see MetricDestination
     */
    public final MetricDestination destination() {
        return MetricDestination.fromValue(destination);
    }

    /**
     * <p>
     * Specifies whether the destination is <code>CloudWatch</code> or <code>Evidently</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return Specifies whether the destination is <code>CloudWatch</code> or <code>Evidently</code>.
     * @see MetricDestination
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * If the destination is <code>Evidently</code>, this specifies the ARN of the Evidently experiment that receives
     * the metrics.
     * </p>
     * 
     * @return If the destination is <code>Evidently</code>, this specifies the ARN of the Evidently experiment that
     *         receives the metrics.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * This field appears only when the destination is <code>Evidently</code>. It specifies the ARN of the IAM role that
     * is used to write to the Evidently experiment that receives the metrics.
     * </p>
     * 
     * @return This field appears only when the destination is <code>Evidently</code>. It specifies the ARN of the IAM
     *         role that is used to write to the Evidently experiment that receives the metrics.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDestinationSummary)) {
            return false;
        }
        MetricDestinationSummary other = (MetricDestinationSummary) obj;
        return Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(iamRoleArn(), other.iamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDestinationSummary").add("Destination", destinationAsString())
                .add("DestinationArn", destinationArn()).add("IamRoleArn", iamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDestinationSummary, T> g) {
        return obj -> g.apply((MetricDestinationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDestinationSummary> {
        /**
         * <p>
         * Specifies whether the destination is <code>CloudWatch</code> or <code>Evidently</code>.
         * </p>
         * 
         * @param destination
         *        Specifies whether the destination is <code>CloudWatch</code> or <code>Evidently</code>.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(String destination);

        /**
         * <p>
         * Specifies whether the destination is <code>CloudWatch</code> or <code>Evidently</code>.
         * </p>
         * 
         * @param destination
         *        Specifies whether the destination is <code>CloudWatch</code> or <code>Evidently</code>.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(MetricDestination destination);

        /**
         * <p>
         * If the destination is <code>Evidently</code>, this specifies the ARN of the Evidently experiment that
         * receives the metrics.
         * </p>
         * 
         * @param destinationArn
         *        If the destination is <code>Evidently</code>, this specifies the ARN of the Evidently experiment that
         *        receives the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * This field appears only when the destination is <code>Evidently</code>. It specifies the ARN of the IAM role
         * that is used to write to the Evidently experiment that receives the metrics.
         * </p>
         * 
         * @param iamRoleArn
         *        This field appears only when the destination is <code>Evidently</code>. It specifies the ARN of the
         *        IAM role that is used to write to the Evidently experiment that receives the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String destination;

        private String destinationArn;

        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDestinationSummary model) {
            destination(model.destination);
            destinationArn(model.destinationArn);
            iamRoleArn(model.iamRoleArn);
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        @Override
        public MetricDestinationSummary build() {
            return new MetricDestinationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
