/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration options of the S3 Access Grants location. It contains the <code>S3SubPrefix</code> field. The grant
 * scope, the data to which you are granting access, is the result of appending the <code>Subprefix</code> field to the
 * scope of the registered location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessGrantsLocationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessGrantsLocationConfiguration.Builder, AccessGrantsLocationConfiguration> {
    private static final SdkField<String> S3_SUB_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3SubPrefix")
            .getter(getter(AccessGrantsLocationConfiguration::s3SubPrefix))
            .setter(setter(Builder::s3SubPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SubPrefix")
                    .unmarshallLocationName("S3SubPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_SUB_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3SubPrefix;

    private AccessGrantsLocationConfiguration(BuilderImpl builder) {
        this.s3SubPrefix = builder.s3SubPrefix;
    }

    /**
     * <p>
     * The <code>S3SubPrefix</code> is appended to the location scope creating the grant scope. Use this field to narrow
     * the scope of the grant to a subset of the location scope. This field is required if the location scope is the
     * default location <code>s3://</code> because you cannot create a grant for all of your S3 data in the Region and
     * must narrow the scope. For example, if the location scope is the default location <code>s3://</code>, the
     * <code>S3SubPrefx</code> can be a &lt;bucket-name&gt;/*, so the full grant scope path would be
     * <code>s3://&lt;bucket-name&gt;/*</code>. Or the <code>S3SubPrefx</code> can be
     * <code>&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>, so the full grant scope path would be or
     * <code>s3://&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>.
     * </p>
     * <p>
     * If the <code>S3SubPrefix</code> includes a prefix, append the wildcard character <code>*</code> after the prefix
     * to indicate that you want to include all object key names in the bucket that start with that prefix.
     * </p>
     * 
     * @return The <code>S3SubPrefix</code> is appended to the location scope creating the grant scope. Use this field
     *         to narrow the scope of the grant to a subset of the location scope. This field is required if the
     *         location scope is the default location <code>s3://</code> because you cannot create a grant for all of
     *         your S3 data in the Region and must narrow the scope. For example, if the location scope is the default
     *         location <code>s3://</code>, the <code>S3SubPrefx</code> can be a &lt;bucket-name&gt;/*, so the full
     *         grant scope path would be <code>s3://&lt;bucket-name&gt;/*</code>. Or the <code>S3SubPrefx</code> can be
     *         <code>&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>, so the full grant scope path would be or
     *         <code>s3://&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>.</p>
     *         <p>
     *         If the <code>S3SubPrefix</code> includes a prefix, append the wildcard character <code>*</code> after the
     *         prefix to indicate that you want to include all object key names in the bucket that start with that
     *         prefix.
     */
    public final String s3SubPrefix() {
        return s3SubPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3SubPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessGrantsLocationConfiguration)) {
            return false;
        }
        AccessGrantsLocationConfiguration other = (AccessGrantsLocationConfiguration) obj;
        return Objects.equals(s3SubPrefix(), other.s3SubPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessGrantsLocationConfiguration").add("S3SubPrefix", s3SubPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3SubPrefix":
            return Optional.ofNullable(clazz.cast(s3SubPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessGrantsLocationConfiguration, T> g) {
        return obj -> g.apply((AccessGrantsLocationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessGrantsLocationConfiguration> {
        /**
         * <p>
         * The <code>S3SubPrefix</code> is appended to the location scope creating the grant scope. Use this field to
         * narrow the scope of the grant to a subset of the location scope. This field is required if the location scope
         * is the default location <code>s3://</code> because you cannot create a grant for all of your S3 data in the
         * Region and must narrow the scope. For example, if the location scope is the default location
         * <code>s3://</code>, the <code>S3SubPrefx</code> can be a &lt;bucket-name&gt;/*, so the full grant scope path
         * would be <code>s3://&lt;bucket-name&gt;/*</code>. Or the <code>S3SubPrefx</code> can be
         * <code>&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>, so the full grant scope path would be or
         * <code>s3://&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>.
         * </p>
         * <p>
         * If the <code>S3SubPrefix</code> includes a prefix, append the wildcard character <code>*</code> after the
         * prefix to indicate that you want to include all object key names in the bucket that start with that prefix.
         * </p>
         * 
         * @param s3SubPrefix
         *        The <code>S3SubPrefix</code> is appended to the location scope creating the grant scope. Use this
         *        field to narrow the scope of the grant to a subset of the location scope. This field is required if
         *        the location scope is the default location <code>s3://</code> because you cannot create a grant for
         *        all of your S3 data in the Region and must narrow the scope. For example, if the location scope is the
         *        default location <code>s3://</code>, the <code>S3SubPrefx</code> can be a &lt;bucket-name&gt;/*, so
         *        the full grant scope path would be <code>s3://&lt;bucket-name&gt;/*</code>. Or the
         *        <code>S3SubPrefx</code> can be <code>&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>, so the full
         *        grant scope path would be or <code>s3://&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>.</p>
         *        <p>
         *        If the <code>S3SubPrefix</code> includes a prefix, append the wildcard character <code>*</code> after
         *        the prefix to indicate that you want to include all object key names in the bucket that start with
         *        that prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3SubPrefix(String s3SubPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String s3SubPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessGrantsLocationConfiguration model) {
            s3SubPrefix(model.s3SubPrefix);
        }

        public final String getS3SubPrefix() {
            return s3SubPrefix;
        }

        public final void setS3SubPrefix(String s3SubPrefix) {
            this.s3SubPrefix = s3SubPrefix;
        }

        @Override
        public final Builder s3SubPrefix(String s3SubPrefix) {
            this.s3SubPrefix = s3SubPrefix;
            return this;
        }

        @Override
        public AccessGrantsLocationConfiguration build() {
            return new AccessGrantsLocationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
