/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataAccessResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetDataAccessResponse.Builder, GetDataAccessResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField
            .<Credentials> builder(MarshallingType.SDK_POJO)
            .memberName("Credentials")
            .getter(getter(GetDataAccessResponse::credentials))
            .setter(setter(Builder::credentials))
            .constructor(Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials")
                    .unmarshallLocationName("Credentials").build()).build();

    private static final SdkField<String> MATCHED_GRANT_TARGET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MatchedGrantTarget")
            .getter(getter(GetDataAccessResponse::matchedGrantTarget))
            .setter(setter(Builder::matchedGrantTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedGrantTarget")
                    .unmarshallLocationName("MatchedGrantTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            MATCHED_GRANT_TARGET_FIELD));

    private final Credentials credentials;

    private final String matchedGrantTarget;

    private GetDataAccessResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.matchedGrantTarget = builder.matchedGrantTarget;
    }

    /**
     * <p>
     * The temporary credential token that S3 Access Grants vends.
     * </p>
     * 
     * @return The temporary credential token that S3 Access Grants vends.
     */
    public final Credentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The S3 URI path of the data to which you are being granted temporary access credentials.
     * </p>
     * 
     * @return The S3 URI path of the data to which you are being granted temporary access credentials.
     */
    public final String matchedGrantTarget() {
        return matchedGrantTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(matchedGrantTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataAccessResponse)) {
            return false;
        }
        GetDataAccessResponse other = (GetDataAccessResponse) obj;
        return Objects.equals(credentials(), other.credentials())
                && Objects.equals(matchedGrantTarget(), other.matchedGrantTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataAccessResponse")
                .add("Credentials", credentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MatchedGrantTarget", matchedGrantTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "MatchedGrantTarget":
            return Optional.ofNullable(clazz.cast(matchedGrantTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataAccessResponse, T> g) {
        return obj -> g.apply((GetDataAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataAccessResponse> {
        /**
         * <p>
         * The temporary credential token that S3 Access Grants vends.
         * </p>
         * 
         * @param credentials
         *        The temporary credential token that S3 Access Grants vends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * The temporary credential token that S3 Access Grants vends.
         * </p>
         * This is a convenience method that creates an instance of the {@link Credentials.Builder} avoiding the need to
         * create one manually via {@link Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #credentials(Credentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(Credentials)
         */
        default Builder credentials(Consumer<Credentials.Builder> credentials) {
            return credentials(Credentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The S3 URI path of the data to which you are being granted temporary access credentials.
         * </p>
         * 
         * @param matchedGrantTarget
         *        The S3 URI path of the data to which you are being granted temporary access credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedGrantTarget(String matchedGrantTarget);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private Credentials credentials;

        private String matchedGrantTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataAccessResponse model) {
            super(model);
            credentials(model.credentials);
            matchedGrantTarget(model.matchedGrantTarget);
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getMatchedGrantTarget() {
            return matchedGrantTarget;
        }

        public final void setMatchedGrantTarget(String matchedGrantTarget) {
            this.matchedGrantTarget = matchedGrantTarget;
        }

        @Override
        public final Builder matchedGrantTarget(String matchedGrantTarget) {
            this.matchedGrantTarget = matchedGrantTarget;
            return this;
        }

        @Override
        public GetDataAccessResponse build() {
            return new GetDataAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
