/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter condition that specifies the object size range of included objects in bytes. Only integers are supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchObjectSize implements SdkPojo, Serializable, ToCopyableBuilder<MatchObjectSize.Builder, MatchObjectSize> {
    private static final SdkField<Long> BYTES_GREATER_THAN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("BytesGreaterThan")
            .getter(getter(MatchObjectSize::bytesGreaterThan))
            .setter(setter(Builder::bytesGreaterThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesGreaterThan")
                    .unmarshallLocationName("BytesGreaterThan").build()).build();

    private static final SdkField<Long> BYTES_LESS_THAN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("BytesLessThan")
            .getter(getter(MatchObjectSize::bytesLessThan))
            .setter(setter(Builder::bytesLessThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesLessThan")
                    .unmarshallLocationName("BytesLessThan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_GREATER_THAN_FIELD,
            BYTES_LESS_THAN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long bytesGreaterThan;

    private final Long bytesLessThan;

    private MatchObjectSize(BuilderImpl builder) {
        this.bytesGreaterThan = builder.bytesGreaterThan;
        this.bytesLessThan = builder.bytesLessThan;
    }

    /**
     * <p>
     * Specifies the minimum object size in Bytes. The value must be a positive number, greater than 0 and less than 5
     * TB.
     * </p>
     * 
     * @return Specifies the minimum object size in Bytes. The value must be a positive number, greater than 0 and less
     *         than 5 TB.
     */
    public final Long bytesGreaterThan() {
        return bytesGreaterThan;
    }

    /**
     * <p>
     * Specifies the maximum object size in Bytes. The value must be a positive number, greater than the minimum object
     * size and less than 5 TB.
     * </p>
     * 
     * @return Specifies the maximum object size in Bytes. The value must be a positive number, greater than the minimum
     *         object size and less than 5 TB.
     */
    public final Long bytesLessThan() {
        return bytesLessThan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bytesGreaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(bytesLessThan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchObjectSize)) {
            return false;
        }
        MatchObjectSize other = (MatchObjectSize) obj;
        return Objects.equals(bytesGreaterThan(), other.bytesGreaterThan())
                && Objects.equals(bytesLessThan(), other.bytesLessThan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchObjectSize").add("BytesGreaterThan", bytesGreaterThan())
                .add("BytesLessThan", bytesLessThan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BytesGreaterThan":
            return Optional.ofNullable(clazz.cast(bytesGreaterThan()));
        case "BytesLessThan":
            return Optional.ofNullable(clazz.cast(bytesLessThan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchObjectSize, T> g) {
        return obj -> g.apply((MatchObjectSize) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchObjectSize> {
        /**
         * <p>
         * Specifies the minimum object size in Bytes. The value must be a positive number, greater than 0 and less than
         * 5 TB.
         * </p>
         * 
         * @param bytesGreaterThan
         *        Specifies the minimum object size in Bytes. The value must be a positive number, greater than 0 and
         *        less than 5 TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesGreaterThan(Long bytesGreaterThan);

        /**
         * <p>
         * Specifies the maximum object size in Bytes. The value must be a positive number, greater than the minimum
         * object size and less than 5 TB.
         * </p>
         * 
         * @param bytesLessThan
         *        Specifies the maximum object size in Bytes. The value must be a positive number, greater than the
         *        minimum object size and less than 5 TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesLessThan(Long bytesLessThan);
    }

    static final class BuilderImpl implements Builder {
        private Long bytesGreaterThan;

        private Long bytesLessThan;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchObjectSize model) {
            bytesGreaterThan(model.bytesGreaterThan);
            bytesLessThan(model.bytesLessThan);
        }

        public final Long getBytesGreaterThan() {
            return bytesGreaterThan;
        }

        public final void setBytesGreaterThan(Long bytesGreaterThan) {
            this.bytesGreaterThan = bytesGreaterThan;
        }

        @Override
        public final Builder bytesGreaterThan(Long bytesGreaterThan) {
            this.bytesGreaterThan = bytesGreaterThan;
            return this;
        }

        public final Long getBytesLessThan() {
            return bytesLessThan;
        }

        public final void setBytesLessThan(Long bytesLessThan) {
            this.bytesLessThan = bytesLessThan;
        }

        @Override
        public final Builder bytesLessThan(Long bytesLessThan) {
            this.bytesLessThan = bytesLessThan;
            return this;
        }

        @Override
        public MatchObjectSize build() {
            return new MatchObjectSize(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
