/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes to every
 * object to the underlying <code>PutObjectLegalHold</code> API operation. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html">Using S3 Object Lock legal hold with
 * S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.
 * </p>
 * <note>
 * <p>
 * This functionality is not supported by directory buckets.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3SetObjectLegalHoldOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<S3SetObjectLegalHoldOperation.Builder, S3SetObjectLegalHoldOperation> {
    private static final SdkField<S3ObjectLockLegalHold> LEGAL_HOLD_FIELD = SdkField
            .<S3ObjectLockLegalHold> builder(MarshallingType.SDK_POJO)
            .memberName("LegalHold")
            .getter(getter(S3SetObjectLegalHoldOperation::legalHold))
            .setter(setter(Builder::legalHold))
            .constructor(S3ObjectLockLegalHold::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHold")
                    .unmarshallLocationName("LegalHold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEGAL_HOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3ObjectLockLegalHold legalHold;

    private S3SetObjectLegalHoldOperation(BuilderImpl builder) {
        this.legalHold = builder.legalHold;
    }

    /**
     * <p>
     * Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.
     * </p>
     * 
     * @return Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.
     */
    public final S3ObjectLockLegalHold legalHold() {
        return legalHold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(legalHold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SetObjectLegalHoldOperation)) {
            return false;
        }
        S3SetObjectLegalHoldOperation other = (S3SetObjectLegalHoldOperation) obj;
        return Objects.equals(legalHold(), other.legalHold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3SetObjectLegalHoldOperation").add("LegalHold", legalHold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LegalHold":
            return Optional.ofNullable(clazz.cast(legalHold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3SetObjectLegalHoldOperation, T> g) {
        return obj -> g.apply((S3SetObjectLegalHoldOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3SetObjectLegalHoldOperation> {
        /**
         * <p>
         * Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.
         * </p>
         * 
         * @param legalHold
         *        Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalHold(S3ObjectLockLegalHold legalHold);

        /**
         * <p>
         * Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ObjectLockLegalHold.Builder} avoiding
         * the need to create one manually via {@link S3ObjectLockLegalHold#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ObjectLockLegalHold.Builder#build()} is called immediately and
         * its result is passed to {@link #legalHold(S3ObjectLockLegalHold)}.
         * 
         * @param legalHold
         *        a consumer that will call methods on {@link S3ObjectLockLegalHold.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legalHold(S3ObjectLockLegalHold)
         */
        default Builder legalHold(Consumer<S3ObjectLockLegalHold.Builder> legalHold) {
            return legalHold(S3ObjectLockLegalHold.builder().applyMutation(legalHold).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ObjectLockLegalHold legalHold;

        private BuilderImpl() {
        }

        private BuilderImpl(S3SetObjectLegalHoldOperation model) {
            legalHold(model.legalHold);
        }

        public final S3ObjectLockLegalHold.Builder getLegalHold() {
            return legalHold != null ? legalHold.toBuilder() : null;
        }

        public final void setLegalHold(S3ObjectLockLegalHold.BuilderImpl legalHold) {
            this.legalHold = legalHold != null ? legalHold.build() : null;
        }

        @Override
        public final Builder legalHold(S3ObjectLockLegalHold legalHold) {
            this.legalHold = legalHold;
            return this;
        }

        @Override
        public S3SetObjectLegalHoldOperation build() {
            return new S3SetObjectLegalHoldOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
