/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStorageLensGroupRequest extends S3ControlRequest implements
        ToCopyableBuilder<UpdateStorageLensGroupRequest.Builder, UpdateStorageLensGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(UpdateStorageLensGroupRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").unmarshallLocationName("name")
                    .build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(UpdateStorageLensGroupRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<StorageLensGroup> STORAGE_LENS_GROUP_FIELD = SdkField
            .<StorageLensGroup> builder(MarshallingType.SDK_POJO)
            .memberName("StorageLensGroup")
            .getter(getter(UpdateStorageLensGroupRequest::storageLensGroup))
            .setter(setter(Builder::storageLensGroup))
            .constructor(StorageLensGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroup")
                    .unmarshallLocationName("StorageLensGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACCOUNT_ID_FIELD,
            STORAGE_LENS_GROUP_FIELD));

    private final String name;

    private final String accountId;

    private final StorageLensGroup storageLensGroup;

    private UpdateStorageLensGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.accountId = builder.accountId;
        this.storageLensGroup = builder.storageLensGroup;
    }

    /**
     * <p>
     * The name of the Storage Lens group that you want to update.
     * </p>
     * 
     * @return The name of the Storage Lens group that you want to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the Storage Lens group owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the Storage Lens group owner.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The JSON file that contains the Storage Lens group configuration.
     * </p>
     * 
     * @return The JSON file that contains the Storage Lens group configuration.
     */
    public final StorageLensGroup storageLensGroup() {
        return storageLensGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(storageLensGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStorageLensGroupRequest)) {
            return false;
        }
        UpdateStorageLensGroupRequest other = (UpdateStorageLensGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(storageLensGroup(), other.storageLensGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStorageLensGroupRequest").add("Name", name()).add("AccountId", accountId())
                .add("StorageLensGroup", storageLensGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "StorageLensGroup":
            return Optional.ofNullable(clazz.cast(storageLensGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStorageLensGroupRequest, T> g) {
        return obj -> g.apply((UpdateStorageLensGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStorageLensGroupRequest> {
        /**
         * <p>
         * The name of the Storage Lens group that you want to update.
         * </p>
         * 
         * @param name
         *        The name of the Storage Lens group that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services account ID of the Storage Lens group owner.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the Storage Lens group owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The JSON file that contains the Storage Lens group configuration.
         * </p>
         * 
         * @param storageLensGroup
         *        The JSON file that contains the Storage Lens group configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensGroup(StorageLensGroup storageLensGroup);

        /**
         * <p>
         * The JSON file that contains the Storage Lens group configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensGroup.Builder} avoiding the
         * need to create one manually via {@link StorageLensGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #storageLensGroup(StorageLensGroup)}.
         * 
         * @param storageLensGroup
         *        a consumer that will call methods on {@link StorageLensGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLensGroup(StorageLensGroup)
         */
        default Builder storageLensGroup(Consumer<StorageLensGroup.Builder> storageLensGroup) {
            return storageLensGroup(StorageLensGroup.builder().applyMutation(storageLensGroup).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String name;

        private String accountId;

        private StorageLensGroup storageLensGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStorageLensGroupRequest model) {
            super(model);
            name(model.name);
            accountId(model.accountId);
            storageLensGroup(model.storageLensGroup);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final StorageLensGroup.Builder getStorageLensGroup() {
            return storageLensGroup != null ? storageLensGroup.toBuilder() : null;
        }

        public final void setStorageLensGroup(StorageLensGroup.BuilderImpl storageLensGroup) {
            this.storageLensGroup = storageLensGroup != null ? storageLensGroup.build() : null;
        }

        @Override
        public final Builder storageLensGroup(StorageLensGroup storageLensGroup) {
            this.storageLensGroup = storageLensGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStorageLensGroupRequest build() {
            return new UpdateStorageLensGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
