/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeAppResponse.Builder, DescribeAppResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppArn")
            .getter(getter(DescribeAppResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppArn").build()).build();

    private static final SdkField<String> APP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppType").getter(getter(DescribeAppResponse::appTypeAsString)).setter(setter(Builder::appType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()).build();

    private static final SdkField<String> APP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppName").getter(getter(DescribeAppResponse::appName)).setter(setter(Builder::appName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppName").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(DescribeAppResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(DescribeAppResponse::userProfileName))
            .setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeAppResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_HEALTH_CHECK_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LastHealthCheckTimestamp")
            .getter(getter(DescribeAppResponse::lastHealthCheckTimestamp)).setter(setter(Builder::lastHealthCheckTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastHealthCheckTimestamp").build())
            .build();

    private static final SdkField<Instant> LAST_USER_ACTIVITY_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LastUserActivityTimestamp")
            .getter(getter(DescribeAppResponse::lastUserActivityTimestamp)).setter(setter(Builder::lastUserActivityTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUserActivityTimestamp").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeAppResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeAppResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<ResourceSpec> RESOURCE_SPEC_FIELD = SdkField.<ResourceSpec> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceSpec").getter(getter(DescribeAppResponse::resourceSpec)).setter(setter(Builder::resourceSpec))
            .constructor(ResourceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSpec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_TYPE_FIELD,
            APP_NAME_FIELD, DOMAIN_ID_FIELD, USER_PROFILE_NAME_FIELD, STATUS_FIELD, LAST_HEALTH_CHECK_TIMESTAMP_FIELD,
            LAST_USER_ACTIVITY_TIMESTAMP_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, RESOURCE_SPEC_FIELD));

    private final String appArn;

    private final String appType;

    private final String appName;

    private final String domainId;

    private final String userProfileName;

    private final String status;

    private final Instant lastHealthCheckTimestamp;

    private final Instant lastUserActivityTimestamp;

    private final Instant creationTime;

    private final String failureReason;

    private final ResourceSpec resourceSpec;

    private DescribeAppResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appType = builder.appType;
        this.appName = builder.appName;
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.status = builder.status;
        this.lastHealthCheckTimestamp = builder.lastHealthCheckTimestamp;
        this.lastUserActivityTimestamp = builder.lastUserActivityTimestamp;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.resourceSpec = builder.resourceSpec;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the app.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The type of app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app.
     * @see AppType
     */
    public final AppType appType() {
        return AppType.fromValue(appType);
    }

    /**
     * <p>
     * The type of app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app.
     * @see AppType
     */
    public final String appTypeAsString() {
        return appType;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public final String appName() {
        return appName;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The user profile name.
     * </p>
     * 
     * @return The user profile name.
     */
    public final String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see AppStatus
     */
    public final AppStatus status() {
        return AppStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see AppStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp of the last health check.
     * </p>
     * 
     * @return The timestamp of the last health check.
     */
    public final Instant lastHealthCheckTimestamp() {
        return lastHealthCheckTimestamp;
    }

    /**
     * <p>
     * The timestamp of the last user's activity. <code>LastUserActivityTimestamp</code> is also updated when SageMaker
     * performs health checks without user activity. As a result, this value is set to the same value as
     * <code>LastHealthCheckTimestamp</code>.
     * </p>
     * 
     * @return The timestamp of the last user's activity. <code>LastUserActivityTimestamp</code> is also updated when
     *         SageMaker performs health checks without user activity. As a result, this value is set to the same value
     *         as <code>LastHealthCheckTimestamp</code>.
     */
    public final Instant lastUserActivityTimestamp() {
        return lastUserActivityTimestamp;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The failure reason.
     * </p>
     * 
     * @return The failure reason.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
     * </p>
     * 
     * @return The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
     */
    public final ResourceSpec resourceSpec() {
        return resourceSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(appName());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastHealthCheckTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUserActivityTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppResponse)) {
            return false;
        }
        DescribeAppResponse other = (DescribeAppResponse) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appTypeAsString(), other.appTypeAsString())
                && Objects.equals(appName(), other.appName()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(userProfileName(), other.userProfileName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastHealthCheckTimestamp(), other.lastHealthCheckTimestamp())
                && Objects.equals(lastUserActivityTimestamp(), other.lastUserActivityTimestamp())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(resourceSpec(), other.resourceSpec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppResponse").add("AppArn", appArn()).add("AppType", appTypeAsString())
                .add("AppName", appName()).add("DomainId", domainId()).add("UserProfileName", userProfileName())
                .add("Status", statusAsString()).add("LastHealthCheckTimestamp", lastHealthCheckTimestamp())
                .add("LastUserActivityTimestamp", lastUserActivityTimestamp()).add("CreationTime", creationTime())
                .add("FailureReason", failureReason()).add("ResourceSpec", resourceSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "AppType":
            return Optional.ofNullable(clazz.cast(appTypeAsString()));
        case "AppName":
            return Optional.ofNullable(clazz.cast(appName()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastHealthCheckTimestamp":
            return Optional.ofNullable(clazz.cast(lastHealthCheckTimestamp()));
        case "LastUserActivityTimestamp":
            return Optional.ofNullable(clazz.cast(lastUserActivityTimestamp()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ResourceSpec":
            return Optional.ofNullable(clazz.cast(resourceSpec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppResponse, T> g) {
        return obj -> g.apply((DescribeAppResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAppResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the app.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The type of app.
         * </p>
         * 
         * @param appType
         *        The type of app.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(String appType);

        /**
         * <p>
         * The type of app.
         * </p>
         * 
         * @param appType
         *        The type of app.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(AppType appType);

        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param appName
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appName(String appName);

        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The user profile name.
         * </p>
         * 
         * @param userProfileName
         *        The user profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(AppStatus status);

        /**
         * <p>
         * The timestamp of the last health check.
         * </p>
         * 
         * @param lastHealthCheckTimestamp
         *        The timestamp of the last health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastHealthCheckTimestamp(Instant lastHealthCheckTimestamp);

        /**
         * <p>
         * The timestamp of the last user's activity. <code>LastUserActivityTimestamp</code> is also updated when
         * SageMaker performs health checks without user activity. As a result, this value is set to the same value as
         * <code>LastHealthCheckTimestamp</code>.
         * </p>
         * 
         * @param lastUserActivityTimestamp
         *        The timestamp of the last user's activity. <code>LastUserActivityTimestamp</code> is also updated when
         *        SageMaker performs health checks without user activity. As a result, this value is set to the same
         *        value as <code>LastHealthCheckTimestamp</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUserActivityTimestamp(Instant lastUserActivityTimestamp);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The failure reason.
         * </p>
         * 
         * @param failureReason
         *        The failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
         * </p>
         * 
         * @param resourceSpec
         *        The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpec(ResourceSpec resourceSpec);

        /**
         * <p>
         * The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceSpec.Builder} avoiding the need
         * to create one manually via {@link ResourceSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceSpec(ResourceSpec)}.
         * 
         * @param resourceSpec
         *        a consumer that will call methods on {@link ResourceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpec(ResourceSpec)
         */
        default Builder resourceSpec(Consumer<ResourceSpec.Builder> resourceSpec) {
            return resourceSpec(ResourceSpec.builder().applyMutation(resourceSpec).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String appArn;

        private String appType;

        private String appName;

        private String domainId;

        private String userProfileName;

        private String status;

        private Instant lastHealthCheckTimestamp;

        private Instant lastUserActivityTimestamp;

        private Instant creationTime;

        private String failureReason;

        private ResourceSpec resourceSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppResponse model) {
            super(model);
            appArn(model.appArn);
            appType(model.appType);
            appName(model.appName);
            domainId(model.domainId);
            userProfileName(model.userProfileName);
            status(model.status);
            lastHealthCheckTimestamp(model.lastHealthCheckTimestamp);
            lastUserActivityTimestamp(model.lastUserActivityTimestamp);
            creationTime(model.creationTime);
            failureReason(model.failureReason);
            resourceSpec(model.resourceSpec);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppType() {
            return appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final String getAppName() {
            return appName;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastHealthCheckTimestamp() {
            return lastHealthCheckTimestamp;
        }

        public final void setLastHealthCheckTimestamp(Instant lastHealthCheckTimestamp) {
            this.lastHealthCheckTimestamp = lastHealthCheckTimestamp;
        }

        @Override
        public final Builder lastHealthCheckTimestamp(Instant lastHealthCheckTimestamp) {
            this.lastHealthCheckTimestamp = lastHealthCheckTimestamp;
            return this;
        }

        public final Instant getLastUserActivityTimestamp() {
            return lastUserActivityTimestamp;
        }

        public final void setLastUserActivityTimestamp(Instant lastUserActivityTimestamp) {
            this.lastUserActivityTimestamp = lastUserActivityTimestamp;
        }

        @Override
        public final Builder lastUserActivityTimestamp(Instant lastUserActivityTimestamp) {
            this.lastUserActivityTimestamp = lastUserActivityTimestamp;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final ResourceSpec.Builder getResourceSpec() {
            return resourceSpec != null ? resourceSpec.toBuilder() : null;
        }

        public final void setResourceSpec(ResourceSpec.BuilderImpl resourceSpec) {
            this.resourceSpec = resourceSpec != null ? resourceSpec.build() : null;
        }

        @Override
        public final Builder resourceSpec(ResourceSpec resourceSpec) {
            this.resourceSpec = resourceSpec;
            return this;
        }

        @Override
        public DescribeAppResponse build() {
            return new DescribeAppResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
