/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelBiasJobDefinitionResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeModelBiasJobDefinitionResponse.Builder, DescribeModelBiasJobDefinitionResponse> {
    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinitionArn").getter(getter(DescribeModelBiasJobDefinitionResponse::jobDefinitionArn))
            .setter(setter(Builder::jobDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionArn").build()).build();

    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinitionName").getter(getter(DescribeModelBiasJobDefinitionResponse::jobDefinitionName))
            .setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeModelBiasJobDefinitionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<ModelBiasBaselineConfig> MODEL_BIAS_BASELINE_CONFIG_FIELD = SdkField
            .<ModelBiasBaselineConfig> builder(MarshallingType.SDK_POJO).memberName("ModelBiasBaselineConfig")
            .getter(getter(DescribeModelBiasJobDefinitionResponse::modelBiasBaselineConfig))
            .setter(setter(Builder::modelBiasBaselineConfig)).constructor(ModelBiasBaselineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasBaselineConfig").build())
            .build();

    private static final SdkField<ModelBiasAppSpecification> MODEL_BIAS_APP_SPECIFICATION_FIELD = SdkField
            .<ModelBiasAppSpecification> builder(MarshallingType.SDK_POJO).memberName("ModelBiasAppSpecification")
            .getter(getter(DescribeModelBiasJobDefinitionResponse::modelBiasAppSpecification))
            .setter(setter(Builder::modelBiasAppSpecification)).constructor(ModelBiasAppSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasAppSpecification").build())
            .build();

    private static final SdkField<ModelBiasJobInput> MODEL_BIAS_JOB_INPUT_FIELD = SdkField
            .<ModelBiasJobInput> builder(MarshallingType.SDK_POJO).memberName("ModelBiasJobInput")
            .getter(getter(DescribeModelBiasJobDefinitionResponse::modelBiasJobInput)).setter(setter(Builder::modelBiasJobInput))
            .constructor(ModelBiasJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasJobInput").build()).build();

    private static final SdkField<MonitoringOutputConfig> MODEL_BIAS_JOB_OUTPUT_CONFIG_FIELD = SdkField
            .<MonitoringOutputConfig> builder(MarshallingType.SDK_POJO).memberName("ModelBiasJobOutputConfig")
            .getter(getter(DescribeModelBiasJobDefinitionResponse::modelBiasJobOutputConfig))
            .setter(setter(Builder::modelBiasJobOutputConfig)).constructor(MonitoringOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasJobOutputConfig").build())
            .build();

    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField
            .<MonitoringResources> builder(MarshallingType.SDK_POJO).memberName("JobResources")
            .getter(getter(DescribeModelBiasJobDefinitionResponse::jobResources)).setter(setter(Builder::jobResources))
            .constructor(MonitoringResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()).build();

    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField
            .<MonitoringNetworkConfig> builder(MarshallingType.SDK_POJO).memberName("NetworkConfig")
            .getter(getter(DescribeModelBiasJobDefinitionResponse::networkConfig)).setter(setter(Builder::networkConfig))
            .constructor(MonitoringNetworkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeModelBiasJobDefinitionResponse::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<MonitoringStoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(DescribeModelBiasJobDefinitionResponse::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(MonitoringStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_ARN_FIELD,
            JOB_DEFINITION_NAME_FIELD, CREATION_TIME_FIELD, MODEL_BIAS_BASELINE_CONFIG_FIELD, MODEL_BIAS_APP_SPECIFICATION_FIELD,
            MODEL_BIAS_JOB_INPUT_FIELD, MODEL_BIAS_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD,
            ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD));

    private final String jobDefinitionArn;

    private final String jobDefinitionName;

    private final Instant creationTime;

    private final ModelBiasBaselineConfig modelBiasBaselineConfig;

    private final ModelBiasAppSpecification modelBiasAppSpecification;

    private final ModelBiasJobInput modelBiasJobInput;

    private final MonitoringOutputConfig modelBiasJobOutputConfig;

    private final MonitoringResources jobResources;

    private final MonitoringNetworkConfig networkConfig;

    private final String roleArn;

    private final MonitoringStoppingCondition stoppingCondition;

    private DescribeModelBiasJobDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.jobDefinitionName = builder.jobDefinitionName;
        this.creationTime = builder.creationTime;
        this.modelBiasBaselineConfig = builder.modelBiasBaselineConfig;
        this.modelBiasAppSpecification = builder.modelBiasAppSpecification;
        this.modelBiasJobInput = builder.modelBiasJobInput;
        this.modelBiasJobOutputConfig = builder.modelBiasJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model bias job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model bias job.
     */
    public final String jobDefinitionArn() {
        return jobDefinitionArn;
    }

    /**
     * <p>
     * The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon
     * Web Services account.
     * </p>
     * 
     * @return The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the
     *         Amazon Web Services account.
     */
    public final String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The time at which the model bias job was created.
     * </p>
     * 
     * @return The time at which the model bias job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The baseline configuration for a model bias job.
     * </p>
     * 
     * @return The baseline configuration for a model bias job.
     */
    public final ModelBiasBaselineConfig modelBiasBaselineConfig() {
        return modelBiasBaselineConfig;
    }

    /**
     * <p>
     * Configures the model bias job to run a specified Docker container image.
     * </p>
     * 
     * @return Configures the model bias job to run a specified Docker container image.
     */
    public final ModelBiasAppSpecification modelBiasAppSpecification() {
        return modelBiasAppSpecification;
    }

    /**
     * <p>
     * Inputs for the model bias job.
     * </p>
     * 
     * @return Inputs for the model bias job.
     */
    public final ModelBiasJobInput modelBiasJobInput() {
        return modelBiasJobInput;
    }

    /**
     * Returns the value of the ModelBiasJobOutputConfig property for this object.
     * 
     * @return The value of the ModelBiasJobOutputConfig property for this object.
     */
    public final MonitoringOutputConfig modelBiasJobOutputConfig() {
        return modelBiasJobOutputConfig;
    }

    /**
     * Returns the value of the JobResources property for this object.
     * 
     * @return The value of the JobResources property for this object.
     */
    public final MonitoringResources jobResources() {
        return jobResources;
    }

    /**
     * <p>
     * Networking options for a model bias job.
     * </p>
     * 
     * @return Networking options for a model bias job.
     */
    public final MonitoringNetworkConfig networkConfig() {
        return networkConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read
     * permission to the input data location and write permission to the output data location in Amazon S3.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that
     *         has read permission to the input data location and write permission to the output data location in Amazon
     *         S3.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the StoppingCondition property for this object.
     * 
     * @return The value of the StoppingCondition property for this object.
     */
    public final MonitoringStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modelBiasBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelBiasAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(modelBiasJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(modelBiasJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelBiasJobDefinitionResponse)) {
            return false;
        }
        DescribeModelBiasJobDefinitionResponse other = (DescribeModelBiasJobDefinitionResponse) obj;
        return Objects.equals(jobDefinitionArn(), other.jobDefinitionArn())
                && Objects.equals(jobDefinitionName(), other.jobDefinitionName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modelBiasBaselineConfig(), other.modelBiasBaselineConfig())
                && Objects.equals(modelBiasAppSpecification(), other.modelBiasAppSpecification())
                && Objects.equals(modelBiasJobInput(), other.modelBiasJobInput())
                && Objects.equals(modelBiasJobOutputConfig(), other.modelBiasJobOutputConfig())
                && Objects.equals(jobResources(), other.jobResources()) && Objects.equals(networkConfig(), other.networkConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(stoppingCondition(), other.stoppingCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelBiasJobDefinitionResponse").add("JobDefinitionArn", jobDefinitionArn())
                .add("JobDefinitionName", jobDefinitionName()).add("CreationTime", creationTime())
                .add("ModelBiasBaselineConfig", modelBiasBaselineConfig())
                .add("ModelBiasAppSpecification", modelBiasAppSpecification()).add("ModelBiasJobInput", modelBiasJobInput())
                .add("ModelBiasJobOutputConfig", modelBiasJobOutputConfig()).add("JobResources", jobResources())
                .add("NetworkConfig", networkConfig()).add("RoleArn", roleArn()).add("StoppingCondition", stoppingCondition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobDefinitionArn":
            return Optional.ofNullable(clazz.cast(jobDefinitionArn()));
        case "JobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModelBiasBaselineConfig":
            return Optional.ofNullable(clazz.cast(modelBiasBaselineConfig()));
        case "ModelBiasAppSpecification":
            return Optional.ofNullable(clazz.cast(modelBiasAppSpecification()));
        case "ModelBiasJobInput":
            return Optional.ofNullable(clazz.cast(modelBiasJobInput()));
        case "ModelBiasJobOutputConfig":
            return Optional.ofNullable(clazz.cast(modelBiasJobOutputConfig()));
        case "JobResources":
            return Optional.ofNullable(clazz.cast(jobResources()));
        case "NetworkConfig":
            return Optional.ofNullable(clazz.cast(networkConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelBiasJobDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeModelBiasJobDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeModelBiasJobDefinitionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model bias job.
         * </p>
         * 
         * @param jobDefinitionArn
         *        The Amazon Resource Name (ARN) of the model bias job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionArn(String jobDefinitionArn);

        /**
         * <p>
         * The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the
         * Amazon Web Services account.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the bias job definition. The name must be unique within an Amazon Web Services Region in
         *        the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The time at which the model bias job was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the model bias job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The baseline configuration for a model bias job.
         * </p>
         * 
         * @param modelBiasBaselineConfig
         *        The baseline configuration for a model bias job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelBiasBaselineConfig(ModelBiasBaselineConfig modelBiasBaselineConfig);

        /**
         * <p>
         * The baseline configuration for a model bias job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelBiasBaselineConfig.Builder} avoiding
         * the need to create one manually via {@link ModelBiasBaselineConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelBiasBaselineConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #modelBiasBaselineConfig(ModelBiasBaselineConfig)}.
         * 
         * @param modelBiasBaselineConfig
         *        a consumer that will call methods on {@link ModelBiasBaselineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelBiasBaselineConfig(ModelBiasBaselineConfig)
         */
        default Builder modelBiasBaselineConfig(Consumer<ModelBiasBaselineConfig.Builder> modelBiasBaselineConfig) {
            return modelBiasBaselineConfig(ModelBiasBaselineConfig.builder().applyMutation(modelBiasBaselineConfig).build());
        }

        /**
         * <p>
         * Configures the model bias job to run a specified Docker container image.
         * </p>
         * 
         * @param modelBiasAppSpecification
         *        Configures the model bias job to run a specified Docker container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelBiasAppSpecification(ModelBiasAppSpecification modelBiasAppSpecification);

        /**
         * <p>
         * Configures the model bias job to run a specified Docker container image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelBiasAppSpecification.Builder}
         * avoiding the need to create one manually via {@link ModelBiasAppSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelBiasAppSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #modelBiasAppSpecification(ModelBiasAppSpecification)}.
         * 
         * @param modelBiasAppSpecification
         *        a consumer that will call methods on {@link ModelBiasAppSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelBiasAppSpecification(ModelBiasAppSpecification)
         */
        default Builder modelBiasAppSpecification(Consumer<ModelBiasAppSpecification.Builder> modelBiasAppSpecification) {
            return modelBiasAppSpecification(ModelBiasAppSpecification.builder().applyMutation(modelBiasAppSpecification).build());
        }

        /**
         * <p>
         * Inputs for the model bias job.
         * </p>
         * 
         * @param modelBiasJobInput
         *        Inputs for the model bias job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelBiasJobInput(ModelBiasJobInput modelBiasJobInput);

        /**
         * <p>
         * Inputs for the model bias job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelBiasJobInput.Builder} avoiding the
         * need to create one manually via {@link ModelBiasJobInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelBiasJobInput.Builder#build()} is called immediately and its
         * result is passed to {@link #modelBiasJobInput(ModelBiasJobInput)}.
         * 
         * @param modelBiasJobInput
         *        a consumer that will call methods on {@link ModelBiasJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelBiasJobInput(ModelBiasJobInput)
         */
        default Builder modelBiasJobInput(Consumer<ModelBiasJobInput.Builder> modelBiasJobInput) {
            return modelBiasJobInput(ModelBiasJobInput.builder().applyMutation(modelBiasJobInput).build());
        }

        /**
         * Sets the value of the ModelBiasJobOutputConfig property for this object.
         *
         * @param modelBiasJobOutputConfig
         *        The new value for the ModelBiasJobOutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelBiasJobOutputConfig(MonitoringOutputConfig modelBiasJobOutputConfig);

        /**
         * Sets the value of the ModelBiasJobOutputConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringOutputConfig.Builder} avoiding
         * the need to create one manually via {@link MonitoringOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #modelBiasJobOutputConfig(MonitoringOutputConfig)}.
         * 
         * @param modelBiasJobOutputConfig
         *        a consumer that will call methods on {@link MonitoringOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelBiasJobOutputConfig(MonitoringOutputConfig)
         */
        default Builder modelBiasJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> modelBiasJobOutputConfig) {
            return modelBiasJobOutputConfig(MonitoringOutputConfig.builder().applyMutation(modelBiasJobOutputConfig).build());
        }

        /**
         * Sets the value of the JobResources property for this object.
         *
         * @param jobResources
         *        The new value for the JobResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobResources(MonitoringResources jobResources);

        /**
         * Sets the value of the JobResources property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringResources.Builder} avoiding the
         * need to create one manually via {@link MonitoringResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringResources.Builder#build()} is called immediately and
         * its result is passed to {@link #jobResources(MonitoringResources)}.
         * 
         * @param jobResources
         *        a consumer that will call methods on {@link MonitoringResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobResources(MonitoringResources)
         */
        default Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return jobResources(MonitoringResources.builder().applyMutation(jobResources).build());
        }

        /**
         * <p>
         * Networking options for a model bias job.
         * </p>
         * 
         * @param networkConfig
         *        Networking options for a model bias job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfig(MonitoringNetworkConfig networkConfig);

        /**
         * <p>
         * Networking options for a model bias job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringNetworkConfig.Builder} avoiding
         * the need to create one manually via {@link MonitoringNetworkConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringNetworkConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #networkConfig(MonitoringNetworkConfig)}.
         * 
         * @param networkConfig
         *        a consumer that will call methods on {@link MonitoringNetworkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfig(MonitoringNetworkConfig)
         */
        default Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return networkConfig(MonitoringNetworkConfig.builder().applyMutation(networkConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has
         * read permission to the input data location and write permission to the output data location in Amazon S3.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role
         *        that has read permission to the input data location and write permission to the output data location
         *        in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * @param stoppingCondition
         *        The new value for the StoppingCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringStoppingCondition.Builder}
         * avoiding the need to create one manually via {@link MonitoringStoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringStoppingCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingCondition(MonitoringStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link MonitoringStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(MonitoringStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(MonitoringStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String jobDefinitionArn;

        private String jobDefinitionName;

        private Instant creationTime;

        private ModelBiasBaselineConfig modelBiasBaselineConfig;

        private ModelBiasAppSpecification modelBiasAppSpecification;

        private ModelBiasJobInput modelBiasJobInput;

        private MonitoringOutputConfig modelBiasJobOutputConfig;

        private MonitoringResources jobResources;

        private MonitoringNetworkConfig networkConfig;

        private String roleArn;

        private MonitoringStoppingCondition stoppingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelBiasJobDefinitionResponse model) {
            super(model);
            jobDefinitionArn(model.jobDefinitionArn);
            jobDefinitionName(model.jobDefinitionName);
            creationTime(model.creationTime);
            modelBiasBaselineConfig(model.modelBiasBaselineConfig);
            modelBiasAppSpecification(model.modelBiasAppSpecification);
            modelBiasJobInput(model.modelBiasJobInput);
            modelBiasJobOutputConfig(model.modelBiasJobOutputConfig);
            jobResources(model.jobResources);
            networkConfig(model.networkConfig);
            roleArn(model.roleArn);
            stoppingCondition(model.stoppingCondition);
        }

        public final String getJobDefinitionArn() {
            return jobDefinitionArn;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ModelBiasBaselineConfig.Builder getModelBiasBaselineConfig() {
            return modelBiasBaselineConfig != null ? modelBiasBaselineConfig.toBuilder() : null;
        }

        public final void setModelBiasBaselineConfig(ModelBiasBaselineConfig.BuilderImpl modelBiasBaselineConfig) {
            this.modelBiasBaselineConfig = modelBiasBaselineConfig != null ? modelBiasBaselineConfig.build() : null;
        }

        @Override
        public final Builder modelBiasBaselineConfig(ModelBiasBaselineConfig modelBiasBaselineConfig) {
            this.modelBiasBaselineConfig = modelBiasBaselineConfig;
            return this;
        }

        public final ModelBiasAppSpecification.Builder getModelBiasAppSpecification() {
            return modelBiasAppSpecification != null ? modelBiasAppSpecification.toBuilder() : null;
        }

        public final void setModelBiasAppSpecification(ModelBiasAppSpecification.BuilderImpl modelBiasAppSpecification) {
            this.modelBiasAppSpecification = modelBiasAppSpecification != null ? modelBiasAppSpecification.build() : null;
        }

        @Override
        public final Builder modelBiasAppSpecification(ModelBiasAppSpecification modelBiasAppSpecification) {
            this.modelBiasAppSpecification = modelBiasAppSpecification;
            return this;
        }

        public final ModelBiasJobInput.Builder getModelBiasJobInput() {
            return modelBiasJobInput != null ? modelBiasJobInput.toBuilder() : null;
        }

        public final void setModelBiasJobInput(ModelBiasJobInput.BuilderImpl modelBiasJobInput) {
            this.modelBiasJobInput = modelBiasJobInput != null ? modelBiasJobInput.build() : null;
        }

        @Override
        public final Builder modelBiasJobInput(ModelBiasJobInput modelBiasJobInput) {
            this.modelBiasJobInput = modelBiasJobInput;
            return this;
        }

        public final MonitoringOutputConfig.Builder getModelBiasJobOutputConfig() {
            return modelBiasJobOutputConfig != null ? modelBiasJobOutputConfig.toBuilder() : null;
        }

        public final void setModelBiasJobOutputConfig(MonitoringOutputConfig.BuilderImpl modelBiasJobOutputConfig) {
            this.modelBiasJobOutputConfig = modelBiasJobOutputConfig != null ? modelBiasJobOutputConfig.build() : null;
        }

        @Override
        public final Builder modelBiasJobOutputConfig(MonitoringOutputConfig modelBiasJobOutputConfig) {
            this.modelBiasJobOutputConfig = modelBiasJobOutputConfig;
            return this;
        }

        public final MonitoringResources.Builder getJobResources() {
            return jobResources != null ? jobResources.toBuilder() : null;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return networkConfig != null ? networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        @Override
        public DescribeModelBiasJobDefinitionResponse build() {
            return new DescribeModelBiasJobDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
