/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The endpoint configuration for the load test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointInputConfiguration.Builder, EndpointInputConfiguration> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(EndpointInputConfiguration::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> INFERENCE_SPECIFICATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InferenceSpecificationName")
            .getter(getter(EndpointInputConfiguration::inferenceSpecificationName))
            .setter(setter(Builder::inferenceSpecificationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecificationName").build())
            .build();

    private static final SdkField<EnvironmentParameterRanges> ENVIRONMENT_PARAMETER_RANGES_FIELD = SdkField
            .<EnvironmentParameterRanges> builder(MarshallingType.SDK_POJO)
            .memberName("EnvironmentParameterRanges")
            .getter(getter(EndpointInputConfiguration::environmentParameterRanges))
            .setter(setter(Builder::environmentParameterRanges))
            .constructor(EnvironmentParameterRanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentParameterRanges").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            INFERENCE_SPECIFICATION_NAME_FIELD, ENVIRONMENT_PARAMETER_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final String inferenceSpecificationName;

    private final EnvironmentParameterRanges environmentParameterRanges;

    private EndpointInputConfiguration(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.inferenceSpecificationName = builder.inferenceSpecificationName;
        this.environmentParameterRanges = builder.environmentParameterRanges;
    }

    /**
     * <p>
     * The instance types to use for the load test.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ProductionVariantInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance types to use for the load test.
     * @see ProductionVariantInstanceType
     */
    public final ProductionVariantInstanceType instanceType() {
        return ProductionVariantInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance types to use for the load test.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ProductionVariantInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance types to use for the load test.
     * @see ProductionVariantInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The inference specification name in the model package version.
     * </p>
     * 
     * @return The inference specification name in the model package version.
     */
    public final String inferenceSpecificationName() {
        return inferenceSpecificationName;
    }

    /**
     * <p>
     * The parameter you want to benchmark against.
     * </p>
     * 
     * @return The parameter you want to benchmark against.
     */
    public final EnvironmentParameterRanges environmentParameterRanges() {
        return environmentParameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSpecificationName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentParameterRanges());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointInputConfiguration)) {
            return false;
        }
        EndpointInputConfiguration other = (EndpointInputConfiguration) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(inferenceSpecificationName(), other.inferenceSpecificationName())
                && Objects.equals(environmentParameterRanges(), other.environmentParameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointInputConfiguration").add("InstanceType", instanceTypeAsString())
                .add("InferenceSpecificationName", inferenceSpecificationName())
                .add("EnvironmentParameterRanges", environmentParameterRanges()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InferenceSpecificationName":
            return Optional.ofNullable(clazz.cast(inferenceSpecificationName()));
        case "EnvironmentParameterRanges":
            return Optional.ofNullable(clazz.cast(environmentParameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointInputConfiguration, T> g) {
        return obj -> g.apply((EndpointInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointInputConfiguration> {
        /**
         * <p>
         * The instance types to use for the load test.
         * </p>
         * 
         * @param instanceType
         *        The instance types to use for the load test.
         * @see ProductionVariantInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductionVariantInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance types to use for the load test.
         * </p>
         * 
         * @param instanceType
         *        The instance types to use for the load test.
         * @see ProductionVariantInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductionVariantInstanceType
         */
        Builder instanceType(ProductionVariantInstanceType instanceType);

        /**
         * <p>
         * The inference specification name in the model package version.
         * </p>
         * 
         * @param inferenceSpecificationName
         *        The inference specification name in the model package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSpecificationName(String inferenceSpecificationName);

        /**
         * <p>
         * The parameter you want to benchmark against.
         * </p>
         * 
         * @param environmentParameterRanges
         *        The parameter you want to benchmark against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentParameterRanges(EnvironmentParameterRanges environmentParameterRanges);

        /**
         * <p>
         * The parameter you want to benchmark against.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentParameterRanges.Builder}
         * avoiding the need to create one manually via {@link EnvironmentParameterRanges#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentParameterRanges.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentParameterRanges(EnvironmentParameterRanges)}.
         * 
         * @param environmentParameterRanges
         *        a consumer that will call methods on {@link EnvironmentParameterRanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentParameterRanges(EnvironmentParameterRanges)
         */
        default Builder environmentParameterRanges(Consumer<EnvironmentParameterRanges.Builder> environmentParameterRanges) {
            return environmentParameterRanges(EnvironmentParameterRanges.builder().applyMutation(environmentParameterRanges)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private String inferenceSpecificationName;

        private EnvironmentParameterRanges environmentParameterRanges;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointInputConfiguration model) {
            instanceType(model.instanceType);
            inferenceSpecificationName(model.inferenceSpecificationName);
            environmentParameterRanges(model.environmentParameterRanges);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ProductionVariantInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getInferenceSpecificationName() {
            return inferenceSpecificationName;
        }

        public final void setInferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
        }

        @Override
        public final Builder inferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
            return this;
        }

        public final EnvironmentParameterRanges.Builder getEnvironmentParameterRanges() {
            return environmentParameterRanges != null ? environmentParameterRanges.toBuilder() : null;
        }

        public final void setEnvironmentParameterRanges(EnvironmentParameterRanges.BuilderImpl environmentParameterRanges) {
            this.environmentParameterRanges = environmentParameterRanges != null ? environmentParameterRanges.build() : null;
        }

        @Override
        public final Builder environmentParameterRanges(EnvironmentParameterRanges environmentParameterRanges) {
            this.environmentParameterRanges = environmentParameterRanges;
            return this;
        }

        @Override
        public EndpointInputConfiguration build() {
            return new EndpointInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
