/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The JupyterServer app settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JupyterServerAppSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<JupyterServerAppSettings.Builder, JupyterServerAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField
            .<ResourceSpec> builder(MarshallingType.SDK_POJO).memberName("DefaultResourceSpec")
            .getter(getter(JupyterServerAppSettings::defaultResourceSpec)).setter(setter(Builder::defaultResourceSpec))
            .constructor(ResourceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build())
            .build();

    private static final SdkField<List<String>> LIFECYCLE_CONFIG_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LifecycleConfigArns")
            .getter(getter(JupyterServerAppSettings::lifecycleConfigArns))
            .setter(setter(Builder::lifecycleConfigArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD,
            LIFECYCLE_CONFIG_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResourceSpec defaultResourceSpec;

    private final List<String> lifecycleConfigArns;

    private JupyterServerAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.lifecycleConfigArns = builder.lifecycleConfigArns;
    }

    /**
     * <p>
     * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the
     * JupyterServer app. If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also
     * required.
     * </p>
     * 
     * @return The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the
     *         JupyterServer app. If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also
     *         required.
     */
    public final ResourceSpec defaultResourceSpec() {
        return defaultResourceSpec;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecycleConfigArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLifecycleConfigArns() {
        return lifecycleConfigArns != null && !(lifecycleConfigArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If you use this
     * parameter, the <code>DefaultResourceSpec</code> parameter is also required.
     * </p>
     * <note>
     * <p>
     * To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecycleConfigArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If you
     *         use this parameter, the <code>DefaultResourceSpec</code> parameter is also required.</p> <note>
     *         <p>
     *         To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
     *         </p>
     */
    public final List<String> lifecycleConfigArns() {
        return lifecycleConfigArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecycleConfigArns() ? lifecycleConfigArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JupyterServerAppSettings)) {
            return false;
        }
        JupyterServerAppSettings other = (JupyterServerAppSettings) obj;
        return Objects.equals(defaultResourceSpec(), other.defaultResourceSpec())
                && hasLifecycleConfigArns() == other.hasLifecycleConfigArns()
                && Objects.equals(lifecycleConfigArns(), other.lifecycleConfigArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JupyterServerAppSettings").add("DefaultResourceSpec", defaultResourceSpec())
                .add("LifecycleConfigArns", hasLifecycleConfigArns() ? lifecycleConfigArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultResourceSpec":
            return Optional.ofNullable(clazz.cast(defaultResourceSpec()));
        case "LifecycleConfigArns":
            return Optional.ofNullable(clazz.cast(lifecycleConfigArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JupyterServerAppSettings, T> g) {
        return obj -> g.apply((JupyterServerAppSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JupyterServerAppSettings> {
        /**
         * <p>
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the
         * JupyterServer app. If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also
         * required.
         * </p>
         * 
         * @param defaultResourceSpec
         *        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by
         *        the JupyterServer app. If you use the <code>LifecycleConfigArns</code> parameter, then this parameter
         *        is also required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResourceSpec(ResourceSpec defaultResourceSpec);

        /**
         * <p>
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the
         * JupyterServer app. If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also
         * required.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceSpec.Builder} avoiding the need
         * to create one manually via {@link ResourceSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultResourceSpec(ResourceSpec)}.
         * 
         * @param defaultResourceSpec
         *        a consumer that will call methods on {@link ResourceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultResourceSpec(ResourceSpec)
         */
        default Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return defaultResourceSpec(ResourceSpec.builder().applyMutation(defaultResourceSpec).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If you use
         * this parameter, the <code>DefaultResourceSpec</code> parameter is also required.
         * </p>
         * <note>
         * <p>
         * To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * </p>
         * </note>
         * 
         * @param lifecycleConfigArns
         *        The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If
         *        you use this parameter, the <code>DefaultResourceSpec</code> parameter is also required.</p> <note>
         *        <p>
         *        To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfigArns(Collection<String> lifecycleConfigArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If you use
         * this parameter, the <code>DefaultResourceSpec</code> parameter is also required.
         * </p>
         * <note>
         * <p>
         * To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * </p>
         * </note>
         * 
         * @param lifecycleConfigArns
         *        The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If
         *        you use this parameter, the <code>DefaultResourceSpec</code> parameter is also required.</p> <note>
         *        <p>
         *        To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfigArns(String... lifecycleConfigArns);
    }

    static final class BuilderImpl implements Builder {
        private ResourceSpec defaultResourceSpec;

        private List<String> lifecycleConfigArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JupyterServerAppSettings model) {
            defaultResourceSpec(model.defaultResourceSpec);
            lifecycleConfigArns(model.lifecycleConfigArns);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return defaultResourceSpec != null ? defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final Collection<String> getLifecycleConfigArns() {
            if (lifecycleConfigArns instanceof SdkAutoConstructList) {
                return null;
            }
            return lifecycleConfigArns;
        }

        public final void setLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
        }

        @Override
        public final Builder lifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleConfigArns(String... lifecycleConfigArns) {
            lifecycleConfigArns(Arrays.asList(lifecycleConfigArns));
            return this;
        }

        @Override
        public JupyterServerAppSettings build() {
            return new JupyterServerAppSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
