/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies mandatory fields for running an Inference Recommender job directly in the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html"
 * >CreateInferenceRecommendationsJob</a> API. The fields specified in <code>ContainerConfig</code> override the
 * corresponding fields in the model package. Use <code>ContainerConfig</code> if you want to specify these fields for
 * the recommendation job but don't want to edit them in your model package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationJobContainerConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationJobContainerConfig.Builder, RecommendationJobContainerConfig> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(RecommendationJobContainerConfig::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> TASK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Task")
            .getter(getter(RecommendationJobContainerConfig::task)).setter(setter(Builder::task))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Framework").getter(getter(RecommendationJobContainerConfig::framework))
            .setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()).build();

    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkVersion").getter(getter(RecommendationJobContainerConfig::frameworkVersion))
            .setter(setter(Builder::frameworkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()).build();

    private static final SdkField<RecommendationJobPayloadConfig> PAYLOAD_CONFIG_FIELD = SdkField
            .<RecommendationJobPayloadConfig> builder(MarshallingType.SDK_POJO).memberName("PayloadConfig")
            .getter(getter(RecommendationJobContainerConfig::payloadConfig)).setter(setter(Builder::payloadConfig))
            .constructor(RecommendationJobPayloadConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadConfig").build()).build();

    private static final SdkField<String> NEAREST_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NearestModelName").getter(getter(RecommendationJobContainerConfig::nearestModelName))
            .setter(setter(Builder::nearestModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NearestModelName").build()).build();

    private static final SdkField<List<String>> SUPPORTED_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedInstanceTypes")
            .getter(getter(RecommendationJobContainerConfig::supportedInstanceTypes))
            .setter(setter(Builder::supportedInstanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, TASK_FIELD,
            FRAMEWORK_FIELD, FRAMEWORK_VERSION_FIELD, PAYLOAD_CONFIG_FIELD, NEAREST_MODEL_NAME_FIELD,
            SUPPORTED_INSTANCE_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String task;

    private final String framework;

    private final String frameworkVersion;

    private final RecommendationJobPayloadConfig payloadConfig;

    private final String nearestModelName;

    private final List<String> supportedInstanceTypes;

    private RecommendationJobContainerConfig(BuilderImpl builder) {
        this.domain = builder.domain;
        this.task = builder.task;
        this.framework = builder.framework;
        this.frameworkVersion = builder.frameworkVersion;
        this.payloadConfig = builder.payloadConfig;
        this.nearestModelName = builder.nearestModelName;
        this.supportedInstanceTypes = builder.supportedInstanceTypes;
    }

    /**
     * <p>
     * The machine learning domain of the model and its components.
     * </p>
     * <p>
     * Valid Values: <code>COMPUTER_VISION | NATURAL_LANGUAGE_PROCESSING | MACHINE_LEARNING</code>
     * </p>
     * 
     * @return The machine learning domain of the model and its components.</p>
     *         <p>
     *         Valid Values: <code>COMPUTER_VISION | NATURAL_LANGUAGE_PROCESSING | MACHINE_LEARNING</code>
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The machine learning task that the model accomplishes.
     * </p>
     * <p>
     * Valid Values:
     * <code>IMAGE_CLASSIFICATION | OBJECT_DETECTION | TEXT_GENERATION | IMAGE_SEGMENTATION | FILL_MASK | CLASSIFICATION | REGRESSION | OTHER</code>
     * </p>
     * 
     * @return The machine learning task that the model accomplishes.</p>
     *         <p>
     *         Valid Values:
     *         <code>IMAGE_CLASSIFICATION | OBJECT_DETECTION | TEXT_GENERATION | IMAGE_SEGMENTATION | FILL_MASK | CLASSIFICATION | REGRESSION | OTHER</code>
     */
    public final String task() {
        return task;
    }

    /**
     * <p>
     * The machine learning framework of the container image.
     * </p>
     * <p>
     * Valid Values: <code>TENSORFLOW | PYTORCH | XGBOOST | SAGEMAKER-SCIKIT-LEARN</code>
     * </p>
     * 
     * @return The machine learning framework of the container image.</p>
     *         <p>
     *         Valid Values: <code>TENSORFLOW | PYTORCH | XGBOOST | SAGEMAKER-SCIKIT-LEARN</code>
     */
    public final String framework() {
        return framework;
    }

    /**
     * <p>
     * The framework version of the container image.
     * </p>
     * 
     * @return The framework version of the container image.
     */
    public final String frameworkVersion() {
        return frameworkVersion;
    }

    /**
     * <p>
     * Specifies the <code>SamplePayloadUrl</code> and all other sample payload-related fields.
     * </p>
     * 
     * @return Specifies the <code>SamplePayloadUrl</code> and all other sample payload-related fields.
     */
    public final RecommendationJobPayloadConfig payloadConfig() {
        return payloadConfig;
    }

    /**
     * <p>
     * The name of a pre-trained machine learning model benchmarked by Amazon SageMaker Inference Recommender that
     * matches your model.
     * </p>
     * <p>
     * Valid Values:
     * <code>efficientnetb7 | unet | xgboost | faster-rcnn-resnet101 | nasnetlarge | vgg16 | inception-v3 | mask-rcnn | sagemaker-scikit-learn | densenet201-gluon | resnet18v2-gluon | xception | densenet201 | yolov4 | resnet152 | bert-base-cased | xceptionV1-keras | resnet50 | retinanet</code>
     * </p>
     * 
     * @return The name of a pre-trained machine learning model benchmarked by Amazon SageMaker Inference Recommender
     *         that matches your model.</p>
     *         <p>
     *         Valid Values:
     *         <code>efficientnetb7 | unet | xgboost | faster-rcnn-resnet101 | nasnetlarge | vgg16 | inception-v3 | mask-rcnn | sagemaker-scikit-learn | densenet201-gluon | resnet18v2-gluon | xception | densenet201 | yolov4 | resnet152 | bert-base-cased | xceptionV1-keras | resnet50 | retinanet</code>
     */
    public final String nearestModelName() {
        return nearestModelName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedInstanceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedInstanceTypes() {
        return supportedInstanceTypes != null && !(supportedInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the instance types that are used to generate inferences in real-time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedInstanceTypes} method.
     * </p>
     * 
     * @return A list of the instance types that are used to generate inferences in real-time.
     */
    public final List<String> supportedInstanceTypes() {
        return supportedInstanceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(payloadConfig());
        hashCode = 31 * hashCode + Objects.hashCode(nearestModelName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedInstanceTypes() ? supportedInstanceTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobContainerConfig)) {
            return false;
        }
        RecommendationJobContainerConfig other = (RecommendationJobContainerConfig) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(task(), other.task())
                && Objects.equals(framework(), other.framework()) && Objects.equals(frameworkVersion(), other.frameworkVersion())
                && Objects.equals(payloadConfig(), other.payloadConfig())
                && Objects.equals(nearestModelName(), other.nearestModelName())
                && hasSupportedInstanceTypes() == other.hasSupportedInstanceTypes()
                && Objects.equals(supportedInstanceTypes(), other.supportedInstanceTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationJobContainerConfig").add("Domain", domain()).add("Task", task())
                .add("Framework", framework()).add("FrameworkVersion", frameworkVersion()).add("PayloadConfig", payloadConfig())
                .add("NearestModelName", nearestModelName())
                .add("SupportedInstanceTypes", hasSupportedInstanceTypes() ? supportedInstanceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Task":
            return Optional.ofNullable(clazz.cast(task()));
        case "Framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "FrameworkVersion":
            return Optional.ofNullable(clazz.cast(frameworkVersion()));
        case "PayloadConfig":
            return Optional.ofNullable(clazz.cast(payloadConfig()));
        case "NearestModelName":
            return Optional.ofNullable(clazz.cast(nearestModelName()));
        case "SupportedInstanceTypes":
            return Optional.ofNullable(clazz.cast(supportedInstanceTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobContainerConfig, T> g) {
        return obj -> g.apply((RecommendationJobContainerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationJobContainerConfig> {
        /**
         * <p>
         * The machine learning domain of the model and its components.
         * </p>
         * <p>
         * Valid Values: <code>COMPUTER_VISION | NATURAL_LANGUAGE_PROCESSING | MACHINE_LEARNING</code>
         * </p>
         * 
         * @param domain
         *        The machine learning domain of the model and its components.</p>
         *        <p>
         *        Valid Values: <code>COMPUTER_VISION | NATURAL_LANGUAGE_PROCESSING | MACHINE_LEARNING</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The machine learning task that the model accomplishes.
         * </p>
         * <p>
         * Valid Values:
         * <code>IMAGE_CLASSIFICATION | OBJECT_DETECTION | TEXT_GENERATION | IMAGE_SEGMENTATION | FILL_MASK | CLASSIFICATION | REGRESSION | OTHER</code>
         * </p>
         * 
         * @param task
         *        The machine learning task that the model accomplishes.</p>
         *        <p>
         *        Valid Values:
         *        <code>IMAGE_CLASSIFICATION | OBJECT_DETECTION | TEXT_GENERATION | IMAGE_SEGMENTATION | FILL_MASK | CLASSIFICATION | REGRESSION | OTHER</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(String task);

        /**
         * <p>
         * The machine learning framework of the container image.
         * </p>
         * <p>
         * Valid Values: <code>TENSORFLOW | PYTORCH | XGBOOST | SAGEMAKER-SCIKIT-LEARN</code>
         * </p>
         * 
         * @param framework
         *        The machine learning framework of the container image.</p>
         *        <p>
         *        Valid Values: <code>TENSORFLOW | PYTORCH | XGBOOST | SAGEMAKER-SCIKIT-LEARN</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(String framework);

        /**
         * <p>
         * The framework version of the container image.
         * </p>
         * 
         * @param frameworkVersion
         *        The framework version of the container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkVersion(String frameworkVersion);

        /**
         * <p>
         * Specifies the <code>SamplePayloadUrl</code> and all other sample payload-related fields.
         * </p>
         * 
         * @param payloadConfig
         *        Specifies the <code>SamplePayloadUrl</code> and all other sample payload-related fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadConfig(RecommendationJobPayloadConfig payloadConfig);

        /**
         * <p>
         * Specifies the <code>SamplePayloadUrl</code> and all other sample payload-related fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationJobPayloadConfig.Builder}
         * avoiding the need to create one manually via {@link RecommendationJobPayloadConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationJobPayloadConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #payloadConfig(RecommendationJobPayloadConfig)}.
         * 
         * @param payloadConfig
         *        a consumer that will call methods on {@link RecommendationJobPayloadConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payloadConfig(RecommendationJobPayloadConfig)
         */
        default Builder payloadConfig(Consumer<RecommendationJobPayloadConfig.Builder> payloadConfig) {
            return payloadConfig(RecommendationJobPayloadConfig.builder().applyMutation(payloadConfig).build());
        }

        /**
         * <p>
         * The name of a pre-trained machine learning model benchmarked by Amazon SageMaker Inference Recommender that
         * matches your model.
         * </p>
         * <p>
         * Valid Values:
         * <code>efficientnetb7 | unet | xgboost | faster-rcnn-resnet101 | nasnetlarge | vgg16 | inception-v3 | mask-rcnn | sagemaker-scikit-learn | densenet201-gluon | resnet18v2-gluon | xception | densenet201 | yolov4 | resnet152 | bert-base-cased | xceptionV1-keras | resnet50 | retinanet</code>
         * </p>
         * 
         * @param nearestModelName
         *        The name of a pre-trained machine learning model benchmarked by Amazon SageMaker Inference Recommender
         *        that matches your model.</p>
         *        <p>
         *        Valid Values:
         *        <code>efficientnetb7 | unet | xgboost | faster-rcnn-resnet101 | nasnetlarge | vgg16 | inception-v3 | mask-rcnn | sagemaker-scikit-learn | densenet201-gluon | resnet18v2-gluon | xception | densenet201 | yolov4 | resnet152 | bert-base-cased | xceptionV1-keras | resnet50 | retinanet</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nearestModelName(String nearestModelName);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedInstanceTypes(Collection<String> supportedInstanceTypes);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedInstanceTypes(String... supportedInstanceTypes);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String task;

        private String framework;

        private String frameworkVersion;

        private RecommendationJobPayloadConfig payloadConfig;

        private String nearestModelName;

        private List<String> supportedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobContainerConfig model) {
            domain(model.domain);
            task(model.task);
            framework(model.framework);
            frameworkVersion(model.frameworkVersion);
            payloadConfig(model.payloadConfig);
            nearestModelName(model.nearestModelName);
            supportedInstanceTypes(model.supportedInstanceTypes);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getTask() {
            return task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getFramework() {
            return framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final String getFrameworkVersion() {
            return frameworkVersion;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public final RecommendationJobPayloadConfig.Builder getPayloadConfig() {
            return payloadConfig != null ? payloadConfig.toBuilder() : null;
        }

        public final void setPayloadConfig(RecommendationJobPayloadConfig.BuilderImpl payloadConfig) {
            this.payloadConfig = payloadConfig != null ? payloadConfig.build() : null;
        }

        @Override
        public final Builder payloadConfig(RecommendationJobPayloadConfig payloadConfig) {
            this.payloadConfig = payloadConfig;
            return this;
        }

        public final String getNearestModelName() {
            return nearestModelName;
        }

        public final void setNearestModelName(String nearestModelName) {
            this.nearestModelName = nearestModelName;
        }

        @Override
        public final Builder nearestModelName(String nearestModelName) {
            this.nearestModelName = nearestModelName;
            return this;
        }

        public final Collection<String> getSupportedInstanceTypes() {
            if (supportedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedInstanceTypes;
        }

        public final void setSupportedInstanceTypes(Collection<String> supportedInstanceTypes) {
            this.supportedInstanceTypes = RecommendationJobSupportedInstanceTypesCopier.copy(supportedInstanceTypes);
        }

        @Override
        public final Builder supportedInstanceTypes(Collection<String> supportedInstanceTypes) {
            this.supportedInstanceTypes = RecommendationJobSupportedInstanceTypesCopier.copy(supportedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedInstanceTypes(String... supportedInstanceTypes) {
            supportedInstanceTypes(Arrays.asList(supportedInstanceTypes));
            return this;
        }

        @Override
        public RecommendationJobContainerConfig build() {
            return new RecommendationJobContainerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
