/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAutoMlJobV2Response extends SageMakerResponse implements
        ToCopyableBuilder<DescribeAutoMlJobV2Response.Builder, DescribeAutoMlJobV2Response> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobName").getter(getter(DescribeAutoMlJobV2Response::autoMLJobName))
            .setter(setter(Builder::autoMLJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobArn").getter(getter(DescribeAutoMlJobV2Response::autoMLJobArn))
            .setter(setter(Builder::autoMLJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()).build();

    private static final SdkField<List<AutoMLJobChannel>> AUTO_ML_JOB_INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<AutoMLJobChannel>> builder(MarshallingType.LIST)
            .memberName("AutoMLJobInputDataConfig")
            .getter(getter(DescribeAutoMlJobV2Response::autoMLJobInputDataConfig))
            .setter(setter(Builder::autoMLJobInputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobInputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLJobChannel> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLJobChannel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoMLOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<AutoMLOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(DescribeAutoMlJobV2Response::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(AutoMLOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeAutoMlJobV2Response::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField
            .<AutoMLJobObjective> builder(MarshallingType.SDK_POJO).memberName("AutoMLJobObjective")
            .getter(getter(DescribeAutoMlJobV2Response::autoMLJobObjective)).setter(setter(Builder::autoMLJobObjective))
            .constructor(AutoMLJobObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build())
            .build();

    private static final SdkField<AutoMLProblemTypeConfig> AUTO_ML_PROBLEM_TYPE_CONFIG_FIELD = SdkField
            .<AutoMLProblemTypeConfig> builder(MarshallingType.SDK_POJO).memberName("AutoMLProblemTypeConfig")
            .getter(getter(DescribeAutoMlJobV2Response::autoMLProblemTypeConfig))
            .setter(setter(Builder::autoMLProblemTypeConfig)).constructor(AutoMLProblemTypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLProblemTypeConfig").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeAutoMlJobV2Response::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeAutoMlJobV2Response::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeAutoMlJobV2Response::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeAutoMlJobV2Response::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<List<AutoMLPartialFailureReason>> PARTIAL_FAILURE_REASONS_FIELD = SdkField
            .<List<AutoMLPartialFailureReason>> builder(MarshallingType.LIST)
            .memberName("PartialFailureReasons")
            .getter(getter(DescribeAutoMlJobV2Response::partialFailureReasons))
            .setter(setter(Builder::partialFailureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialFailureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLPartialFailureReason> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLPartialFailureReason::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoMLCandidate> BEST_CANDIDATE_FIELD = SdkField
            .<AutoMLCandidate> builder(MarshallingType.SDK_POJO).memberName("BestCandidate")
            .getter(getter(DescribeAutoMlJobV2Response::bestCandidate)).setter(setter(Builder::bestCandidate))
            .constructor(AutoMLCandidate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCandidate").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobStatus").getter(getter(DescribeAutoMlJobV2Response::autoMLJobStatusAsString))
            .setter(setter(Builder::autoMLJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobStatus").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_SECONDARY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobSecondaryStatus").getter(getter(DescribeAutoMlJobV2Response::autoMLJobSecondaryStatusAsString))
            .setter(setter(Builder::autoMLJobSecondaryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobSecondaryStatus").build())
            .build();

    private static final SdkField<ModelDeployConfig> MODEL_DEPLOY_CONFIG_FIELD = SdkField
            .<ModelDeployConfig> builder(MarshallingType.SDK_POJO).memberName("ModelDeployConfig")
            .getter(getter(DescribeAutoMlJobV2Response::modelDeployConfig)).setter(setter(Builder::modelDeployConfig))
            .constructor(ModelDeployConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDeployConfig").build()).build();

    private static final SdkField<ModelDeployResult> MODEL_DEPLOY_RESULT_FIELD = SdkField
            .<ModelDeployResult> builder(MarshallingType.SDK_POJO).memberName("ModelDeployResult")
            .getter(getter(DescribeAutoMlJobV2Response::modelDeployResult)).setter(setter(Builder::modelDeployResult))
            .constructor(ModelDeployResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDeployResult").build()).build();

    private static final SdkField<AutoMLDataSplitConfig> DATA_SPLIT_CONFIG_FIELD = SdkField
            .<AutoMLDataSplitConfig> builder(MarshallingType.SDK_POJO).memberName("DataSplitConfig")
            .getter(getter(DescribeAutoMlJobV2Response::dataSplitConfig)).setter(setter(Builder::dataSplitConfig))
            .constructor(AutoMLDataSplitConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSplitConfig").build()).build();

    private static final SdkField<AutoMLSecurityConfig> SECURITY_CONFIG_FIELD = SdkField
            .<AutoMLSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("SecurityConfig")
            .getter(getter(DescribeAutoMlJobV2Response::securityConfig)).setter(setter(Builder::securityConfig))
            .constructor(AutoMLSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()).build();

    private static final SdkField<AutoMLJobArtifacts> AUTO_ML_JOB_ARTIFACTS_FIELD = SdkField
            .<AutoMLJobArtifacts> builder(MarshallingType.SDK_POJO).memberName("AutoMLJobArtifacts")
            .getter(getter(DescribeAutoMlJobV2Response::autoMLJobArtifacts)).setter(setter(Builder::autoMLJobArtifacts))
            .constructor(AutoMLJobArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArtifacts").build())
            .build();

    private static final SdkField<AutoMLResolvedAttributes> RESOLVED_ATTRIBUTES_FIELD = SdkField
            .<AutoMLResolvedAttributes> builder(MarshallingType.SDK_POJO).memberName("ResolvedAttributes")
            .getter(getter(DescribeAutoMlJobV2Response::resolvedAttributes)).setter(setter(Builder::resolvedAttributes))
            .constructor(AutoMLResolvedAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedAttributes").build())
            .build();

    private static final SdkField<String> AUTO_ML_PROBLEM_TYPE_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoMLProblemTypeConfigName")
            .getter(getter(DescribeAutoMlJobV2Response::autoMLProblemTypeConfigNameAsString))
            .setter(setter(Builder::autoMLProblemTypeConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLProblemTypeConfigName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD,
            AUTO_ML_JOB_ARN_FIELD, AUTO_ML_JOB_INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, ROLE_ARN_FIELD,
            AUTO_ML_JOB_OBJECTIVE_FIELD, AUTO_ML_PROBLEM_TYPE_CONFIG_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, PARTIAL_FAILURE_REASONS_FIELD, BEST_CANDIDATE_FIELD,
            AUTO_ML_JOB_STATUS_FIELD, AUTO_ML_JOB_SECONDARY_STATUS_FIELD, MODEL_DEPLOY_CONFIG_FIELD, MODEL_DEPLOY_RESULT_FIELD,
            DATA_SPLIT_CONFIG_FIELD, SECURITY_CONFIG_FIELD, AUTO_ML_JOB_ARTIFACTS_FIELD, RESOLVED_ATTRIBUTES_FIELD,
            AUTO_ML_PROBLEM_TYPE_CONFIG_NAME_FIELD));

    private final String autoMLJobName;

    private final String autoMLJobArn;

    private final List<AutoMLJobChannel> autoMLJobInputDataConfig;

    private final AutoMLOutputDataConfig outputDataConfig;

    private final String roleArn;

    private final AutoMLJobObjective autoMLJobObjective;

    private final AutoMLProblemTypeConfig autoMLProblemTypeConfig;

    private final Instant creationTime;

    private final Instant endTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final List<AutoMLPartialFailureReason> partialFailureReasons;

    private final AutoMLCandidate bestCandidate;

    private final String autoMLJobStatus;

    private final String autoMLJobSecondaryStatus;

    private final ModelDeployConfig modelDeployConfig;

    private final ModelDeployResult modelDeployResult;

    private final AutoMLDataSplitConfig dataSplitConfig;

    private final AutoMLSecurityConfig securityConfig;

    private final AutoMLJobArtifacts autoMLJobArtifacts;

    private final AutoMLResolvedAttributes resolvedAttributes;

    private final String autoMLProblemTypeConfigName;

    private DescribeAutoMlJobV2Response(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.autoMLJobInputDataConfig = builder.autoMLJobInputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.roleArn = builder.roleArn;
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.autoMLProblemTypeConfig = builder.autoMLProblemTypeConfig;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.partialFailureReasons = builder.partialFailureReasons;
        this.bestCandidate = builder.bestCandidate;
        this.autoMLJobStatus = builder.autoMLJobStatus;
        this.autoMLJobSecondaryStatus = builder.autoMLJobSecondaryStatus;
        this.modelDeployConfig = builder.modelDeployConfig;
        this.modelDeployResult = builder.modelDeployResult;
        this.dataSplitConfig = builder.dataSplitConfig;
        this.securityConfig = builder.securityConfig;
        this.autoMLJobArtifacts = builder.autoMLJobArtifacts;
        this.resolvedAttributes = builder.resolvedAttributes;
        this.autoMLProblemTypeConfigName = builder.autoMLProblemTypeConfigName;
    }

    /**
     * <p>
     * Returns the name of the AutoML job V2.
     * </p>
     * 
     * @return Returns the name of the AutoML job V2.
     */
    public final String autoMLJobName() {
        return autoMLJobName;
    }

    /**
     * <p>
     * Returns the Amazon Resource Name (ARN) of the AutoML job V2.
     * </p>
     * 
     * @return Returns the Amazon Resource Name (ARN) of the AutoML job V2.
     */
    public final String autoMLJobArn() {
        return autoMLJobArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoMLJobInputDataConfig property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoMLJobInputDataConfig() {
        return autoMLJobInputDataConfig != null && !(autoMLJobInputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array of channel objects describing the input data and their location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoMLJobInputDataConfig} method.
     * </p>
     * 
     * @return Returns an array of channel objects describing the input data and their location.
     */
    public final List<AutoMLJobChannel> autoMLJobInputDataConfig() {
        return autoMLJobInputDataConfig;
    }

    /**
     * <p>
     * Returns the job's output data config.
     * </p>
     * 
     * @return Returns the job's output data config.
     */
    public final AutoMLOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The ARN of the Identity and Access Management role that has read permission to the input data location and write
     * permission to the output data location in Amazon S3.
     * </p>
     * 
     * @return The ARN of the Identity and Access Management role that has read permission to the input data location
     *         and write permission to the output data location in Amazon S3.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Returns the job's objective.
     * </p>
     * 
     * @return Returns the job's objective.
     */
    public final AutoMLJobObjective autoMLJobObjective() {
        return autoMLJobObjective;
    }

    /**
     * <p>
     * Returns the configuration settings of the problem type set for the AutoML job V2.
     * </p>
     * 
     * @return Returns the configuration settings of the problem type set for the AutoML job V2.
     */
    public final AutoMLProblemTypeConfig autoMLProblemTypeConfig() {
        return autoMLProblemTypeConfig;
    }

    /**
     * <p>
     * Returns the creation time of the AutoML job V2.
     * </p>
     * 
     * @return Returns the creation time of the AutoML job V2.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Returns the end time of the AutoML job V2.
     * </p>
     * 
     * @return Returns the end time of the AutoML job V2.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Returns the job's last modified time.
     * </p>
     * 
     * @return Returns the job's last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Returns the reason for the failure of the AutoML job V2, when applicable.
     * </p>
     * 
     * @return Returns the reason for the failure of the AutoML job V2, when applicable.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartialFailureReasons property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPartialFailureReasons() {
        return partialFailureReasons != null && !(partialFailureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of reasons for partial failures within an AutoML job V2.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartialFailureReasons} method.
     * </p>
     * 
     * @return Returns a list of reasons for partial failures within an AutoML job V2.
     */
    public final List<AutoMLPartialFailureReason> partialFailureReasons() {
        return partialFailureReasons;
    }

    /**
     * <p>
     * Information about the candidate produced by an AutoML training job V2, including its status, steps, and other
     * properties.
     * </p>
     * 
     * @return Information about the candidate produced by an AutoML training job V2, including its status, steps, and
     *         other properties.
     */
    public final AutoMLCandidate bestCandidate() {
        return bestCandidate;
    }

    /**
     * <p>
     * Returns the status of the AutoML job V2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoMLJobStatus}
     * will return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoMLJobStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the AutoML job V2.
     * @see AutoMLJobStatus
     */
    public final AutoMLJobStatus autoMLJobStatus() {
        return AutoMLJobStatus.fromValue(autoMLJobStatus);
    }

    /**
     * <p>
     * Returns the status of the AutoML job V2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoMLJobStatus}
     * will return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoMLJobStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the AutoML job V2.
     * @see AutoMLJobStatus
     */
    public final String autoMLJobStatusAsString() {
        return autoMLJobStatus;
    }

    /**
     * <p>
     * Returns the secondary status of the AutoML job V2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLJobSecondaryStatus} will return {@link AutoMLJobSecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoMLJobSecondaryStatusAsString}.
     * </p>
     * 
     * @return Returns the secondary status of the AutoML job V2.
     * @see AutoMLJobSecondaryStatus
     */
    public final AutoMLJobSecondaryStatus autoMLJobSecondaryStatus() {
        return AutoMLJobSecondaryStatus.fromValue(autoMLJobSecondaryStatus);
    }

    /**
     * <p>
     * Returns the secondary status of the AutoML job V2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLJobSecondaryStatus} will return {@link AutoMLJobSecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoMLJobSecondaryStatusAsString}.
     * </p>
     * 
     * @return Returns the secondary status of the AutoML job V2.
     * @see AutoMLJobSecondaryStatus
     */
    public final String autoMLJobSecondaryStatusAsString() {
        return autoMLJobSecondaryStatus;
    }

    /**
     * <p>
     * Indicates whether the model was deployed automatically to an endpoint and the name of that endpoint if deployed
     * automatically.
     * </p>
     * 
     * @return Indicates whether the model was deployed automatically to an endpoint and the name of that endpoint if
     *         deployed automatically.
     */
    public final ModelDeployConfig modelDeployConfig() {
        return modelDeployConfig;
    }

    /**
     * <p>
     * Provides information about endpoint for the model deployment.
     * </p>
     * 
     * @return Provides information about endpoint for the model deployment.
     */
    public final ModelDeployResult modelDeployResult() {
        return modelDeployResult;
    }

    /**
     * <p>
     * Returns the configuration settings of how the data are split into train and validation datasets.
     * </p>
     * 
     * @return Returns the configuration settings of how the data are split into train and validation datasets.
     */
    public final AutoMLDataSplitConfig dataSplitConfig() {
        return dataSplitConfig;
    }

    /**
     * <p>
     * Returns the security configuration for traffic encryption or Amazon VPC settings.
     * </p>
     * 
     * @return Returns the security configuration for traffic encryption or Amazon VPC settings.
     */
    public final AutoMLSecurityConfig securityConfig() {
        return securityConfig;
    }

    /**
     * Returns the value of the AutoMLJobArtifacts property for this object.
     * 
     * @return The value of the AutoMLJobArtifacts property for this object.
     */
    public final AutoMLJobArtifacts autoMLJobArtifacts() {
        return autoMLJobArtifacts;
    }

    /**
     * <p>
     * Returns the resolved attributes used by the AutoML job V2.
     * </p>
     * 
     * @return Returns the resolved attributes used by the AutoML job V2.
     */
    public final AutoMLResolvedAttributes resolvedAttributes() {
        return resolvedAttributes;
    }

    /**
     * <p>
     * Returns the name of the problem type configuration set for the AutoML job V2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLProblemTypeConfigName} will return {@link AutoMLProblemTypeConfigName#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #autoMLProblemTypeConfigNameAsString}.
     * </p>
     * 
     * @return Returns the name of the problem type configuration set for the AutoML job V2.
     * @see AutoMLProblemTypeConfigName
     */
    public final AutoMLProblemTypeConfigName autoMLProblemTypeConfigName() {
        return AutoMLProblemTypeConfigName.fromValue(autoMLProblemTypeConfigName);
    }

    /**
     * <p>
     * Returns the name of the problem type configuration set for the AutoML job V2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLProblemTypeConfigName} will return {@link AutoMLProblemTypeConfigName#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #autoMLProblemTypeConfigNameAsString}.
     * </p>
     * 
     * @return Returns the name of the problem type configuration set for the AutoML job V2.
     * @see AutoMLProblemTypeConfigName
     */
    public final String autoMLProblemTypeConfigNameAsString() {
        return autoMLProblemTypeConfigName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoMLJobInputDataConfig() ? autoMLJobInputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLProblemTypeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartialFailureReasons() ? partialFailureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(bestCandidate());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobSecondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelDeployConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelDeployResult());
        hashCode = 31 * hashCode + Objects.hashCode(dataSplitConfig());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLProblemTypeConfigNameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoMlJobV2Response)) {
            return false;
        }
        DescribeAutoMlJobV2Response other = (DescribeAutoMlJobV2Response) obj;
        return Objects.equals(autoMLJobName(), other.autoMLJobName()) && Objects.equals(autoMLJobArn(), other.autoMLJobArn())
                && hasAutoMLJobInputDataConfig() == other.hasAutoMLJobInputDataConfig()
                && Objects.equals(autoMLJobInputDataConfig(), other.autoMLJobInputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(autoMLJobObjective(), other.autoMLJobObjective())
                && Objects.equals(autoMLProblemTypeConfig(), other.autoMLProblemTypeConfig())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason())
                && hasPartialFailureReasons() == other.hasPartialFailureReasons()
                && Objects.equals(partialFailureReasons(), other.partialFailureReasons())
                && Objects.equals(bestCandidate(), other.bestCandidate())
                && Objects.equals(autoMLJobStatusAsString(), other.autoMLJobStatusAsString())
                && Objects.equals(autoMLJobSecondaryStatusAsString(), other.autoMLJobSecondaryStatusAsString())
                && Objects.equals(modelDeployConfig(), other.modelDeployConfig())
                && Objects.equals(modelDeployResult(), other.modelDeployResult())
                && Objects.equals(dataSplitConfig(), other.dataSplitConfig())
                && Objects.equals(securityConfig(), other.securityConfig())
                && Objects.equals(autoMLJobArtifacts(), other.autoMLJobArtifacts())
                && Objects.equals(resolvedAttributes(), other.resolvedAttributes())
                && Objects.equals(autoMLProblemTypeConfigNameAsString(), other.autoMLProblemTypeConfigNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAutoMlJobV2Response").add("AutoMLJobName", autoMLJobName())
                .add("AutoMLJobArn", autoMLJobArn())
                .add("AutoMLJobInputDataConfig", hasAutoMLJobInputDataConfig() ? autoMLJobInputDataConfig() : null)
                .add("OutputDataConfig", outputDataConfig()).add("RoleArn", roleArn())
                .add("AutoMLJobObjective", autoMLJobObjective()).add("AutoMLProblemTypeConfig", autoMLProblemTypeConfig())
                .add("CreationTime", creationTime()).add("EndTime", endTime()).add("LastModifiedTime", lastModifiedTime())
                .add("FailureReason", failureReason())
                .add("PartialFailureReasons", hasPartialFailureReasons() ? partialFailureReasons() : null)
                .add("BestCandidate", bestCandidate()).add("AutoMLJobStatus", autoMLJobStatusAsString())
                .add("AutoMLJobSecondaryStatus", autoMLJobSecondaryStatusAsString())
                .add("ModelDeployConfig", modelDeployConfig()).add("ModelDeployResult", modelDeployResult())
                .add("DataSplitConfig", dataSplitConfig()).add("SecurityConfig", securityConfig())
                .add("AutoMLJobArtifacts", autoMLJobArtifacts()).add("ResolvedAttributes", resolvedAttributes())
                .add("AutoMLProblemTypeConfigName", autoMLProblemTypeConfigNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLJobName":
            return Optional.ofNullable(clazz.cast(autoMLJobName()));
        case "AutoMLJobArn":
            return Optional.ofNullable(clazz.cast(autoMLJobArn()));
        case "AutoMLJobInputDataConfig":
            return Optional.ofNullable(clazz.cast(autoMLJobInputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "AutoMLJobObjective":
            return Optional.ofNullable(clazz.cast(autoMLJobObjective()));
        case "AutoMLProblemTypeConfig":
            return Optional.ofNullable(clazz.cast(autoMLProblemTypeConfig()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "PartialFailureReasons":
            return Optional.ofNullable(clazz.cast(partialFailureReasons()));
        case "BestCandidate":
            return Optional.ofNullable(clazz.cast(bestCandidate()));
        case "AutoMLJobStatus":
            return Optional.ofNullable(clazz.cast(autoMLJobStatusAsString()));
        case "AutoMLJobSecondaryStatus":
            return Optional.ofNullable(clazz.cast(autoMLJobSecondaryStatusAsString()));
        case "ModelDeployConfig":
            return Optional.ofNullable(clazz.cast(modelDeployConfig()));
        case "ModelDeployResult":
            return Optional.ofNullable(clazz.cast(modelDeployResult()));
        case "DataSplitConfig":
            return Optional.ofNullable(clazz.cast(dataSplitConfig()));
        case "SecurityConfig":
            return Optional.ofNullable(clazz.cast(securityConfig()));
        case "AutoMLJobArtifacts":
            return Optional.ofNullable(clazz.cast(autoMLJobArtifacts()));
        case "ResolvedAttributes":
            return Optional.ofNullable(clazz.cast(resolvedAttributes()));
        case "AutoMLProblemTypeConfigName":
            return Optional.ofNullable(clazz.cast(autoMLProblemTypeConfigNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoMlJobV2Response, T> g) {
        return obj -> g.apply((DescribeAutoMlJobV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAutoMlJobV2Response> {
        /**
         * <p>
         * Returns the name of the AutoML job V2.
         * </p>
         * 
         * @param autoMLJobName
         *        Returns the name of the AutoML job V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobName(String autoMLJobName);

        /**
         * <p>
         * Returns the Amazon Resource Name (ARN) of the AutoML job V2.
         * </p>
         * 
         * @param autoMLJobArn
         *        Returns the Amazon Resource Name (ARN) of the AutoML job V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobArn(String autoMLJobArn);

        /**
         * <p>
         * Returns an array of channel objects describing the input data and their location.
         * </p>
         * 
         * @param autoMLJobInputDataConfig
         *        Returns an array of channel objects describing the input data and their location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobInputDataConfig(Collection<AutoMLJobChannel> autoMLJobInputDataConfig);

        /**
         * <p>
         * Returns an array of channel objects describing the input data and their location.
         * </p>
         * 
         * @param autoMLJobInputDataConfig
         *        Returns an array of channel objects describing the input data and their location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobInputDataConfig(AutoMLJobChannel... autoMLJobInputDataConfig);

        /**
         * <p>
         * Returns an array of channel objects describing the input data and their location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel.Builder#build()} is called
         * immediately and its result is passed to {@link #autoMLJobInputDataConfig(List<AutoMLJobChannel>)}.
         * 
         * @param autoMLJobInputDataConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobInputDataConfig(java.util.Collection<AutoMLJobChannel>)
         */
        Builder autoMLJobInputDataConfig(Consumer<AutoMLJobChannel.Builder>... autoMLJobInputDataConfig);

        /**
         * <p>
         * Returns the job's output data config.
         * </p>
         * 
         * @param outputDataConfig
         *        Returns the job's output data config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig);

        /**
         * <p>
         * Returns the job's output data config.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLOutputDataConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLOutputDataConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outputDataConfig(AutoMLOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link AutoMLOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(AutoMLOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<AutoMLOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(AutoMLOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The ARN of the Identity and Access Management role that has read permission to the input data location and
         * write permission to the output data location in Amazon S3.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the Identity and Access Management role that has read permission to the input data location
         *        and write permission to the output data location in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Returns the job's objective.
         * </p>
         * 
         * @param autoMLJobObjective
         *        Returns the job's objective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective);

        /**
         * <p>
         * Returns the job's objective.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLJobObjective.Builder} avoiding the
         * need to create one manually via {@link AutoMLJobObjective#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobObjective.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobObjective(AutoMLJobObjective)}.
         * 
         * @param autoMLJobObjective
         *        a consumer that will call methods on {@link AutoMLJobObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobObjective(AutoMLJobObjective)
         */
        default Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return autoMLJobObjective(AutoMLJobObjective.builder().applyMutation(autoMLJobObjective).build());
        }

        /**
         * <p>
         * Returns the configuration settings of the problem type set for the AutoML job V2.
         * </p>
         * 
         * @param autoMLProblemTypeConfig
         *        Returns the configuration settings of the problem type set for the AutoML job V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLProblemTypeConfig(AutoMLProblemTypeConfig autoMLProblemTypeConfig);

        /**
         * <p>
         * Returns the configuration settings of the problem type set for the AutoML job V2.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLProblemTypeConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLProblemTypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLProblemTypeConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #autoMLProblemTypeConfig(AutoMLProblemTypeConfig)}.
         * 
         * @param autoMLProblemTypeConfig
         *        a consumer that will call methods on {@link AutoMLProblemTypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLProblemTypeConfig(AutoMLProblemTypeConfig)
         */
        default Builder autoMLProblemTypeConfig(Consumer<AutoMLProblemTypeConfig.Builder> autoMLProblemTypeConfig) {
            return autoMLProblemTypeConfig(AutoMLProblemTypeConfig.builder().applyMutation(autoMLProblemTypeConfig).build());
        }

        /**
         * <p>
         * Returns the creation time of the AutoML job V2.
         * </p>
         * 
         * @param creationTime
         *        Returns the creation time of the AutoML job V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Returns the end time of the AutoML job V2.
         * </p>
         * 
         * @param endTime
         *        Returns the end time of the AutoML job V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Returns the job's last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        Returns the job's last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Returns the reason for the failure of the AutoML job V2, when applicable.
         * </p>
         * 
         * @param failureReason
         *        Returns the reason for the failure of the AutoML job V2, when applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Returns a list of reasons for partial failures within an AutoML job V2.
         * </p>
         * 
         * @param partialFailureReasons
         *        Returns a list of reasons for partial failures within an AutoML job V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> partialFailureReasons);

        /**
         * <p>
         * Returns a list of reasons for partial failures within an AutoML job V2.
         * </p>
         * 
         * @param partialFailureReasons
         *        Returns a list of reasons for partial failures within an AutoML job V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partialFailureReasons(AutoMLPartialFailureReason... partialFailureReasons);

        /**
         * <p>
         * Returns a list of reasons for partial failures within an AutoML job V2.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason.Builder#build()} is called
         * immediately and its result is passed to {@link #partialFailureReasons(List<AutoMLPartialFailureReason>)}.
         * 
         * @param partialFailureReasons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partialFailureReasons(java.util.Collection<AutoMLPartialFailureReason>)
         */
        Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder>... partialFailureReasons);

        /**
         * <p>
         * Information about the candidate produced by an AutoML training job V2, including its status, steps, and other
         * properties.
         * </p>
         * 
         * @param bestCandidate
         *        Information about the candidate produced by an AutoML training job V2, including its status, steps,
         *        and other properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestCandidate(AutoMLCandidate bestCandidate);

        /**
         * <p>
         * Information about the candidate produced by an AutoML training job V2, including its status, steps, and other
         * properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLCandidate.Builder} avoiding the
         * need to create one manually via {@link AutoMLCandidate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLCandidate.Builder#build()} is called immediately and its
         * result is passed to {@link #bestCandidate(AutoMLCandidate)}.
         * 
         * @param bestCandidate
         *        a consumer that will call methods on {@link AutoMLCandidate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bestCandidate(AutoMLCandidate)
         */
        default Builder bestCandidate(Consumer<AutoMLCandidate.Builder> bestCandidate) {
            return bestCandidate(AutoMLCandidate.builder().applyMutation(bestCandidate).build());
        }

        /**
         * <p>
         * Returns the status of the AutoML job V2.
         * </p>
         * 
         * @param autoMLJobStatus
         *        Returns the status of the AutoML job V2.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder autoMLJobStatus(String autoMLJobStatus);

        /**
         * <p>
         * Returns the status of the AutoML job V2.
         * </p>
         * 
         * @param autoMLJobStatus
         *        Returns the status of the AutoML job V2.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus);

        /**
         * <p>
         * Returns the secondary status of the AutoML job V2.
         * </p>
         * 
         * @param autoMLJobSecondaryStatus
         *        Returns the secondary status of the AutoML job V2.
         * @see AutoMLJobSecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobSecondaryStatus
         */
        Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus);

        /**
         * <p>
         * Returns the secondary status of the AutoML job V2.
         * </p>
         * 
         * @param autoMLJobSecondaryStatus
         *        Returns the secondary status of the AutoML job V2.
         * @see AutoMLJobSecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobSecondaryStatus
         */
        Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus);

        /**
         * <p>
         * Indicates whether the model was deployed automatically to an endpoint and the name of that endpoint if
         * deployed automatically.
         * </p>
         * 
         * @param modelDeployConfig
         *        Indicates whether the model was deployed automatically to an endpoint and the name of that endpoint if
         *        deployed automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDeployConfig(ModelDeployConfig modelDeployConfig);

        /**
         * <p>
         * Indicates whether the model was deployed automatically to an endpoint and the name of that endpoint if
         * deployed automatically.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDeployConfig.Builder} avoiding the
         * need to create one manually via {@link ModelDeployConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDeployConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDeployConfig(ModelDeployConfig)}.
         * 
         * @param modelDeployConfig
         *        a consumer that will call methods on {@link ModelDeployConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDeployConfig(ModelDeployConfig)
         */
        default Builder modelDeployConfig(Consumer<ModelDeployConfig.Builder> modelDeployConfig) {
            return modelDeployConfig(ModelDeployConfig.builder().applyMutation(modelDeployConfig).build());
        }

        /**
         * <p>
         * Provides information about endpoint for the model deployment.
         * </p>
         * 
         * @param modelDeployResult
         *        Provides information about endpoint for the model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDeployResult(ModelDeployResult modelDeployResult);

        /**
         * <p>
         * Provides information about endpoint for the model deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDeployResult.Builder} avoiding the
         * need to create one manually via {@link ModelDeployResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDeployResult.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDeployResult(ModelDeployResult)}.
         * 
         * @param modelDeployResult
         *        a consumer that will call methods on {@link ModelDeployResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDeployResult(ModelDeployResult)
         */
        default Builder modelDeployResult(Consumer<ModelDeployResult.Builder> modelDeployResult) {
            return modelDeployResult(ModelDeployResult.builder().applyMutation(modelDeployResult).build());
        }

        /**
         * <p>
         * Returns the configuration settings of how the data are split into train and validation datasets.
         * </p>
         * 
         * @param dataSplitConfig
         *        Returns the configuration settings of how the data are split into train and validation datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSplitConfig(AutoMLDataSplitConfig dataSplitConfig);

        /**
         * <p>
         * Returns the configuration settings of how the data are split into train and validation datasets.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLDataSplitConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLDataSplitConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLDataSplitConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSplitConfig(AutoMLDataSplitConfig)}.
         * 
         * @param dataSplitConfig
         *        a consumer that will call methods on {@link AutoMLDataSplitConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSplitConfig(AutoMLDataSplitConfig)
         */
        default Builder dataSplitConfig(Consumer<AutoMLDataSplitConfig.Builder> dataSplitConfig) {
            return dataSplitConfig(AutoMLDataSplitConfig.builder().applyMutation(dataSplitConfig).build());
        }

        /**
         * <p>
         * Returns the security configuration for traffic encryption or Amazon VPC settings.
         * </p>
         * 
         * @param securityConfig
         *        Returns the security configuration for traffic encryption or Amazon VPC settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfig(AutoMLSecurityConfig securityConfig);

        /**
         * <p>
         * Returns the security configuration for traffic encryption or Amazon VPC settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLSecurityConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLSecurityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLSecurityConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #securityConfig(AutoMLSecurityConfig)}.
         * 
         * @param securityConfig
         *        a consumer that will call methods on {@link AutoMLSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfig(AutoMLSecurityConfig)
         */
        default Builder securityConfig(Consumer<AutoMLSecurityConfig.Builder> securityConfig) {
            return securityConfig(AutoMLSecurityConfig.builder().applyMutation(securityConfig).build());
        }

        /**
         * Sets the value of the AutoMLJobArtifacts property for this object.
         *
         * @param autoMLJobArtifacts
         *        The new value for the AutoMLJobArtifacts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobArtifacts(AutoMLJobArtifacts autoMLJobArtifacts);

        /**
         * Sets the value of the AutoMLJobArtifacts property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoMLJobArtifacts.Builder} avoiding the
         * need to create one manually via {@link AutoMLJobArtifacts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobArtifacts.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobArtifacts(AutoMLJobArtifacts)}.
         * 
         * @param autoMLJobArtifacts
         *        a consumer that will call methods on {@link AutoMLJobArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobArtifacts(AutoMLJobArtifacts)
         */
        default Builder autoMLJobArtifacts(Consumer<AutoMLJobArtifacts.Builder> autoMLJobArtifacts) {
            return autoMLJobArtifacts(AutoMLJobArtifacts.builder().applyMutation(autoMLJobArtifacts).build());
        }

        /**
         * <p>
         * Returns the resolved attributes used by the AutoML job V2.
         * </p>
         * 
         * @param resolvedAttributes
         *        Returns the resolved attributes used by the AutoML job V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedAttributes(AutoMLResolvedAttributes resolvedAttributes);

        /**
         * <p>
         * Returns the resolved attributes used by the AutoML job V2.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLResolvedAttributes.Builder}
         * avoiding the need to create one manually via {@link AutoMLResolvedAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLResolvedAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #resolvedAttributes(AutoMLResolvedAttributes)}.
         * 
         * @param resolvedAttributes
         *        a consumer that will call methods on {@link AutoMLResolvedAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolvedAttributes(AutoMLResolvedAttributes)
         */
        default Builder resolvedAttributes(Consumer<AutoMLResolvedAttributes.Builder> resolvedAttributes) {
            return resolvedAttributes(AutoMLResolvedAttributes.builder().applyMutation(resolvedAttributes).build());
        }

        /**
         * <p>
         * Returns the name of the problem type configuration set for the AutoML job V2.
         * </p>
         * 
         * @param autoMLProblemTypeConfigName
         *        Returns the name of the problem type configuration set for the AutoML job V2.
         * @see AutoMLProblemTypeConfigName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLProblemTypeConfigName
         */
        Builder autoMLProblemTypeConfigName(String autoMLProblemTypeConfigName);

        /**
         * <p>
         * Returns the name of the problem type configuration set for the AutoML job V2.
         * </p>
         * 
         * @param autoMLProblemTypeConfigName
         *        Returns the name of the problem type configuration set for the AutoML job V2.
         * @see AutoMLProblemTypeConfigName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLProblemTypeConfigName
         */
        Builder autoMLProblemTypeConfigName(AutoMLProblemTypeConfigName autoMLProblemTypeConfigName);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String autoMLJobName;

        private String autoMLJobArn;

        private List<AutoMLJobChannel> autoMLJobInputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private AutoMLOutputDataConfig outputDataConfig;

        private String roleArn;

        private AutoMLJobObjective autoMLJobObjective;

        private AutoMLProblemTypeConfig autoMLProblemTypeConfig;

        private Instant creationTime;

        private Instant endTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private List<AutoMLPartialFailureReason> partialFailureReasons = DefaultSdkAutoConstructList.getInstance();

        private AutoMLCandidate bestCandidate;

        private String autoMLJobStatus;

        private String autoMLJobSecondaryStatus;

        private ModelDeployConfig modelDeployConfig;

        private ModelDeployResult modelDeployResult;

        private AutoMLDataSplitConfig dataSplitConfig;

        private AutoMLSecurityConfig securityConfig;

        private AutoMLJobArtifacts autoMLJobArtifacts;

        private AutoMLResolvedAttributes resolvedAttributes;

        private String autoMLProblemTypeConfigName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoMlJobV2Response model) {
            super(model);
            autoMLJobName(model.autoMLJobName);
            autoMLJobArn(model.autoMLJobArn);
            autoMLJobInputDataConfig(model.autoMLJobInputDataConfig);
            outputDataConfig(model.outputDataConfig);
            roleArn(model.roleArn);
            autoMLJobObjective(model.autoMLJobObjective);
            autoMLProblemTypeConfig(model.autoMLProblemTypeConfig);
            creationTime(model.creationTime);
            endTime(model.endTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            partialFailureReasons(model.partialFailureReasons);
            bestCandidate(model.bestCandidate);
            autoMLJobStatus(model.autoMLJobStatus);
            autoMLJobSecondaryStatus(model.autoMLJobSecondaryStatus);
            modelDeployConfig(model.modelDeployConfig);
            modelDeployResult(model.modelDeployResult);
            dataSplitConfig(model.dataSplitConfig);
            securityConfig(model.securityConfig);
            autoMLJobArtifacts(model.autoMLJobArtifacts);
            resolvedAttributes(model.resolvedAttributes);
            autoMLProblemTypeConfigName(model.autoMLProblemTypeConfigName);
        }

        public final String getAutoMLJobName() {
            return autoMLJobName;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final String getAutoMLJobArn() {
            return autoMLJobArn;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final List<AutoMLJobChannel.Builder> getAutoMLJobInputDataConfig() {
            List<AutoMLJobChannel.Builder> result = AutoMLJobInputDataConfigCopier.copyToBuilder(this.autoMLJobInputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoMLJobInputDataConfig(Collection<AutoMLJobChannel.BuilderImpl> autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig = AutoMLJobInputDataConfigCopier.copyFromBuilder(autoMLJobInputDataConfig);
        }

        @Override
        public final Builder autoMLJobInputDataConfig(Collection<AutoMLJobChannel> autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig = AutoMLJobInputDataConfigCopier.copy(autoMLJobInputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobInputDataConfig(AutoMLJobChannel... autoMLJobInputDataConfig) {
            autoMLJobInputDataConfig(Arrays.asList(autoMLJobInputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobInputDataConfig(Consumer<AutoMLJobChannel.Builder>... autoMLJobInputDataConfig) {
            autoMLJobInputDataConfig(Stream.of(autoMLJobInputDataConfig)
                    .map(c -> AutoMLJobChannel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoMLOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(AutoMLOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return autoMLJobObjective != null ? autoMLJobObjective.toBuilder() : null;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final AutoMLProblemTypeConfig.Builder getAutoMLProblemTypeConfig() {
            return autoMLProblemTypeConfig != null ? autoMLProblemTypeConfig.toBuilder() : null;
        }

        public final void setAutoMLProblemTypeConfig(AutoMLProblemTypeConfig.BuilderImpl autoMLProblemTypeConfig) {
            this.autoMLProblemTypeConfig = autoMLProblemTypeConfig != null ? autoMLProblemTypeConfig.build() : null;
        }

        @Override
        public final Builder autoMLProblemTypeConfig(AutoMLProblemTypeConfig autoMLProblemTypeConfig) {
            this.autoMLProblemTypeConfig = autoMLProblemTypeConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final List<AutoMLPartialFailureReason.Builder> getPartialFailureReasons() {
            List<AutoMLPartialFailureReason.Builder> result = AutoMLPartialFailureReasonsCopier
                    .copyToBuilder(this.partialFailureReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartialFailureReasons(Collection<AutoMLPartialFailureReason.BuilderImpl> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copyFromBuilder(partialFailureReasons);
        }

        @Override
        public final Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copy(partialFailureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(AutoMLPartialFailureReason... partialFailureReasons) {
            partialFailureReasons(Arrays.asList(partialFailureReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder>... partialFailureReasons) {
            partialFailureReasons(Stream.of(partialFailureReasons)
                    .map(c -> AutoMLPartialFailureReason.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoMLCandidate.Builder getBestCandidate() {
            return bestCandidate != null ? bestCandidate.toBuilder() : null;
        }

        public final void setBestCandidate(AutoMLCandidate.BuilderImpl bestCandidate) {
            this.bestCandidate = bestCandidate != null ? bestCandidate.build() : null;
        }

        @Override
        public final Builder bestCandidate(AutoMLCandidate bestCandidate) {
            this.bestCandidate = bestCandidate;
            return this;
        }

        public final String getAutoMLJobStatus() {
            return autoMLJobStatus;
        }

        public final void setAutoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
        }

        @Override
        public final Builder autoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus) {
            this.autoMLJobStatus(autoMLJobStatus == null ? null : autoMLJobStatus.toString());
            return this;
        }

        public final String getAutoMLJobSecondaryStatus() {
            return autoMLJobSecondaryStatus;
        }

        public final void setAutoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus(autoMLJobSecondaryStatus == null ? null : autoMLJobSecondaryStatus.toString());
            return this;
        }

        public final ModelDeployConfig.Builder getModelDeployConfig() {
            return modelDeployConfig != null ? modelDeployConfig.toBuilder() : null;
        }

        public final void setModelDeployConfig(ModelDeployConfig.BuilderImpl modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig != null ? modelDeployConfig.build() : null;
        }

        @Override
        public final Builder modelDeployConfig(ModelDeployConfig modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig;
            return this;
        }

        public final ModelDeployResult.Builder getModelDeployResult() {
            return modelDeployResult != null ? modelDeployResult.toBuilder() : null;
        }

        public final void setModelDeployResult(ModelDeployResult.BuilderImpl modelDeployResult) {
            this.modelDeployResult = modelDeployResult != null ? modelDeployResult.build() : null;
        }

        @Override
        public final Builder modelDeployResult(ModelDeployResult modelDeployResult) {
            this.modelDeployResult = modelDeployResult;
            return this;
        }

        public final AutoMLDataSplitConfig.Builder getDataSplitConfig() {
            return dataSplitConfig != null ? dataSplitConfig.toBuilder() : null;
        }

        public final void setDataSplitConfig(AutoMLDataSplitConfig.BuilderImpl dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig != null ? dataSplitConfig.build() : null;
        }

        @Override
        public final Builder dataSplitConfig(AutoMLDataSplitConfig dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig;
            return this;
        }

        public final AutoMLSecurityConfig.Builder getSecurityConfig() {
            return securityConfig != null ? securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(AutoMLSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(AutoMLSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final AutoMLJobArtifacts.Builder getAutoMLJobArtifacts() {
            return autoMLJobArtifacts != null ? autoMLJobArtifacts.toBuilder() : null;
        }

        public final void setAutoMLJobArtifacts(AutoMLJobArtifacts.BuilderImpl autoMLJobArtifacts) {
            this.autoMLJobArtifacts = autoMLJobArtifacts != null ? autoMLJobArtifacts.build() : null;
        }

        @Override
        public final Builder autoMLJobArtifacts(AutoMLJobArtifacts autoMLJobArtifacts) {
            this.autoMLJobArtifacts = autoMLJobArtifacts;
            return this;
        }

        public final AutoMLResolvedAttributes.Builder getResolvedAttributes() {
            return resolvedAttributes != null ? resolvedAttributes.toBuilder() : null;
        }

        public final void setResolvedAttributes(AutoMLResolvedAttributes.BuilderImpl resolvedAttributes) {
            this.resolvedAttributes = resolvedAttributes != null ? resolvedAttributes.build() : null;
        }

        @Override
        public final Builder resolvedAttributes(AutoMLResolvedAttributes resolvedAttributes) {
            this.resolvedAttributes = resolvedAttributes;
            return this;
        }

        public final String getAutoMLProblemTypeConfigName() {
            return autoMLProblemTypeConfigName;
        }

        public final void setAutoMLProblemTypeConfigName(String autoMLProblemTypeConfigName) {
            this.autoMLProblemTypeConfigName = autoMLProblemTypeConfigName;
        }

        @Override
        public final Builder autoMLProblemTypeConfigName(String autoMLProblemTypeConfigName) {
            this.autoMLProblemTypeConfigName = autoMLProblemTypeConfigName;
            return this;
        }

        @Override
        public final Builder autoMLProblemTypeConfigName(AutoMLProblemTypeConfigName autoMLProblemTypeConfigName) {
            this.autoMLProblemTypeConfigName(autoMLProblemTypeConfigName == null ? null : autoMLProblemTypeConfigName.toString());
            return this;
        }

        @Override
        public DescribeAutoMlJobV2Response build() {
            return new DescribeAutoMlJobV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
