/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeDomainResponse.Builder, DescribeDomainResponse> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainArn").getter(getter(DescribeDomainResponse::domainArn)).setter(setter(Builder::domainArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainArn").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(DescribeDomainResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DescribeDomainResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeEfsFileSystemId").getter(getter(DescribeDomainResponse::homeEfsFileSystemId))
            .setter(setter(Builder::homeEfsFileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemId").build())
            .build();

    private static final SdkField<String> SINGLE_SIGN_ON_MANAGED_APPLICATION_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SingleSignOnManagedApplicationInstanceId")
            .getter(getter(DescribeDomainResponse::singleSignOnManagedApplicationInstanceId))
            .setter(setter(Builder::singleSignOnManagedApplicationInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SingleSignOnManagedApplicationInstanceId").build()).build();

    private static final SdkField<String> SINGLE_SIGN_ON_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SingleSignOnApplicationArn")
            .getter(getter(DescribeDomainResponse::singleSignOnApplicationArn))
            .setter(setter(Builder::singleSignOnApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnApplicationArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDomainResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeDomainResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeDomainResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeDomainResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthMode").getter(getter(DescribeDomainResponse::authModeAsString)).setter(setter(Builder::authMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()).build();

    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField
            .<UserSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultUserSettings")
            .getter(getter(DescribeDomainResponse::defaultUserSettings)).setter(setter(Builder::defaultUserSettings))
            .constructor(UserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build())
            .build();

    private static final SdkField<String> APP_NETWORK_ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppNetworkAccessType").getter(getter(DescribeDomainResponse::appNetworkAccessTypeAsString))
            .setter(setter(Builder::appNetworkAccessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppNetworkAccessType").build())
            .build();

    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("HomeEfsFileSystemKmsKeyId")
            .getter(getter(DescribeDomainResponse::homeEfsFileSystemKmsKeyId)).setter(setter(Builder::homeEfsFileSystemKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemKmsKeyId").build())
            .build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(DescribeDomainResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(DescribeDomainResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(DescribeDomainResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DescribeDomainResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<DomainSettings> DOMAIN_SETTINGS_FIELD = SdkField
            .<DomainSettings> builder(MarshallingType.SDK_POJO).memberName("DomainSettings")
            .getter(getter(DescribeDomainResponse::domainSettings)).setter(setter(Builder::domainSettings))
            .constructor(DomainSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSettings").build()).build();

    private static final SdkField<String> APP_SECURITY_GROUP_MANAGEMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AppSecurityGroupManagement")
            .getter(getter(DescribeDomainResponse::appSecurityGroupManagementAsString))
            .setter(setter(Builder::appSecurityGroupManagement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSecurityGroupManagement").build())
            .build();

    private static final SdkField<String> SECURITY_GROUP_ID_FOR_DOMAIN_BOUNDARY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupIdForDomainBoundary")
            .getter(getter(DescribeDomainResponse::securityGroupIdForDomainBoundary))
            .setter(setter(Builder::securityGroupIdForDomainBoundary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdForDomainBoundary")
                    .build()).build();

    private static final SdkField<DefaultSpaceSettings> DEFAULT_SPACE_SETTINGS_FIELD = SdkField
            .<DefaultSpaceSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultSpaceSettings")
            .getter(getter(DescribeDomainResponse::defaultSpaceSettings)).setter(setter(Builder::defaultSpaceSettings))
            .constructor(DefaultSpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSpaceSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD,
            DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, HOME_EFS_FILE_SYSTEM_ID_FIELD,
            SINGLE_SIGN_ON_MANAGED_APPLICATION_INSTANCE_ID_FIELD, SINGLE_SIGN_ON_APPLICATION_ARN_FIELD, STATUS_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, AUTH_MODE_FIELD, DEFAULT_USER_SETTINGS_FIELD,
            APP_NETWORK_ACCESS_TYPE_FIELD, HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD, SUBNET_IDS_FIELD, URL_FIELD, VPC_ID_FIELD,
            KMS_KEY_ID_FIELD, DOMAIN_SETTINGS_FIELD, APP_SECURITY_GROUP_MANAGEMENT_FIELD,
            SECURITY_GROUP_ID_FOR_DOMAIN_BOUNDARY_FIELD, DEFAULT_SPACE_SETTINGS_FIELD));

    private final String domainArn;

    private final String domainId;

    private final String domainName;

    private final String homeEfsFileSystemId;

    private final String singleSignOnManagedApplicationInstanceId;

    private final String singleSignOnApplicationArn;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final String authMode;

    private final UserSettings defaultUserSettings;

    private final String appNetworkAccessType;

    private final String homeEfsFileSystemKmsKeyId;

    private final List<String> subnetIds;

    private final String url;

    private final String vpcId;

    private final String kmsKeyId;

    private final DomainSettings domainSettings;

    private final String appSecurityGroupManagement;

    private final String securityGroupIdForDomainBoundary;

    private final DefaultSpaceSettings defaultSpaceSettings;

    private DescribeDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainArn = builder.domainArn;
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.homeEfsFileSystemId = builder.homeEfsFileSystemId;
        this.singleSignOnManagedApplicationInstanceId = builder.singleSignOnManagedApplicationInstanceId;
        this.singleSignOnApplicationArn = builder.singleSignOnApplicationArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.authMode = builder.authMode;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.appNetworkAccessType = builder.appNetworkAccessType;
        this.homeEfsFileSystemKmsKeyId = builder.homeEfsFileSystemKmsKeyId;
        this.subnetIds = builder.subnetIds;
        this.url = builder.url;
        this.vpcId = builder.vpcId;
        this.kmsKeyId = builder.kmsKeyId;
        this.domainSettings = builder.domainSettings;
        this.appSecurityGroupManagement = builder.appSecurityGroupManagement;
        this.securityGroupIdForDomainBoundary = builder.securityGroupIdForDomainBoundary;
        this.defaultSpaceSettings = builder.defaultSpaceSettings;
    }

    /**
     * <p>
     * The domain's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The domain's Amazon Resource Name (ARN).
     */
    public final String domainArn() {
        return domainArn;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The ID of the Amazon Elastic File System (EFS) managed by this Domain.
     * </p>
     * 
     * @return The ID of the Amazon Elastic File System (EFS) managed by this Domain.
     */
    public final String homeEfsFileSystemId() {
        return homeEfsFileSystemId;
    }

    /**
     * <p>
     * The IAM Identity Center managed application instance ID.
     * </p>
     * 
     * @return The IAM Identity Center managed application instance ID.
     */
    public final String singleSignOnManagedApplicationInstanceId() {
        return singleSignOnManagedApplicationInstanceId;
    }

    /**
     * <p>
     * The ARN of the application managed by SageMaker in IAM Identity Center. This value is only returned for domains
     * created after September 19, 2023.
     * </p>
     * 
     * @return The ARN of the application managed by SageMaker in IAM Identity Center. This value is only returned for
     *         domains created after September 19, 2023.
     */
    public final String singleSignOnApplicationArn() {
        return singleSignOnApplicationArn;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see DomainStatus
     */
    public final DomainStatus status() {
        return DomainStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see DomainStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last modified time.
     * </p>
     * 
     * @return The last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The failure reason.
     * </p>
     * 
     * @return The failure reason.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The domain's authentication mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return The domain's authentication mode.
     * @see AuthMode
     */
    public final AuthMode authMode() {
        return AuthMode.fromValue(authMode);
    }

    /**
     * <p>
     * The domain's authentication mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return The domain's authentication mode.
     * @see AuthMode
     */
    public final String authModeAsString() {
        return authMode;
    }

    /**
     * <p>
     * Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a given
     * UserProfile.
     * </p>
     * 
     * @return Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a
     *         given UserProfile.
     */
    public final UserSettings defaultUserSettings() {
        return defaultUserSettings;
    }

    /**
     * <p>
     * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
     * direct internet access
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All traffic is through the specified VPC and subnets
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appNetworkAccessType} will return {@link AppNetworkAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appNetworkAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
     *         allows direct internet access
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VpcOnly</code> - All traffic is through the specified VPC and subnets
     *         </p>
     *         </li>
     * @see AppNetworkAccessType
     */
    public final AppNetworkAccessType appNetworkAccessType() {
        return AppNetworkAccessType.fromValue(appNetworkAccessType);
    }

    /**
     * <p>
     * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
     * direct internet access
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All traffic is through the specified VPC and subnets
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appNetworkAccessType} will return {@link AppNetworkAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appNetworkAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
     *         allows direct internet access
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VpcOnly</code> - All traffic is through the specified VPC and subnets
     *         </p>
     *         </li>
     * @see AppNetworkAccessType
     */
    public final String appNetworkAccessTypeAsString() {
        return appNetworkAccessType;
    }

    /**
     * <p>
     * Use <code>KmsKeyId</code>.
     * </p>
     * 
     * @return Use <code>KmsKeyId</code>.
     * @deprecated This property is deprecated, use KmsKeyId instead.
     */
    @Deprecated
    public final String homeEfsFileSystemKmsKeyId() {
        return homeEfsFileSystemKmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC subnets that the domain uses for communication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The VPC subnets that the domain uses for communication.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The domain's URL.
     * </p>
     * 
     * @return The domain's URL.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The ID of the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
     * </p>
     * 
     * @return The ID of the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the domain.
     * </p>
     * 
     * @return The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the domain.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A collection of <code>Domain</code> settings.
     * </p>
     * 
     * @return A collection of <code>Domain</code> settings.
     */
    public final DomainSettings domainSettings() {
        return domainSettings;
    }

    /**
     * <p>
     * The entity that creates and manages the required security groups for inter-app communication in
     * <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code>
     * and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appSecurityGroupManagement} will return {@link AppSecurityGroupManagement#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #appSecurityGroupManagementAsString}.
     * </p>
     * 
     * @return The entity that creates and manages the required security groups for inter-app communication in
     *         <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
     *         <code>VPCOnly</code> and
     *         <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.
     * @see AppSecurityGroupManagement
     */
    public final AppSecurityGroupManagement appSecurityGroupManagement() {
        return AppSecurityGroupManagement.fromValue(appSecurityGroupManagement);
    }

    /**
     * <p>
     * The entity that creates and manages the required security groups for inter-app communication in
     * <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code>
     * and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appSecurityGroupManagement} will return {@link AppSecurityGroupManagement#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #appSecurityGroupManagementAsString}.
     * </p>
     * 
     * @return The entity that creates and manages the required security groups for inter-app communication in
     *         <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
     *         <code>VPCOnly</code> and
     *         <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.
     * @see AppSecurityGroupManagement
     */
    public final String appSecurityGroupManagementAsString() {
        return appSecurityGroupManagement;
    }

    /**
     * <p>
     * The ID of the security group that authorizes traffic between the <code>RSessionGateway</code> apps and the
     * <code>RStudioServerPro</code> app.
     * </p>
     * 
     * @return The ID of the security group that authorizes traffic between the <code>RSessionGateway</code> apps and
     *         the <code>RStudioServerPro</code> app.
     */
    public final String securityGroupIdForDomainBoundary() {
        return securityGroupIdForDomainBoundary;
    }

    /**
     * <p>
     * The default settings used to create a space.
     * </p>
     * 
     * @return The default settings used to create a space.
     */
    public final DefaultSpaceSettings defaultSpaceSettings() {
        return defaultSpaceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(homeEfsFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOnManagedApplicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOnApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(appNetworkAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(homeEfsFileSystemKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(domainSettings());
        hashCode = 31 * hashCode + Objects.hashCode(appSecurityGroupManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIdForDomainBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSpaceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainResponse)) {
            return false;
        }
        DescribeDomainResponse other = (DescribeDomainResponse) obj;
        return Objects.equals(domainArn(), other.domainArn()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(domainName(), other.domainName())
                && Objects.equals(homeEfsFileSystemId(), other.homeEfsFileSystemId())
                && Objects.equals(singleSignOnManagedApplicationInstanceId(), other.singleSignOnManagedApplicationInstanceId())
                && Objects.equals(singleSignOnApplicationArn(), other.singleSignOnApplicationArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(authModeAsString(), other.authModeAsString())
                && Objects.equals(defaultUserSettings(), other.defaultUserSettings())
                && Objects.equals(appNetworkAccessTypeAsString(), other.appNetworkAccessTypeAsString())
                && Objects.equals(homeEfsFileSystemKmsKeyId(), other.homeEfsFileSystemKmsKeyId())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(url(), other.url()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(domainSettings(), other.domainSettings())
                && Objects.equals(appSecurityGroupManagementAsString(), other.appSecurityGroupManagementAsString())
                && Objects.equals(securityGroupIdForDomainBoundary(), other.securityGroupIdForDomainBoundary())
                && Objects.equals(defaultSpaceSettings(), other.defaultSpaceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDomainResponse").add("DomainArn", domainArn()).add("DomainId", domainId())
                .add("DomainName", domainName()).add("HomeEfsFileSystemId", homeEfsFileSystemId())
                .add("SingleSignOnManagedApplicationInstanceId", singleSignOnManagedApplicationInstanceId())
                .add("SingleSignOnApplicationArn", singleSignOnApplicationArn()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("FailureReason", failureReason()).add("AuthMode", authModeAsString())
                .add("DefaultUserSettings", defaultUserSettings()).add("AppNetworkAccessType", appNetworkAccessTypeAsString())
                .add("HomeEfsFileSystemKmsKeyId", homeEfsFileSystemKmsKeyId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Url", url()).add("VpcId", vpcId())
                .add("KmsKeyId", kmsKeyId()).add("DomainSettings", domainSettings())
                .add("AppSecurityGroupManagement", appSecurityGroupManagementAsString())
                .add("SecurityGroupIdForDomainBoundary", securityGroupIdForDomainBoundary())
                .add("DefaultSpaceSettings", defaultSpaceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainArn":
            return Optional.ofNullable(clazz.cast(domainArn()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "HomeEfsFileSystemId":
            return Optional.ofNullable(clazz.cast(homeEfsFileSystemId()));
        case "SingleSignOnManagedApplicationInstanceId":
            return Optional.ofNullable(clazz.cast(singleSignOnManagedApplicationInstanceId()));
        case "SingleSignOnApplicationArn":
            return Optional.ofNullable(clazz.cast(singleSignOnApplicationArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "AuthMode":
            return Optional.ofNullable(clazz.cast(authModeAsString()));
        case "DefaultUserSettings":
            return Optional.ofNullable(clazz.cast(defaultUserSettings()));
        case "AppNetworkAccessType":
            return Optional.ofNullable(clazz.cast(appNetworkAccessTypeAsString()));
        case "HomeEfsFileSystemKmsKeyId":
            return Optional.ofNullable(clazz.cast(homeEfsFileSystemKmsKeyId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "DomainSettings":
            return Optional.ofNullable(clazz.cast(domainSettings()));
        case "AppSecurityGroupManagement":
            return Optional.ofNullable(clazz.cast(appSecurityGroupManagementAsString()));
        case "SecurityGroupIdForDomainBoundary":
            return Optional.ofNullable(clazz.cast(securityGroupIdForDomainBoundary()));
        case "DefaultSpaceSettings":
            return Optional.ofNullable(clazz.cast(defaultSpaceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainResponse, T> g) {
        return obj -> g.apply((DescribeDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDomainResponse> {
        /**
         * <p>
         * The domain's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param domainArn
         *        The domain's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainArn(String domainArn);

        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domainName
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The ID of the Amazon Elastic File System (EFS) managed by this Domain.
         * </p>
         * 
         * @param homeEfsFileSystemId
         *        The ID of the Amazon Elastic File System (EFS) managed by this Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeEfsFileSystemId(String homeEfsFileSystemId);

        /**
         * <p>
         * The IAM Identity Center managed application instance ID.
         * </p>
         * 
         * @param singleSignOnManagedApplicationInstanceId
         *        The IAM Identity Center managed application instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId);

        /**
         * <p>
         * The ARN of the application managed by SageMaker in IAM Identity Center. This value is only returned for
         * domains created after September 19, 2023.
         * </p>
         * 
         * @param singleSignOnApplicationArn
         *        The ARN of the application managed by SageMaker in IAM Identity Center. This value is only returned
         *        for domains created after September 19, 2023.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOnApplicationArn(String singleSignOnApplicationArn);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(DomainStatus status);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The failure reason.
         * </p>
         * 
         * @param failureReason
         *        The failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The domain's authentication mode.
         * </p>
         * 
         * @param authMode
         *        The domain's authentication mode.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(String authMode);

        /**
         * <p>
         * The domain's authentication mode.
         * </p>
         * 
         * @param authMode
         *        The domain's authentication mode.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(AuthMode authMode);

        /**
         * <p>
         * Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a given
         * UserProfile.
         * </p>
         * 
         * @param defaultUserSettings
         *        Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in
         *        a given UserProfile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultUserSettings(UserSettings defaultUserSettings);

        /**
         * <p>
         * Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a given
         * UserProfile.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserSettings.Builder} avoiding the need
         * to create one manually via {@link UserSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultUserSettings(UserSettings)}.
         * 
         * @param defaultUserSettings
         *        a consumer that will call methods on {@link UserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultUserSettings(UserSettings)
         */
        default Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return defaultUserSettings(UserSettings.builder().applyMutation(defaultUserSettings).build());
        }

        /**
         * <p>
         * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
         * direct internet access
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VpcOnly</code> - All traffic is through the specified VPC and subnets
         * </p>
         * </li>
         * </ul>
         * 
         * @param appNetworkAccessType
         *        Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
         *        allows direct internet access
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VpcOnly</code> - All traffic is through the specified VPC and subnets
         *        </p>
         *        </li>
         * @see AppNetworkAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppNetworkAccessType
         */
        Builder appNetworkAccessType(String appNetworkAccessType);

        /**
         * <p>
         * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
         * direct internet access
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VpcOnly</code> - All traffic is through the specified VPC and subnets
         * </p>
         * </li>
         * </ul>
         * 
         * @param appNetworkAccessType
         *        Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
         *        allows direct internet access
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VpcOnly</code> - All traffic is through the specified VPC and subnets
         *        </p>
         *        </li>
         * @see AppNetworkAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppNetworkAccessType
         */
        Builder appNetworkAccessType(AppNetworkAccessType appNetworkAccessType);

        /**
         * <p>
         * Use <code>KmsKeyId</code>.
         * </p>
         * 
         * @param homeEfsFileSystemKmsKeyId
         *        Use <code>KmsKeyId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This property is deprecated, use KmsKeyId instead.
         */
        @Deprecated
        Builder homeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId);

        /**
         * <p>
         * The VPC subnets that the domain uses for communication.
         * </p>
         * 
         * @param subnetIds
         *        The VPC subnets that the domain uses for communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The VPC subnets that the domain uses for communication.
         * </p>
         * 
         * @param subnetIds
         *        The VPC subnets that the domain uses for communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The domain's URL.
         * </p>
         * 
         * @param url
         *        The domain's URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The ID of the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the domain.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A collection of <code>Domain</code> settings.
         * </p>
         * 
         * @param domainSettings
         *        A collection of <code>Domain</code> settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainSettings(DomainSettings domainSettings);

        /**
         * <p>
         * A collection of <code>Domain</code> settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainSettings.Builder} avoiding the need
         * to create one manually via {@link DomainSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #domainSettings(DomainSettings)}.
         * 
         * @param domainSettings
         *        a consumer that will call methods on {@link DomainSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainSettings(DomainSettings)
         */
        default Builder domainSettings(Consumer<DomainSettings.Builder> domainSettings) {
            return domainSettings(DomainSettings.builder().applyMutation(domainSettings).build());
        }

        /**
         * <p>
         * The entity that creates and manages the required security groups for inter-app communication in
         * <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
         * <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is
         * provided.
         * </p>
         * 
         * @param appSecurityGroupManagement
         *        The entity that creates and manages the required security groups for inter-app communication in
         *        <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
         *        <code>VPCOnly</code> and
         *        <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.
         * @see AppSecurityGroupManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppSecurityGroupManagement
         */
        Builder appSecurityGroupManagement(String appSecurityGroupManagement);

        /**
         * <p>
         * The entity that creates and manages the required security groups for inter-app communication in
         * <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
         * <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is
         * provided.
         * </p>
         * 
         * @param appSecurityGroupManagement
         *        The entity that creates and manages the required security groups for inter-app communication in
         *        <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
         *        <code>VPCOnly</code> and
         *        <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.
         * @see AppSecurityGroupManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppSecurityGroupManagement
         */
        Builder appSecurityGroupManagement(AppSecurityGroupManagement appSecurityGroupManagement);

        /**
         * <p>
         * The ID of the security group that authorizes traffic between the <code>RSessionGateway</code> apps and the
         * <code>RStudioServerPro</code> app.
         * </p>
         * 
         * @param securityGroupIdForDomainBoundary
         *        The ID of the security group that authorizes traffic between the <code>RSessionGateway</code> apps and
         *        the <code>RStudioServerPro</code> app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdForDomainBoundary(String securityGroupIdForDomainBoundary);

        /**
         * <p>
         * The default settings used to create a space.
         * </p>
         * 
         * @param defaultSpaceSettings
         *        The default settings used to create a space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings);

        /**
         * <p>
         * The default settings used to create a space.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultSpaceSettings.Builder} avoiding
         * the need to create one manually via {@link DefaultSpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultSpaceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultSpaceSettings(DefaultSpaceSettings)}.
         * 
         * @param defaultSpaceSettings
         *        a consumer that will call methods on {@link DefaultSpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultSpaceSettings(DefaultSpaceSettings)
         */
        default Builder defaultSpaceSettings(Consumer<DefaultSpaceSettings.Builder> defaultSpaceSettings) {
            return defaultSpaceSettings(DefaultSpaceSettings.builder().applyMutation(defaultSpaceSettings).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String domainArn;

        private String domainId;

        private String domainName;

        private String homeEfsFileSystemId;

        private String singleSignOnManagedApplicationInstanceId;

        private String singleSignOnApplicationArn;

        private String status;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private String authMode;

        private UserSettings defaultUserSettings;

        private String appNetworkAccessType;

        private String homeEfsFileSystemKmsKeyId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String url;

        private String vpcId;

        private String kmsKeyId;

        private DomainSettings domainSettings;

        private String appSecurityGroupManagement;

        private String securityGroupIdForDomainBoundary;

        private DefaultSpaceSettings defaultSpaceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainResponse model) {
            super(model);
            domainArn(model.domainArn);
            domainId(model.domainId);
            domainName(model.domainName);
            homeEfsFileSystemId(model.homeEfsFileSystemId);
            singleSignOnManagedApplicationInstanceId(model.singleSignOnManagedApplicationInstanceId);
            singleSignOnApplicationArn(model.singleSignOnApplicationArn);
            status(model.status);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            authMode(model.authMode);
            defaultUserSettings(model.defaultUserSettings);
            appNetworkAccessType(model.appNetworkAccessType);
            homeEfsFileSystemKmsKeyId(model.homeEfsFileSystemKmsKeyId);
            subnetIds(model.subnetIds);
            url(model.url);
            vpcId(model.vpcId);
            kmsKeyId(model.kmsKeyId);
            domainSettings(model.domainSettings);
            appSecurityGroupManagement(model.appSecurityGroupManagement);
            securityGroupIdForDomainBoundary(model.securityGroupIdForDomainBoundary);
            defaultSpaceSettings(model.defaultSpaceSettings);
        }

        public final String getDomainArn() {
            return domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getHomeEfsFileSystemId() {
            return homeEfsFileSystemId;
        }

        public final void setHomeEfsFileSystemId(String homeEfsFileSystemId) {
            this.homeEfsFileSystemId = homeEfsFileSystemId;
        }

        @Override
        public final Builder homeEfsFileSystemId(String homeEfsFileSystemId) {
            this.homeEfsFileSystemId = homeEfsFileSystemId;
            return this;
        }

        public final String getSingleSignOnManagedApplicationInstanceId() {
            return singleSignOnManagedApplicationInstanceId;
        }

        public final void setSingleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId) {
            this.singleSignOnManagedApplicationInstanceId = singleSignOnManagedApplicationInstanceId;
        }

        @Override
        public final Builder singleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId) {
            this.singleSignOnManagedApplicationInstanceId = singleSignOnManagedApplicationInstanceId;
            return this;
        }

        public final String getSingleSignOnApplicationArn() {
            return singleSignOnApplicationArn;
        }

        public final void setSingleSignOnApplicationArn(String singleSignOnApplicationArn) {
            this.singleSignOnApplicationArn = singleSignOnApplicationArn;
        }

        @Override
        public final Builder singleSignOnApplicationArn(String singleSignOnApplicationArn) {
            this.singleSignOnApplicationArn = singleSignOnApplicationArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getAuthMode() {
            return authMode;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return defaultUserSettings != null ? defaultUserSettings.toBuilder() : null;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final String getAppNetworkAccessType() {
            return appNetworkAccessType;
        }

        public final void setAppNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
        }

        @Override
        public final Builder appNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
            return this;
        }

        @Override
        public final Builder appNetworkAccessType(AppNetworkAccessType appNetworkAccessType) {
            this.appNetworkAccessType(appNetworkAccessType == null ? null : appNetworkAccessType.toString());
            return this;
        }

        @Deprecated
        public final String getHomeEfsFileSystemKmsKeyId() {
            return homeEfsFileSystemKmsKeyId;
        }

        @Deprecated
        public final void setHomeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
        }

        @Override
        @Deprecated
        public final Builder homeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final DomainSettings.Builder getDomainSettings() {
            return domainSettings != null ? domainSettings.toBuilder() : null;
        }

        public final void setDomainSettings(DomainSettings.BuilderImpl domainSettings) {
            this.domainSettings = domainSettings != null ? domainSettings.build() : null;
        }

        @Override
        public final Builder domainSettings(DomainSettings domainSettings) {
            this.domainSettings = domainSettings;
            return this;
        }

        public final String getAppSecurityGroupManagement() {
            return appSecurityGroupManagement;
        }

        public final void setAppSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
        }

        @Override
        public final Builder appSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
            return this;
        }

        @Override
        public final Builder appSecurityGroupManagement(AppSecurityGroupManagement appSecurityGroupManagement) {
            this.appSecurityGroupManagement(appSecurityGroupManagement == null ? null : appSecurityGroupManagement.toString());
            return this;
        }

        public final String getSecurityGroupIdForDomainBoundary() {
            return securityGroupIdForDomainBoundary;
        }

        public final void setSecurityGroupIdForDomainBoundary(String securityGroupIdForDomainBoundary) {
            this.securityGroupIdForDomainBoundary = securityGroupIdForDomainBoundary;
        }

        @Override
        public final Builder securityGroupIdForDomainBoundary(String securityGroupIdForDomainBoundary) {
            this.securityGroupIdForDomainBoundary = securityGroupIdForDomainBoundary;
            return this;
        }

        public final DefaultSpaceSettings.Builder getDefaultSpaceSettings() {
            return defaultSpaceSettings != null ? defaultSpaceSettings.toBuilder() : null;
        }

        public final void setDefaultSpaceSettings(DefaultSpaceSettings.BuilderImpl defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings != null ? defaultSpaceSettings.build() : null;
        }

        @Override
        public final Builder defaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings;
            return this;
        }

        @Override
        public DescribeDomainResponse build() {
            return new DescribeDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
