/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of EBS storage settings that applies to private spaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsStorageSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsStorageSettings.Builder, EbsStorageSettings> {
    private static final SdkField<Integer> EBS_VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EbsVolumeSizeInGb").getter(getter(EbsStorageSettings::ebsVolumeSizeInGb))
            .setter(setter(Builder::ebsVolumeSizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsVolumeSizeInGb").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_VOLUME_SIZE_IN_GB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer ebsVolumeSizeInGb;

    private EbsStorageSettings(BuilderImpl builder) {
        this.ebsVolumeSizeInGb = builder.ebsVolumeSizeInGb;
    }

    /**
     * <p>
     * The size of an EBS storage volume for a private space.
     * </p>
     * 
     * @return The size of an EBS storage volume for a private space.
     */
    public final Integer ebsVolumeSizeInGb() {
        return ebsVolumeSizeInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsVolumeSizeInGb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsStorageSettings)) {
            return false;
        }
        EbsStorageSettings other = (EbsStorageSettings) obj;
        return Objects.equals(ebsVolumeSizeInGb(), other.ebsVolumeSizeInGb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsStorageSettings").add("EbsVolumeSizeInGb", ebsVolumeSizeInGb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsVolumeSizeInGb":
            return Optional.ofNullable(clazz.cast(ebsVolumeSizeInGb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsStorageSettings, T> g) {
        return obj -> g.apply((EbsStorageSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsStorageSettings> {
        /**
         * <p>
         * The size of an EBS storage volume for a private space.
         * </p>
         * 
         * @param ebsVolumeSizeInGb
         *        The size of an EBS storage volume for a private space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsVolumeSizeInGb(Integer ebsVolumeSizeInGb);
    }

    static final class BuilderImpl implements Builder {
        private Integer ebsVolumeSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsStorageSettings model) {
            ebsVolumeSizeInGb(model.ebsVolumeSizeInGb);
        }

        public final Integer getEbsVolumeSizeInGb() {
            return ebsVolumeSizeInGb;
        }

        public final void setEbsVolumeSizeInGb(Integer ebsVolumeSizeInGb) {
            this.ebsVolumeSizeInGb = ebsVolumeSizeInGb;
        }

        @Override
        public final Builder ebsVolumeSizeInGb(Integer ebsVolumeSizeInGb) {
            this.ebsVolumeSizeInGb = ebsVolumeSizeInGb;
            return this;
        }

        @Override
        public EbsStorageSettings build() {
            return new EbsStorageSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
