/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMonitoringExecutionsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListMonitoringExecutionsRequest.Builder, ListMonitoringExecutionsRequest> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleName").getter(getter(ListMonitoringExecutionsRequest::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(ListMonitoringExecutionsRequest::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListMonitoringExecutionsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListMonitoringExecutionsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMonitoringExecutionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListMonitoringExecutionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> SCHEDULED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScheduledTimeBefore").getter(getter(ListMonitoringExecutionsRequest::scheduledTimeBefore))
            .setter(setter(Builder::scheduledTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTimeBefore").build())
            .build();

    private static final SdkField<Instant> SCHEDULED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScheduledTimeAfter").getter(getter(ListMonitoringExecutionsRequest::scheduledTimeAfter))
            .setter(setter(Builder::scheduledTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTimeAfter").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListMonitoringExecutionsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListMonitoringExecutionsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeBefore").getter(getter(ListMonitoringExecutionsRequest::lastModifiedTimeBefore))
            .setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeAfter").getter(getter(ListMonitoringExecutionsRequest::lastModifiedTimeAfter))
            .setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListMonitoringExecutionsRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> MONITORING_JOB_DEFINITION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MonitoringJobDefinitionName")
            .getter(getter(ListMonitoringExecutionsRequest::monitoringJobDefinitionName))
            .setter(setter(Builder::monitoringJobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringJobDefinitionName")
                    .build()).build();

    private static final SdkField<String> MONITORING_TYPE_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringTypeEquals").getter(getter(ListMonitoringExecutionsRequest::monitoringTypeEqualsAsString))
            .setter(setter(Builder::monitoringTypeEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringTypeEquals").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_NAME_FIELD, ENDPOINT_NAME_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, SCHEDULED_TIME_BEFORE_FIELD, SCHEDULED_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD,
            CREATION_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD, STATUS_EQUALS_FIELD,
            MONITORING_JOB_DEFINITION_NAME_FIELD, MONITORING_TYPE_EQUALS_FIELD));

    private final String monitoringScheduleName;

    private final String endpointName;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private final Instant scheduledTimeBefore;

    private final Instant scheduledTimeAfter;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private final String statusEquals;

    private final String monitoringJobDefinitionName;

    private final String monitoringTypeEquals;

    private ListMonitoringExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.endpointName = builder.endpointName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.scheduledTimeBefore = builder.scheduledTimeBefore;
        this.scheduledTimeAfter = builder.scheduledTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.statusEquals = builder.statusEquals;
        this.monitoringJobDefinitionName = builder.monitoringJobDefinitionName;
        this.monitoringTypeEquals = builder.monitoringTypeEquals;
    }

    /**
     * <p>
     * Name of a specific schedule to fetch jobs for.
     * </p>
     * 
     * @return Name of a specific schedule to fetch jobs for.
     */
    public final String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * Name of a specific endpoint to fetch jobs for.
     * </p>
     * 
     * @return Name of a specific endpoint to fetch jobs for.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or <code>ScheduledTime</code>
     * field. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringExecutionSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or
     *         <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.
     * @see MonitoringExecutionSortKey
     */
    public final MonitoringExecutionSortKey sortBy() {
        return MonitoringExecutionSortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or <code>ScheduledTime</code>
     * field. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringExecutionSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or
     *         <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.
     * @see MonitoringExecutionSortKey
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     * <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     *         <code>Descending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     * <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     *         <code>Descending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next
     * request.
     * </p>
     * 
     * @return The token returned if the response is truncated. To retrieve the next set of job executions, use it in
     *         the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of jobs to return in the response. The default value is 10.
     * </p>
     * 
     * @return The maximum number of jobs to return in the response. The default value is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filter for jobs scheduled before a specified time.
     * </p>
     * 
     * @return Filter for jobs scheduled before a specified time.
     */
    public final Instant scheduledTimeBefore() {
        return scheduledTimeBefore;
    }

    /**
     * <p>
     * Filter for jobs scheduled after a specified time.
     * </p>
     * 
     * @return Filter for jobs scheduled after a specified time.
     */
    public final Instant scheduledTimeAfter() {
        return scheduledTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only jobs created before a specified time.
     * </p>
     * 
     * @return A filter that returns only jobs created before a specified time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only jobs created after a specified time.
     * </p>
     * 
     * @return A filter that returns only jobs created after a specified time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only jobs modified after a specified time.
     * </p>
     * 
     * @return A filter that returns only jobs modified after a specified time.
     */
    public final Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only jobs modified before a specified time.
     * </p>
     * 
     * @return A filter that returns only jobs modified before a specified time.
     */
    public final Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    /**
     * <p>
     * A filter that retrieves only jobs with a specific status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that retrieves only jobs with a specific status.
     * @see ExecutionStatus
     */
    public final ExecutionStatus statusEquals() {
        return ExecutionStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * A filter that retrieves only jobs with a specific status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that retrieves only jobs with a specific status.
     * @see ExecutionStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * Gets a list of the monitoring job runs of the specified monitoring job definitions.
     * </p>
     * 
     * @return Gets a list of the monitoring job runs of the specified monitoring job definitions.
     */
    public final String monitoringJobDefinitionName() {
        return monitoringJobDefinitionName;
    }

    /**
     * <p>
     * A filter that returns only the monitoring job runs of the specified monitoring type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringTypeEquals} will return {@link MonitoringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #monitoringTypeEqualsAsString}.
     * </p>
     * 
     * @return A filter that returns only the monitoring job runs of the specified monitoring type.
     * @see MonitoringType
     */
    public final MonitoringType monitoringTypeEquals() {
        return MonitoringType.fromValue(monitoringTypeEquals);
    }

    /**
     * <p>
     * A filter that returns only the monitoring job runs of the specified monitoring type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringTypeEquals} will return {@link MonitoringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #monitoringTypeEqualsAsString}.
     * </p>
     * 
     * @return A filter that returns only the monitoring job runs of the specified monitoring type.
     * @see MonitoringType
     */
    public final String monitoringTypeEqualsAsString() {
        return monitoringTypeEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringJobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringTypeEqualsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringExecutionsRequest)) {
            return false;
        }
        ListMonitoringExecutionsRequest other = (ListMonitoringExecutionsRequest) obj;
        return Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(scheduledTimeBefore(), other.scheduledTimeBefore())
                && Objects.equals(scheduledTimeAfter(), other.scheduledTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(monitoringJobDefinitionName(), other.monitoringJobDefinitionName())
                && Objects.equals(monitoringTypeEqualsAsString(), other.monitoringTypeEqualsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMonitoringExecutionsRequest").add("MonitoringScheduleName", monitoringScheduleName())
                .add("EndpointName", endpointName()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("ScheduledTimeBefore", scheduledTimeBefore())
                .add("ScheduledTimeAfter", scheduledTimeAfter()).add("CreationTimeBefore", creationTimeBefore())
                .add("CreationTimeAfter", creationTimeAfter()).add("LastModifiedTimeBefore", lastModifiedTimeBefore())
                .add("LastModifiedTimeAfter", lastModifiedTimeAfter()).add("StatusEquals", statusEqualsAsString())
                .add("MonitoringJobDefinitionName", monitoringJobDefinitionName())
                .add("MonitoringTypeEquals", monitoringTypeEqualsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ScheduledTimeBefore":
            return Optional.ofNullable(clazz.cast(scheduledTimeBefore()));
        case "ScheduledTimeAfter":
            return Optional.ofNullable(clazz.cast(scheduledTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "MonitoringJobDefinitionName":
            return Optional.ofNullable(clazz.cast(monitoringJobDefinitionName()));
        case "MonitoringTypeEquals":
            return Optional.ofNullable(clazz.cast(monitoringTypeEqualsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringExecutionsRequest, T> g) {
        return obj -> g.apply((ListMonitoringExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMonitoringExecutionsRequest> {
        /**
         * <p>
         * Name of a specific schedule to fetch jobs for.
         * </p>
         * 
         * @param monitoringScheduleName
         *        Name of a specific schedule to fetch jobs for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * Name of a specific endpoint to fetch jobs for.
         * </p>
         * 
         * @param endpointName
         *        Name of a specific endpoint to fetch jobs for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or
         * <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or
         *        <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.
         * @see MonitoringExecutionSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringExecutionSortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or
         * <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or
         *        <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.
         * @see MonitoringExecutionSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringExecutionSortKey
         */
        Builder sortBy(MonitoringExecutionSortKey sortBy);

        /**
         * <p>
         * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         * <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         *        <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         * <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         *        <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The token returned if the response is truncated. To retrieve the next set of job executions, use it in the
         * next request.
         * </p>
         * 
         * @param nextToken
         *        The token returned if the response is truncated. To retrieve the next set of job executions, use it in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of jobs to return in the response. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of jobs to return in the response. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter for jobs scheduled before a specified time.
         * </p>
         * 
         * @param scheduledTimeBefore
         *        Filter for jobs scheduled before a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledTimeBefore(Instant scheduledTimeBefore);

        /**
         * <p>
         * Filter for jobs scheduled after a specified time.
         * </p>
         * 
         * @param scheduledTimeAfter
         *        Filter for jobs scheduled after a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledTimeAfter(Instant scheduledTimeAfter);

        /**
         * <p>
         * A filter that returns only jobs created before a specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        A filter that returns only jobs created before a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * A filter that returns only jobs created after a specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        A filter that returns only jobs created after a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * A filter that returns only jobs modified after a specified time.
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        A filter that returns only jobs modified after a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * A filter that returns only jobs modified before a specified time.
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        A filter that returns only jobs modified before a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        /**
         * <p>
         * A filter that retrieves only jobs with a specific status.
         * </p>
         * 
         * @param statusEquals
         *        A filter that retrieves only jobs with a specific status.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * A filter that retrieves only jobs with a specific status.
         * </p>
         * 
         * @param statusEquals
         *        A filter that retrieves only jobs with a specific status.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder statusEquals(ExecutionStatus statusEquals);

        /**
         * <p>
         * Gets a list of the monitoring job runs of the specified monitoring job definitions.
         * </p>
         * 
         * @param monitoringJobDefinitionName
         *        Gets a list of the monitoring job runs of the specified monitoring job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringJobDefinitionName(String monitoringJobDefinitionName);

        /**
         * <p>
         * A filter that returns only the monitoring job runs of the specified monitoring type.
         * </p>
         * 
         * @param monitoringTypeEquals
         *        A filter that returns only the monitoring job runs of the specified monitoring type.
         * @see MonitoringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringType
         */
        Builder monitoringTypeEquals(String monitoringTypeEquals);

        /**
         * <p>
         * A filter that returns only the monitoring job runs of the specified monitoring type.
         * </p>
         * 
         * @param monitoringTypeEquals
         *        A filter that returns only the monitoring job runs of the specified monitoring type.
         * @see MonitoringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringType
         */
        Builder monitoringTypeEquals(MonitoringType monitoringTypeEquals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String monitoringScheduleName;

        private String endpointName;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private Instant scheduledTimeBefore;

        private Instant scheduledTimeAfter;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private Instant lastModifiedTimeBefore;

        private Instant lastModifiedTimeAfter;

        private String statusEquals;

        private String monitoringJobDefinitionName;

        private String monitoringTypeEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringExecutionsRequest model) {
            super(model);
            monitoringScheduleName(model.monitoringScheduleName);
            endpointName(model.endpointName);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            scheduledTimeBefore(model.scheduledTimeBefore);
            scheduledTimeAfter(model.scheduledTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            statusEquals(model.statusEquals);
            monitoringJobDefinitionName(model.monitoringJobDefinitionName);
            monitoringTypeEquals(model.monitoringTypeEquals);
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(MonitoringExecutionSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getScheduledTimeBefore() {
            return scheduledTimeBefore;
        }

        public final void setScheduledTimeBefore(Instant scheduledTimeBefore) {
            this.scheduledTimeBefore = scheduledTimeBefore;
        }

        @Override
        public final Builder scheduledTimeBefore(Instant scheduledTimeBefore) {
            this.scheduledTimeBefore = scheduledTimeBefore;
            return this;
        }

        public final Instant getScheduledTimeAfter() {
            return scheduledTimeAfter;
        }

        public final void setScheduledTimeAfter(Instant scheduledTimeAfter) {
            this.scheduledTimeAfter = scheduledTimeAfter;
        }

        @Override
        public final Builder scheduledTimeAfter(Instant scheduledTimeAfter) {
            this.scheduledTimeAfter = scheduledTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(ExecutionStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getMonitoringJobDefinitionName() {
            return monitoringJobDefinitionName;
        }

        public final void setMonitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
        }

        @Override
        public final Builder monitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
            return this;
        }

        public final String getMonitoringTypeEquals() {
            return monitoringTypeEquals;
        }

        public final void setMonitoringTypeEquals(String monitoringTypeEquals) {
            this.monitoringTypeEquals = monitoringTypeEquals;
        }

        @Override
        public final Builder monitoringTypeEquals(String monitoringTypeEquals) {
            this.monitoringTypeEquals = monitoringTypeEquals;
            return this;
        }

        @Override
        public final Builder monitoringTypeEquals(MonitoringType monitoringTypeEquals) {
            this.monitoringTypeEquals(monitoringTypeEquals == null ? null : monitoringTypeEquals.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMonitoringExecutionsRequest build() {
            return new ListMonitoringExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
