/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of the pipeline definition stored in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineDefinitionS3Location implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineDefinitionS3Location.Builder, PipelineDefinitionS3Location> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(PipelineDefinitionS3Location::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> OBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectKey").getter(getter(PipelineDefinitionS3Location::objectKey)).setter(setter(Builder::objectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKey").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(PipelineDefinitionS3Location::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            OBJECT_KEY_FIELD, VERSION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String objectKey;

    private final String versionId;

    private PipelineDefinitionS3Location(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.objectKey = builder.objectKey;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * Name of the S3 bucket.
     * </p>
     * 
     * @return Name of the S3 bucket.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The object key (or key name) uniquely identifies the object in an S3 bucket.
     * </p>
     * 
     * @return The object key (or key name) uniquely identifies the object in an S3 bucket.
     */
    public final String objectKey() {
        return objectKey;
    }

    /**
     * <p>
     * Version Id of the pipeline definition file. If not specified, Amazon SageMaker will retrieve the latest version.
     * </p>
     * 
     * @return Version Id of the pipeline definition file. If not specified, Amazon SageMaker will retrieve the latest
     *         version.
     */
    public final String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(objectKey());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDefinitionS3Location)) {
            return false;
        }
        PipelineDefinitionS3Location other = (PipelineDefinitionS3Location) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(objectKey(), other.objectKey())
                && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineDefinitionS3Location").add("Bucket", bucket()).add("ObjectKey", objectKey())
                .add("VersionId", versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "ObjectKey":
            return Optional.ofNullable(clazz.cast(objectKey()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineDefinitionS3Location, T> g) {
        return obj -> g.apply((PipelineDefinitionS3Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineDefinitionS3Location> {
        /**
         * <p>
         * Name of the S3 bucket.
         * </p>
         * 
         * @param bucket
         *        Name of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The object key (or key name) uniquely identifies the object in an S3 bucket.
         * </p>
         * 
         * @param objectKey
         *        The object key (or key name) uniquely identifies the object in an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectKey(String objectKey);

        /**
         * <p>
         * Version Id of the pipeline definition file. If not specified, Amazon SageMaker will retrieve the latest
         * version.
         * </p>
         * 
         * @param versionId
         *        Version Id of the pipeline definition file. If not specified, Amazon SageMaker will retrieve the
         *        latest version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String objectKey;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDefinitionS3Location model) {
            bucket(model.bucket);
            objectKey(model.objectKey);
            versionId(model.versionId);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getObjectKey() {
            return objectKey;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        @Override
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public PipelineDefinitionS3Location build() {
            return new PipelineDefinitionS3Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
