/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for a specific benchmark from an Inference Recommender job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationJobInferenceBenchmark implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationJobInferenceBenchmark.Builder, RecommendationJobInferenceBenchmark> {
    private static final SdkField<RecommendationMetrics> METRICS_FIELD = SdkField
            .<RecommendationMetrics> builder(MarshallingType.SDK_POJO).memberName("Metrics")
            .getter(getter(RecommendationJobInferenceBenchmark::metrics)).setter(setter(Builder::metrics))
            .constructor(RecommendationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()).build();

    private static final SdkField<EndpointOutputConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<EndpointOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("EndpointConfiguration")
            .getter(getter(RecommendationJobInferenceBenchmark::endpointConfiguration))
            .setter(setter(Builder::endpointConfiguration)).constructor(EndpointOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfiguration").build())
            .build();

    private static final SdkField<ModelConfiguration> MODEL_CONFIGURATION_FIELD = SdkField
            .<ModelConfiguration> builder(MarshallingType.SDK_POJO).memberName("ModelConfiguration")
            .getter(getter(RecommendationJobInferenceBenchmark::modelConfiguration)).setter(setter(Builder::modelConfiguration))
            .constructor(ModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelConfiguration").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(RecommendationJobInferenceBenchmark::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<InferenceMetrics> ENDPOINT_METRICS_FIELD = SdkField
            .<InferenceMetrics> builder(MarshallingType.SDK_POJO).memberName("EndpointMetrics")
            .getter(getter(RecommendationJobInferenceBenchmark::endpointMetrics)).setter(setter(Builder::endpointMetrics))
            .constructor(InferenceMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointMetrics").build()).build();

    private static final SdkField<Instant> INVOCATION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvocationEndTime").getter(getter(RecommendationJobInferenceBenchmark::invocationEndTime))
            .setter(setter(Builder::invocationEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationEndTime").build()).build();

    private static final SdkField<Instant> INVOCATION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvocationStartTime").getter(getter(RecommendationJobInferenceBenchmark::invocationStartTime))
            .setter(setter(Builder::invocationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationStartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD,
            ENDPOINT_CONFIGURATION_FIELD, MODEL_CONFIGURATION_FIELD, FAILURE_REASON_FIELD, ENDPOINT_METRICS_FIELD,
            INVOCATION_END_TIME_FIELD, INVOCATION_START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final RecommendationMetrics metrics;

    private final EndpointOutputConfiguration endpointConfiguration;

    private final ModelConfiguration modelConfiguration;

    private final String failureReason;

    private final InferenceMetrics endpointMetrics;

    private final Instant invocationEndTime;

    private final Instant invocationStartTime;

    private RecommendationJobInferenceBenchmark(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.modelConfiguration = builder.modelConfiguration;
        this.failureReason = builder.failureReason;
        this.endpointMetrics = builder.endpointMetrics;
        this.invocationEndTime = builder.invocationEndTime;
        this.invocationStartTime = builder.invocationStartTime;
    }

    /**
     * Returns the value of the Metrics property for this object.
     * 
     * @return The value of the Metrics property for this object.
     */
    public final RecommendationMetrics metrics() {
        return metrics;
    }

    /**
     * Returns the value of the EndpointConfiguration property for this object.
     * 
     * @return The value of the EndpointConfiguration property for this object.
     */
    public final EndpointOutputConfiguration endpointConfiguration() {
        return endpointConfiguration;
    }

    /**
     * Returns the value of the ModelConfiguration property for this object.
     * 
     * @return The value of the ModelConfiguration property for this object.
     */
    public final ModelConfiguration modelConfiguration() {
        return modelConfiguration;
    }

    /**
     * <p>
     * The reason why a benchmark failed.
     * </p>
     * 
     * @return The reason why a benchmark failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * Returns the value of the EndpointMetrics property for this object.
     * 
     * @return The value of the EndpointMetrics property for this object.
     */
    public final InferenceMetrics endpointMetrics() {
        return endpointMetrics;
    }

    /**
     * <p>
     * A timestamp that shows when the benchmark completed.
     * </p>
     * 
     * @return A timestamp that shows when the benchmark completed.
     */
    public final Instant invocationEndTime() {
        return invocationEndTime;
    }

    /**
     * <p>
     * A timestamp that shows when the benchmark started.
     * </p>
     * 
     * @return A timestamp that shows when the benchmark started.
     */
    public final Instant invocationStartTime() {
        return invocationStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(endpointMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(invocationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(invocationStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobInferenceBenchmark)) {
            return false;
        }
        RecommendationJobInferenceBenchmark other = (RecommendationJobInferenceBenchmark) obj;
        return Objects.equals(metrics(), other.metrics())
                && Objects.equals(endpointConfiguration(), other.endpointConfiguration())
                && Objects.equals(modelConfiguration(), other.modelConfiguration())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(endpointMetrics(), other.endpointMetrics())
                && Objects.equals(invocationEndTime(), other.invocationEndTime())
                && Objects.equals(invocationStartTime(), other.invocationStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationJobInferenceBenchmark").add("Metrics", metrics())
                .add("EndpointConfiguration", endpointConfiguration()).add("ModelConfiguration", modelConfiguration())
                .add("FailureReason", failureReason()).add("EndpointMetrics", endpointMetrics())
                .add("InvocationEndTime", invocationEndTime()).add("InvocationStartTime", invocationStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "EndpointConfiguration":
            return Optional.ofNullable(clazz.cast(endpointConfiguration()));
        case "ModelConfiguration":
            return Optional.ofNullable(clazz.cast(modelConfiguration()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "EndpointMetrics":
            return Optional.ofNullable(clazz.cast(endpointMetrics()));
        case "InvocationEndTime":
            return Optional.ofNullable(clazz.cast(invocationEndTime()));
        case "InvocationStartTime":
            return Optional.ofNullable(clazz.cast(invocationStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobInferenceBenchmark, T> g) {
        return obj -> g.apply((RecommendationJobInferenceBenchmark) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationJobInferenceBenchmark> {
        /**
         * Sets the value of the Metrics property for this object.
         *
         * @param metrics
         *        The new value for the Metrics property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(RecommendationMetrics metrics);

        /**
         * Sets the value of the Metrics property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RecommendationMetrics.Builder} avoiding
         * the need to create one manually via {@link RecommendationMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #metrics(RecommendationMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link RecommendationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(RecommendationMetrics)
         */
        default Builder metrics(Consumer<RecommendationMetrics.Builder> metrics) {
            return metrics(RecommendationMetrics.builder().applyMutation(metrics).build());
        }

        /**
         * Sets the value of the EndpointConfiguration property for this object.
         *
         * @param endpointConfiguration
         *        The new value for the EndpointConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfiguration(EndpointOutputConfiguration endpointConfiguration);

        /**
         * Sets the value of the EndpointConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EndpointOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link EndpointOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointConfiguration(EndpointOutputConfiguration)}.
         * 
         * @param endpointConfiguration
         *        a consumer that will call methods on {@link EndpointOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfiguration(EndpointOutputConfiguration)
         */
        default Builder endpointConfiguration(Consumer<EndpointOutputConfiguration.Builder> endpointConfiguration) {
            return endpointConfiguration(EndpointOutputConfiguration.builder().applyMutation(endpointConfiguration).build());
        }

        /**
         * Sets the value of the ModelConfiguration property for this object.
         *
         * @param modelConfiguration
         *        The new value for the ModelConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelConfiguration(ModelConfiguration modelConfiguration);

        /**
         * Sets the value of the ModelConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ModelConfiguration.Builder} avoiding the
         * need to create one manually via {@link ModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #modelConfiguration(ModelConfiguration)}.
         * 
         * @param modelConfiguration
         *        a consumer that will call methods on {@link ModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelConfiguration(ModelConfiguration)
         */
        default Builder modelConfiguration(Consumer<ModelConfiguration.Builder> modelConfiguration) {
            return modelConfiguration(ModelConfiguration.builder().applyMutation(modelConfiguration).build());
        }

        /**
         * <p>
         * The reason why a benchmark failed.
         * </p>
         * 
         * @param failureReason
         *        The reason why a benchmark failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * Sets the value of the EndpointMetrics property for this object.
         *
         * @param endpointMetrics
         *        The new value for the EndpointMetrics property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointMetrics(InferenceMetrics endpointMetrics);

        /**
         * Sets the value of the EndpointMetrics property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InferenceMetrics.Builder} avoiding the
         * need to create one manually via {@link InferenceMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointMetrics(InferenceMetrics)}.
         * 
         * @param endpointMetrics
         *        a consumer that will call methods on {@link InferenceMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointMetrics(InferenceMetrics)
         */
        default Builder endpointMetrics(Consumer<InferenceMetrics.Builder> endpointMetrics) {
            return endpointMetrics(InferenceMetrics.builder().applyMutation(endpointMetrics).build());
        }

        /**
         * <p>
         * A timestamp that shows when the benchmark completed.
         * </p>
         * 
         * @param invocationEndTime
         *        A timestamp that shows when the benchmark completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationEndTime(Instant invocationEndTime);

        /**
         * <p>
         * A timestamp that shows when the benchmark started.
         * </p>
         * 
         * @param invocationStartTime
         *        A timestamp that shows when the benchmark started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationStartTime(Instant invocationStartTime);
    }

    static final class BuilderImpl implements Builder {
        private RecommendationMetrics metrics;

        private EndpointOutputConfiguration endpointConfiguration;

        private ModelConfiguration modelConfiguration;

        private String failureReason;

        private InferenceMetrics endpointMetrics;

        private Instant invocationEndTime;

        private Instant invocationStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobInferenceBenchmark model) {
            metrics(model.metrics);
            endpointConfiguration(model.endpointConfiguration);
            modelConfiguration(model.modelConfiguration);
            failureReason(model.failureReason);
            endpointMetrics(model.endpointMetrics);
            invocationEndTime(model.invocationEndTime);
            invocationStartTime(model.invocationStartTime);
        }

        public final RecommendationMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(RecommendationMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(RecommendationMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final EndpointOutputConfiguration.Builder getEndpointConfiguration() {
            return endpointConfiguration != null ? endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointOutputConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointOutputConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final ModelConfiguration.Builder getModelConfiguration() {
            return modelConfiguration != null ? modelConfiguration.toBuilder() : null;
        }

        public final void setModelConfiguration(ModelConfiguration.BuilderImpl modelConfiguration) {
            this.modelConfiguration = modelConfiguration != null ? modelConfiguration.build() : null;
        }

        @Override
        public final Builder modelConfiguration(ModelConfiguration modelConfiguration) {
            this.modelConfiguration = modelConfiguration;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final InferenceMetrics.Builder getEndpointMetrics() {
            return endpointMetrics != null ? endpointMetrics.toBuilder() : null;
        }

        public final void setEndpointMetrics(InferenceMetrics.BuilderImpl endpointMetrics) {
            this.endpointMetrics = endpointMetrics != null ? endpointMetrics.build() : null;
        }

        @Override
        public final Builder endpointMetrics(InferenceMetrics endpointMetrics) {
            this.endpointMetrics = endpointMetrics;
            return this;
        }

        public final Instant getInvocationEndTime() {
            return invocationEndTime;
        }

        public final void setInvocationEndTime(Instant invocationEndTime) {
            this.invocationEndTime = invocationEndTime;
        }

        @Override
        public final Builder invocationEndTime(Instant invocationEndTime) {
            this.invocationEndTime = invocationEndTime;
            return this;
        }

        public final Instant getInvocationStartTime() {
            return invocationStartTime;
        }

        public final void setInvocationStartTime(Instant invocationStartTime) {
            this.invocationStartTime = invocationStartTime;
        }

        @Override
        public final Builder invocationStartTime(Instant invocationStartTime) {
            this.invocationStartTime = invocationStartTime;
            return this;
        }

        @Override
        public RecommendationJobInferenceBenchmark build() {
            return new RecommendationJobInferenceBenchmark(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
