/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeEndpointAsyncRequest extends SageMakerRuntimeRequest implements
        ToCopyableBuilder<InvokeEndpointAsyncRequest.Builder, InvokeEndpointAsyncRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(InvokeEndpointAsyncRequest::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EndpointName").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentType")
            .getter(getter(InvokeEndpointAsyncRequest::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Content-Type")
                    .build()).build();

    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Accept")
            .getter(getter(InvokeEndpointAsyncRequest::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Accept").build())
            .build();

    private static final SdkField<String> CUSTOM_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomAttributes")
            .getter(getter(InvokeEndpointAsyncRequest::customAttributes))
            .setter(setter(Builder::customAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Custom-Attributes")
                    .build()).build();

    private static final SdkField<String> INFERENCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InferenceId")
            .getter(getter(InvokeEndpointAsyncRequest::inferenceId))
            .setter(setter(Builder::inferenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Inference-Id")
                    .build()).build();

    private static final SdkField<String> INPUT_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InputLocation")
            .getter(getter(InvokeEndpointAsyncRequest::inputLocation))
            .setter(setter(Builder::inputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-InputLocation")
                    .build()).build();

    private static final SdkField<Integer> REQUEST_TTL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RequestTTLSeconds")
            .getter(getter(InvokeEndpointAsyncRequest::requestTTLSeconds))
            .setter(setter(Builder::requestTTLSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-RequestTTLSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            CONTENT_TYPE_FIELD, ACCEPT_FIELD, CUSTOM_ATTRIBUTES_FIELD, INFERENCE_ID_FIELD, INPUT_LOCATION_FIELD,
            REQUEST_TTL_SECONDS_FIELD));

    private final String endpointName;

    private final String contentType;

    private final String accept;

    private final String customAttributes;

    private final String inferenceId;

    private final String inputLocation;

    private final Integer requestTTLSeconds;

    private InvokeEndpointAsyncRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.customAttributes = builder.customAttributes;
        this.inferenceId = builder.inferenceId;
        this.inputLocation = builder.inputLocation;
        this.requestTTLSeconds = builder.requestTTLSeconds;
    }

    /**
     * <p>
     * The name of the endpoint that you specified when you created the endpoint using the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">
     * <code>CreateEndpoint</code> </a> API.
     * </p>
     * 
     * @return The name of the endpoint that you specified when you created the endpoint using the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">
     *         <code>CreateEndpoint</code> </a> API.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The MIME type of the input data in the request body.
     * </p>
     * 
     * @return The MIME type of the input data in the request body.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The desired MIME type of the inference in the response.
     * </p>
     * 
     * @return The desired MIME type of the inference in the response.
     */
    public final String accept() {
        return accept;
    }

    /**
     * <p>
     * Provides additional information about a request for an inference submitted to a model hosted at an Amazon
     * SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for
     * example, to provide an ID that you can use to track a request or to provide other metadata that a service
     * endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as
     * specified in <a href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value
     * Components</a> of the Hypertext Transfer Protocol (HTTP/1.1).
     * </p>
     * <p>
     * The code in your model is responsible for setting or updating any custom attributes in the response. If your code
     * does not set this value in the response, an empty value is returned. For example, if a custom attribute
     * represents the trace ID, your model can prepend the custom attribute with <code>Trace ID</code>: in your
     * post-processing function.
     * </p>
     * <p>
     * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.
     * </p>
     * 
     * @return Provides additional information about a request for an inference submitted to a model hosted at an Amazon
     *         SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this
     *         value, for example, to provide an ID that you can use to track a request or to provide other metadata
     *         that a service endpoint was programmed to process. The value must consist of no more than 1024 visible
     *         US-ASCII characters as specified in <a
     *         href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value
     *         Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
     *         <p>
     *         The code in your model is responsible for setting or updating any custom attributes in the response. If
     *         your code does not set this value in the response, an empty value is returned. For example, if a custom
     *         attribute represents the trace ID, your model can prepend the custom attribute with <code>Trace ID</code>
     *         : in your post-processing function.
     *         </p>
     *         <p>
     *         This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker
     *         Python SDK.
     */
    public final String customAttributes() {
        return customAttributes;
    }

    /**
     * <p>
     * The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none is
     * specified.
     * </p>
     * 
     * @return The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none is
     *         specified.
     */
    public final String inferenceId() {
        return inferenceId;
    }

    /**
     * <p>
     * The Amazon S3 URI where the inference request payload is stored.
     * </p>
     * 
     * @return The Amazon S3 URI where the inference request payload is stored.
     */
    public final String inputLocation() {
        return inputLocation;
    }

    /**
     * <p>
     * Maximum age in seconds a request can be in the queue before it is marked as expired.
     * </p>
     * 
     * @return Maximum age in seconds a request can be in the queue before it is marked as expired.
     */
    public final Integer requestTTLSeconds() {
        return requestTTLSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(customAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(inputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(requestTTLSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointAsyncRequest)) {
            return false;
        }
        InvokeEndpointAsyncRequest other = (InvokeEndpointAsyncRequest) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(accept(), other.accept()) && Objects.equals(customAttributes(), other.customAttributes())
                && Objects.equals(inferenceId(), other.inferenceId()) && Objects.equals(inputLocation(), other.inputLocation())
                && Objects.equals(requestTTLSeconds(), other.requestTTLSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeEndpointAsyncRequest").add("EndpointName", endpointName())
                .add("ContentType", contentType()).add("Accept", accept())
                .add("CustomAttributes", customAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InferenceId", inferenceId()).add("InputLocation", inputLocation())
                .add("RequestTTLSeconds", requestTTLSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "CustomAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        case "InferenceId":
            return Optional.ofNullable(clazz.cast(inferenceId()));
        case "InputLocation":
            return Optional.ofNullable(clazz.cast(inputLocation()));
        case "RequestTTLSeconds":
            return Optional.ofNullable(clazz.cast(requestTTLSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointAsyncRequest, T> g) {
        return obj -> g.apply((InvokeEndpointAsyncRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeEndpointAsyncRequest> {
        /**
         * <p>
         * The name of the endpoint that you specified when you created the endpoint using the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">
         * <code>CreateEndpoint</code> </a> API.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint that you specified when you created the endpoint using the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">
         *        <code>CreateEndpoint</code> </a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The MIME type of the input data in the request body.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the input data in the request body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The desired MIME type of the inference in the response.
         * </p>
         * 
         * @param accept
         *        The desired MIME type of the inference in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p>
         * Provides additional information about a request for an inference submitted to a model hosted at an Amazon
         * SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value,
         * for example, to provide an ID that you can use to track a request or to provide other metadata that a service
         * endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters
         * as specified in <a href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6. Field
         * Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1).
         * </p>
         * <p>
         * The code in your model is responsible for setting or updating any custom attributes in the response. If your
         * code does not set this value in the response, an empty value is returned. For example, if a custom attribute
         * represents the trace ID, your model can prepend the custom attribute with <code>Trace ID</code>: in your
         * post-processing function.
         * </p>
         * <p>
         * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python
         * SDK.
         * </p>
         * 
         * @param customAttributes
         *        Provides additional information about a request for an inference submitted to a model hosted at an
         *        Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could
         *        use this value, for example, to provide an ID that you can use to track a request or to provide other
         *        metadata that a service endpoint was programmed to process. The value must consist of no more than
         *        1024 visible US-ASCII characters as specified in <a
         *        href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value
         *        Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
         *        <p>
         *        The code in your model is responsible for setting or updating any custom attributes in the response.
         *        If your code does not set this value in the response, an empty value is returned. For example, if a
         *        custom attribute represents the trace ID, your model can prepend the custom attribute with
         *        <code>Trace ID</code>: in your post-processing function.
         *        </p>
         *        <p>
         *        This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker
         *        Python SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(String customAttributes);

        /**
         * <p>
         * The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none is
         * specified.
         * </p>
         * 
         * @param inferenceId
         *        The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none
         *        is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceId(String inferenceId);

        /**
         * <p>
         * The Amazon S3 URI where the inference request payload is stored.
         * </p>
         * 
         * @param inputLocation
         *        The Amazon S3 URI where the inference request payload is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLocation(String inputLocation);

        /**
         * <p>
         * Maximum age in seconds a request can be in the queue before it is marked as expired.
         * </p>
         * 
         * @param requestTTLSeconds
         *        Maximum age in seconds a request can be in the queue before it is marked as expired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTTLSeconds(Integer requestTTLSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRuntimeRequest.BuilderImpl implements Builder {
        private String endpointName;

        private String contentType;

        private String accept;

        private String customAttributes;

        private String inferenceId;

        private String inputLocation;

        private Integer requestTTLSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointAsyncRequest model) {
            super(model);
            endpointName(model.endpointName);
            contentType(model.contentType);
            accept(model.accept);
            customAttributes(model.customAttributes);
            inferenceId(model.inferenceId);
            inputLocation(model.inputLocation);
            requestTTLSeconds(model.requestTTLSeconds);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getAccept() {
            return accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final String getCustomAttributes() {
            return customAttributes;
        }

        public final void setCustomAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
        }

        @Override
        public final Builder customAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public final String getInferenceId() {
            return inferenceId;
        }

        public final void setInferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
        }

        @Override
        public final Builder inferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
            return this;
        }

        public final String getInputLocation() {
            return inputLocation;
        }

        public final void setInputLocation(String inputLocation) {
            this.inputLocation = inputLocation;
        }

        @Override
        public final Builder inputLocation(String inputLocation) {
            this.inputLocation = inputLocation;
            return this;
        }

        public final Integer getRequestTTLSeconds() {
            return requestTTLSeconds;
        }

        public final void setRequestTTLSeconds(Integer requestTTLSeconds) {
            this.requestTTLSeconds = requestTTLSeconds;
        }

        @Override
        public final Builder requestTTLSeconds(Integer requestTTLSeconds) {
            this.requestTTLSeconds = requestTTLSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeEndpointAsyncRequest build() {
            return new InvokeEndpointAsyncRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
