/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeEndpointWithResponseStreamVisitorBuilder implements
        InvokeEndpointWithResponseStreamResponseHandler.Visitor.Builder {
    private Consumer<ResponseStream> onDefault;

    private Consumer<PayloadPart> onPayloadPart;

    @Override
    public InvokeEndpointWithResponseStreamResponseHandler.Visitor.Builder onDefault(Consumer<ResponseStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public InvokeEndpointWithResponseStreamResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public InvokeEndpointWithResponseStreamResponseHandler.Visitor.Builder onPayloadPart(Consumer<PayloadPart> c) {
        this.onPayloadPart = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements InvokeEndpointWithResponseStreamResponseHandler.Visitor {
        private final Consumer<ResponseStream> onDefault;

        private final Consumer<PayloadPart> onPayloadPart;

        VisitorFromBuilder(DefaultInvokeEndpointWithResponseStreamVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : InvokeEndpointWithResponseStreamResponseHandler.Visitor.super::visitDefault;
            this.onPayloadPart = builder.onPayloadPart != null ? builder.onPayloadPart
                    : InvokeEndpointWithResponseStreamResponseHandler.Visitor.super::visitPayloadPart;
        }

        @Override
        public void visitDefault(ResponseStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitPayloadPart(PayloadPart event) {
            onPayloadPart.accept(event);
        }
    }
}
