/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchedulesResponse extends SchedulerResponse implements
        ToCopyableBuilder<ListSchedulesResponse.Builder, ListSchedulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSchedulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ScheduleSummary>> SCHEDULES_FIELD = SdkField
            .<List<ScheduleSummary>> builder(MarshallingType.LIST)
            .memberName("Schedules")
            .getter(getter(ListSchedulesResponse::schedules))
            .setter(setter(Builder::schedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCHEDULES_FIELD));

    private final String nextToken;

    private final List<ScheduleSummary> schedules;

    private ListSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.schedules = builder.schedules;
    }

    /**
     * <p>
     * Indicates whether there are additional results to retrieve. If the value is null, there are no more results.
     * </p>
     * 
     * @return Indicates whether there are additional results to retrieve. If the value is null, there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Schedules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchedules() {
        return schedules != null && !(schedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The schedules that match the specified criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchedules} method.
     * </p>
     * 
     * @return The schedules that match the specified criteria.
     */
    public final List<ScheduleSummary> schedules() {
        return schedules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSchedules() ? schedules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchedulesResponse)) {
            return false;
        }
        ListSchedulesResponse other = (ListSchedulesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSchedules() == other.hasSchedules()
                && Objects.equals(schedules(), other.schedules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchedulesResponse").add("NextToken", nextToken())
                .add("Schedules", hasSchedules() ? schedules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Schedules":
            return Optional.ofNullable(clazz.cast(schedules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchedulesResponse, T> g) {
        return obj -> g.apply((ListSchedulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchedulerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSchedulesResponse> {
        /**
         * <p>
         * Indicates whether there are additional results to retrieve. If the value is null, there are no more results.
         * </p>
         * 
         * @param nextToken
         *        Indicates whether there are additional results to retrieve. If the value is null, there are no more
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The schedules that match the specified criteria.
         * </p>
         * 
         * @param schedules
         *        The schedules that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedules(Collection<ScheduleSummary> schedules);

        /**
         * <p>
         * The schedules that match the specified criteria.
         * </p>
         * 
         * @param schedules
         *        The schedules that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedules(ScheduleSummary... schedules);

        /**
         * <p>
         * The schedules that match the specified criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.scheduler.model.ScheduleSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.scheduler.model.ScheduleSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.scheduler.model.ScheduleSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #schedules(List<ScheduleSummary>)}.
         * 
         * @param schedules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.scheduler.model.ScheduleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedules(java.util.Collection<ScheduleSummary>)
         */
        Builder schedules(Consumer<ScheduleSummary.Builder>... schedules);
    }

    static final class BuilderImpl extends SchedulerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ScheduleSummary> schedules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchedulesResponse model) {
            super(model);
            nextToken(model.nextToken);
            schedules(model.schedules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScheduleSummary.Builder> getSchedules() {
            List<ScheduleSummary.Builder> result = ScheduleListCopier.copyToBuilder(this.schedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchedules(Collection<ScheduleSummary.BuilderImpl> schedules) {
            this.schedules = ScheduleListCopier.copyFromBuilder(schedules);
        }

        @Override
        public final Builder schedules(Collection<ScheduleSummary> schedules) {
            this.schedules = ScheduleListCopier.copy(schedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(ScheduleSummary... schedules) {
            schedules(Arrays.asList(schedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(Consumer<ScheduleSummary.Builder>... schedules) {
            schedules(Stream.of(schedules).map(c -> ScheduleSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSchedulesResponse build() {
            return new ListSchedulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
