/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.schemas.SchemasClient;
import software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest;
import software.amazon.awssdk.services.schemas.model.DescribeCodeBindingResponse;
import software.amazon.awssdk.services.schemas.model.SchemasRequest;
import software.amazon.awssdk.services.schemas.waiters.SchemasWaiter;
import software.amazon.awssdk.services.schemas.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultSchemasWaiter
implements SchemasWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final SchemasClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeCodeBindingResponse> codeBindingExistsWaiter;

    private DefaultSchemasWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (SchemasClient)SchemasClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.codeBindingExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeCodeBindingResponse.class).acceptors(DefaultSchemasWaiter.codeBindingExistsWaiterAcceptors())).overrideConfiguration(DefaultSchemasWaiter.codeBindingExistsWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeCodeBindingResponse> waitUntilCodeBindingExists(DescribeCodeBindingRequest describeCodeBindingRequest) {
        return this.codeBindingExistsWaiter.run(() -> this.client.describeCodeBinding(this.applyWaitersUserAgent(describeCodeBindingRequest)));
    }

    @Override
    public WaiterResponse<DescribeCodeBindingResponse> waitUntilCodeBindingExists(DescribeCodeBindingRequest describeCodeBindingRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.codeBindingExistsWaiter.run(() -> this.client.describeCodeBinding(this.applyWaitersUserAgent(describeCodeBindingRequest)), DefaultSchemasWaiter.codeBindingExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeCodeBindingResponse>> codeBindingExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCodeBindingResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCodeBindingResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_COMPLETE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSchemasWaiter.errorCode(error), "NotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration codeBindingExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static SchemasWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends SchemasRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SchemasRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements SchemasWaiter.Builder {
        private SchemasClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public SchemasWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public SchemasWaiter.Builder client(SchemasClient client) {
            this.client = client;
            return this;
        }

        @Override
        public SchemasWaiter build() {
            return new DefaultSchemasWaiter(this);
        }
    }
}

