/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a version 1 Amazon API Gateway stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsApiGatewayStageDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsApiGatewayStageDetails.Builder, AwsApiGatewayStageDetails> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentId").getter(getter(AwsApiGatewayStageDetails::deploymentId))
            .setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCertificateId").getter(getter(AwsApiGatewayStageDetails::clientCertificateId))
            .setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertificateId").build())
            .build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(AwsApiGatewayStageDetails::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsApiGatewayStageDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> CACHE_CLUSTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CacheClusterEnabled").getter(getter(AwsApiGatewayStageDetails::cacheClusterEnabled))
            .setter(setter(Builder::cacheClusterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterEnabled").build())
            .build();

    private static final SdkField<String> CACHE_CLUSTER_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterSize").getter(getter(AwsApiGatewayStageDetails::cacheClusterSize))
            .setter(setter(Builder::cacheClusterSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterSize").build()).build();

    private static final SdkField<String> CACHE_CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterStatus").getter(getter(AwsApiGatewayStageDetails::cacheClusterStatus))
            .setter(setter(Builder::cacheClusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterStatus").build())
            .build();

    private static final SdkField<List<AwsApiGatewayMethodSettings>> METHOD_SETTINGS_FIELD = SdkField
            .<List<AwsApiGatewayMethodSettings>> builder(MarshallingType.LIST)
            .memberName("MethodSettings")
            .getter(getter(AwsApiGatewayStageDetails::methodSettings))
            .setter(setter(Builder::methodSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MethodSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsApiGatewayMethodSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsApiGatewayMethodSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Variables")
            .getter(getter(AwsApiGatewayStageDetails::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENTATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentationVersion").getter(getter(AwsApiGatewayStageDetails::documentationVersion))
            .setter(setter(Builder::documentationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationVersion").build())
            .build();

    private static final SdkField<AwsApiGatewayAccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField
            .<AwsApiGatewayAccessLogSettings> builder(MarshallingType.SDK_POJO).memberName("AccessLogSettings")
            .getter(getter(AwsApiGatewayStageDetails::accessLogSettings)).setter(setter(Builder::accessLogSettings))
            .constructor(AwsApiGatewayAccessLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLogSettings").build()).build();

    private static final SdkField<AwsApiGatewayCanarySettings> CANARY_SETTINGS_FIELD = SdkField
            .<AwsApiGatewayCanarySettings> builder(MarshallingType.SDK_POJO).memberName("CanarySettings")
            .getter(getter(AwsApiGatewayStageDetails::canarySettings)).setter(setter(Builder::canarySettings))
            .constructor(AwsApiGatewayCanarySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanarySettings").build()).build();

    private static final SdkField<Boolean> TRACING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TracingEnabled").getter(getter(AwsApiGatewayStageDetails::tracingEnabled))
            .setter(setter(Builder::tracingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingEnabled").build()).build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(AwsApiGatewayStageDetails::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> LAST_UPDATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedDate").getter(getter(AwsApiGatewayStageDetails::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()).build();

    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAclArn").getter(getter(AwsApiGatewayStageDetails::webAclArn)).setter(setter(Builder::webAclArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            CLIENT_CERTIFICATE_ID_FIELD, STAGE_NAME_FIELD, DESCRIPTION_FIELD, CACHE_CLUSTER_ENABLED_FIELD,
            CACHE_CLUSTER_SIZE_FIELD, CACHE_CLUSTER_STATUS_FIELD, METHOD_SETTINGS_FIELD, VARIABLES_FIELD,
            DOCUMENTATION_VERSION_FIELD, ACCESS_LOG_SETTINGS_FIELD, CANARY_SETTINGS_FIELD, TRACING_ENABLED_FIELD,
            CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, WEB_ACL_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentId;

    private final String clientCertificateId;

    private final String stageName;

    private final String description;

    private final Boolean cacheClusterEnabled;

    private final String cacheClusterSize;

    private final String cacheClusterStatus;

    private final List<AwsApiGatewayMethodSettings> methodSettings;

    private final Map<String, String> variables;

    private final String documentationVersion;

    private final AwsApiGatewayAccessLogSettings accessLogSettings;

    private final AwsApiGatewayCanarySettings canarySettings;

    private final Boolean tracingEnabled;

    private final String createdDate;

    private final String lastUpdatedDate;

    private final String webAclArn;

    private AwsApiGatewayStageDetails(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.clientCertificateId = builder.clientCertificateId;
        this.stageName = builder.stageName;
        this.description = builder.description;
        this.cacheClusterEnabled = builder.cacheClusterEnabled;
        this.cacheClusterSize = builder.cacheClusterSize;
        this.cacheClusterStatus = builder.cacheClusterStatus;
        this.methodSettings = builder.methodSettings;
        this.variables = builder.variables;
        this.documentationVersion = builder.documentationVersion;
        this.accessLogSettings = builder.accessLogSettings;
        this.canarySettings = builder.canarySettings;
        this.tracingEnabled = builder.tracingEnabled;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.webAclArn = builder.webAclArn;
    }

    /**
     * <p>
     * The identifier of the deployment that the stage points to.
     * </p>
     * 
     * @return The identifier of the deployment that the stage points to.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The identifier of the client certificate for the stage.
     * </p>
     * 
     * @return The identifier of the client certificate for the stage.
     */
    public final String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * A description of the stage.
     * </p>
     * 
     * @return A description of the stage.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether a cache cluster is enabled for the stage.
     * </p>
     * 
     * @return Indicates whether a cache cluster is enabled for the stage.
     */
    public final Boolean cacheClusterEnabled() {
        return cacheClusterEnabled;
    }

    /**
     * <p>
     * If a cache cluster is enabled, the size of the cache cluster.
     * </p>
     * 
     * @return If a cache cluster is enabled, the size of the cache cluster.
     */
    public final String cacheClusterSize() {
        return cacheClusterSize;
    }

    /**
     * <p>
     * If a cache cluster is enabled, the status of the cache cluster.
     * </p>
     * 
     * @return If a cache cluster is enabled, the status of the cache cluster.
     */
    public final String cacheClusterStatus() {
        return cacheClusterStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the MethodSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMethodSettings() {
        return methodSettings != null && !(methodSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the method settings for the stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMethodSettings} method.
     * </p>
     * 
     * @return Defines the method settings for the stage.
     */
    public final List<AwsApiGatewayMethodSettings> methodSettings() {
        return methodSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that defines the stage variables for the stage.
     * </p>
     * <p>
     * Variable names can have alphanumeric and underscore characters.
     * </p>
     * <p>
     * Variable values can contain the following characters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Uppercase and lowercase letters
     * </p>
     * </li>
     * <li>
     * <p>
     * Numbers
     * </p>
     * </li>
     * <li>
     * <p>
     * Special characters -._~:/?#&amp;=,
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return A map that defines the stage variables for the stage.</p>
     *         <p>
     *         Variable names can have alphanumeric and underscore characters.
     *         </p>
     *         <p>
     *         Variable values can contain the following characters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Uppercase and lowercase letters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Numbers
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Special characters -._~:/?#&amp;=,
     *         </p>
     *         </li>
     */
    public final Map<String, String> variables() {
        return variables;
    }

    /**
     * <p>
     * The version of the API documentation that is associated with the stage.
     * </p>
     * 
     * @return The version of the API documentation that is associated with the stage.
     */
    public final String documentationVersion() {
        return documentationVersion;
    }

    /**
     * <p>
     * Settings for logging access for the stage.
     * </p>
     * 
     * @return Settings for logging access for the stage.
     */
    public final AwsApiGatewayAccessLogSettings accessLogSettings() {
        return accessLogSettings;
    }

    /**
     * <p>
     * Information about settings for canary deployment in the stage.
     * </p>
     * 
     * @return Information about settings for canary deployment in the stage.
     */
    public final AwsApiGatewayCanarySettings canarySettings() {
        return canarySettings;
    }

    /**
     * <p>
     * Indicates whether active tracing with X-Ray is enabled for the stage.
     * </p>
     * 
     * @return Indicates whether active tracing with X-Ray is enabled for the stage.
     */
    public final Boolean tracingEnabled() {
        return tracingEnabled;
    }

    /**
     * <p>
     * Indicates when the stage was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the stage was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * Indicates when the stage was most recently updated.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the stage was most recently updated.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The ARN of the web ACL associated with the stage.
     * </p>
     * 
     * @return The ARN of the web ACL associated with the stage.
     */
    public final String webAclArn() {
        return webAclArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasMethodSettings() ? methodSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(documentationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(canarySettings());
        hashCode = 31 * hashCode + Objects.hashCode(tracingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(webAclArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayStageDetails)) {
            return false;
        }
        AwsApiGatewayStageDetails other = (AwsApiGatewayStageDetails) obj;
        return Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(clientCertificateId(), other.clientCertificateId())
                && Objects.equals(stageName(), other.stageName()) && Objects.equals(description(), other.description())
                && Objects.equals(cacheClusterEnabled(), other.cacheClusterEnabled())
                && Objects.equals(cacheClusterSize(), other.cacheClusterSize())
                && Objects.equals(cacheClusterStatus(), other.cacheClusterStatus())
                && hasMethodSettings() == other.hasMethodSettings() && Objects.equals(methodSettings(), other.methodSettings())
                && hasVariables() == other.hasVariables() && Objects.equals(variables(), other.variables())
                && Objects.equals(documentationVersion(), other.documentationVersion())
                && Objects.equals(accessLogSettings(), other.accessLogSettings())
                && Objects.equals(canarySettings(), other.canarySettings())
                && Objects.equals(tracingEnabled(), other.tracingEnabled()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(webAclArn(), other.webAclArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsApiGatewayStageDetails").add("DeploymentId", deploymentId())
                .add("ClientCertificateId", clientCertificateId()).add("StageName", stageName())
                .add("Description", description()).add("CacheClusterEnabled", cacheClusterEnabled())
                .add("CacheClusterSize", cacheClusterSize()).add("CacheClusterStatus", cacheClusterStatus())
                .add("MethodSettings", hasMethodSettings() ? methodSettings() : null)
                .add("Variables", hasVariables() ? variables() : null).add("DocumentationVersion", documentationVersion())
                .add("AccessLogSettings", accessLogSettings()).add("CanarySettings", canarySettings())
                .add("TracingEnabled", tracingEnabled()).add("CreatedDate", createdDate())
                .add("LastUpdatedDate", lastUpdatedDate()).add("WebAclArn", webAclArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "ClientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CacheClusterEnabled":
            return Optional.ofNullable(clazz.cast(cacheClusterEnabled()));
        case "CacheClusterSize":
            return Optional.ofNullable(clazz.cast(cacheClusterSize()));
        case "CacheClusterStatus":
            return Optional.ofNullable(clazz.cast(cacheClusterStatus()));
        case "MethodSettings":
            return Optional.ofNullable(clazz.cast(methodSettings()));
        case "Variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "DocumentationVersion":
            return Optional.ofNullable(clazz.cast(documentationVersion()));
        case "AccessLogSettings":
            return Optional.ofNullable(clazz.cast(accessLogSettings()));
        case "CanarySettings":
            return Optional.ofNullable(clazz.cast(canarySettings()));
        case "TracingEnabled":
            return Optional.ofNullable(clazz.cast(tracingEnabled()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "LastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "WebAclArn":
            return Optional.ofNullable(clazz.cast(webAclArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayStageDetails, T> g) {
        return obj -> g.apply((AwsApiGatewayStageDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsApiGatewayStageDetails> {
        /**
         * <p>
         * The identifier of the deployment that the stage points to.
         * </p>
         * 
         * @param deploymentId
         *        The identifier of the deployment that the stage points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The identifier of the client certificate for the stage.
         * </p>
         * 
         * @param clientCertificateId
         *        The identifier of the client certificate for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param stageName
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * A description of the stage.
         * </p>
         * 
         * @param description
         *        A description of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether a cache cluster is enabled for the stage.
         * </p>
         * 
         * @param cacheClusterEnabled
         *        Indicates whether a cache cluster is enabled for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterEnabled(Boolean cacheClusterEnabled);

        /**
         * <p>
         * If a cache cluster is enabled, the size of the cache cluster.
         * </p>
         * 
         * @param cacheClusterSize
         *        If a cache cluster is enabled, the size of the cache cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterSize(String cacheClusterSize);

        /**
         * <p>
         * If a cache cluster is enabled, the status of the cache cluster.
         * </p>
         * 
         * @param cacheClusterStatus
         *        If a cache cluster is enabled, the status of the cache cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterStatus(String cacheClusterStatus);

        /**
         * <p>
         * Defines the method settings for the stage.
         * </p>
         * 
         * @param methodSettings
         *        Defines the method settings for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methodSettings(Collection<AwsApiGatewayMethodSettings> methodSettings);

        /**
         * <p>
         * Defines the method settings for the stage.
         * </p>
         * 
         * @param methodSettings
         *        Defines the method settings for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methodSettings(AwsApiGatewayMethodSettings... methodSettings);

        /**
         * <p>
         * Defines the method settings for the stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings.Builder#build()} is
         * called immediately and its result is passed to {@link #methodSettings(List<AwsApiGatewayMethodSettings>)}.
         * 
         * @param methodSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #methodSettings(java.util.Collection<AwsApiGatewayMethodSettings>)
         */
        Builder methodSettings(Consumer<AwsApiGatewayMethodSettings.Builder>... methodSettings);

        /**
         * <p>
         * A map that defines the stage variables for the stage.
         * </p>
         * <p>
         * Variable names can have alphanumeric and underscore characters.
         * </p>
         * <p>
         * Variable values can contain the following characters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Uppercase and lowercase letters
         * </p>
         * </li>
         * <li>
         * <p>
         * Numbers
         * </p>
         * </li>
         * <li>
         * <p>
         * Special characters -._~:/?#&amp;=,
         * </p>
         * </li>
         * </ul>
         * 
         * @param variables
         *        A map that defines the stage variables for the stage.</p>
         *        <p>
         *        Variable names can have alphanumeric and underscore characters.
         *        </p>
         *        <p>
         *        Variable values can contain the following characters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Uppercase and lowercase letters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Numbers
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Special characters -._~:/?#&amp;=,
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Map<String, String> variables);

        /**
         * <p>
         * The version of the API documentation that is associated with the stage.
         * </p>
         * 
         * @param documentationVersion
         *        The version of the API documentation that is associated with the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationVersion(String documentationVersion);

        /**
         * <p>
         * Settings for logging access for the stage.
         * </p>
         * 
         * @param accessLogSettings
         *        Settings for logging access for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLogSettings(AwsApiGatewayAccessLogSettings accessLogSettings);

        /**
         * <p>
         * Settings for logging access for the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiGatewayAccessLogSettings.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayAccessLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiGatewayAccessLogSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #accessLogSettings(AwsApiGatewayAccessLogSettings)}.
         * 
         * @param accessLogSettings
         *        a consumer that will call methods on {@link AwsApiGatewayAccessLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLogSettings(AwsApiGatewayAccessLogSettings)
         */
        default Builder accessLogSettings(Consumer<AwsApiGatewayAccessLogSettings.Builder> accessLogSettings) {
            return accessLogSettings(AwsApiGatewayAccessLogSettings.builder().applyMutation(accessLogSettings).build());
        }

        /**
         * <p>
         * Information about settings for canary deployment in the stage.
         * </p>
         * 
         * @param canarySettings
         *        Information about settings for canary deployment in the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canarySettings(AwsApiGatewayCanarySettings canarySettings);

        /**
         * <p>
         * Information about settings for canary deployment in the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiGatewayCanarySettings.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayCanarySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiGatewayCanarySettings.Builder#build()} is called
         * immediately and its result is passed to {@link #canarySettings(AwsApiGatewayCanarySettings)}.
         * 
         * @param canarySettings
         *        a consumer that will call methods on {@link AwsApiGatewayCanarySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canarySettings(AwsApiGatewayCanarySettings)
         */
        default Builder canarySettings(Consumer<AwsApiGatewayCanarySettings.Builder> canarySettings) {
            return canarySettings(AwsApiGatewayCanarySettings.builder().applyMutation(canarySettings).build());
        }

        /**
         * <p>
         * Indicates whether active tracing with X-Ray is enabled for the stage.
         * </p>
         * 
         * @param tracingEnabled
         *        Indicates whether active tracing with X-Ray is enabled for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingEnabled(Boolean tracingEnabled);

        /**
         * <p>
         * Indicates when the stage was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdDate
         *        Indicates when the stage was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);

        /**
         * <p>
         * Indicates when the stage was most recently updated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param lastUpdatedDate
         *        Indicates when the stage was most recently updated.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(String lastUpdatedDate);

        /**
         * <p>
         * The ARN of the web ACL associated with the stage.
         * </p>
         * 
         * @param webAclArn
         *        The ARN of the web ACL associated with the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAclArn(String webAclArn);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String clientCertificateId;

        private String stageName;

        private String description;

        private Boolean cacheClusterEnabled;

        private String cacheClusterSize;

        private String cacheClusterStatus;

        private List<AwsApiGatewayMethodSettings> methodSettings = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private String documentationVersion;

        private AwsApiGatewayAccessLogSettings accessLogSettings;

        private AwsApiGatewayCanarySettings canarySettings;

        private Boolean tracingEnabled;

        private String createdDate;

        private String lastUpdatedDate;

        private String webAclArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayStageDetails model) {
            deploymentId(model.deploymentId);
            clientCertificateId(model.clientCertificateId);
            stageName(model.stageName);
            description(model.description);
            cacheClusterEnabled(model.cacheClusterEnabled);
            cacheClusterSize(model.cacheClusterSize);
            cacheClusterStatus(model.cacheClusterStatus);
            methodSettings(model.methodSettings);
            variables(model.variables);
            documentationVersion(model.documentationVersion);
            accessLogSettings(model.accessLogSettings);
            canarySettings(model.canarySettings);
            tracingEnabled(model.tracingEnabled);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
            webAclArn(model.webAclArn);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getCacheClusterEnabled() {
            return cacheClusterEnabled;
        }

        public final void setCacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
        }

        @Override
        public final Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        public final String getCacheClusterSize() {
            return cacheClusterSize;
        }

        public final void setCacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
        }

        @Override
        public final Builder cacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        public final String getCacheClusterStatus() {
            return cacheClusterStatus;
        }

        public final void setCacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
        }

        @Override
        public final Builder cacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
            return this;
        }

        public final List<AwsApiGatewayMethodSettings.Builder> getMethodSettings() {
            List<AwsApiGatewayMethodSettings.Builder> result = AwsApiGatewayMethodSettingsListCopier
                    .copyToBuilder(this.methodSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMethodSettings(Collection<AwsApiGatewayMethodSettings.BuilderImpl> methodSettings) {
            this.methodSettings = AwsApiGatewayMethodSettingsListCopier.copyFromBuilder(methodSettings);
        }

        @Override
        public final Builder methodSettings(Collection<AwsApiGatewayMethodSettings> methodSettings) {
            this.methodSettings = AwsApiGatewayMethodSettingsListCopier.copy(methodSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methodSettings(AwsApiGatewayMethodSettings... methodSettings) {
            methodSettings(Arrays.asList(methodSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methodSettings(Consumer<AwsApiGatewayMethodSettings.Builder>... methodSettings) {
            methodSettings(Stream.of(methodSettings).map(c -> AwsApiGatewayMethodSettings.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getVariables() {
            if (variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = FieldMapCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = FieldMapCopier.copy(variables);
            return this;
        }

        public final String getDocumentationVersion() {
            return documentationVersion;
        }

        public final void setDocumentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
        }

        @Override
        public final Builder documentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        public final AwsApiGatewayAccessLogSettings.Builder getAccessLogSettings() {
            return accessLogSettings != null ? accessLogSettings.toBuilder() : null;
        }

        public final void setAccessLogSettings(AwsApiGatewayAccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        @Override
        public final Builder accessLogSettings(AwsApiGatewayAccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final AwsApiGatewayCanarySettings.Builder getCanarySettings() {
            return canarySettings != null ? canarySettings.toBuilder() : null;
        }

        public final void setCanarySettings(AwsApiGatewayCanarySettings.BuilderImpl canarySettings) {
            this.canarySettings = canarySettings != null ? canarySettings.build() : null;
        }

        @Override
        public final Builder canarySettings(AwsApiGatewayCanarySettings canarySettings) {
            this.canarySettings = canarySettings;
            return this;
        }

        public final Boolean getTracingEnabled() {
            return tracingEnabled;
        }

        public final void setTracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
        }

        @Override
        public final Builder tracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getWebAclArn() {
            return webAclArn;
        }

        public final void setWebAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
        }

        @Override
        public final Builder webAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
            return this;
        }

        @Override
        public AwsApiGatewayStageDetails build() {
            return new AwsApiGatewayStageDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
