/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the provisioned throughput for the table or for a global secondary index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableProvisionedThroughput implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableProvisionedThroughput.Builder, AwsDynamoDbTableProvisionedThroughput> {
    private static final SdkField<String> LAST_DECREASE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastDecreaseDateTime").getter(getter(AwsDynamoDbTableProvisionedThroughput::lastDecreaseDateTime))
            .setter(setter(Builder::lastDecreaseDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDecreaseDateTime").build())
            .build();

    private static final SdkField<String> LAST_INCREASE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastIncreaseDateTime").getter(getter(AwsDynamoDbTableProvisionedThroughput::lastIncreaseDateTime))
            .setter(setter(Builder::lastIncreaseDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastIncreaseDateTime").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_DECREASES_TODAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfDecreasesToday").getter(getter(AwsDynamoDbTableProvisionedThroughput::numberOfDecreasesToday))
            .setter(setter(Builder::numberOfDecreasesToday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDecreasesToday").build())
            .build();

    private static final SdkField<Integer> READ_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReadCapacityUnits").getter(getter(AwsDynamoDbTableProvisionedThroughput::readCapacityUnits))
            .setter(setter(Builder::readCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCapacityUnits").build()).build();

    private static final SdkField<Integer> WRITE_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WriteCapacityUnits").getter(getter(AwsDynamoDbTableProvisionedThroughput::writeCapacityUnits))
            .setter(setter(Builder::writeCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteCapacityUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LAST_DECREASE_DATE_TIME_FIELD, LAST_INCREASE_DATE_TIME_FIELD, NUMBER_OF_DECREASES_TODAY_FIELD,
                    READ_CAPACITY_UNITS_FIELD, WRITE_CAPACITY_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lastDecreaseDateTime;

    private final String lastIncreaseDateTime;

    private final Integer numberOfDecreasesToday;

    private final Integer readCapacityUnits;

    private final Integer writeCapacityUnits;

    private AwsDynamoDbTableProvisionedThroughput(BuilderImpl builder) {
        this.lastDecreaseDateTime = builder.lastDecreaseDateTime;
        this.lastIncreaseDateTime = builder.lastIncreaseDateTime;
        this.numberOfDecreasesToday = builder.numberOfDecreasesToday;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    /**
     * <p>
     * Indicates when the provisioned throughput was last decreased.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the provisioned throughput was last decreased.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String lastDecreaseDateTime() {
        return lastDecreaseDateTime;
    }

    /**
     * <p>
     * Indicates when the provisioned throughput was last increased.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the provisioned throughput was last increased.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String lastIncreaseDateTime() {
        return lastIncreaseDateTime;
    }

    /**
     * <p>
     * The number of times during the current UTC calendar day that the provisioned throughput was decreased.
     * </p>
     * 
     * @return The number of times during the current UTC calendar day that the provisioned throughput was decreased.
     */
    public final Integer numberOfDecreasesToday() {
        return numberOfDecreasesToday;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>.
     */
    public final Integer readCapacityUnits() {
        return readCapacityUnits;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>.
     */
    public final Integer writeCapacityUnits() {
        return writeCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastDecreaseDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastIncreaseDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDecreasesToday());
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(writeCapacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableProvisionedThroughput)) {
            return false;
        }
        AwsDynamoDbTableProvisionedThroughput other = (AwsDynamoDbTableProvisionedThroughput) obj;
        return Objects.equals(lastDecreaseDateTime(), other.lastDecreaseDateTime())
                && Objects.equals(lastIncreaseDateTime(), other.lastIncreaseDateTime())
                && Objects.equals(numberOfDecreasesToday(), other.numberOfDecreasesToday())
                && Objects.equals(readCapacityUnits(), other.readCapacityUnits())
                && Objects.equals(writeCapacityUnits(), other.writeCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableProvisionedThroughput").add("LastDecreaseDateTime", lastDecreaseDateTime())
                .add("LastIncreaseDateTime", lastIncreaseDateTime()).add("NumberOfDecreasesToday", numberOfDecreasesToday())
                .add("ReadCapacityUnits", readCapacityUnits()).add("WriteCapacityUnits", writeCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastDecreaseDateTime":
            return Optional.ofNullable(clazz.cast(lastDecreaseDateTime()));
        case "LastIncreaseDateTime":
            return Optional.ofNullable(clazz.cast(lastIncreaseDateTime()));
        case "NumberOfDecreasesToday":
            return Optional.ofNullable(clazz.cast(numberOfDecreasesToday()));
        case "ReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(readCapacityUnits()));
        case "WriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(writeCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableProvisionedThroughput, T> g) {
        return obj -> g.apply((AwsDynamoDbTableProvisionedThroughput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableProvisionedThroughput> {
        /**
         * <p>
         * Indicates when the provisioned throughput was last decreased.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param lastDecreaseDateTime
         *        Indicates when the provisioned throughput was last decreased.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDecreaseDateTime(String lastDecreaseDateTime);

        /**
         * <p>
         * Indicates when the provisioned throughput was last increased.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param lastIncreaseDateTime
         *        Indicates when the provisioned throughput was last increased.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastIncreaseDateTime(String lastIncreaseDateTime);

        /**
         * <p>
         * The number of times during the current UTC calendar day that the provisioned throughput was decreased.
         * </p>
         * 
         * @param numberOfDecreasesToday
         *        The number of times during the current UTC calendar day that the provisioned throughput was decreased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDecreasesToday(Integer numberOfDecreasesToday);

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>.
         * </p>
         * 
         * @param readCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityUnits(Integer readCapacityUnits);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
         * </p>
         * 
         * @param writeCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCapacityUnits(Integer writeCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private String lastDecreaseDateTime;

        private String lastIncreaseDateTime;

        private Integer numberOfDecreasesToday;

        private Integer readCapacityUnits;

        private Integer writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableProvisionedThroughput model) {
            lastDecreaseDateTime(model.lastDecreaseDateTime);
            lastIncreaseDateTime(model.lastIncreaseDateTime);
            numberOfDecreasesToday(model.numberOfDecreasesToday);
            readCapacityUnits(model.readCapacityUnits);
            writeCapacityUnits(model.writeCapacityUnits);
        }

        public final String getLastDecreaseDateTime() {
            return lastDecreaseDateTime;
        }

        public final void setLastDecreaseDateTime(String lastDecreaseDateTime) {
            this.lastDecreaseDateTime = lastDecreaseDateTime;
        }

        @Override
        public final Builder lastDecreaseDateTime(String lastDecreaseDateTime) {
            this.lastDecreaseDateTime = lastDecreaseDateTime;
            return this;
        }

        public final String getLastIncreaseDateTime() {
            return lastIncreaseDateTime;
        }

        public final void setLastIncreaseDateTime(String lastIncreaseDateTime) {
            this.lastIncreaseDateTime = lastIncreaseDateTime;
        }

        @Override
        public final Builder lastIncreaseDateTime(String lastIncreaseDateTime) {
            this.lastIncreaseDateTime = lastIncreaseDateTime;
            return this;
        }

        public final Integer getNumberOfDecreasesToday() {
            return numberOfDecreasesToday;
        }

        public final void setNumberOfDecreasesToday(Integer numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
        }

        @Override
        public final Builder numberOfDecreasesToday(Integer numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
            return this;
        }

        public final Integer getReadCapacityUnits() {
            return readCapacityUnits;
        }

        public final void setReadCapacityUnits(Integer readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Integer readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final Integer getWriteCapacityUnits() {
            return writeCapacityUnits;
        }

        public final void setWriteCapacityUnits(Integer writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Integer writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        @Override
        public AwsDynamoDbTableProvisionedThroughput build() {
            return new AwsDynamoDbTableProvisionedThroughput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
