/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the network interface attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2NetworkInterfaceAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2NetworkInterfaceAttachment.Builder, AwsEc2NetworkInterfaceAttachment> {
    private static final SdkField<String> ATTACH_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachTime").getter(getter(AwsEc2NetworkInterfaceAttachment::attachTime))
            .setter(setter(Builder::attachTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").build()).build();

    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId").getter(getter(AwsEc2NetworkInterfaceAttachment::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination").getter(getter(AwsEc2NetworkInterfaceAttachment::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").build())
            .build();

    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeviceIndex").getter(getter(AwsEc2NetworkInterfaceAttachment::deviceIndex))
            .setter(setter(Builder::deviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AwsEc2NetworkInterfaceAttachment::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceOwnerId").getter(getter(AwsEc2NetworkInterfaceAttachment::instanceOwnerId))
            .setter(setter(Builder::instanceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwnerId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsEc2NetworkInterfaceAttachment::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACH_TIME_FIELD,
            ATTACHMENT_ID_FIELD, DELETE_ON_TERMINATION_FIELD, DEVICE_INDEX_FIELD, INSTANCE_ID_FIELD, INSTANCE_OWNER_ID_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachTime;

    private final String attachmentId;

    private final Boolean deleteOnTermination;

    private final Integer deviceIndex;

    private final String instanceId;

    private final String instanceOwnerId;

    private final String status;

    private AwsEc2NetworkInterfaceAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Indicates when the attachment initiated.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the attachment initiated.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String attachTime() {
        return attachTime;
    }

    /**
     * <p>
     * The identifier of the network interface attachment
     * </p>
     * 
     * @return The identifier of the network interface attachment
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The device index of the network interface attachment on the instance.
     * </p>
     * 
     * @return The device index of the network interface attachment on the instance.
     */
    public final Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the instance.
     */
    public final String instanceOwnerId() {
        return instanceOwnerId;
    }

    /**
     * <p>
     * The attachment state.
     * </p>
     * <p>
     * Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>
     * </p>
     * 
     * @return The attachment state.</p>
     *         <p>
     *         Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> |
     *         <code>detached</code>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceAttachment)) {
            return false;
        }
        AwsEc2NetworkInterfaceAttachment other = (AwsEc2NetworkInterfaceAttachment) obj;
        return Objects.equals(attachTime(), other.attachTime()) && Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(deviceIndex(), other.deviceIndex()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceOwnerId(), other.instanceOwnerId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2NetworkInterfaceAttachment").add("AttachTime", attachTime())
                .add("AttachmentId", attachmentId()).add("DeleteOnTermination", deleteOnTermination())
                .add("DeviceIndex", deviceIndex()).add("InstanceId", instanceId()).add("InstanceOwnerId", instanceOwnerId())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachTime":
            return Optional.ofNullable(clazz.cast(attachTime()));
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "DeviceIndex":
            return Optional.ofNullable(clazz.cast(deviceIndex()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceOwnerId":
            return Optional.ofNullable(clazz.cast(instanceOwnerId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceAttachment, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2NetworkInterfaceAttachment> {
        /**
         * <p>
         * Indicates when the attachment initiated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param attachTime
         *        Indicates when the attachment initiated.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTime(String attachTime);

        /**
         * <p>
         * The identifier of the network interface attachment
         * </p>
         * 
         * @param attachmentId
         *        The identifier of the network interface attachment
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The device index of the network interface attachment on the instance.
         * </p>
         * 
         * @param deviceIndex
         *        The device index of the network interface attachment on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the instance.
         * </p>
         * 
         * @param instanceOwnerId
         *        The Amazon Web Services account ID of the owner of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceOwnerId(String instanceOwnerId);

        /**
         * <p>
         * The attachment state.
         * </p>
         * <p>
         * Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>
         * </p>
         * 
         * @param status
         *        The attachment state.</p>
         *        <p>
         *        Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> |
         *        <code>detached</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String attachTime;

        private String attachmentId;

        private Boolean deleteOnTermination;

        private Integer deviceIndex;

        private String instanceId;

        private String instanceOwnerId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceAttachment model) {
            attachTime(model.attachTime);
            attachmentId(model.attachmentId);
            deleteOnTermination(model.deleteOnTermination);
            deviceIndex(model.deviceIndex);
            instanceId(model.instanceId);
            instanceOwnerId(model.instanceOwnerId);
            status(model.status);
        }

        public final String getAttachTime() {
            return attachTime;
        }

        public final void setAttachTime(String attachTime) {
            this.attachTime = attachTime;
        }

        @Override
        public final Builder attachTime(String attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceOwnerId() {
            return instanceOwnerId;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsEc2NetworkInterfaceAttachment build() {
            return new AwsEc2NetworkInterfaceAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
