/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an EC2 volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VolumeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VolumeDetails.Builder, AwsEc2VolumeDetails> {
    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateTime").getter(getter(AwsEc2VolumeDetails::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(AwsEc2VolumeDetails::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(AwsEc2VolumeDetails::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Size")
            .getter(getter(AwsEc2VolumeDetails::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(AwsEc2VolumeDetails::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsEc2VolumeDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsEc2VolumeDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<AwsEc2VolumeAttachment>> ATTACHMENTS_FIELD = SdkField
            .<List<AwsEc2VolumeAttachment>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(AwsEc2VolumeDetails::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2VolumeAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2VolumeAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(AwsEc2VolumeDetails::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(AwsEc2VolumeDetails::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<String> VOLUME_SCAN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeScanStatus").getter(getter(AwsEc2VolumeDetails::volumeScanStatus))
            .setter(setter(Builder::volumeScanStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeScanStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            DEVICE_NAME_FIELD, ENCRYPTED_FIELD, SIZE_FIELD, SNAPSHOT_ID_FIELD, STATUS_FIELD, KMS_KEY_ID_FIELD, ATTACHMENTS_FIELD,
            VOLUME_ID_FIELD, VOLUME_TYPE_FIELD, VOLUME_SCAN_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String createTime;

    private final String deviceName;

    private final Boolean encrypted;

    private final Integer size;

    private final String snapshotId;

    private final String status;

    private final String kmsKeyId;

    private final List<AwsEc2VolumeAttachment> attachments;

    private final String volumeId;

    private final String volumeType;

    private final String volumeScanStatus;

    private AwsEc2VolumeDetails(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.deviceName = builder.deviceName;
        this.encrypted = builder.encrypted;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.kmsKeyId = builder.kmsKeyId;
        this.attachments = builder.attachments;
        this.volumeId = builder.volumeId;
        this.volumeType = builder.volumeType;
        this.volumeScanStatus = builder.volumeScanStatus;
    }

    /**
     * <p>
     * Indicates when the volume was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the volume was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createTime() {
        return createTime;
    }

    /**
     * <p>
     * The device name for the volume that is attached to the instance.
     * </p>
     * 
     * @return The device name for the volume that is attached to the instance.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Specifies whether the volume is encrypted.
     * </p>
     * 
     * @return Specifies whether the volume is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The size of the volume, in GiBs.
     * </p>
     * 
     * @return The size of the volume, in GiBs.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The snapshot from which the volume was created.
     * </p>
     * 
     * @return The snapshot from which the volume was created.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The volume state. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>available</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>creating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>in-use</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The volume state. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>available</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>creating</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>in-use</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The ARN of the KMS key that was used to protect the volume encryption key for the volume.
     * </p>
     * 
     * @return The ARN of the KMS key that was used to protect the volume encryption key for the volume.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The volume attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return The volume attachments.
     */
    public final List<AwsEc2VolumeAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The volume type.
     * </p>
     * 
     * @return The volume type.
     */
    public final String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * Indicates whether the volume was scanned or skipped.
     * </p>
     * 
     * @return Indicates whether the volume was scanned or skipped.
     */
    public final String volumeScanStatus() {
        return volumeScanStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(volumeScanStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VolumeDetails)) {
            return false;
        }
        AwsEc2VolumeDetails other = (AwsEc2VolumeDetails) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(size(), other.size())
                && Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(status(), other.status())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasAttachments() == other.hasAttachments()
                && Objects.equals(attachments(), other.attachments()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(volumeType(), other.volumeType())
                && Objects.equals(volumeScanStatus(), other.volumeScanStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VolumeDetails").add("CreateTime", createTime()).add("DeviceName", deviceName())
                .add("Encrypted", encrypted()).add("Size", size()).add("SnapshotId", snapshotId()).add("Status", status())
                .add("KmsKeyId", kmsKeyId()).add("Attachments", hasAttachments() ? attachments() : null)
                .add("VolumeId", volumeId()).add("VolumeType", volumeType()).add("VolumeScanStatus", volumeScanStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "VolumeScanStatus":
            return Optional.ofNullable(clazz.cast(volumeScanStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VolumeDetails, T> g) {
        return obj -> g.apply((AwsEc2VolumeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VolumeDetails> {
        /**
         * <p>
         * Indicates when the volume was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createTime
         *        Indicates when the volume was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(String createTime);

        /**
         * <p>
         * The device name for the volume that is attached to the instance.
         * </p>
         * 
         * @param deviceName
         *        The device name for the volume that is attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Specifies whether the volume is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether the volume is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The size of the volume, in GiBs.
         * </p>
         * 
         * @param size
         *        The size of the volume, in GiBs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The snapshot from which the volume was created.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot from which the volume was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The volume state. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>available</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creating</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>in-use</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The volume state. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>available</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creating</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>in-use</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The ARN of the KMS key that was used to protect the volume encryption key for the volume.
         * </p>
         * 
         * @param kmsKeyId
         *        The ARN of the KMS key that was used to protect the volume encryption key for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The volume attachments.
         * </p>
         * 
         * @param attachments
         *        The volume attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<AwsEc2VolumeAttachment> attachments);

        /**
         * <p>
         * The volume attachments.
         * </p>
         * 
         * @param attachments
         *        The volume attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(AwsEc2VolumeAttachment... attachments);

        /**
         * <p>
         * The volume attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #attachments(List<AwsEc2VolumeAttachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<AwsEc2VolumeAttachment>)
         */
        Builder attachments(Consumer<AwsEc2VolumeAttachment.Builder>... attachments);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The volume type.
         * </p>
         * 
         * @param volumeType
         *        The volume type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * Indicates whether the volume was scanned or skipped.
         * </p>
         * 
         * @param volumeScanStatus
         *        Indicates whether the volume was scanned or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeScanStatus(String volumeScanStatus);
    }

    static final class BuilderImpl implements Builder {
        private String createTime;

        private String deviceName;

        private Boolean encrypted;

        private Integer size;

        private String snapshotId;

        private String status;

        private String kmsKeyId;

        private List<AwsEc2VolumeAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private String volumeId;

        private String volumeType;

        private String volumeScanStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VolumeDetails model) {
            createTime(model.createTime);
            deviceName(model.deviceName);
            encrypted(model.encrypted);
            size(model.size);
            snapshotId(model.snapshotId);
            status(model.status);
            kmsKeyId(model.kmsKeyId);
            attachments(model.attachments);
            volumeId(model.volumeId);
            volumeType(model.volumeType);
            volumeScanStatus(model.volumeScanStatus);
        }

        public final String getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<AwsEc2VolumeAttachment.Builder> getAttachments() {
            List<AwsEc2VolumeAttachment.Builder> result = AwsEc2VolumeAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AwsEc2VolumeAttachment.BuilderImpl> attachments) {
            this.attachments = AwsEc2VolumeAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<AwsEc2VolumeAttachment> attachments) {
            this.attachments = AwsEc2VolumeAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AwsEc2VolumeAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AwsEc2VolumeAttachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> AwsEc2VolumeAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final String getVolumeScanStatus() {
            return volumeScanStatus;
        }

        public final void setVolumeScanStatus(String volumeScanStatus) {
            this.volumeScanStatus = volumeScanStatus;
        }

        @Override
        public final Builder volumeScanStatus(String volumeScanStatus) {
            this.volumeScanStatus = volumeScanStatus;
            return this;
        }

        @Override
        public AwsEc2VolumeDetails build() {
            return new AwsEc2VolumeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
