/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * configures the CloudWatch Logs to publish for the Elasticsearch domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElasticsearchDomainLogPublishingOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElasticsearchDomainLogPublishingOptions.Builder, AwsElasticsearchDomainLogPublishingOptions> {
    private static final SdkField<AwsElasticsearchDomainLogPublishingOptionsLogConfig> INDEX_SLOW_LOGS_FIELD = SdkField
            .<AwsElasticsearchDomainLogPublishingOptionsLogConfig> builder(MarshallingType.SDK_POJO).memberName("IndexSlowLogs")
            .getter(getter(AwsElasticsearchDomainLogPublishingOptions::indexSlowLogs)).setter(setter(Builder::indexSlowLogs))
            .constructor(AwsElasticsearchDomainLogPublishingOptionsLogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexSlowLogs").build()).build();

    private static final SdkField<AwsElasticsearchDomainLogPublishingOptionsLogConfig> SEARCH_SLOW_LOGS_FIELD = SdkField
            .<AwsElasticsearchDomainLogPublishingOptionsLogConfig> builder(MarshallingType.SDK_POJO).memberName("SearchSlowLogs")
            .getter(getter(AwsElasticsearchDomainLogPublishingOptions::searchSlowLogs)).setter(setter(Builder::searchSlowLogs))
            .constructor(AwsElasticsearchDomainLogPublishingOptionsLogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchSlowLogs").build()).build();

    private static final SdkField<AwsElasticsearchDomainLogPublishingOptionsLogConfig> AUDIT_LOGS_FIELD = SdkField
            .<AwsElasticsearchDomainLogPublishingOptionsLogConfig> builder(MarshallingType.SDK_POJO).memberName("AuditLogs")
            .getter(getter(AwsElasticsearchDomainLogPublishingOptions::auditLogs)).setter(setter(Builder::auditLogs))
            .constructor(AwsElasticsearchDomainLogPublishingOptionsLogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_SLOW_LOGS_FIELD,
            SEARCH_SLOW_LOGS_FIELD, AUDIT_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsElasticsearchDomainLogPublishingOptionsLogConfig indexSlowLogs;

    private final AwsElasticsearchDomainLogPublishingOptionsLogConfig searchSlowLogs;

    private final AwsElasticsearchDomainLogPublishingOptionsLogConfig auditLogs;

    private AwsElasticsearchDomainLogPublishingOptions(BuilderImpl builder) {
        this.indexSlowLogs = builder.indexSlowLogs;
        this.searchSlowLogs = builder.searchSlowLogs;
        this.auditLogs = builder.auditLogs;
    }

    /**
     * <p>
     * Configures the OpenSearch index logs publishing.
     * </p>
     * 
     * @return Configures the OpenSearch index logs publishing.
     */
    public final AwsElasticsearchDomainLogPublishingOptionsLogConfig indexSlowLogs() {
        return indexSlowLogs;
    }

    /**
     * <p>
     * Configures the OpenSearch search slow log publishing.
     * </p>
     * 
     * @return Configures the OpenSearch search slow log publishing.
     */
    public final AwsElasticsearchDomainLogPublishingOptionsLogConfig searchSlowLogs() {
        return searchSlowLogs;
    }

    /**
     * Returns the value of the AuditLogs property for this object.
     * 
     * @return The value of the AuditLogs property for this object.
     */
    public final AwsElasticsearchDomainLogPublishingOptionsLogConfig auditLogs() {
        return auditLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexSlowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(searchSlowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(auditLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticsearchDomainLogPublishingOptions)) {
            return false;
        }
        AwsElasticsearchDomainLogPublishingOptions other = (AwsElasticsearchDomainLogPublishingOptions) obj;
        return Objects.equals(indexSlowLogs(), other.indexSlowLogs()) && Objects.equals(searchSlowLogs(), other.searchSlowLogs())
                && Objects.equals(auditLogs(), other.auditLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElasticsearchDomainLogPublishingOptions").add("IndexSlowLogs", indexSlowLogs())
                .add("SearchSlowLogs", searchSlowLogs()).add("AuditLogs", auditLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexSlowLogs":
            return Optional.ofNullable(clazz.cast(indexSlowLogs()));
        case "SearchSlowLogs":
            return Optional.ofNullable(clazz.cast(searchSlowLogs()));
        case "AuditLogs":
            return Optional.ofNullable(clazz.cast(auditLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticsearchDomainLogPublishingOptions, T> g) {
        return obj -> g.apply((AwsElasticsearchDomainLogPublishingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElasticsearchDomainLogPublishingOptions> {
        /**
         * <p>
         * Configures the OpenSearch index logs publishing.
         * </p>
         * 
         * @param indexSlowLogs
         *        Configures the OpenSearch index logs publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig indexSlowLogs);

        /**
         * <p>
         * Configures the OpenSearch index logs publishing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder} avoiding the need to create one manually
         * via {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #indexSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig)}.
         * 
         * @param indexSlowLogs
         *        a consumer that will call methods on
         *        {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig)
         */
        default Builder indexSlowLogs(Consumer<AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder> indexSlowLogs) {
            return indexSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig.builder().applyMutation(indexSlowLogs)
                    .build());
        }

        /**
         * <p>
         * Configures the OpenSearch search slow log publishing.
         * </p>
         * 
         * @param searchSlowLogs
         *        Configures the OpenSearch search slow log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig searchSlowLogs);

        /**
         * <p>
         * Configures the OpenSearch search slow log publishing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder} avoiding the need to create one manually
         * via {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #searchSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig)}.
         * 
         * @param searchSlowLogs
         *        a consumer that will call methods on
         *        {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig)
         */
        default Builder searchSlowLogs(Consumer<AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder> searchSlowLogs) {
            return searchSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig.builder().applyMutation(searchSlowLogs)
                    .build());
        }

        /**
         * Sets the value of the AuditLogs property for this object.
         *
         * @param auditLogs
         *        The new value for the AuditLogs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig auditLogs);

        /**
         * Sets the value of the AuditLogs property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder} avoiding the need to create one manually
         * via {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #auditLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig)}.
         * 
         * @param auditLogs
         *        a consumer that will call methods on
         *        {@link AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig)
         */
        default Builder auditLogs(Consumer<AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder> auditLogs) {
            return auditLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig.builder().applyMutation(auditLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsElasticsearchDomainLogPublishingOptionsLogConfig indexSlowLogs;

        private AwsElasticsearchDomainLogPublishingOptionsLogConfig searchSlowLogs;

        private AwsElasticsearchDomainLogPublishingOptionsLogConfig auditLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticsearchDomainLogPublishingOptions model) {
            indexSlowLogs(model.indexSlowLogs);
            searchSlowLogs(model.searchSlowLogs);
            auditLogs(model.auditLogs);
        }

        public final AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder getIndexSlowLogs() {
            return indexSlowLogs != null ? indexSlowLogs.toBuilder() : null;
        }

        public final void setIndexSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig.BuilderImpl indexSlowLogs) {
            this.indexSlowLogs = indexSlowLogs != null ? indexSlowLogs.build() : null;
        }

        @Override
        public final Builder indexSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig indexSlowLogs) {
            this.indexSlowLogs = indexSlowLogs;
            return this;
        }

        public final AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder getSearchSlowLogs() {
            return searchSlowLogs != null ? searchSlowLogs.toBuilder() : null;
        }

        public final void setSearchSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig.BuilderImpl searchSlowLogs) {
            this.searchSlowLogs = searchSlowLogs != null ? searchSlowLogs.build() : null;
        }

        @Override
        public final Builder searchSlowLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig searchSlowLogs) {
            this.searchSlowLogs = searchSlowLogs;
            return this;
        }

        public final AwsElasticsearchDomainLogPublishingOptionsLogConfig.Builder getAuditLogs() {
            return auditLogs != null ? auditLogs.toBuilder() : null;
        }

        public final void setAuditLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig.BuilderImpl auditLogs) {
            this.auditLogs = auditLogs != null ? auditLogs.build() : null;
        }

        @Override
        public final Builder auditLogs(AwsElasticsearchDomainLogPublishingOptionsLogConfig auditLogs) {
            this.auditLogs = auditLogs;
            return this;
        }

        @Override
        public AwsElasticsearchDomainLogPublishingOptions build() {
            return new AwsElasticsearchDomainLogPublishingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
