/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for a lifecycle rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketBucketLifecycleConfigurationRulesDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketBucketLifecycleConfigurationRulesDetails.Builder, AwsS3BucketBucketLifecycleConfigurationRulesDetails> {
    private static final SdkField<AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails> ABORT_INCOMPLETE_MULTIPART_UPLOAD_FIELD = SdkField
            .<AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AbortIncompleteMultipartUpload")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::abortIncompleteMultipartUpload))
            .setter(setter(Builder::abortIncompleteMultipartUpload))
            .constructor(AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortIncompleteMultipartUpload")
                    .build()).build();

    private static final SdkField<String> EXPIRATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationDate").getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final SdkField<Integer> EXPIRATION_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpirationInDays").getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::expirationInDays))
            .setter(setter(Builder::expirationInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationInDays").build()).build();

    private static final SdkField<Boolean> EXPIRED_OBJECT_DELETE_MARKER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ExpiredObjectDeleteMarker")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::expiredObjectDeleteMarker))
            .setter(setter(Builder::expiredObjectDeleteMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiredObjectDeleteMarker").build())
            .build();

    private static final SdkField<AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails> FILTER_FIELD = SdkField
            .<AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::filter)).setter(setter(Builder::filter))
            .constructor(AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ID")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ID").build()).build();

    private static final SdkField<Integer> NONCURRENT_VERSION_EXPIRATION_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NoncurrentVersionExpirationInDays")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::noncurrentVersionExpirationInDays))
            .setter(setter(Builder::noncurrentVersionExpirationInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoncurrentVersionExpirationInDays")
                    .build()).build();

    private static final SdkField<List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails>> NONCURRENT_VERSION_TRANSITIONS_FIELD = SdkField
            .<List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails>> builder(MarshallingType.LIST)
            .memberName("NoncurrentVersionTransitions")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::noncurrentVersionTransitions))
            .setter(setter(Builder::noncurrentVersionTransitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoncurrentVersionTransitions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(
                                                    AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails>> TRANSITIONS_FIELD = SdkField
            .<List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails>> builder(MarshallingType.LIST)
            .memberName("Transitions")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesDetails::transitions))
            .setter(setter(Builder::transitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ABORT_INCOMPLETE_MULTIPART_UPLOAD_FIELD, EXPIRATION_DATE_FIELD, EXPIRATION_IN_DAYS_FIELD,
            EXPIRED_OBJECT_DELETE_MARKER_FIELD, FILTER_FIELD, ID_FIELD, NONCURRENT_VERSION_EXPIRATION_IN_DAYS_FIELD,
            NONCURRENT_VERSION_TRANSITIONS_FIELD, PREFIX_FIELD, STATUS_FIELD, TRANSITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails abortIncompleteMultipartUpload;

    private final String expirationDate;

    private final Integer expirationInDays;

    private final Boolean expiredObjectDeleteMarker;

    private final AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails filter;

    private final String id;

    private final Integer noncurrentVersionExpirationInDays;

    private final List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> noncurrentVersionTransitions;

    private final String prefix;

    private final String status;

    private final List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails> transitions;

    private AwsS3BucketBucketLifecycleConfigurationRulesDetails(BuilderImpl builder) {
        this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
        this.expirationDate = builder.expirationDate;
        this.expirationInDays = builder.expirationInDays;
        this.expiredObjectDeleteMarker = builder.expiredObjectDeleteMarker;
        this.filter = builder.filter;
        this.id = builder.id;
        this.noncurrentVersionExpirationInDays = builder.noncurrentVersionExpirationInDays;
        this.noncurrentVersionTransitions = builder.noncurrentVersionTransitions;
        this.prefix = builder.prefix;
        this.status = builder.status;
        this.transitions = builder.transitions;
    }

    /**
     * <p>
     * How Amazon S3 responds when a multipart upload is incomplete. Specifically, provides a number of days before
     * Amazon S3 cancels the entire upload.
     * </p>
     * 
     * @return How Amazon S3 responds when a multipart upload is incomplete. Specifically, provides a number of days
     *         before Amazon S3 cancels the entire upload.
     */
    public final AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails abortIncompleteMultipartUpload() {
        return abortIncompleteMultipartUpload;
    }

    /**
     * <p>
     * The date when objects are moved or deleted.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The date when objects are moved or deleted.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * The length in days of the lifetime for objects that are subject to the rule.
     * </p>
     * 
     * @return The length in days of the lifetime for objects that are subject to the rule.
     */
    public final Integer expirationInDays() {
        return expirationInDays;
    }

    /**
     * <p>
     * Whether Amazon S3 removes a delete marker that has no noncurrent versions. If set to <code>true</code>, the
     * delete marker is expired. If set to <code>false</code>, the policy takes no action.
     * </p>
     * <p>
     * If you provide <code>ExpiredObjectDeleteMarker</code>, you cannot provide <code>ExpirationInDays</code> or
     * <code>ExpirationDate</code>.
     * </p>
     * 
     * @return Whether Amazon S3 removes a delete marker that has no noncurrent versions. If set to <code>true</code>,
     *         the delete marker is expired. If set to <code>false</code>, the policy takes no action.</p>
     *         <p>
     *         If you provide <code>ExpiredObjectDeleteMarker</code>, you cannot provide <code>ExpirationInDays</code>
     *         or <code>ExpirationDate</code>.
     */
    public final Boolean expiredObjectDeleteMarker() {
        return expiredObjectDeleteMarker;
    }

    /**
     * <p>
     * Identifies the objects that a rule applies to.
     * </p>
     * 
     * @return Identifies the objects that a rule applies to.
     */
    public final AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails filter() {
        return filter;
    }

    /**
     * <p>
     * The unique identifier of the rule.
     * </p>
     * 
     * @return The unique identifier of the rule.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
     * </p>
     * 
     * @return The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
     */
    public final Integer noncurrentVersionExpirationInDays() {
        return noncurrentVersionExpirationInDays;
    }

    /**
     * For responses, this returns true if the service returned a value for the NoncurrentVersionTransitions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNoncurrentVersionTransitions() {
        return noncurrentVersionTransitions != null && !(noncurrentVersionTransitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Transition rules that describe when noncurrent objects transition to a specified storage class.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNoncurrentVersionTransitions} method.
     * </p>
     * 
     * @return Transition rules that describe when noncurrent objects transition to a specified storage class.
     */
    public final List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> noncurrentVersionTransitions() {
        return noncurrentVersionTransitions;
    }

    /**
     * <p>
     * A prefix that identifies one or more objects that the rule applies to.
     * </p>
     * 
     * @return A prefix that identifies one or more objects that the rule applies to.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The current status of the rule. Indicates whether the rule is currently being applied.
     * </p>
     * 
     * @return The current status of the rule. Indicates whether the rule is currently being applied.
     */
    public final String status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Transitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransitions() {
        return transitions != null && !(transitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Transition rules that indicate when objects transition to a specified storage class.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransitions} method.
     * </p>
     * 
     * @return Transition rules that indicate when objects transition to a specified storage class.
     */
    public final List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails> transitions() {
        return transitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(abortIncompleteMultipartUpload());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(expiredObjectDeleteMarker());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(noncurrentVersionExpirationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(hasNoncurrentVersionTransitions() ? noncurrentVersionTransitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitions() ? transitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketBucketLifecycleConfigurationRulesDetails)) {
            return false;
        }
        AwsS3BucketBucketLifecycleConfigurationRulesDetails other = (AwsS3BucketBucketLifecycleConfigurationRulesDetails) obj;
        return Objects.equals(abortIncompleteMultipartUpload(), other.abortIncompleteMultipartUpload())
                && Objects.equals(expirationDate(), other.expirationDate())
                && Objects.equals(expirationInDays(), other.expirationInDays())
                && Objects.equals(expiredObjectDeleteMarker(), other.expiredObjectDeleteMarker())
                && Objects.equals(filter(), other.filter()) && Objects.equals(id(), other.id())
                && Objects.equals(noncurrentVersionExpirationInDays(), other.noncurrentVersionExpirationInDays())
                && hasNoncurrentVersionTransitions() == other.hasNoncurrentVersionTransitions()
                && Objects.equals(noncurrentVersionTransitions(), other.noncurrentVersionTransitions())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(status(), other.status())
                && hasTransitions() == other.hasTransitions() && Objects.equals(transitions(), other.transitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketBucketLifecycleConfigurationRulesDetails")
                .add("AbortIncompleteMultipartUpload", abortIncompleteMultipartUpload()).add("ExpirationDate", expirationDate())
                .add("ExpirationInDays", expirationInDays()).add("ExpiredObjectDeleteMarker", expiredObjectDeleteMarker())
                .add("Filter", filter()).add("ID", id())
                .add("NoncurrentVersionExpirationInDays", noncurrentVersionExpirationInDays())
                .add("NoncurrentVersionTransitions", hasNoncurrentVersionTransitions() ? noncurrentVersionTransitions() : null)
                .add("Prefix", prefix()).add("Status", status()).add("Transitions", hasTransitions() ? transitions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbortIncompleteMultipartUpload":
            return Optional.ofNullable(clazz.cast(abortIncompleteMultipartUpload()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "ExpirationInDays":
            return Optional.ofNullable(clazz.cast(expirationInDays()));
        case "ExpiredObjectDeleteMarker":
            return Optional.ofNullable(clazz.cast(expiredObjectDeleteMarker()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "ID":
            return Optional.ofNullable(clazz.cast(id()));
        case "NoncurrentVersionExpirationInDays":
            return Optional.ofNullable(clazz.cast(noncurrentVersionExpirationInDays()));
        case "NoncurrentVersionTransitions":
            return Optional.ofNullable(clazz.cast(noncurrentVersionTransitions()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Transitions":
            return Optional.ofNullable(clazz.cast(transitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketBucketLifecycleConfigurationRulesDetails, T> g) {
        return obj -> g.apply((AwsS3BucketBucketLifecycleConfigurationRulesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketBucketLifecycleConfigurationRulesDetails> {
        /**
         * <p>
         * How Amazon S3 responds when a multipart upload is incomplete. Specifically, provides a number of days before
         * Amazon S3 cancels the entire upload.
         * </p>
         * 
         * @param abortIncompleteMultipartUpload
         *        How Amazon S3 responds when a multipart upload is incomplete. Specifically, provides a number of days
         *        before Amazon S3 cancels the entire upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortIncompleteMultipartUpload(
                AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails abortIncompleteMultipartUpload);

        /**
         * <p>
         * How Amazon S3 responds when a multipart upload is incomplete. Specifically, provides a number of days before
         * Amazon S3 cancels the entire upload.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.Builder} avoiding
         * the need to create one manually via
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #abortIncompleteMultipartUpload(AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails)}.
         * 
         * @param abortIncompleteMultipartUpload
         *        a consumer that will call methods on
         *        {@link AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortIncompleteMultipartUpload(AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails)
         */
        default Builder abortIncompleteMultipartUpload(
                Consumer<AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.Builder> abortIncompleteMultipartUpload) {
            return abortIncompleteMultipartUpload(AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
                    .builder().applyMutation(abortIncompleteMultipartUpload).build());
        }

        /**
         * <p>
         * The date when objects are moved or deleted.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param expirationDate
         *        The date when objects are moved or deleted.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(String expirationDate);

        /**
         * <p>
         * The length in days of the lifetime for objects that are subject to the rule.
         * </p>
         * 
         * @param expirationInDays
         *        The length in days of the lifetime for objects that are subject to the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationInDays(Integer expirationInDays);

        /**
         * <p>
         * Whether Amazon S3 removes a delete marker that has no noncurrent versions. If set to <code>true</code>, the
         * delete marker is expired. If set to <code>false</code>, the policy takes no action.
         * </p>
         * <p>
         * If you provide <code>ExpiredObjectDeleteMarker</code>, you cannot provide <code>ExpirationInDays</code> or
         * <code>ExpirationDate</code>.
         * </p>
         * 
         * @param expiredObjectDeleteMarker
         *        Whether Amazon S3 removes a delete marker that has no noncurrent versions. If set to <code>true</code>
         *        , the delete marker is expired. If set to <code>false</code>, the policy takes no action.</p>
         *        <p>
         *        If you provide <code>ExpiredObjectDeleteMarker</code>, you cannot provide
         *        <code>ExpirationInDays</code> or <code>ExpirationDate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker);

        /**
         * <p>
         * Identifies the objects that a rule applies to.
         * </p>
         * 
         * @param filter
         *        Identifies the objects that a rule applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails filter);

        /**
         * <p>
         * Identifies the objects that a rule applies to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.Builder} avoiding the need to create one
         * manually via {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails)}.
         * 
         * @param filter
         *        a consumer that will call methods on
         *        {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails)
         */
        default Builder filter(Consumer<AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.Builder> filter) {
            return filter(AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The unique identifier of the rule.
         * </p>
         * 
         * @param id
         *        The unique identifier of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
         * </p>
         * 
         * @param noncurrentVersionExpirationInDays
         *        The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionExpirationInDays(Integer noncurrentVersionExpirationInDays);

        /**
         * <p>
         * Transition rules that describe when noncurrent objects transition to a specified storage class.
         * </p>
         * 
         * @param noncurrentVersionTransitions
         *        Transition rules that describe when noncurrent objects transition to a specified storage class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionTransitions(
                Collection<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> noncurrentVersionTransitions);

        /**
         * <p>
         * Transition rules that describe when noncurrent objects transition to a specified storage class.
         * </p>
         * 
         * @param noncurrentVersionTransitions
         *        Transition rules that describe when noncurrent objects transition to a specified storage class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionTransitions(
                AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails... noncurrentVersionTransitions);

        /**
         * <p>
         * Transition rules that describe when noncurrent objects transition to a specified storage class.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link #noncurrentVersionTransitions(List<
         * AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails>)}.
         * 
         * @param noncurrentVersionTransitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noncurrentVersionTransitions(java.util.Collection<
         *      AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails>)
         */
        Builder noncurrentVersionTransitions(
                Consumer<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder>... noncurrentVersionTransitions);

        /**
         * <p>
         * A prefix that identifies one or more objects that the rule applies to.
         * </p>
         * 
         * @param prefix
         *        A prefix that identifies one or more objects that the rule applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The current status of the rule. Indicates whether the rule is currently being applied.
         * </p>
         * 
         * @param status
         *        The current status of the rule. Indicates whether the rule is currently being applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Transition rules that indicate when objects transition to a specified storage class.
         * </p>
         * 
         * @param transitions
         *        Transition rules that indicate when objects transition to a specified storage class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(Collection<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails> transitions);

        /**
         * <p>
         * Transition rules that indicate when objects transition to a specified storage class.
         * </p>
         * 
         * @param transitions
         *        Transition rules that indicate when objects transition to a specified storage class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails... transitions);

        /**
         * <p>
         * Transition rules that indicate when objects transition to a specified storage class.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #transitions(List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails>)}.
         * 
         * @param transitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitions(java.util.Collection<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails>)
         */
        Builder transitions(Consumer<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.Builder>... transitions);
    }

    static final class BuilderImpl implements Builder {
        private AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails abortIncompleteMultipartUpload;

        private String expirationDate;

        private Integer expirationInDays;

        private Boolean expiredObjectDeleteMarker;

        private AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails filter;

        private String id;

        private Integer noncurrentVersionExpirationInDays;

        private List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> noncurrentVersionTransitions = DefaultSdkAutoConstructList
                .getInstance();

        private String prefix;

        private String status;

        private List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails> transitions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketBucketLifecycleConfigurationRulesDetails model) {
            abortIncompleteMultipartUpload(model.abortIncompleteMultipartUpload);
            expirationDate(model.expirationDate);
            expirationInDays(model.expirationInDays);
            expiredObjectDeleteMarker(model.expiredObjectDeleteMarker);
            filter(model.filter);
            id(model.id);
            noncurrentVersionExpirationInDays(model.noncurrentVersionExpirationInDays);
            noncurrentVersionTransitions(model.noncurrentVersionTransitions);
            prefix(model.prefix);
            status(model.status);
            transitions(model.transitions);
        }

        public final AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.Builder getAbortIncompleteMultipartUpload() {
            return abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.toBuilder() : null;
        }

        public final void setAbortIncompleteMultipartUpload(
                AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.BuilderImpl abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.build()
                    : null;
        }

        @Override
        public final Builder abortIncompleteMultipartUpload(
                AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
            return this;
        }

        public final String getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final Integer getExpirationInDays() {
            return expirationInDays;
        }

        public final void setExpirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
        }

        @Override
        public final Builder expirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
            return this;
        }

        public final Boolean getExpiredObjectDeleteMarker() {
            return expiredObjectDeleteMarker;
        }

        public final void setExpiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker) {
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
        }

        @Override
        public final Builder expiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker) {
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
            return this;
        }

        public final AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails filter) {
            this.filter = filter;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getNoncurrentVersionExpirationInDays() {
            return noncurrentVersionExpirationInDays;
        }

        public final void setNoncurrentVersionExpirationInDays(Integer noncurrentVersionExpirationInDays) {
            this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
        }

        @Override
        public final Builder noncurrentVersionExpirationInDays(Integer noncurrentVersionExpirationInDays) {
            this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
            return this;
        }

        public final List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder> getNoncurrentVersionTransitions() {
            List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder> result = AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListCopier
                    .copyToBuilder(this.noncurrentVersionTransitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNoncurrentVersionTransitions(
                Collection<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.BuilderImpl> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListCopier
                    .copyFromBuilder(noncurrentVersionTransitions);
        }

        @Override
        public final Builder noncurrentVersionTransitions(
                Collection<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListCopier
                    .copy(noncurrentVersionTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noncurrentVersionTransitions(
                AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails... noncurrentVersionTransitions) {
            noncurrentVersionTransitions(Arrays.asList(noncurrentVersionTransitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noncurrentVersionTransitions(
                Consumer<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder>... noncurrentVersionTransitions) {
            noncurrentVersionTransitions(Stream
                    .of(noncurrentVersionTransitions)
                    .map(c -> AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.builder()
                            .applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.Builder> getTransitions() {
            List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.Builder> result = AwsS3BucketBucketLifecycleConfigurationRulesTransitionsListCopier
                    .copyToBuilder(this.transitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitions(
                Collection<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.BuilderImpl> transitions) {
            this.transitions = AwsS3BucketBucketLifecycleConfigurationRulesTransitionsListCopier.copyFromBuilder(transitions);
        }

        @Override
        public final Builder transitions(Collection<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails> transitions) {
            this.transitions = AwsS3BucketBucketLifecycleConfigurationRulesTransitionsListCopier.copy(transitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails... transitions) {
            transitions(Arrays.asList(transitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(
                Consumer<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.Builder>... transitions) {
            transitions(Stream.of(transitions)
                    .map(c -> AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsS3BucketBucketLifecycleConfigurationRulesDetails build() {
            return new AwsS3BucketBucketLifecycleConfigurationRulesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
