/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a consistent format for Security Hub findings. <code>AwsSecurityFinding</code> format allows you to share
 * findings between Amazon Web Services security services and third-party solutions.
 * </p>
 * <note>
 * <p>
 * A finding is a potential security issue generated either by Amazon Web Services services or by the integrated
 * third-party solutions and standards checks.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSecurityFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSecurityFinding.Builder, AwsSecurityFinding> {
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersion").getter(getter(AwsSecurityFinding::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsSecurityFinding::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductArn").getter(getter(AwsSecurityFinding::productArn)).setter(setter(Builder::productArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductName").getter(getter(AwsSecurityFinding::productName)).setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompanyName").getter(getter(AwsSecurityFinding::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(AwsSecurityFinding::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> GENERATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratorId").getter(getter(AwsSecurityFinding::generatorId)).setter(setter(Builder::generatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratorId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(AwsSecurityFinding::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Types")
            .getter(getter(AwsSecurityFinding::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FIRST_OBSERVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstObservedAt").getter(getter(AwsSecurityFinding::firstObservedAt))
            .setter(setter(Builder::firstObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstObservedAt").build()).build();

    private static final SdkField<String> LAST_OBSERVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastObservedAt").getter(getter(AwsSecurityFinding::lastObservedAt))
            .setter(setter(Builder::lastObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastObservedAt").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(AwsSecurityFinding::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedAt").getter(getter(AwsSecurityFinding::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<Severity> SEVERITY_FIELD = SdkField.<Severity> builder(MarshallingType.SDK_POJO)
            .memberName("Severity").getter(getter(AwsSecurityFinding::severity)).setter(setter(Builder::severity))
            .constructor(Severity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Confidence").getter(getter(AwsSecurityFinding::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Criticality").getter(getter(AwsSecurityFinding::criticality)).setter(setter(Builder::criticality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(AwsSecurityFinding::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsSecurityFinding::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.<Remediation> builder(MarshallingType.SDK_POJO)
            .memberName("Remediation").getter(getter(AwsSecurityFinding::remediation)).setter(setter(Builder::remediation))
            .constructor(Remediation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remediation").build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceUrl").getter(getter(AwsSecurityFinding::sourceUrl)).setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build()).build();

    private static final SdkField<Map<String, String>> PRODUCT_FIELDS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ProductFields")
            .getter(getter(AwsSecurityFinding::productFields))
            .setter(setter(Builder::productFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductFields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> USER_DEFINED_FIELDS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("UserDefinedFields")
            .getter(getter(AwsSecurityFinding::userDefinedFields))
            .setter(setter(Builder::userDefinedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Malware>> MALWARE_FIELD = SdkField
            .<List<Malware>> builder(MarshallingType.LIST)
            .memberName("Malware")
            .getter(getter(AwsSecurityFinding::malware))
            .setter(setter(Builder::malware))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Malware").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Malware> builder(MarshallingType.SDK_POJO)
                                            .constructor(Malware::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Network> NETWORK_FIELD = SdkField.<Network> builder(MarshallingType.SDK_POJO)
            .memberName("Network").getter(getter(AwsSecurityFinding::network)).setter(setter(Builder::network))
            .constructor(Network::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Network").build()).build();

    private static final SdkField<List<NetworkPathComponent>> NETWORK_PATH_FIELD = SdkField
            .<List<NetworkPathComponent>> builder(MarshallingType.LIST)
            .memberName("NetworkPath")
            .getter(getter(AwsSecurityFinding::networkPath))
            .setter(setter(Builder::networkPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkPathComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkPathComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProcessDetails> PROCESS_FIELD = SdkField.<ProcessDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Process").getter(getter(AwsSecurityFinding::process)).setter(setter(Builder::process))
            .constructor(ProcessDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Process").build()).build();

    private static final SdkField<List<Threat>> THREATS_FIELD = SdkField
            .<List<Threat>> builder(MarshallingType.LIST)
            .memberName("Threats")
            .getter(getter(AwsSecurityFinding::threats))
            .setter(setter(Builder::threats))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Threat> builder(MarshallingType.SDK_POJO)
                                            .constructor(Threat::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ThreatIntelIndicator>> THREAT_INTEL_INDICATORS_FIELD = SdkField
            .<List<ThreatIntelIndicator>> builder(MarshallingType.LIST)
            .memberName("ThreatIntelIndicators")
            .getter(getter(AwsSecurityFinding::threatIntelIndicators))
            .setter(setter(Builder::threatIntelIndicators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreatIntelIndicators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThreatIntelIndicator> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThreatIntelIndicator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(AwsSecurityFinding::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Compliance> COMPLIANCE_FIELD = SdkField.<Compliance> builder(MarshallingType.SDK_POJO)
            .memberName("Compliance").getter(getter(AwsSecurityFinding::compliance)).setter(setter(Builder::compliance))
            .constructor(Compliance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compliance").build()).build();

    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationState").getter(getter(AwsSecurityFinding::verificationStateAsString))
            .setter(setter(Builder::verificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationState").build()).build();

    private static final SdkField<String> WORKFLOW_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowState").getter(getter(AwsSecurityFinding::workflowStateAsString))
            .setter(setter(Builder::workflowState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowState").build()).build();

    private static final SdkField<Workflow> WORKFLOW_FIELD = SdkField.<Workflow> builder(MarshallingType.SDK_POJO)
            .memberName("Workflow").getter(getter(AwsSecurityFinding::workflow)).setter(setter(Builder::workflow))
            .constructor(Workflow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflow").build()).build();

    private static final SdkField<String> RECORD_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordState").getter(getter(AwsSecurityFinding::recordStateAsString))
            .setter(setter(Builder::recordState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordState").build()).build();

    private static final SdkField<List<RelatedFinding>> RELATED_FINDINGS_FIELD = SdkField
            .<List<RelatedFinding>> builder(MarshallingType.LIST)
            .memberName("RelatedFindings")
            .getter(getter(AwsSecurityFinding::relatedFindings))
            .setter(setter(Builder::relatedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelatedFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelatedFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Note> NOTE_FIELD = SdkField.<Note> builder(MarshallingType.SDK_POJO).memberName("Note")
            .getter(getter(AwsSecurityFinding::note)).setter(setter(Builder::note)).constructor(Note::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()).build();

    private static final SdkField<List<Vulnerability>> VULNERABILITIES_FIELD = SdkField
            .<List<Vulnerability>> builder(MarshallingType.LIST)
            .memberName("Vulnerabilities")
            .getter(getter(AwsSecurityFinding::vulnerabilities))
            .setter(setter(Builder::vulnerabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vulnerabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Vulnerability> builder(MarshallingType.SDK_POJO)
                                            .constructor(Vulnerability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PatchSummary> PATCH_SUMMARY_FIELD = SdkField.<PatchSummary> builder(MarshallingType.SDK_POJO)
            .memberName("PatchSummary").getter(getter(AwsSecurityFinding::patchSummary)).setter(setter(Builder::patchSummary))
            .constructor(PatchSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchSummary").build()).build();

    private static final SdkField<Action> ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(AwsSecurityFinding::action)).setter(setter(Builder::action)).constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<FindingProviderFields> FINDING_PROVIDER_FIELDS_FIELD = SdkField
            .<FindingProviderFields> builder(MarshallingType.SDK_POJO).memberName("FindingProviderFields")
            .getter(getter(AwsSecurityFinding::findingProviderFields)).setter(setter(Builder::findingProviderFields))
            .constructor(FindingProviderFields::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingProviderFields").build())
            .build();

    private static final SdkField<Boolean> SAMPLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Sample").getter(getter(AwsSecurityFinding::sample)).setter(setter(Builder::sample))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sample").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD,
            ID_FIELD, PRODUCT_ARN_FIELD, PRODUCT_NAME_FIELD, COMPANY_NAME_FIELD, REGION_FIELD, GENERATOR_ID_FIELD,
            AWS_ACCOUNT_ID_FIELD, TYPES_FIELD, FIRST_OBSERVED_AT_FIELD, LAST_OBSERVED_AT_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, SEVERITY_FIELD, CONFIDENCE_FIELD, CRITICALITY_FIELD, TITLE_FIELD, DESCRIPTION_FIELD,
            REMEDIATION_FIELD, SOURCE_URL_FIELD, PRODUCT_FIELDS_FIELD, USER_DEFINED_FIELDS_FIELD, MALWARE_FIELD, NETWORK_FIELD,
            NETWORK_PATH_FIELD, PROCESS_FIELD, THREATS_FIELD, THREAT_INTEL_INDICATORS_FIELD, RESOURCES_FIELD, COMPLIANCE_FIELD,
            VERIFICATION_STATE_FIELD, WORKFLOW_STATE_FIELD, WORKFLOW_FIELD, RECORD_STATE_FIELD, RELATED_FINDINGS_FIELD,
            NOTE_FIELD, VULNERABILITIES_FIELD, PATCH_SUMMARY_FIELD, ACTION_FIELD, FINDING_PROVIDER_FIELDS_FIELD, SAMPLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String schemaVersion;

    private final String id;

    private final String productArn;

    private final String productName;

    private final String companyName;

    private final String region;

    private final String generatorId;

    private final String awsAccountId;

    private final List<String> types;

    private final String firstObservedAt;

    private final String lastObservedAt;

    private final String createdAt;

    private final String updatedAt;

    private final Severity severity;

    private final Integer confidence;

    private final Integer criticality;

    private final String title;

    private final String description;

    private final Remediation remediation;

    private final String sourceUrl;

    private final Map<String, String> productFields;

    private final Map<String, String> userDefinedFields;

    private final List<Malware> malware;

    private final Network network;

    private final List<NetworkPathComponent> networkPath;

    private final ProcessDetails process;

    private final List<Threat> threats;

    private final List<ThreatIntelIndicator> threatIntelIndicators;

    private final List<Resource> resources;

    private final Compliance compliance;

    private final String verificationState;

    private final String workflowState;

    private final Workflow workflow;

    private final String recordState;

    private final List<RelatedFinding> relatedFindings;

    private final Note note;

    private final List<Vulnerability> vulnerabilities;

    private final PatchSummary patchSummary;

    private final Action action;

    private final FindingProviderFields findingProviderFields;

    private final Boolean sample;

    private AwsSecurityFinding(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.id = builder.id;
        this.productArn = builder.productArn;
        this.productName = builder.productName;
        this.companyName = builder.companyName;
        this.region = builder.region;
        this.generatorId = builder.generatorId;
        this.awsAccountId = builder.awsAccountId;
        this.types = builder.types;
        this.firstObservedAt = builder.firstObservedAt;
        this.lastObservedAt = builder.lastObservedAt;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.severity = builder.severity;
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.title = builder.title;
        this.description = builder.description;
        this.remediation = builder.remediation;
        this.sourceUrl = builder.sourceUrl;
        this.productFields = builder.productFields;
        this.userDefinedFields = builder.userDefinedFields;
        this.malware = builder.malware;
        this.network = builder.network;
        this.networkPath = builder.networkPath;
        this.process = builder.process;
        this.threats = builder.threats;
        this.threatIntelIndicators = builder.threatIntelIndicators;
        this.resources = builder.resources;
        this.compliance = builder.compliance;
        this.verificationState = builder.verificationState;
        this.workflowState = builder.workflowState;
        this.workflow = builder.workflow;
        this.recordState = builder.recordState;
        this.relatedFindings = builder.relatedFindings;
        this.note = builder.note;
        this.vulnerabilities = builder.vulnerabilities;
        this.patchSummary = builder.patchSummary;
        this.action = builder.action;
        this.findingProviderFields = builder.findingProviderFields;
        this.sample = builder.sample;
    }

    /**
     * <p>
     * The schema version that a finding is formatted for.
     * </p>
     * 
     * @return The schema version that a finding is formatted for.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * 
     * @return The security findings provider-specific identifier for a finding.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN
     * for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
     * </p>
     * 
     * @return The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be
     *         the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom
     *         integration.
     */
    public final String productArn() {
        return productArn;
    }

    /**
     * <p>
     * The name of the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     * </p>
     * 
     * @return The name of the product that generated the finding.</p>
     *         <p>
     *         Security Hub populates this attribute automatically for each finding. You cannot update this attribute
     *         with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
     *         custom integration.
     *         </p>
     *         <p>
     *         When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * The name of the company for the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     * </p>
     * 
     * @return The name of the company for the product that generated the finding.</p>
     *         <p>
     *         Security Hub populates this attribute automatically for each finding. You cannot update this attribute
     *         with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
     *         custom integration.
     *         </p>
     *         <p>
     *         When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * The Region from which the finding was generated.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update it using
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
     * </p>
     * 
     * @return The Region from which the finding was generated.</p>
     *         <p>
     *         Security Hub populates this attribute automatically for each finding. You cannot update it using
     *         <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plugin, etc.
     * </p>
     * 
     * @return The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
     *         In various security-findings providers' solutions, this generator can be called a rule, a check, a
     *         detector, a plugin, etc.
     */
    public final String generatorId() {
        return generatorId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that a finding is generated in.
     * </p>
     * 
     * @return The Amazon Web Services account ID that a finding is generated in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.
     * </p>
     * <p>
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive
     * Data Identifications
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
     *         finding.</p>
     *         <p>
     *         Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
     *         Sensitive Data Identifications
     */
    public final List<String> types() {
        return types;
    }

    /**
     * <p>
     * Indicates when the security-findings provider first observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the security-findings provider first observed the potential security issue that a finding
     *         captured.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String firstObservedAt() {
        return firstObservedAt;
    }

    /**
     * <p>
     * Indicates when the security-findings provider most recently observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the security-findings provider most recently observed the potential security issue that a
     *         finding captured.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String lastObservedAt() {
        return lastObservedAt;
    }

    /**
     * <p>
     * Indicates when the security-findings provider created the potential security issue that a finding captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the security-findings provider created the potential security issue that a finding
     *         captured.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Indicates when the security-findings provider last updated the finding record.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the security-findings provider last updated the finding record.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * A finding's severity.
     * </p>
     * 
     * @return A finding's severity.
     */
    public final Severity severity() {
        return severity;
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify.
     * </p>
     * <p>
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means
     * 100 percent confidence.
     * </p>
     * 
     * @return A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *         behavior or issue that it was intended to identify.</p>
     *         <p>
     *         Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100
     *         means 100 percent confidence.
     */
    public final Integer confidence() {
        return confidence;
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding.
     * </p>
     * <p>
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most
     * critical resources.
     * </p>
     * 
     * @return The level of importance assigned to the resources associated with the finding.</p>
     *         <p>
     *         A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for
     *         the most critical resources.
     */
    public final Integer criticality() {
        return criticality;
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Title</code> is a required property.
     * </p>
     * </note>
     * 
     * @return A finding's title.</p> <note>
     *         <p>
     *         In this release, <code>Title</code> is a required property.
     *         </p>
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Description</code> is a required property.
     * </p>
     * </note>
     * 
     * @return A finding's description.</p> <note>
     *         <p>
     *         In this release, <code>Description</code> is a required property.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A data type that describes the remediation options for a finding.
     * </p>
     * 
     * @return A data type that describes the remediation options for a finding.
     */
    public final Remediation remediation() {
        return remediation;
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     * </p>
     * 
     * @return A URL that links to a page about the current finding in the security-findings provider's solution.
     */
    public final String sourceUrl() {
        return sourceUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductFields() {
        return productFields != null && !(productFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A data type where security-findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * <p>
     * Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the
     * value can contain up to 2048 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductFields} method.
     * </p>
     * 
     * @return A data type where security-findings providers can include additional solution-specific details that
     *         aren't part of the defined <code>AwsSecurityFinding</code> format.</p>
     *         <p>
     *         Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters,
     *         and the value can contain up to 2048 characters.
     */
    public final Map<String, String> productFields() {
        return productFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserDefinedFields property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserDefinedFields() {
        return userDefinedFields != null && !(userDefinedFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserDefinedFields} method.
     * </p>
     * 
     * @return A list of name/value string pairs associated with the finding. These are custom, user-defined fields
     *         added to a finding.
     */
    public final Map<String, String> userDefinedFields() {
        return userDefinedFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Malware property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMalware() {
        return malware != null && !(malware instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of malware related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMalware} method.
     * </p>
     * 
     * @return A list of malware related to a finding.
     */
    public final List<Malware> malware() {
        return malware;
    }

    /**
     * <p>
     * The details of network-related information about a finding.
     * </p>
     * 
     * @return The details of network-related information about a finding.
     */
    public final Network network() {
        return network;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkPath property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkPath() {
        return networkPath != null && !(networkPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about a network path that is relevant to a finding. Each entry under
     * <code>NetworkPath</code> represents a component of that path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkPath} method.
     * </p>
     * 
     * @return Provides information about a network path that is relevant to a finding. Each entry under
     *         <code>NetworkPath</code> represents a component of that path.
     */
    public final List<NetworkPathComponent> networkPath() {
        return networkPath;
    }

    /**
     * <p>
     * The details of process-related information about a finding.
     * </p>
     * 
     * @return The details of process-related information about a finding.
     */
    public final ProcessDetails process() {
        return process;
    }

    /**
     * For responses, this returns true if the service returned a value for the Threats property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasThreats() {
        return threats != null && !(threats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the threat detected in a security finding and the file paths that were affected by the threat.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThreats} method.
     * </p>
     * 
     * @return Details about the threat detected in a security finding and the file paths that were affected by the
     *         threat.
     */
    public final List<Threat> threats() {
        return threats;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThreatIntelIndicators property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasThreatIntelIndicators() {
        return threatIntelIndicators != null && !(threatIntelIndicators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Threat intelligence details related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThreatIntelIndicators} method.
     * </p>
     * 
     * @return Threat intelligence details related to a finding.
     */
    public final List<ThreatIntelIndicator> threatIntelIndicators() {
        return threatIntelIndicators;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of resource data types that describe the resources that the finding refers to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return A set of resource data types that describe the resources that the finding refers to.
     */
    public final List<Resource> resources() {
        return resources;
    }

    /**
     * <p>
     * This data type is exclusive to findings that are generated as the result of a check run against a specific rule
     * in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security standard-related
     * finding details.
     * </p>
     * 
     * @return This data type is exclusive to findings that are generated as the result of a check run against a
     *         specific rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains
     *         security standard-related finding details.
     */
    public final Compliance compliance() {
        return compliance;
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return Indicates the veracity of a finding.
     * @see VerificationState
     */
    public final VerificationState verificationState() {
        return VerificationState.fromValue(verificationState);
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return Indicates the veracity of a finding.
     * @see VerificationState
     */
    public final String verificationStateAsString() {
        return verificationState;
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowState}
     * will return {@link WorkflowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowStateAsString}.
     * </p>
     * 
     * @return The workflow state of a finding.
     * @see WorkflowState
     */
    public final WorkflowState workflowState() {
        return WorkflowState.fromValue(workflowState);
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowState}
     * will return {@link WorkflowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowStateAsString}.
     * </p>
     * 
     * @return The workflow state of a finding.
     * @see WorkflowState
     */
    public final String workflowStateAsString() {
        return workflowState;
    }

    /**
     * <p>
     * Provides information about the status of the investigation into a finding.
     * </p>
     * 
     * @return Provides information about the status of the investigation into a finding.
     */
    public final Workflow workflow() {
        return workflow;
    }

    /**
     * <p>
     * The record state of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordState} will
     * return {@link RecordState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordStateAsString}.
     * </p>
     * 
     * @return The record state of a finding.
     * @see RecordState
     */
    public final RecordState recordState() {
        return RecordState.fromValue(recordState);
    }

    /**
     * <p>
     * The record state of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordState} will
     * return {@link RecordState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordStateAsString}.
     * </p>
     * 
     * @return The record state of a finding.
     * @see RecordState
     */
    public final String recordStateAsString() {
        return recordState;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedFindings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRelatedFindings() {
        return relatedFindings != null && !(relatedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of related findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedFindings} method.
     * </p>
     * 
     * @return A list of related findings.
     */
    public final List<RelatedFinding> relatedFindings() {
        return relatedFindings;
    }

    /**
     * <p>
     * A user-defined note added to a finding.
     * </p>
     * 
     * @return A user-defined note added to a finding.
     */
    public final Note note() {
        return note;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vulnerabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVulnerabilities() {
        return vulnerabilities != null && !(vulnerabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of vulnerabilities associated with the findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVulnerabilities} method.
     * </p>
     * 
     * @return Provides a list of vulnerabilities associated with the findings.
     */
    public final List<Vulnerability> vulnerabilities() {
        return vulnerabilities;
    }

    /**
     * <p>
     * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
     * </p>
     * 
     * @return Provides an overview of the patch compliance status for an instance against a selected compliance
     *         standard.
     */
    public final PatchSummary patchSummary() {
        return patchSummary;
    }

    /**
     * <p>
     * Provides details about an action that affects or that was taken on a resource.
     * </p>
     * 
     * @return Provides details about an action that affects or that was taken on a resource.
     */
    public final Action action() {
        return action;
    }

    /**
     * <p>
     * In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to
     * provide and update their own values for confidence, criticality, related findings, severity, and types.
     * </p>
     * 
     * @return In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code>
     *         to provide and update their own values for confidence, criticality, related findings, severity, and
     *         types.
     */
    public final FindingProviderFields findingProviderFields() {
        return findingProviderFields;
    }

    /**
     * <p>
     * Indicates whether the finding is a sample finding.
     * </p>
     * 
     * @return Indicates whether the finding is a sample finding.
     */
    public final Boolean sample() {
        return sample;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(productArn());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(generatorId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(criticality());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductFields() ? productFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserDefinedFields() ? userDefinedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMalware() ? malware() : null);
        hashCode = 31 * hashCode + Objects.hashCode(network());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkPath() ? networkPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(process());
        hashCode = 31 * hashCode + Objects.hashCode(hasThreats() ? threats() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThreatIntelIndicators() ? threatIntelIndicators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(compliance());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflow());
        hashCode = 31 * hashCode + Objects.hashCode(recordStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedFindings() ? relatedFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(note());
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerabilities() ? vulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(patchSummary());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(findingProviderFields());
        hashCode = 31 * hashCode + Objects.hashCode(sample());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSecurityFinding)) {
            return false;
        }
        AwsSecurityFinding other = (AwsSecurityFinding) obj;
        return Objects.equals(schemaVersion(), other.schemaVersion()) && Objects.equals(id(), other.id())
                && Objects.equals(productArn(), other.productArn()) && Objects.equals(productName(), other.productName())
                && Objects.equals(companyName(), other.companyName()) && Objects.equals(region(), other.region())
                && Objects.equals(generatorId(), other.generatorId()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && hasTypes() == other.hasTypes() && Objects.equals(types(), other.types())
                && Objects.equals(firstObservedAt(), other.firstObservedAt())
                && Objects.equals(lastObservedAt(), other.lastObservedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(severity(), other.severity())
                && Objects.equals(confidence(), other.confidence()) && Objects.equals(criticality(), other.criticality())
                && Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(remediation(), other.remediation()) && Objects.equals(sourceUrl(), other.sourceUrl())
                && hasProductFields() == other.hasProductFields() && Objects.equals(productFields(), other.productFields())
                && hasUserDefinedFields() == other.hasUserDefinedFields()
                && Objects.equals(userDefinedFields(), other.userDefinedFields()) && hasMalware() == other.hasMalware()
                && Objects.equals(malware(), other.malware()) && Objects.equals(network(), other.network())
                && hasNetworkPath() == other.hasNetworkPath() && Objects.equals(networkPath(), other.networkPath())
                && Objects.equals(process(), other.process()) && hasThreats() == other.hasThreats()
                && Objects.equals(threats(), other.threats()) && hasThreatIntelIndicators() == other.hasThreatIntelIndicators()
                && Objects.equals(threatIntelIndicators(), other.threatIntelIndicators())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(compliance(), other.compliance())
                && Objects.equals(verificationStateAsString(), other.verificationStateAsString())
                && Objects.equals(workflowStateAsString(), other.workflowStateAsString())
                && Objects.equals(workflow(), other.workflow())
                && Objects.equals(recordStateAsString(), other.recordStateAsString())
                && hasRelatedFindings() == other.hasRelatedFindings()
                && Objects.equals(relatedFindings(), other.relatedFindings()) && Objects.equals(note(), other.note())
                && hasVulnerabilities() == other.hasVulnerabilities()
                && Objects.equals(vulnerabilities(), other.vulnerabilities())
                && Objects.equals(patchSummary(), other.patchSummary()) && Objects.equals(action(), other.action())
                && Objects.equals(findingProviderFields(), other.findingProviderFields())
                && Objects.equals(sample(), other.sample());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSecurityFinding").add("SchemaVersion", schemaVersion()).add("Id", id())
                .add("ProductArn", productArn()).add("ProductName", productName()).add("CompanyName", companyName())
                .add("Region", region()).add("GeneratorId", generatorId()).add("AwsAccountId", awsAccountId())
                .add("Types", hasTypes() ? types() : null).add("FirstObservedAt", firstObservedAt())
                .add("LastObservedAt", lastObservedAt()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("Severity", severity()).add("Confidence", confidence()).add("Criticality", criticality())
                .add("Title", title()).add("Description", description()).add("Remediation", remediation())
                .add("SourceUrl", sourceUrl()).add("ProductFields", hasProductFields() ? productFields() : null)
                .add("UserDefinedFields", hasUserDefinedFields() ? userDefinedFields() : null)
                .add("Malware", hasMalware() ? malware() : null).add("Network", network())
                .add("NetworkPath", hasNetworkPath() ? networkPath() : null).add("Process", process())
                .add("Threats", hasThreats() ? threats() : null)
                .add("ThreatIntelIndicators", hasThreatIntelIndicators() ? threatIntelIndicators() : null)
                .add("Resources", hasResources() ? resources() : null).add("Compliance", compliance())
                .add("VerificationState", verificationStateAsString()).add("WorkflowState", workflowStateAsString())
                .add("Workflow", workflow()).add("RecordState", recordStateAsString())
                .add("RelatedFindings", hasRelatedFindings() ? relatedFindings() : null).add("Note", note())
                .add("Vulnerabilities", hasVulnerabilities() ? vulnerabilities() : null).add("PatchSummary", patchSummary())
                .add("Action", action()).add("FindingProviderFields", findingProviderFields()).add("Sample", sample()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ProductArn":
            return Optional.ofNullable(clazz.cast(productArn()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "GeneratorId":
            return Optional.ofNullable(clazz.cast(generatorId()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Types":
            return Optional.ofNullable(clazz.cast(types()));
        case "FirstObservedAt":
            return Optional.ofNullable(clazz.cast(firstObservedAt()));
        case "LastObservedAt":
            return Optional.ofNullable(clazz.cast(lastObservedAt()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Criticality":
            return Optional.ofNullable(clazz.cast(criticality()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "SourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        case "ProductFields":
            return Optional.ofNullable(clazz.cast(productFields()));
        case "UserDefinedFields":
            return Optional.ofNullable(clazz.cast(userDefinedFields()));
        case "Malware":
            return Optional.ofNullable(clazz.cast(malware()));
        case "Network":
            return Optional.ofNullable(clazz.cast(network()));
        case "NetworkPath":
            return Optional.ofNullable(clazz.cast(networkPath()));
        case "Process":
            return Optional.ofNullable(clazz.cast(process()));
        case "Threats":
            return Optional.ofNullable(clazz.cast(threats()));
        case "ThreatIntelIndicators":
            return Optional.ofNullable(clazz.cast(threatIntelIndicators()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "Compliance":
            return Optional.ofNullable(clazz.cast(compliance()));
        case "VerificationState":
            return Optional.ofNullable(clazz.cast(verificationStateAsString()));
        case "WorkflowState":
            return Optional.ofNullable(clazz.cast(workflowStateAsString()));
        case "Workflow":
            return Optional.ofNullable(clazz.cast(workflow()));
        case "RecordState":
            return Optional.ofNullable(clazz.cast(recordStateAsString()));
        case "RelatedFindings":
            return Optional.ofNullable(clazz.cast(relatedFindings()));
        case "Note":
            return Optional.ofNullable(clazz.cast(note()));
        case "Vulnerabilities":
            return Optional.ofNullable(clazz.cast(vulnerabilities()));
        case "PatchSummary":
            return Optional.ofNullable(clazz.cast(patchSummary()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "FindingProviderFields":
            return Optional.ofNullable(clazz.cast(findingProviderFields()));
        case "Sample":
            return Optional.ofNullable(clazz.cast(sample()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSecurityFinding, T> g) {
        return obj -> g.apply((AwsSecurityFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSecurityFinding> {
        /**
         * <p>
         * The schema version that a finding is formatted for.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version that a finding is formatted for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The security findings provider-specific identifier for a finding.
         * </p>
         * 
         * @param id
         *        The security findings provider-specific identifier for a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the
         * ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
         * </p>
         * 
         * @param productArn
         *        The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can
         *        be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom
         *        integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productArn(String productArn);

        /**
         * <p>
         * The name of the product that generated the finding.
         * </p>
         * <p>
         * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
         * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
         * integration.
         * </p>
         * <p>
         * When you use the Security Hub console or API to filter findings by product name, you use this attribute.
         * </p>
         * 
         * @param productName
         *        The name of the product that generated the finding.</p>
         *        <p>
         *        Security Hub populates this attribute automatically for each finding. You cannot update this attribute
         *        with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
         *        custom integration.
         *        </p>
         *        <p>
         *        When you use the Security Hub console or API to filter findings by product name, you use this
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * The name of the company for the product that generated the finding.
         * </p>
         * <p>
         * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
         * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
         * integration.
         * </p>
         * <p>
         * When you use the Security Hub console or API to filter findings by company name, you use this attribute.
         * </p>
         * 
         * @param companyName
         *        The name of the company for the product that generated the finding.</p>
         *        <p>
         *        Security Hub populates this attribute automatically for each finding. You cannot update this attribute
         *        with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
         *        custom integration.
         *        </p>
         *        <p>
         *        When you use the Security Hub console or API to filter findings by company name, you use this
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * The Region from which the finding was generated.
         * </p>
         * <p>
         * Security Hub populates this attribute automatically for each finding. You cannot update it using
         * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
         * </p>
         * 
         * @param region
         *        The Region from which the finding was generated.</p>
         *        <p>
         *        Security Hub populates this attribute automatically for each finding. You cannot update it using
         *        <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
         * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
         * plugin, etc.
         * </p>
         * 
         * @param generatorId
         *        The identifier for the solution-specific component (a discrete unit of logic) that generated a
         *        finding. In various security-findings providers' solutions, this generator can be called a rule, a
         *        check, a detector, a plugin, etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatorId(String generatorId);

        /**
         * <p>
         * The Amazon Web Services account ID that a finding is generated in.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID that a finding is generated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
         * finding.
         * </p>
         * <p>
         * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
         * Sensitive Data Identifications
         * </p>
         * 
         * @param types
         *        One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
         *        finding.</p>
         *        <p>
         *        Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
         *        Sensitive Data Identifications
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<String> types);

        /**
         * <p>
         * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
         * finding.
         * </p>
         * <p>
         * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
         * Sensitive Data Identifications
         * </p>
         * 
         * @param types
         *        One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
         *        finding.</p>
         *        <p>
         *        Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
         *        Sensitive Data Identifications
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(String... types);

        /**
         * <p>
         * Indicates when the security-findings provider first observed the potential security issue that a finding
         * captured.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param firstObservedAt
         *        Indicates when the security-findings provider first observed the potential security issue that a
         *        finding captured.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(String firstObservedAt);

        /**
         * <p>
         * Indicates when the security-findings provider most recently observed the potential security issue that a
         * finding captured.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param lastObservedAt
         *        Indicates when the security-findings provider most recently observed the potential security issue that
         *        a finding captured.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(String lastObservedAt);

        /**
         * <p>
         * Indicates when the security-findings provider created the potential security issue that a finding captured.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdAt
         *        Indicates when the security-findings provider created the potential security issue that a finding
         *        captured.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Indicates when the security-findings provider last updated the finding record.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param updatedAt
         *        Indicates when the security-findings provider last updated the finding record.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(String updatedAt);

        /**
         * <p>
         * A finding's severity.
         * </p>
         * 
         * @param severity
         *        A finding's severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Severity severity);

        /**
         * <p>
         * A finding's severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link Severity.Builder} avoiding the need to
         * create one manually via {@link Severity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Severity.Builder#build()} is called immediately and its result is
         * passed to {@link #severity(Severity)}.
         * 
         * @param severity
         *        a consumer that will call methods on {@link Severity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severity(Severity)
         */
        default Builder severity(Consumer<Severity.Builder> severity) {
            return severity(Severity.builder().applyMutation(severity).build());
        }

        /**
         * <p>
         * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
         * behavior or issue that it was intended to identify.
         * </p>
         * <p>
         * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100
         * means 100 percent confidence.
         * </p>
         * 
         * @param confidence
         *        A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies
         *        the behavior or issue that it was intended to identify.</p>
         *        <p>
         *        Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and
         *        100 means 100 percent confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Integer confidence);

        /**
         * <p>
         * The level of importance assigned to the resources associated with the finding.
         * </p>
         * <p>
         * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the
         * most critical resources.
         * </p>
         * 
         * @param criticality
         *        The level of importance assigned to the resources associated with the finding.</p>
         *        <p>
         *        A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved
         *        for the most critical resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(Integer criticality);

        /**
         * <p>
         * A finding's title.
         * </p>
         * <note>
         * <p>
         * In this release, <code>Title</code> is a required property.
         * </p>
         * </note>
         * 
         * @param title
         *        A finding's title.</p> <note>
         *        <p>
         *        In this release, <code>Title</code> is a required property.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A finding's description.
         * </p>
         * <note>
         * <p>
         * In this release, <code>Description</code> is a required property.
         * </p>
         * </note>
         * 
         * @param description
         *        A finding's description.</p> <note>
         *        <p>
         *        In this release, <code>Description</code> is a required property.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A data type that describes the remediation options for a finding.
         * </p>
         * 
         * @param remediation
         *        A data type that describes the remediation options for a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(Remediation remediation);

        /**
         * <p>
         * A data type that describes the remediation options for a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Remediation.Builder} avoiding the need to
         * create one manually via {@link Remediation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Remediation.Builder#build()} is called immediately and its result
         * is passed to {@link #remediation(Remediation)}.
         * 
         * @param remediation
         *        a consumer that will call methods on {@link Remediation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediation(Remediation)
         */
        default Builder remediation(Consumer<Remediation.Builder> remediation) {
            return remediation(Remediation.builder().applyMutation(remediation).build());
        }

        /**
         * <p>
         * A URL that links to a page about the current finding in the security-findings provider's solution.
         * </p>
         * 
         * @param sourceUrl
         *        A URL that links to a page about the current finding in the security-findings provider's solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(String sourceUrl);

        /**
         * <p>
         * A data type where security-findings providers can include additional solution-specific details that aren't
         * part of the defined <code>AwsSecurityFinding</code> format.
         * </p>
         * <p>
         * Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and
         * the value can contain up to 2048 characters.
         * </p>
         * 
         * @param productFields
         *        A data type where security-findings providers can include additional solution-specific details that
         *        aren't part of the defined <code>AwsSecurityFinding</code> format.</p>
         *        <p>
         *        Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128
         *        characters, and the value can contain up to 2048 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productFields(Map<String, String> productFields);

        /**
         * <p>
         * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to
         * a finding.
         * </p>
         * 
         * @param userDefinedFields
         *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields
         *        added to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFields(Map<String, String> userDefinedFields);

        /**
         * <p>
         * A list of malware related to a finding.
         * </p>
         * 
         * @param malware
         *        A list of malware related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malware(Collection<Malware> malware);

        /**
         * <p>
         * A list of malware related to a finding.
         * </p>
         * 
         * @param malware
         *        A list of malware related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malware(Malware... malware);

        /**
         * <p>
         * A list of malware related to a finding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.Malware.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.Malware#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.Malware.Builder#build()} is called immediately and
         * its result is passed to {@link #malware(List<Malware>)}.
         * 
         * @param malware
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.Malware.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malware(java.util.Collection<Malware>)
         */
        Builder malware(Consumer<Malware.Builder>... malware);

        /**
         * <p>
         * The details of network-related information about a finding.
         * </p>
         * 
         * @param network
         *        The details of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder network(Network network);

        /**
         * <p>
         * The details of network-related information about a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Network.Builder} avoiding the need to
         * create one manually via {@link Network#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Network.Builder#build()} is called immediately and its result is
         * passed to {@link #network(Network)}.
         * 
         * @param network
         *        a consumer that will call methods on {@link Network.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #network(Network)
         */
        default Builder network(Consumer<Network.Builder> network) {
            return network(Network.builder().applyMutation(network).build());
        }

        /**
         * <p>
         * Provides information about a network path that is relevant to a finding. Each entry under
         * <code>NetworkPath</code> represents a component of that path.
         * </p>
         * 
         * @param networkPath
         *        Provides information about a network path that is relevant to a finding. Each entry under
         *        <code>NetworkPath</code> represents a component of that path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPath(Collection<NetworkPathComponent> networkPath);

        /**
         * <p>
         * Provides information about a network path that is relevant to a finding. Each entry under
         * <code>NetworkPath</code> represents a component of that path.
         * </p>
         * 
         * @param networkPath
         *        Provides information about a network path that is relevant to a finding. Each entry under
         *        <code>NetworkPath</code> represents a component of that path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPath(NetworkPathComponent... networkPath);

        /**
         * <p>
         * Provides information about a network path that is relevant to a finding. Each entry under
         * <code>NetworkPath</code> represents a component of that path.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.NetworkPathComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.NetworkPathComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.NetworkPathComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #networkPath(List<NetworkPathComponent>)}.
         * 
         * @param networkPath
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.NetworkPathComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkPath(java.util.Collection<NetworkPathComponent>)
         */
        Builder networkPath(Consumer<NetworkPathComponent.Builder>... networkPath);

        /**
         * <p>
         * The details of process-related information about a finding.
         * </p>
         * 
         * @param process
         *        The details of process-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder process(ProcessDetails process);

        /**
         * <p>
         * The details of process-related information about a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProcessDetails.Builder} avoiding the need
         * to create one manually via {@link ProcessDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #process(ProcessDetails)}.
         * 
         * @param process
         *        a consumer that will call methods on {@link ProcessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #process(ProcessDetails)
         */
        default Builder process(Consumer<ProcessDetails.Builder> process) {
            return process(ProcessDetails.builder().applyMutation(process).build());
        }

        /**
         * <p>
         * Details about the threat detected in a security finding and the file paths that were affected by the threat.
         * </p>
         * 
         * @param threats
         *        Details about the threat detected in a security finding and the file paths that were affected by the
         *        threat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threats(Collection<Threat> threats);

        /**
         * <p>
         * Details about the threat detected in a security finding and the file paths that were affected by the threat.
         * </p>
         * 
         * @param threats
         *        Details about the threat detected in a security finding and the file paths that were affected by the
         *        threat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threats(Threat... threats);

        /**
         * <p>
         * Details about the threat detected in a security finding and the file paths that were affected by the threat.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.Threat.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.Threat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.Threat.Builder#build()} is called immediately and
         * its result is passed to {@link #threats(List<Threat>)}.
         * 
         * @param threats
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.Threat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threats(java.util.Collection<Threat>)
         */
        Builder threats(Consumer<Threat.Builder>... threats);

        /**
         * <p>
         * Threat intelligence details related to a finding.
         * </p>
         * 
         * @param threatIntelIndicators
         *        Threat intelligence details related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicators(Collection<ThreatIntelIndicator> threatIntelIndicators);

        /**
         * <p>
         * Threat intelligence details related to a finding.
         * </p>
         * 
         * @param threatIntelIndicators
         *        Threat intelligence details related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicators(ThreatIntelIndicator... threatIntelIndicators);

        /**
         * <p>
         * Threat intelligence details related to a finding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator.Builder#build()} is called
         * immediately and its result is passed to {@link #threatIntelIndicators(List<ThreatIntelIndicator>)}.
         * 
         * @param threatIntelIndicators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatIntelIndicators(java.util.Collection<ThreatIntelIndicator>)
         */
        Builder threatIntelIndicators(Consumer<ThreatIntelIndicator.Builder>... threatIntelIndicators);

        /**
         * <p>
         * A set of resource data types that describe the resources that the finding refers to.
         * </p>
         * 
         * @param resources
         *        A set of resource data types that describe the resources that the finding refers to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * <p>
         * A set of resource data types that describe the resources that the finding refers to.
         * </p>
         * 
         * @param resources
         *        A set of resource data types that describe the resources that the finding refers to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);

        /**
         * <p>
         * A set of resource data types that describe the resources that the finding refers to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.Resource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.Resource.Builder#build()} is called immediately and
         * its result is passed to {@link #resources(List<Resource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<Resource>)
         */
        Builder resources(Consumer<Resource.Builder>... resources);

        /**
         * <p>
         * This data type is exclusive to findings that are generated as the result of a check run against a specific
         * rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security
         * standard-related finding details.
         * </p>
         * 
         * @param compliance
         *        This data type is exclusive to findings that are generated as the result of a check run against a
         *        specific rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains
         *        security standard-related finding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Compliance compliance);

        /**
         * <p>
         * This data type is exclusive to findings that are generated as the result of a check run against a specific
         * rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security
         * standard-related finding details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Compliance.Builder} avoiding the need to
         * create one manually via {@link Compliance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Compliance.Builder#build()} is called immediately and its result
         * is passed to {@link #compliance(Compliance)}.
         * 
         * @param compliance
         *        a consumer that will call methods on {@link Compliance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compliance(Compliance)
         */
        default Builder compliance(Consumer<Compliance.Builder> compliance) {
            return compliance(Compliance.builder().applyMutation(compliance).build());
        }

        /**
         * <p>
         * Indicates the veracity of a finding.
         * </p>
         * 
         * @param verificationState
         *        Indicates the veracity of a finding.
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(String verificationState);

        /**
         * <p>
         * Indicates the veracity of a finding.
         * </p>
         * 
         * @param verificationState
         *        Indicates the veracity of a finding.
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(VerificationState verificationState);

        /**
         * <p>
         * The workflow state of a finding.
         * </p>
         * 
         * @param workflowState
         *        The workflow state of a finding.
         * @see WorkflowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowState
         */
        Builder workflowState(String workflowState);

        /**
         * <p>
         * The workflow state of a finding.
         * </p>
         * 
         * @param workflowState
         *        The workflow state of a finding.
         * @see WorkflowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowState
         */
        Builder workflowState(WorkflowState workflowState);

        /**
         * <p>
         * Provides information about the status of the investigation into a finding.
         * </p>
         * 
         * @param workflow
         *        Provides information about the status of the investigation into a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflow(Workflow workflow);

        /**
         * <p>
         * Provides information about the status of the investigation into a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Workflow.Builder} avoiding the need to
         * create one manually via {@link Workflow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Workflow.Builder#build()} is called immediately and its result is
         * passed to {@link #workflow(Workflow)}.
         * 
         * @param workflow
         *        a consumer that will call methods on {@link Workflow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflow(Workflow)
         */
        default Builder workflow(Consumer<Workflow.Builder> workflow) {
            return workflow(Workflow.builder().applyMutation(workflow).build());
        }

        /**
         * <p>
         * The record state of a finding.
         * </p>
         * 
         * @param recordState
         *        The record state of a finding.
         * @see RecordState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordState
         */
        Builder recordState(String recordState);

        /**
         * <p>
         * The record state of a finding.
         * </p>
         * 
         * @param recordState
         *        The record state of a finding.
         * @see RecordState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordState
         */
        Builder recordState(RecordState recordState);

        /**
         * <p>
         * A list of related findings.
         * </p>
         * 
         * @param relatedFindings
         *        A list of related findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindings(Collection<RelatedFinding> relatedFindings);

        /**
         * <p>
         * A list of related findings.
         * </p>
         * 
         * @param relatedFindings
         *        A list of related findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindings(RelatedFinding... relatedFindings);

        /**
         * <p>
         * A list of related findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RelatedFinding.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.RelatedFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RelatedFinding.Builder#build()} is called
         * immediately and its result is passed to {@link #relatedFindings(List<RelatedFinding>)}.
         * 
         * @param relatedFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RelatedFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindings(java.util.Collection<RelatedFinding>)
         */
        Builder relatedFindings(Consumer<RelatedFinding.Builder>... relatedFindings);

        /**
         * <p>
         * A user-defined note added to a finding.
         * </p>
         * 
         * @param note
         *        A user-defined note added to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder note(Note note);

        /**
         * <p>
         * A user-defined note added to a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Note.Builder} avoiding the need to create
         * one manually via {@link Note#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Note.Builder#build()} is called immediately and its result is
         * passed to {@link #note(Note)}.
         * 
         * @param note
         *        a consumer that will call methods on {@link Note.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #note(Note)
         */
        default Builder note(Consumer<Note.Builder> note) {
            return note(Note.builder().applyMutation(note).build());
        }

        /**
         * <p>
         * Provides a list of vulnerabilities associated with the findings.
         * </p>
         * 
         * @param vulnerabilities
         *        Provides a list of vulnerabilities associated with the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilities(Collection<Vulnerability> vulnerabilities);

        /**
         * <p>
         * Provides a list of vulnerabilities associated with the findings.
         * </p>
         * 
         * @param vulnerabilities
         *        Provides a list of vulnerabilities associated with the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilities(Vulnerability... vulnerabilities);

        /**
         * <p>
         * Provides a list of vulnerabilities associated with the findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.Vulnerability.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.Vulnerability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.Vulnerability.Builder#build()} is called immediately
         * and its result is passed to {@link #vulnerabilities(List<Vulnerability>)}.
         * 
         * @param vulnerabilities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.Vulnerability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerabilities(java.util.Collection<Vulnerability>)
         */
        Builder vulnerabilities(Consumer<Vulnerability.Builder>... vulnerabilities);

        /**
         * <p>
         * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
         * </p>
         * 
         * @param patchSummary
         *        Provides an overview of the patch compliance status for an instance against a selected compliance
         *        standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchSummary(PatchSummary patchSummary);

        /**
         * <p>
         * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
         * </p>
         * This is a convenience method that creates an instance of the {@link PatchSummary.Builder} avoiding the need
         * to create one manually via {@link PatchSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PatchSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #patchSummary(PatchSummary)}.
         * 
         * @param patchSummary
         *        a consumer that will call methods on {@link PatchSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchSummary(PatchSummary)
         */
        default Builder patchSummary(Consumer<PatchSummary.Builder> patchSummary) {
            return patchSummary(PatchSummary.builder().applyMutation(patchSummary).build());
        }

        /**
         * <p>
         * Provides details about an action that affects or that was taken on a resource.
         * </p>
         * 
         * @param action
         *        Provides details about an action that affects or that was taken on a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Action action);

        /**
         * <p>
         * Provides details about an action that affects or that was taken on a resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link Action.Builder} avoiding the need to
         * create one manually via {@link Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #action(Action)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(Action)
         */
        default Builder action(Consumer<Action.Builder> action) {
            return action(Action.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to
         * provide and update their own values for confidence, criticality, related findings, severity, and types.
         * </p>
         * 
         * @param findingProviderFields
         *        In a <code>BatchImportFindings</code> request, finding providers use
         *        <code>FindingProviderFields</code> to provide and update their own values for confidence, criticality,
         *        related findings, severity, and types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingProviderFields(FindingProviderFields findingProviderFields);

        /**
         * <p>
         * In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to
         * provide and update their own values for confidence, criticality, related findings, severity, and types.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingProviderFields.Builder} avoiding
         * the need to create one manually via {@link FindingProviderFields#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingProviderFields.Builder#build()} is called immediately and
         * its result is passed to {@link #findingProviderFields(FindingProviderFields)}.
         * 
         * @param findingProviderFields
         *        a consumer that will call methods on {@link FindingProviderFields.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingProviderFields(FindingProviderFields)
         */
        default Builder findingProviderFields(Consumer<FindingProviderFields.Builder> findingProviderFields) {
            return findingProviderFields(FindingProviderFields.builder().applyMutation(findingProviderFields).build());
        }

        /**
         * <p>
         * Indicates whether the finding is a sample finding.
         * </p>
         * 
         * @param sample
         *        Indicates whether the finding is a sample finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sample(Boolean sample);
    }

    static final class BuilderImpl implements Builder {
        private String schemaVersion;

        private String id;

        private String productArn;

        private String productName;

        private String companyName;

        private String region;

        private String generatorId;

        private String awsAccountId;

        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private String firstObservedAt;

        private String lastObservedAt;

        private String createdAt;

        private String updatedAt;

        private Severity severity;

        private Integer confidence;

        private Integer criticality;

        private String title;

        private String description;

        private Remediation remediation;

        private String sourceUrl;

        private Map<String, String> productFields = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> userDefinedFields = DefaultSdkAutoConstructMap.getInstance();

        private List<Malware> malware = DefaultSdkAutoConstructList.getInstance();

        private Network network;

        private List<NetworkPathComponent> networkPath = DefaultSdkAutoConstructList.getInstance();

        private ProcessDetails process;

        private List<Threat> threats = DefaultSdkAutoConstructList.getInstance();

        private List<ThreatIntelIndicator> threatIntelIndicators = DefaultSdkAutoConstructList.getInstance();

        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private Compliance compliance;

        private String verificationState;

        private String workflowState;

        private Workflow workflow;

        private String recordState;

        private List<RelatedFinding> relatedFindings = DefaultSdkAutoConstructList.getInstance();

        private Note note;

        private List<Vulnerability> vulnerabilities = DefaultSdkAutoConstructList.getInstance();

        private PatchSummary patchSummary;

        private Action action;

        private FindingProviderFields findingProviderFields;

        private Boolean sample;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSecurityFinding model) {
            schemaVersion(model.schemaVersion);
            id(model.id);
            productArn(model.productArn);
            productName(model.productName);
            companyName(model.companyName);
            region(model.region);
            generatorId(model.generatorId);
            awsAccountId(model.awsAccountId);
            types(model.types);
            firstObservedAt(model.firstObservedAt);
            lastObservedAt(model.lastObservedAt);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            severity(model.severity);
            confidence(model.confidence);
            criticality(model.criticality);
            title(model.title);
            description(model.description);
            remediation(model.remediation);
            sourceUrl(model.sourceUrl);
            productFields(model.productFields);
            userDefinedFields(model.userDefinedFields);
            malware(model.malware);
            network(model.network);
            networkPath(model.networkPath);
            process(model.process);
            threats(model.threats);
            threatIntelIndicators(model.threatIntelIndicators);
            resources(model.resources);
            compliance(model.compliance);
            verificationState(model.verificationState);
            workflowState(model.workflowState);
            workflow(model.workflow);
            recordState(model.recordState);
            relatedFindings(model.relatedFindings);
            note(model.note);
            vulnerabilities(model.vulnerabilities);
            patchSummary(model.patchSummary);
            action(model.action);
            findingProviderFields(model.findingProviderFields);
            sample(model.sample);
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProductArn() {
            return productArn;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        @Override
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        public final String getProductName() {
            return productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getGeneratorId() {
            return generatorId;
        }

        public final void setGeneratorId(String generatorId) {
            this.generatorId = generatorId;
        }

        @Override
        public final Builder generatorId(String generatorId) {
            this.generatorId = generatorId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final String getFirstObservedAt() {
            return firstObservedAt;
        }

        public final void setFirstObservedAt(String firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        @Override
        public final Builder firstObservedAt(String firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final String getLastObservedAt() {
            return lastObservedAt;
        }

        public final void setLastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        @Override
        public final Builder lastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Severity.Builder getSeverity() {
            return severity != null ? severity.toBuilder() : null;
        }

        public final void setSeverity(Severity.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public final Integer getConfidence() {
            return confidence;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Integer getCriticality() {
            return criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return remediation != null ? remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getSourceUrl() {
            return sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final Map<String, String> getProductFields() {
            if (productFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return productFields;
        }

        public final void setProductFields(Map<String, String> productFields) {
            this.productFields = FieldMapCopier.copy(productFields);
        }

        @Override
        public final Builder productFields(Map<String, String> productFields) {
            this.productFields = FieldMapCopier.copy(productFields);
            return this;
        }

        public final Map<String, String> getUserDefinedFields() {
            if (userDefinedFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return userDefinedFields;
        }

        public final void setUserDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
        }

        @Override
        public final Builder userDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
            return this;
        }

        public final List<Malware.Builder> getMalware() {
            List<Malware.Builder> result = MalwareListCopier.copyToBuilder(this.malware);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMalware(Collection<Malware.BuilderImpl> malware) {
            this.malware = MalwareListCopier.copyFromBuilder(malware);
        }

        @Override
        public final Builder malware(Collection<Malware> malware) {
            this.malware = MalwareListCopier.copy(malware);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malware(Malware... malware) {
            malware(Arrays.asList(malware));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malware(Consumer<Malware.Builder>... malware) {
            malware(Stream.of(malware).map(c -> Malware.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Network.Builder getNetwork() {
            return network != null ? network.toBuilder() : null;
        }

        public final void setNetwork(Network.BuilderImpl network) {
            this.network = network != null ? network.build() : null;
        }

        @Override
        public final Builder network(Network network) {
            this.network = network;
            return this;
        }

        public final List<NetworkPathComponent.Builder> getNetworkPath() {
            List<NetworkPathComponent.Builder> result = NetworkPathListCopier.copyToBuilder(this.networkPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkPath(Collection<NetworkPathComponent.BuilderImpl> networkPath) {
            this.networkPath = NetworkPathListCopier.copyFromBuilder(networkPath);
        }

        @Override
        public final Builder networkPath(Collection<NetworkPathComponent> networkPath) {
            this.networkPath = NetworkPathListCopier.copy(networkPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkPath(NetworkPathComponent... networkPath) {
            networkPath(Arrays.asList(networkPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkPath(Consumer<NetworkPathComponent.Builder>... networkPath) {
            networkPath(Stream.of(networkPath).map(c -> NetworkPathComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ProcessDetails.Builder getProcess() {
            return process != null ? process.toBuilder() : null;
        }

        public final void setProcess(ProcessDetails.BuilderImpl process) {
            this.process = process != null ? process.build() : null;
        }

        @Override
        public final Builder process(ProcessDetails process) {
            this.process = process;
            return this;
        }

        public final List<Threat.Builder> getThreats() {
            List<Threat.Builder> result = ThreatListCopier.copyToBuilder(this.threats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreats(Collection<Threat.BuilderImpl> threats) {
            this.threats = ThreatListCopier.copyFromBuilder(threats);
        }

        @Override
        public final Builder threats(Collection<Threat> threats) {
            this.threats = ThreatListCopier.copy(threats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(Threat... threats) {
            threats(Arrays.asList(threats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(Consumer<Threat.Builder>... threats) {
            threats(Stream.of(threats).map(c -> Threat.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThreatIntelIndicator.Builder> getThreatIntelIndicators() {
            List<ThreatIntelIndicator.Builder> result = ThreatIntelIndicatorListCopier.copyToBuilder(this.threatIntelIndicators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatIntelIndicators(Collection<ThreatIntelIndicator.BuilderImpl> threatIntelIndicators) {
            this.threatIntelIndicators = ThreatIntelIndicatorListCopier.copyFromBuilder(threatIntelIndicators);
        }

        @Override
        public final Builder threatIntelIndicators(Collection<ThreatIntelIndicator> threatIntelIndicators) {
            this.threatIntelIndicators = ThreatIntelIndicatorListCopier.copy(threatIntelIndicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicators(ThreatIntelIndicator... threatIntelIndicators) {
            threatIntelIndicators(Arrays.asList(threatIntelIndicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicators(Consumer<ThreatIntelIndicator.Builder>... threatIntelIndicators) {
            threatIntelIndicators(Stream.of(threatIntelIndicators)
                    .map(c -> ThreatIntelIndicator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> Resource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Compliance.Builder getCompliance() {
            return compliance != null ? compliance.toBuilder() : null;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final String getVerificationState() {
            return verificationState;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        @Override
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final String getWorkflowState() {
            return workflowState;
        }

        public final void setWorkflowState(String workflowState) {
            this.workflowState = workflowState;
        }

        @Override
        public final Builder workflowState(String workflowState) {
            this.workflowState = workflowState;
            return this;
        }

        @Override
        public final Builder workflowState(WorkflowState workflowState) {
            this.workflowState(workflowState == null ? null : workflowState.toString());
            return this;
        }

        public final Workflow.Builder getWorkflow() {
            return workflow != null ? workflow.toBuilder() : null;
        }

        public final void setWorkflow(Workflow.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        @Override
        public final Builder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public final String getRecordState() {
            return recordState;
        }

        public final void setRecordState(String recordState) {
            this.recordState = recordState;
        }

        @Override
        public final Builder recordState(String recordState) {
            this.recordState = recordState;
            return this;
        }

        @Override
        public final Builder recordState(RecordState recordState) {
            this.recordState(recordState == null ? null : recordState.toString());
            return this;
        }

        public final List<RelatedFinding.Builder> getRelatedFindings() {
            List<RelatedFinding.Builder> result = RelatedFindingListCopier.copyToBuilder(this.relatedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedFindings(Collection<RelatedFinding.BuilderImpl> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copyFromBuilder(relatedFindings);
        }

        @Override
        public final Builder relatedFindings(Collection<RelatedFinding> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copy(relatedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(RelatedFinding... relatedFindings) {
            relatedFindings(Arrays.asList(relatedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(Consumer<RelatedFinding.Builder>... relatedFindings) {
            relatedFindings(Stream.of(relatedFindings).map(c -> RelatedFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Note.Builder getNote() {
            return note != null ? note.toBuilder() : null;
        }

        public final void setNote(Note.BuilderImpl note) {
            this.note = note != null ? note.build() : null;
        }

        @Override
        public final Builder note(Note note) {
            this.note = note;
            return this;
        }

        public final List<Vulnerability.Builder> getVulnerabilities() {
            List<Vulnerability.Builder> result = VulnerabilityListCopier.copyToBuilder(this.vulnerabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerabilities(Collection<Vulnerability.BuilderImpl> vulnerabilities) {
            this.vulnerabilities = VulnerabilityListCopier.copyFromBuilder(vulnerabilities);
        }

        @Override
        public final Builder vulnerabilities(Collection<Vulnerability> vulnerabilities) {
            this.vulnerabilities = VulnerabilityListCopier.copy(vulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilities(Vulnerability... vulnerabilities) {
            vulnerabilities(Arrays.asList(vulnerabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilities(Consumer<Vulnerability.Builder>... vulnerabilities) {
            vulnerabilities(Stream.of(vulnerabilities).map(c -> Vulnerability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final PatchSummary.Builder getPatchSummary() {
            return patchSummary != null ? patchSummary.toBuilder() : null;
        }

        public final void setPatchSummary(PatchSummary.BuilderImpl patchSummary) {
            this.patchSummary = patchSummary != null ? patchSummary.build() : null;
        }

        @Override
        public final Builder patchSummary(PatchSummary patchSummary) {
            this.patchSummary = patchSummary;
            return this;
        }

        public final Action.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final FindingProviderFields.Builder getFindingProviderFields() {
            return findingProviderFields != null ? findingProviderFields.toBuilder() : null;
        }

        public final void setFindingProviderFields(FindingProviderFields.BuilderImpl findingProviderFields) {
            this.findingProviderFields = findingProviderFields != null ? findingProviderFields.build() : null;
        }

        @Override
        public final Builder findingProviderFields(FindingProviderFields findingProviderFields) {
            this.findingProviderFields = findingProviderFields;
            return this;
        }

        public final Boolean getSample() {
            return sample;
        }

        public final void setSample(Boolean sample) {
            this.sample = sample;
        }

        @Override
        public final Builder sample(Boolean sample) {
            this.sample = sample;
            return this;
        }

        @Override
        public AwsSecurityFinding build() {
            return new AwsSecurityFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
