/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an WAF rule group. A rule group is a collection of rules for inspecting and controlling
 * web requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafRuleGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafRuleGroupDetails.Builder, AwsWafRuleGroupDetails> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(AwsWafRuleGroupDetails::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsWafRuleGroupDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupId").getter(getter(AwsWafRuleGroupDetails::ruleGroupId)).setter(setter(Builder::ruleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupId").build()).build();

    private static final SdkField<List<AwsWafRuleGroupRulesDetails>> RULES_FIELD = SdkField
            .<List<AwsWafRuleGroupRulesDetails>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(AwsWafRuleGroupDetails::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsWafRuleGroupRulesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsWafRuleGroupRulesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NAME_FIELD,
            RULE_GROUP_ID_FIELD, RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String name;

    private final String ruleGroupId;

    private final List<AwsWafRuleGroupRulesDetails> rules;

    private AwsWafRuleGroupDetails(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.ruleGroupId = builder.ruleGroupId;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The name of the metrics for this rule group.
     * </p>
     * 
     * @return The name of the metrics for this rule group.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The name of the rule group.
     * </p>
     * 
     * @return The name of the rule group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the rule group.
     * </p>
     * 
     * @return The ID of the rule group.
     */
    public final String ruleGroupId() {
        return ruleGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about the rules attached to the rule group. These rules identify the web requests that you
     * want to allow, block, or count.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return Provides information about the rules attached to the rule group. These rules identify the web requests
     *         that you want to allow, block, or count.
     */
    public final List<AwsWafRuleGroupRulesDetails> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRuleGroupDetails)) {
            return false;
        }
        AwsWafRuleGroupDetails other = (AwsWafRuleGroupDetails) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(name(), other.name())
                && Objects.equals(ruleGroupId(), other.ruleGroupId()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafRuleGroupDetails").add("MetricName", metricName()).add("Name", name())
                .add("RuleGroupId", ruleGroupId()).add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleGroupId":
            return Optional.ofNullable(clazz.cast(ruleGroupId()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRuleGroupDetails, T> g) {
        return obj -> g.apply((AwsWafRuleGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafRuleGroupDetails> {
        /**
         * <p>
         * The name of the metrics for this rule group.
         * </p>
         * 
         * @param metricName
         *        The name of the metrics for this rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The name of the rule group.
         * </p>
         * 
         * @param name
         *        The name of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the rule group.
         * </p>
         * 
         * @param ruleGroupId
         *        The ID of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupId(String ruleGroupId);

        /**
         * <p>
         * Provides information about the rules attached to the rule group. These rules identify the web requests that
         * you want to allow, block, or count.
         * </p>
         * 
         * @param rules
         *        Provides information about the rules attached to the rule group. These rules identify the web requests
         *        that you want to allow, block, or count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<AwsWafRuleGroupRulesDetails> rules);

        /**
         * <p>
         * Provides information about the rules attached to the rule group. These rules identify the web requests that
         * you want to allow, block, or count.
         * </p>
         * 
         * @param rules
         *        Provides information about the rules attached to the rule group. These rules identify the web requests
         *        that you want to allow, block, or count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(AwsWafRuleGroupRulesDetails... rules);

        /**
         * <p>
         * Provides information about the rules attached to the rule group. These rules identify the web requests that
         * you want to allow, block, or count.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #rules(List<AwsWafRuleGroupRulesDetails>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<AwsWafRuleGroupRulesDetails>)
         */
        Builder rules(Consumer<AwsWafRuleGroupRulesDetails.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String name;

        private String ruleGroupId;

        private List<AwsWafRuleGroupRulesDetails> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRuleGroupDetails model) {
            metricName(model.metricName);
            name(model.name);
            ruleGroupId(model.ruleGroupId);
            rules(model.rules);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleGroupId() {
            return ruleGroupId;
        }

        public final void setRuleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
        }

        @Override
        public final Builder ruleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        public final List<AwsWafRuleGroupRulesDetails.Builder> getRules() {
            List<AwsWafRuleGroupRulesDetails.Builder> result = AwsWafRuleGroupRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AwsWafRuleGroupRulesDetails.BuilderImpl> rules) {
            this.rules = AwsWafRuleGroupRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AwsWafRuleGroupRulesDetails> rules) {
            this.rules = AwsWafRuleGroupRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AwsWafRuleGroupRulesDetails... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AwsWafRuleGroupRulesDetails.Builder>... rules) {
            rules(Stream.of(rules).map(c -> AwsWafRuleGroupRulesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsWafRuleGroupDetails build() {
            return new AwsWafRuleGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
