/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status of the investigation into a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workflow implements SdkPojo, Serializable, ToCopyableBuilder<Workflow.Builder, Workflow> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Workflow::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private Workflow(BuilderImpl builder) {
        this.status = builder.status;
    }

    /**
     * <p>
     * The status of the investigation into the finding. The workflow status is specific to an individual finding. It
     * does not affect the generation of new findings. For example, setting the workflow status to
     * <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.
     * </p>
     * <p>
     * The allowed values are the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code> - The initial state of a finding, before it is reviewed.
     * </p>
     * <p>
     * Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to
     * <code>NEW</code> in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ComplianceStatus</code> changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when the
     * initial reviewer is not the resource owner, and needs intervention from the resource owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is needed.
     * The finding is no longer updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the investigation into the finding. The workflow status is specific to an individual
     *         finding. It does not affect the generation of new findings. For example, setting the workflow status to
     *         <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.</p>
     *         <p>
     *         The allowed values are the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code> - The initial state of a finding, before it is reviewed.
     *         </p>
     *         <p>
     *         Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to
     *         <code>NEW</code> in the following cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ComplianceStatus</code> changes from <code>PASSED</code> to either <code>WARNING</code>,
     *         <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used
     *         when the initial reviewer is not the resource owner, and needs intervention from the resource owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is
     *         needed. The finding is no longer updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.
     *         </p>
     *         </li>
     * @see WorkflowStatus
     */
    public final WorkflowStatus status() {
        return WorkflowStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the investigation into the finding. The workflow status is specific to an individual finding. It
     * does not affect the generation of new findings. For example, setting the workflow status to
     * <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.
     * </p>
     * <p>
     * The allowed values are the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code> - The initial state of a finding, before it is reviewed.
     * </p>
     * <p>
     * Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to
     * <code>NEW</code> in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ComplianceStatus</code> changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when the
     * initial reviewer is not the resource owner, and needs intervention from the resource owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is needed.
     * The finding is no longer updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the investigation into the finding. The workflow status is specific to an individual
     *         finding. It does not affect the generation of new findings. For example, setting the workflow status to
     *         <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.</p>
     *         <p>
     *         The allowed values are the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code> - The initial state of a finding, before it is reviewed.
     *         </p>
     *         <p>
     *         Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to
     *         <code>NEW</code> in the following cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ComplianceStatus</code> changes from <code>PASSED</code> to either <code>WARNING</code>,
     *         <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used
     *         when the initial reviewer is not the resource owner, and needs intervention from the resource owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is
     *         needed. The finding is no longer updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.
     *         </p>
     *         </li>
     * @see WorkflowStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workflow)) {
            return false;
        }
        Workflow other = (Workflow) obj;
        return Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Workflow").add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workflow, T> g) {
        return obj -> g.apply((Workflow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workflow> {
        /**
         * <p>
         * The status of the investigation into the finding. The workflow status is specific to an individual finding.
         * It does not affect the generation of new findings. For example, setting the workflow status to
         * <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.
         * </p>
         * <p>
         * The allowed values are the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code> - The initial state of a finding, before it is reviewed.
         * </p>
         * <p>
         * Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to
         * <code>NEW</code> in the following cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ComplianceStatus</code> changes from <code>PASSED</code> to either <code>WARNING</code>,
         * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when
         * the initial reviewer is not the resource owner, and needs intervention from the resource owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is
         * needed. The finding is no longer updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the investigation into the finding. The workflow status is specific to an individual
         *        finding. It does not affect the generation of new findings. For example, setting the workflow status
         *        to <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same
         *        issue.</p>
         *        <p>
         *        The allowed values are the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code> - The initial state of a finding, before it is reviewed.
         *        </p>
         *        <p>
         *        Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to
         *        <code>NEW</code> in the following cases:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ComplianceStatus</code> changes from <code>PASSED</code> to either <code>WARNING</code>,
         *        <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used
         *        when the initial reviewer is not the resource owner, and needs intervention from the resource owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action
         *        is needed. The finding is no longer updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.
         *        </p>
         *        </li>
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the investigation into the finding. The workflow status is specific to an individual finding.
         * It does not affect the generation of new findings. For example, setting the workflow status to
         * <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.
         * </p>
         * <p>
         * The allowed values are the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code> - The initial state of a finding, before it is reviewed.
         * </p>
         * <p>
         * Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to
         * <code>NEW</code> in the following cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ComplianceStatus</code> changes from <code>PASSED</code> to either <code>WARNING</code>,
         * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when
         * the initial reviewer is not the resource owner, and needs intervention from the resource owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is
         * needed. The finding is no longer updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the investigation into the finding. The workflow status is specific to an individual
         *        finding. It does not affect the generation of new findings. For example, setting the workflow status
         *        to <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same
         *        issue.</p>
         *        <p>
         *        The allowed values are the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code> - The initial state of a finding, before it is reviewed.
         *        </p>
         *        <p>
         *        Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to
         *        <code>NEW</code> in the following cases:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ComplianceStatus</code> changes from <code>PASSED</code> to either <code>WARNING</code>,
         *        <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used
         *        when the initial reviewer is not the resource owner, and needs intervention from the resource owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action
         *        is needed. The finding is no longer updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.
         *        </p>
         *        </li>
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(WorkflowStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Workflow model) {
            status(model.status);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Workflow build() {
            return new Workflow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
