/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Database Migration Service (DMS) endpoint. An endpoint provides connection, data store
 * type, and location information about your data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDmsEndpointDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDmsEndpointDetails.Builder, AwsDmsEndpointDetails> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(AwsDmsEndpointDetails::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(AwsDmsEndpointDetails::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(AwsDmsEndpointDetails::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointIdentifier").getter(getter(AwsDmsEndpointDetails::endpointIdentifier))
            .setter(setter(Builder::endpointIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIdentifier").build())
            .build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(AwsDmsEndpointDetails::endpointType)).setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineName").getter(getter(AwsDmsEndpointDetails::engineName)).setter(setter(Builder::engineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalId").getter(getter(AwsDmsEndpointDetails::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<String> EXTRA_CONNECTION_ATTRIBUTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtraConnectionAttributes").getter(getter(AwsDmsEndpointDetails::extraConnectionAttributes))
            .setter(setter(Builder::extraConnectionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraConnectionAttributes").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsDmsEndpointDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(AwsDmsEndpointDetails::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(AwsDmsEndpointDetails::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> SSL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslMode").getter(getter(AwsDmsEndpointDetails::sslMode)).setter(setter(Builder::sslMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(AwsDmsEndpointDetails::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            DATABASE_NAME_FIELD, ENDPOINT_ARN_FIELD, ENDPOINT_IDENTIFIER_FIELD, ENDPOINT_TYPE_FIELD, ENGINE_NAME_FIELD,
            EXTERNAL_ID_FIELD, EXTRA_CONNECTION_ATTRIBUTES_FIELD, KMS_KEY_ID_FIELD, PORT_FIELD, SERVER_NAME_FIELD,
            SSL_MODE_FIELD, USERNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateArn;

    private final String databaseName;

    private final String endpointArn;

    private final String endpointIdentifier;

    private final String endpointType;

    private final String engineName;

    private final String externalId;

    private final String extraConnectionAttributes;

    private final String kmsKeyId;

    private final Integer port;

    private final String serverName;

    private final String sslMode;

    private final String username;

    private AwsDmsEndpointDetails(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.databaseName = builder.databaseName;
        this.endpointArn = builder.endpointArn;
        this.endpointIdentifier = builder.endpointIdentifier;
        this.endpointType = builder.endpointType;
        this.engineName = builder.engineName;
        this.externalId = builder.externalId;
        this.extraConnectionAttributes = builder.extraConnectionAttributes;
        this.kmsKeyId = builder.kmsKeyId;
        this.port = builder.port;
        this.serverName = builder.serverName;
        this.sslMode = builder.sslMode;
        this.username = builder.username;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the SSL certificate that encrypts connections between the DMS endpoint and the
     * replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the SSL certificate that encrypts connections between the DMS endpoint
     *         and the replication instance.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The name of the endpoint database.
     * </p>
     * 
     * @return The name of the endpoint database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The database endpoint identifier.
     * </p>
     * 
     * @return The database endpoint identifier.
     */
    public final String endpointIdentifier() {
        return endpointIdentifier;
    }

    /**
     * <p>
     * The type of endpoint. Valid values are source and target.
     * </p>
     * 
     * @return The type of endpoint. Valid values are source and target.
     */
    public final String endpointType() {
        return endpointType;
    }

    /**
     * <p>
     * The type of engine for the endpoint, depending on the <code>EndpointType</code> value.
     * </p>
     * 
     * @return The type of engine for the endpoint, depending on the <code>EndpointType</code> value.
     */
    public final String engineName() {
        return engineName;
    }

    /**
     * <p>
     * A value that can be used for cross-account validation.
     * </p>
     * 
     * @return A value that can be used for cross-account validation.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * Additional attributes associated with the connection.
     * </p>
     * 
     * @return Additional attributes associated with the connection.
     */
    public final String extraConnectionAttributes() {
        return extraConnectionAttributes;
    }

    /**
     * <p>
     * An DMS key identifier that is used to encrypt the connection parameters for the endpoint. If you don't specify a
     * value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key. KMS creates the default
     * encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default
     * encryption key for each Amazon Web Services Region.
     * </p>
     * 
     * @return An DMS key identifier that is used to encrypt the connection parameters for the endpoint. If you don't
     *         specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key. KMS
     *         creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account
     *         has a different default encryption key for each Amazon Web Services Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The port used to access the endpoint.
     * </p>
     * 
     * @return The port used to access the endpoint.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The name of the server where the endpoint database resides.
     * </p>
     * 
     * @return The name of the server where the endpoint database resides.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The SSL mode used to connect to the endpoint. The default is none.
     * </p>
     * 
     * @return The SSL mode used to connect to the endpoint. The default is none.
     */
    public final String sslMode() {
        return sslMode;
    }

    /**
     * <p>
     * The user name to be used to log in to the endpoint database.
     * </p>
     * 
     * @return The user name to be used to log in to the endpoint database.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(engineName());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(extraConnectionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(sslMode());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDmsEndpointDetails)) {
            return false;
        }
        AwsDmsEndpointDetails other = (AwsDmsEndpointDetails) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(endpointArn(), other.endpointArn())
                && Objects.equals(endpointIdentifier(), other.endpointIdentifier())
                && Objects.equals(endpointType(), other.endpointType()) && Objects.equals(engineName(), other.engineName())
                && Objects.equals(externalId(), other.externalId())
                && Objects.equals(extraConnectionAttributes(), other.extraConnectionAttributes())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(port(), other.port())
                && Objects.equals(serverName(), other.serverName()) && Objects.equals(sslMode(), other.sslMode())
                && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDmsEndpointDetails").add("CertificateArn", certificateArn())
                .add("DatabaseName", databaseName()).add("EndpointArn", endpointArn())
                .add("EndpointIdentifier", endpointIdentifier()).add("EndpointType", endpointType())
                .add("EngineName", engineName()).add("ExternalId", externalId())
                .add("ExtraConnectionAttributes", extraConnectionAttributes()).add("KmsKeyId", kmsKeyId()).add("Port", port())
                .add("ServerName", serverName()).add("SslMode", sslMode()).add("Username", username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "EndpointIdentifier":
            return Optional.ofNullable(clazz.cast(endpointIdentifier()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointType()));
        case "EngineName":
            return Optional.ofNullable(clazz.cast(engineName()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "ExtraConnectionAttributes":
            return Optional.ofNullable(clazz.cast(extraConnectionAttributes()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "SslMode":
            return Optional.ofNullable(clazz.cast(sslMode()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDmsEndpointDetails, T> g) {
        return obj -> g.apply((AwsDmsEndpointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDmsEndpointDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the SSL certificate that encrypts connections between the DMS endpoint and
         * the replication instance.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) for the SSL certificate that encrypts connections between the DMS
         *        endpoint and the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The name of the endpoint database.
         * </p>
         * 
         * @param databaseName
         *        The name of the endpoint database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The database endpoint identifier.
         * </p>
         * 
         * @param endpointIdentifier
         *        The database endpoint identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIdentifier(String endpointIdentifier);

        /**
         * <p>
         * The type of endpoint. Valid values are source and target.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint. Valid values are source and target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of engine for the endpoint, depending on the <code>EndpointType</code> value.
         * </p>
         * 
         * @param engineName
         *        The type of engine for the endpoint, depending on the <code>EndpointType</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineName(String engineName);

        /**
         * <p>
         * A value that can be used for cross-account validation.
         * </p>
         * 
         * @param externalId
         *        A value that can be used for cross-account validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * Additional attributes associated with the connection.
         * </p>
         * 
         * @param extraConnectionAttributes
         *        Additional attributes associated with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraConnectionAttributes(String extraConnectionAttributes);

        /**
         * <p>
         * An DMS key identifier that is used to encrypt the connection parameters for the endpoint. If you don't
         * specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key. KMS
         * creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has
         * a different default encryption key for each Amazon Web Services Region.
         * </p>
         * 
         * @param kmsKeyId
         *        An DMS key identifier that is used to encrypt the connection parameters for the endpoint. If you don't
         *        specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.
         *        KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services
         *        account has a different default encryption key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The port used to access the endpoint.
         * </p>
         * 
         * @param port
         *        The port used to access the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The name of the server where the endpoint database resides.
         * </p>
         * 
         * @param serverName
         *        The name of the server where the endpoint database resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The SSL mode used to connect to the endpoint. The default is none.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the endpoint. The default is none.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslMode(String sslMode);

        /**
         * <p>
         * The user name to be used to log in to the endpoint database.
         * </p>
         * 
         * @param username
         *        The user name to be used to log in to the endpoint database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String databaseName;

        private String endpointArn;

        private String endpointIdentifier;

        private String endpointType;

        private String engineName;

        private String externalId;

        private String extraConnectionAttributes;

        private String kmsKeyId;

        private Integer port;

        private String serverName;

        private String sslMode;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDmsEndpointDetails model) {
            certificateArn(model.certificateArn);
            databaseName(model.databaseName);
            endpointArn(model.endpointArn);
            endpointIdentifier(model.endpointIdentifier);
            endpointType(model.endpointType);
            engineName(model.engineName);
            externalId(model.externalId);
            extraConnectionAttributes(model.extraConnectionAttributes);
            kmsKeyId(model.kmsKeyId);
            port(model.port);
            serverName(model.serverName);
            sslMode(model.sslMode);
            username(model.username);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getEndpointIdentifier() {
            return endpointIdentifier;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final String getEngineName() {
            return engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getExtraConnectionAttributes() {
            return extraConnectionAttributes;
        }

        public final void setExtraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
        }

        @Override
        public final Builder extraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getSslMode() {
            return sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public AwsDmsEndpointDetails build() {
            return new AwsDmsEndpointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
