/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an Amazon
 * EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder, AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails> {
    private static final SdkField<Integer> MAX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Max")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails::max))
            .setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final SdkField<Integer> MIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Min")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails::min))
            .setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_FIELD, MIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer max;

    private final Integer min;

    private AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails(BuilderImpl builder) {
        this.max = builder.max;
        this.min = builder.min;
    }

    /**
     * <p>
     * The maximum number of accelerators. If this parameter isn't specified, there's no maximum limit. To exclude
     * accelerator-enabled instance types, set <code>Max</code> to <code>0</code>.
     * </p>
     * 
     * @return The maximum number of accelerators. If this parameter isn't specified, there's no maximum limit. To
     *         exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code>.
     */
    public final Integer max() {
        return max;
    }

    /**
     * <p>
     * The minimum number of accelerators. If this parameter isn't specified, there's no minimum limit.
     * </p>
     * 
     * @return The minimum number of accelerators. If this parameter isn't specified, there's no minimum limit.
     */
    public final Integer min() {
        return min;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(min());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails other = (AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails) obj;
        return Objects.equals(max(), other.max()) && Objects.equals(min(), other.min());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails").add("Max", max())
                .add("Min", min()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        case "Min":
            return Optional.ofNullable(clazz.cast(min()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails> {
        /**
         * <p>
         * The maximum number of accelerators. If this parameter isn't specified, there's no maximum limit. To exclude
         * accelerator-enabled instance types, set <code>Max</code> to <code>0</code>.
         * </p>
         * 
         * @param max
         *        The maximum number of accelerators. If this parameter isn't specified, there's no maximum limit. To
         *        exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Integer max);

        /**
         * <p>
         * The minimum number of accelerators. If this parameter isn't specified, there's no minimum limit.
         * </p>
         * 
         * @param min
         *        The minimum number of accelerators. If this parameter isn't specified, there's no minimum limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Integer min);
    }

    static final class BuilderImpl implements Builder {
        private Integer max;

        private Integer min;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails model) {
            max(model.max);
            min(model.min);
        }

        public final Integer getMax() {
            return max;
        }

        public final void setMax(Integer max) {
            this.max = max;
        }

        @Override
        public final Builder max(Integer max) {
            this.max = max;
            return this;
        }

        public final Integer getMin() {
            return min;
        }

        public final void setMin(Integer min) {
            this.min = min;
        }

        @Override
        public final Builder min(Integer min) {
            this.min = min;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails build() {
            return new AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
