/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon ECR image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcrContainerImageDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcrContainerImageDetails.Builder, AwsEcrContainerImageDetails> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryId").getter(getter(AwsEcrContainerImageDetails::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryName").getter(getter(AwsEcrContainerImageDetails::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Architecture").getter(getter(AwsEcrContainerImageDetails::architecture))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()).build();

    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageDigest").getter(getter(AwsEcrContainerImageDetails::imageDigest))
            .setter(setter(Builder::imageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDigest").build()).build();

    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ImageTags")
            .getter(getter(AwsEcrContainerImageDetails::imageTags))
            .setter(setter(Builder::imageTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMAGE_PUBLISHED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImagePublishedAt").getter(getter(AwsEcrContainerImageDetails::imagePublishedAt))
            .setter(setter(Builder::imagePublishedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePublishedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, ARCHITECTURE_FIELD, IMAGE_DIGEST_FIELD, IMAGE_TAGS_FIELD, IMAGE_PUBLISHED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String registryId;

    private final String repositoryName;

    private final String architecture;

    private final String imageDigest;

    private final List<String> imageTags;

    private final String imagePublishedAt;

    private AwsEcrContainerImageDetails(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.architecture = builder.architecture;
        this.imageDigest = builder.imageDigest;
        this.imageTags = builder.imageTags;
        this.imagePublishedAt = builder.imagePublishedAt;
    }

    /**
     * <p>
     * The Amazon Web Services account identifier that is associated with the registry that the image belongs to.
     * </p>
     * 
     * @return The Amazon Web Services account identifier that is associated with the registry that the image belongs
     *         to.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository that the image belongs to.
     * </p>
     * 
     * @return The name of the repository that the image belongs to.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The architecture of the image. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arm64</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>i386</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x86_64</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The architecture of the image. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arm64</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>i386</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>x86_64</code>
     *         </p>
     *         </li>
     */
    public final String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The sha256 digest of the image manifest.
     * </p>
     * 
     * @return The sha256 digest of the image manifest.
     */
    public final String imageDigest() {
        return imageDigest;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageTags() {
        return imageTags != null && !(imageTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags that are associated with the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageTags} method.
     * </p>
     * 
     * @return The list of tags that are associated with the image.
     */
    public final List<String> imageTags() {
        return imageTags;
    }

    /**
     * <p>
     * The date and time when the image was pushed to the repository.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The date and time when the image was pushed to the repository.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String imagePublishedAt() {
        return imagePublishedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageTags() ? imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imagePublishedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrContainerImageDetails)) {
            return false;
        }
        AwsEcrContainerImageDetails other = (AwsEcrContainerImageDetails) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(architecture(), other.architecture()) && Objects.equals(imageDigest(), other.imageDigest())
                && hasImageTags() == other.hasImageTags() && Objects.equals(imageTags(), other.imageTags())
                && Objects.equals(imagePublishedAt(), other.imagePublishedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcrContainerImageDetails").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("Architecture", architecture()).add("ImageDigest", imageDigest())
                .add("ImageTags", hasImageTags() ? imageTags() : null).add("ImagePublishedAt", imagePublishedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "RepositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "ImageDigest":
            return Optional.ofNullable(clazz.cast(imageDigest()));
        case "ImageTags":
            return Optional.ofNullable(clazz.cast(imageTags()));
        case "ImagePublishedAt":
            return Optional.ofNullable(clazz.cast(imagePublishedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrContainerImageDetails, T> g) {
        return obj -> g.apply((AwsEcrContainerImageDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcrContainerImageDetails> {
        /**
         * <p>
         * The Amazon Web Services account identifier that is associated with the registry that the image belongs to.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account identifier that is associated with the registry that the image belongs
         *        to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository that the image belongs to.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that the image belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The architecture of the image. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arm64</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>i386</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>x86_64</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param architecture
         *        The architecture of the image. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arm64</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>i386</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>x86_64</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The sha256 digest of the image manifest.
         * </p>
         * 
         * @param imageDigest
         *        The sha256 digest of the image manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDigest(String imageDigest);

        /**
         * <p>
         * The list of tags that are associated with the image.
         * </p>
         * 
         * @param imageTags
         *        The list of tags that are associated with the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(Collection<String> imageTags);

        /**
         * <p>
         * The list of tags that are associated with the image.
         * </p>
         * 
         * @param imageTags
         *        The list of tags that are associated with the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(String... imageTags);

        /**
         * <p>
         * The date and time when the image was pushed to the repository.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param imagePublishedAt
         *        The date and time when the image was pushed to the repository.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePublishedAt(String imagePublishedAt);
    }

    static final class BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String architecture;

        private String imageDigest;

        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();

        private String imagePublishedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrContainerImageDetails model) {
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            architecture(model.architecture);
            imageDigest(model.imageDigest);
            imageTags(model.imageTags);
            imagePublishedAt(model.imagePublishedAt);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getImageDigest() {
            return imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final Collection<String> getImageTags() {
            if (imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return imageTags;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = NonEmptyStringListCopier.copy(imageTags);
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = NonEmptyStringListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String... imageTags) {
            imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final String getImagePublishedAt() {
            return imagePublishedAt;
        }

        public final void setImagePublishedAt(String imagePublishedAt) {
            this.imagePublishedAt = imagePublishedAt;
        }

        @Override
        public final Builder imagePublishedAt(String imagePublishedAt) {
            this.imagePublishedAt = imagePublishedAt;
            return this;
        }

        @Override
        public AwsEcrContainerImageDetails build() {
            return new AwsEcrContainerImageDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
