/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains attributes for the load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElbLoadBalancerAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElbLoadBalancerAttributes.Builder, AwsElbLoadBalancerAttributes> {
    private static final SdkField<AwsElbLoadBalancerAccessLog> ACCESS_LOG_FIELD = SdkField
            .<AwsElbLoadBalancerAccessLog> builder(MarshallingType.SDK_POJO).memberName("AccessLog")
            .getter(getter(AwsElbLoadBalancerAttributes::accessLog)).setter(setter(Builder::accessLog))
            .constructor(AwsElbLoadBalancerAccessLog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLog").build()).build();

    private static final SdkField<AwsElbLoadBalancerConnectionDraining> CONNECTION_DRAINING_FIELD = SdkField
            .<AwsElbLoadBalancerConnectionDraining> builder(MarshallingType.SDK_POJO).memberName("ConnectionDraining")
            .getter(getter(AwsElbLoadBalancerAttributes::connectionDraining)).setter(setter(Builder::connectionDraining))
            .constructor(AwsElbLoadBalancerConnectionDraining::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionDraining").build())
            .build();

    private static final SdkField<AwsElbLoadBalancerConnectionSettings> CONNECTION_SETTINGS_FIELD = SdkField
            .<AwsElbLoadBalancerConnectionSettings> builder(MarshallingType.SDK_POJO).memberName("ConnectionSettings")
            .getter(getter(AwsElbLoadBalancerAttributes::connectionSettings)).setter(setter(Builder::connectionSettings))
            .constructor(AwsElbLoadBalancerConnectionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionSettings").build())
            .build();

    private static final SdkField<AwsElbLoadBalancerCrossZoneLoadBalancing> CROSS_ZONE_LOAD_BALANCING_FIELD = SdkField
            .<AwsElbLoadBalancerCrossZoneLoadBalancing> builder(MarshallingType.SDK_POJO).memberName("CrossZoneLoadBalancing")
            .getter(getter(AwsElbLoadBalancerAttributes::crossZoneLoadBalancing)).setter(setter(Builder::crossZoneLoadBalancing))
            .constructor(AwsElbLoadBalancerCrossZoneLoadBalancing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossZoneLoadBalancing").build())
            .build();

    private static final SdkField<List<AwsElbLoadBalancerAdditionalAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<List<AwsElbLoadBalancerAdditionalAttribute>> builder(MarshallingType.LIST)
            .memberName("AdditionalAttributes")
            .getter(getter(AwsElbLoadBalancerAttributes::additionalAttributes))
            .setter(setter(Builder::additionalAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsElbLoadBalancerAdditionalAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsElbLoadBalancerAdditionalAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_FIELD,
            CONNECTION_DRAINING_FIELD, CONNECTION_SETTINGS_FIELD, CROSS_ZONE_LOAD_BALANCING_FIELD, ADDITIONAL_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsElbLoadBalancerAccessLog accessLog;

    private final AwsElbLoadBalancerConnectionDraining connectionDraining;

    private final AwsElbLoadBalancerConnectionSettings connectionSettings;

    private final AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing;

    private final List<AwsElbLoadBalancerAdditionalAttribute> additionalAttributes;

    private AwsElbLoadBalancerAttributes(BuilderImpl builder) {
        this.accessLog = builder.accessLog;
        this.connectionDraining = builder.connectionDraining;
        this.connectionSettings = builder.connectionSettings;
        this.crossZoneLoadBalancing = builder.crossZoneLoadBalancing;
        this.additionalAttributes = builder.additionalAttributes;
    }

    /**
     * <p>
     * Information about the access log configuration for the load balancer.
     * </p>
     * <p>
     * If the access log is enabled, the load balancer captures detailed information about all requests. It delivers the
     * information to a specified S3 bucket.
     * </p>
     * 
     * @return Information about the access log configuration for the load balancer.</p>
     *         <p>
     *         If the access log is enabled, the load balancer captures detailed information about all requests. It
     *         delivers the information to a specified S3 bucket.
     */
    public final AwsElbLoadBalancerAccessLog accessLog() {
        return accessLog;
    }

    /**
     * <p>
     * Information about the connection draining configuration for the load balancer.
     * </p>
     * <p>
     * If connection draining is enabled, the load balancer allows existing requests to complete before it shifts
     * traffic away from a deregistered or unhealthy instance.
     * </p>
     * 
     * @return Information about the connection draining configuration for the load balancer.</p>
     *         <p>
     *         If connection draining is enabled, the load balancer allows existing requests to complete before it
     *         shifts traffic away from a deregistered or unhealthy instance.
     */
    public final AwsElbLoadBalancerConnectionDraining connectionDraining() {
        return connectionDraining;
    }

    /**
     * <p>
     * Connection settings for the load balancer.
     * </p>
     * <p>
     * If an idle timeout is configured, the load balancer allows connections to remain idle for the specified duration.
     * When a connection is idle, no data is sent over the connection.
     * </p>
     * 
     * @return Connection settings for the load balancer.</p>
     *         <p>
     *         If an idle timeout is configured, the load balancer allows connections to remain idle for the specified
     *         duration. When a connection is idle, no data is sent over the connection.
     */
    public final AwsElbLoadBalancerConnectionSettings connectionSettings() {
        return connectionSettings;
    }

    /**
     * <p>
     * Cross-zone load balancing settings for the load balancer.
     * </p>
     * <p>
     * If cross-zone load balancing is enabled, the load balancer routes the request traffic evenly across all instances
     * regardless of the Availability Zones.
     * </p>
     * 
     * @return Cross-zone load balancing settings for the load balancer.</p>
     *         <p>
     *         If cross-zone load balancing is enabled, the load balancer routes the request traffic evenly across all
     *         instances regardless of the Availability Zones.
     */
    public final AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing() {
        return crossZoneLoadBalancing;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalAttributes() {
        return additionalAttributes != null && !(additionalAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any additional attributes for a load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributes} method.
     * </p>
     * 
     * @return Any additional attributes for a load balancer.
     */
    public final List<AwsElbLoadBalancerAdditionalAttribute> additionalAttributes() {
        return additionalAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessLog());
        hashCode = 31 * hashCode + Objects.hashCode(connectionDraining());
        hashCode = 31 * hashCode + Objects.hashCode(connectionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(crossZoneLoadBalancing());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAttributes() ? additionalAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerAttributes)) {
            return false;
        }
        AwsElbLoadBalancerAttributes other = (AwsElbLoadBalancerAttributes) obj;
        return Objects.equals(accessLog(), other.accessLog()) && Objects.equals(connectionDraining(), other.connectionDraining())
                && Objects.equals(connectionSettings(), other.connectionSettings())
                && Objects.equals(crossZoneLoadBalancing(), other.crossZoneLoadBalancing())
                && hasAdditionalAttributes() == other.hasAdditionalAttributes()
                && Objects.equals(additionalAttributes(), other.additionalAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElbLoadBalancerAttributes").add("AccessLog", accessLog())
                .add("ConnectionDraining", connectionDraining()).add("ConnectionSettings", connectionSettings())
                .add("CrossZoneLoadBalancing", crossZoneLoadBalancing())
                .add("AdditionalAttributes", hasAdditionalAttributes() ? additionalAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessLog":
            return Optional.ofNullable(clazz.cast(accessLog()));
        case "ConnectionDraining":
            return Optional.ofNullable(clazz.cast(connectionDraining()));
        case "ConnectionSettings":
            return Optional.ofNullable(clazz.cast(connectionSettings()));
        case "CrossZoneLoadBalancing":
            return Optional.ofNullable(clazz.cast(crossZoneLoadBalancing()));
        case "AdditionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerAttributes, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElbLoadBalancerAttributes> {
        /**
         * <p>
         * Information about the access log configuration for the load balancer.
         * </p>
         * <p>
         * If the access log is enabled, the load balancer captures detailed information about all requests. It delivers
         * the information to a specified S3 bucket.
         * </p>
         * 
         * @param accessLog
         *        Information about the access log configuration for the load balancer.</p>
         *        <p>
         *        If the access log is enabled, the load balancer captures detailed information about all requests. It
         *        delivers the information to a specified S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLog(AwsElbLoadBalancerAccessLog accessLog);

        /**
         * <p>
         * Information about the access log configuration for the load balancer.
         * </p>
         * <p>
         * If the access log is enabled, the load balancer captures detailed information about all requests. It delivers
         * the information to a specified S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsElbLoadBalancerAccessLog.Builder}
         * avoiding the need to create one manually via {@link AwsElbLoadBalancerAccessLog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbLoadBalancerAccessLog.Builder#build()} is called
         * immediately and its result is passed to {@link #accessLog(AwsElbLoadBalancerAccessLog)}.
         * 
         * @param accessLog
         *        a consumer that will call methods on {@link AwsElbLoadBalancerAccessLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLog(AwsElbLoadBalancerAccessLog)
         */
        default Builder accessLog(Consumer<AwsElbLoadBalancerAccessLog.Builder> accessLog) {
            return accessLog(AwsElbLoadBalancerAccessLog.builder().applyMutation(accessLog).build());
        }

        /**
         * <p>
         * Information about the connection draining configuration for the load balancer.
         * </p>
         * <p>
         * If connection draining is enabled, the load balancer allows existing requests to complete before it shifts
         * traffic away from a deregistered or unhealthy instance.
         * </p>
         * 
         * @param connectionDraining
         *        Information about the connection draining configuration for the load balancer.</p>
         *        <p>
         *        If connection draining is enabled, the load balancer allows existing requests to complete before it
         *        shifts traffic away from a deregistered or unhealthy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionDraining(AwsElbLoadBalancerConnectionDraining connectionDraining);

        /**
         * <p>
         * Information about the connection draining configuration for the load balancer.
         * </p>
         * <p>
         * If connection draining is enabled, the load balancer allows existing requests to complete before it shifts
         * traffic away from a deregistered or unhealthy instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsElbLoadBalancerConnectionDraining.Builder} avoiding the need to create one manually via
         * {@link AwsElbLoadBalancerConnectionDraining#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbLoadBalancerConnectionDraining.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionDraining(AwsElbLoadBalancerConnectionDraining)}.
         * 
         * @param connectionDraining
         *        a consumer that will call methods on {@link AwsElbLoadBalancerConnectionDraining.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionDraining(AwsElbLoadBalancerConnectionDraining)
         */
        default Builder connectionDraining(Consumer<AwsElbLoadBalancerConnectionDraining.Builder> connectionDraining) {
            return connectionDraining(AwsElbLoadBalancerConnectionDraining.builder().applyMutation(connectionDraining).build());
        }

        /**
         * <p>
         * Connection settings for the load balancer.
         * </p>
         * <p>
         * If an idle timeout is configured, the load balancer allows connections to remain idle for the specified
         * duration. When a connection is idle, no data is sent over the connection.
         * </p>
         * 
         * @param connectionSettings
         *        Connection settings for the load balancer.</p>
         *        <p>
         *        If an idle timeout is configured, the load balancer allows connections to remain idle for the
         *        specified duration. When a connection is idle, no data is sent over the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionSettings(AwsElbLoadBalancerConnectionSettings connectionSettings);

        /**
         * <p>
         * Connection settings for the load balancer.
         * </p>
         * <p>
         * If an idle timeout is configured, the load balancer allows connections to remain idle for the specified
         * duration. When a connection is idle, no data is sent over the connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsElbLoadBalancerConnectionSettings.Builder} avoiding the need to create one manually via
         * {@link AwsElbLoadBalancerConnectionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbLoadBalancerConnectionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionSettings(AwsElbLoadBalancerConnectionSettings)}.
         * 
         * @param connectionSettings
         *        a consumer that will call methods on {@link AwsElbLoadBalancerConnectionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionSettings(AwsElbLoadBalancerConnectionSettings)
         */
        default Builder connectionSettings(Consumer<AwsElbLoadBalancerConnectionSettings.Builder> connectionSettings) {
            return connectionSettings(AwsElbLoadBalancerConnectionSettings.builder().applyMutation(connectionSettings).build());
        }

        /**
         * <p>
         * Cross-zone load balancing settings for the load balancer.
         * </p>
         * <p>
         * If cross-zone load balancing is enabled, the load balancer routes the request traffic evenly across all
         * instances regardless of the Availability Zones.
         * </p>
         * 
         * @param crossZoneLoadBalancing
         *        Cross-zone load balancing settings for the load balancer.</p>
         *        <p>
         *        If cross-zone load balancing is enabled, the load balancer routes the request traffic evenly across
         *        all instances regardless of the Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing);

        /**
         * <p>
         * Cross-zone load balancing settings for the load balancer.
         * </p>
         * <p>
         * If cross-zone load balancing is enabled, the load balancer routes the request traffic evenly across all
         * instances regardless of the Availability Zones.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsElbLoadBalancerCrossZoneLoadBalancing.Builder} avoiding the need to create one manually via
         * {@link AwsElbLoadBalancerCrossZoneLoadBalancing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElbLoadBalancerCrossZoneLoadBalancing.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #crossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing)}.
         * 
         * @param crossZoneLoadBalancing
         *        a consumer that will call methods on {@link AwsElbLoadBalancerCrossZoneLoadBalancing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing)
         */
        default Builder crossZoneLoadBalancing(Consumer<AwsElbLoadBalancerCrossZoneLoadBalancing.Builder> crossZoneLoadBalancing) {
            return crossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing.builder()
                    .applyMutation(crossZoneLoadBalancing).build());
        }

        /**
         * <p>
         * Any additional attributes for a load balancer.
         * </p>
         * 
         * @param additionalAttributes
         *        Any additional attributes for a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(Collection<AwsElbLoadBalancerAdditionalAttribute> additionalAttributes);

        /**
         * <p>
         * Any additional attributes for a load balancer.
         * </p>
         * 
         * @param additionalAttributes
         *        Any additional attributes for a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(AwsElbLoadBalancerAdditionalAttribute... additionalAttributes);

        /**
         * <p>
         * Any additional attributes for a load balancer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAdditionalAttribute.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAdditionalAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAdditionalAttribute.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #additionalAttributes(List<AwsElbLoadBalancerAdditionalAttribute>)}.
         * 
         * @param additionalAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAdditionalAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAttributes(java.util.Collection<AwsElbLoadBalancerAdditionalAttribute>)
         */
        Builder additionalAttributes(Consumer<AwsElbLoadBalancerAdditionalAttribute.Builder>... additionalAttributes);
    }

    static final class BuilderImpl implements Builder {
        private AwsElbLoadBalancerAccessLog accessLog;

        private AwsElbLoadBalancerConnectionDraining connectionDraining;

        private AwsElbLoadBalancerConnectionSettings connectionSettings;

        private AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing;

        private List<AwsElbLoadBalancerAdditionalAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerAttributes model) {
            accessLog(model.accessLog);
            connectionDraining(model.connectionDraining);
            connectionSettings(model.connectionSettings);
            crossZoneLoadBalancing(model.crossZoneLoadBalancing);
            additionalAttributes(model.additionalAttributes);
        }

        public final AwsElbLoadBalancerAccessLog.Builder getAccessLog() {
            return accessLog != null ? accessLog.toBuilder() : null;
        }

        public final void setAccessLog(AwsElbLoadBalancerAccessLog.BuilderImpl accessLog) {
            this.accessLog = accessLog != null ? accessLog.build() : null;
        }

        @Override
        public final Builder accessLog(AwsElbLoadBalancerAccessLog accessLog) {
            this.accessLog = accessLog;
            return this;
        }

        public final AwsElbLoadBalancerConnectionDraining.Builder getConnectionDraining() {
            return connectionDraining != null ? connectionDraining.toBuilder() : null;
        }

        public final void setConnectionDraining(AwsElbLoadBalancerConnectionDraining.BuilderImpl connectionDraining) {
            this.connectionDraining = connectionDraining != null ? connectionDraining.build() : null;
        }

        @Override
        public final Builder connectionDraining(AwsElbLoadBalancerConnectionDraining connectionDraining) {
            this.connectionDraining = connectionDraining;
            return this;
        }

        public final AwsElbLoadBalancerConnectionSettings.Builder getConnectionSettings() {
            return connectionSettings != null ? connectionSettings.toBuilder() : null;
        }

        public final void setConnectionSettings(AwsElbLoadBalancerConnectionSettings.BuilderImpl connectionSettings) {
            this.connectionSettings = connectionSettings != null ? connectionSettings.build() : null;
        }

        @Override
        public final Builder connectionSettings(AwsElbLoadBalancerConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
            return this;
        }

        public final AwsElbLoadBalancerCrossZoneLoadBalancing.Builder getCrossZoneLoadBalancing() {
            return crossZoneLoadBalancing != null ? crossZoneLoadBalancing.toBuilder() : null;
        }

        public final void setCrossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing.BuilderImpl crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing != null ? crossZoneLoadBalancing.build() : null;
        }

        @Override
        public final Builder crossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing;
            return this;
        }

        public final List<AwsElbLoadBalancerAdditionalAttribute.Builder> getAdditionalAttributes() {
            List<AwsElbLoadBalancerAdditionalAttribute.Builder> result = AwsElbLoadBalancerAdditionalAttributeListCopier
                    .copyToBuilder(this.additionalAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAttributes(
                Collection<AwsElbLoadBalancerAdditionalAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = AwsElbLoadBalancerAdditionalAttributeListCopier.copyFromBuilder(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributes(Collection<AwsElbLoadBalancerAdditionalAttribute> additionalAttributes) {
            this.additionalAttributes = AwsElbLoadBalancerAdditionalAttributeListCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AwsElbLoadBalancerAdditionalAttribute... additionalAttributes) {
            additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<AwsElbLoadBalancerAdditionalAttribute.Builder>... additionalAttributes) {
            additionalAttributes(Stream.of(additionalAttributes)
                    .map(c -> AwsElbLoadBalancerAdditionalAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsElbLoadBalancerAttributes build() {
            return new AwsElbLoadBalancerAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
