/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the health checks that are conducted on the load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElbLoadBalancerHealthCheck implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElbLoadBalancerHealthCheck.Builder, AwsElbLoadBalancerHealthCheck> {
    private static final SdkField<Integer> HEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthyThreshold").getter(getter(AwsElbLoadBalancerHealthCheck::healthyThreshold))
            .setter(setter(Builder::healthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThreshold").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Interval").getter(getter(AwsElbLoadBalancerHealthCheck::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(AwsElbLoadBalancerHealthCheck::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(AwsElbLoadBalancerHealthCheck::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UnhealthyThreshold").getter(getter(AwsElbLoadBalancerHealthCheck::unhealthyThreshold))
            .setter(setter(Builder::unhealthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThreshold").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTHY_THRESHOLD_FIELD,
            INTERVAL_FIELD, TARGET_FIELD, TIMEOUT_FIELD, UNHEALTHY_THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer healthyThreshold;

    private final Integer interval;

    private final String target;

    private final Integer timeout;

    private final Integer unhealthyThreshold;

    private AwsElbLoadBalancerHealthCheck(BuilderImpl builder) {
        this.healthyThreshold = builder.healthyThreshold;
        this.interval = builder.interval;
        this.target = builder.target;
        this.timeout = builder.timeout;
        this.unhealthyThreshold = builder.unhealthyThreshold;
    }

    /**
     * <p>
     * The number of consecutive health check successes required before the instance is moved to the Healthy state.
     * </p>
     * 
     * @return The number of consecutive health check successes required before the instance is moved to the Healthy
     *         state.
     */
    public final Integer healthyThreshold() {
        return healthyThreshold;
    }

    /**
     * <p>
     * The approximate interval, in seconds, between health checks of an individual instance.
     * </p>
     * 
     * @return The approximate interval, in seconds, between health checks of an individual instance.
     */
    public final Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The instance that is being checked. The target specifies the protocol and port. The available protocols are TCP,
     * SSL, HTTP, and HTTPS. The range of valid ports is 1 through 65535.
     * </p>
     * <p>
     * For the HTTP and HTTPS protocols, the target also specifies the ping path.
     * </p>
     * <p>
     * For the TCP protocol, the target is specified as <code>TCP: <i>&lt;port&gt;</i> </code>.
     * </p>
     * <p>
     * For the SSL protocol, the target is specified as <code>SSL.<i>&lt;port&gt;</i> </code>.
     * </p>
     * <p>
     * For the HTTP and HTTPS protocols, the target is specified as
     * <code> <i>&lt;protocol&gt;</i>:<i>&lt;port&gt;</i>/<i>&lt;path to ping&gt;</i> </code>.
     * </p>
     * 
     * @return The instance that is being checked. The target specifies the protocol and port. The available protocols
     *         are TCP, SSL, HTTP, and HTTPS. The range of valid ports is 1 through 65535.</p>
     *         <p>
     *         For the HTTP and HTTPS protocols, the target also specifies the ping path.
     *         </p>
     *         <p>
     *         For the TCP protocol, the target is specified as <code>TCP: <i>&lt;port&gt;</i> </code>.
     *         </p>
     *         <p>
     *         For the SSL protocol, the target is specified as <code>SSL.<i>&lt;port&gt;</i> </code>.
     *         </p>
     *         <p>
     *         For the HTTP and HTTPS protocols, the target is specified as
     *         <code> <i>&lt;protocol&gt;</i>:<i>&lt;port&gt;</i>/<i>&lt;path to ping&gt;</i> </code>.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The amount of time, in seconds, during which no response means a failed health check.
     * </p>
     * 
     * @return The amount of time, in seconds, during which no response means a failed health check.
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The number of consecutive health check failures that must occur before the instance is moved to the Unhealthy
     * state.
     * </p>
     * 
     * @return The number of consecutive health check failures that must occur before the instance is moved to the
     *         Unhealthy state.
     */
    public final Integer unhealthyThreshold() {
        return unhealthyThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerHealthCheck)) {
            return false;
        }
        AwsElbLoadBalancerHealthCheck other = (AwsElbLoadBalancerHealthCheck) obj;
        return Objects.equals(healthyThreshold(), other.healthyThreshold()) && Objects.equals(interval(), other.interval())
                && Objects.equals(target(), other.target()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(unhealthyThreshold(), other.unhealthyThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElbLoadBalancerHealthCheck").add("HealthyThreshold", healthyThreshold())
                .add("Interval", interval()).add("Target", target()).add("Timeout", timeout())
                .add("UnhealthyThreshold", unhealthyThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthyThreshold":
            return Optional.ofNullable(clazz.cast(healthyThreshold()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "UnhealthyThreshold":
            return Optional.ofNullable(clazz.cast(unhealthyThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerHealthCheck, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerHealthCheck) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElbLoadBalancerHealthCheck> {
        /**
         * <p>
         * The number of consecutive health check successes required before the instance is moved to the Healthy state.
         * </p>
         * 
         * @param healthyThreshold
         *        The number of consecutive health check successes required before the instance is moved to the Healthy
         *        state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyThreshold(Integer healthyThreshold);

        /**
         * <p>
         * The approximate interval, in seconds, between health checks of an individual instance.
         * </p>
         * 
         * @param interval
         *        The approximate interval, in seconds, between health checks of an individual instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The instance that is being checked. The target specifies the protocol and port. The available protocols are
         * TCP, SSL, HTTP, and HTTPS. The range of valid ports is 1 through 65535.
         * </p>
         * <p>
         * For the HTTP and HTTPS protocols, the target also specifies the ping path.
         * </p>
         * <p>
         * For the TCP protocol, the target is specified as <code>TCP: <i>&lt;port&gt;</i> </code>.
         * </p>
         * <p>
         * For the SSL protocol, the target is specified as <code>SSL.<i>&lt;port&gt;</i> </code>.
         * </p>
         * <p>
         * For the HTTP and HTTPS protocols, the target is specified as
         * <code> <i>&lt;protocol&gt;</i>:<i>&lt;port&gt;</i>/<i>&lt;path to ping&gt;</i> </code>.
         * </p>
         * 
         * @param target
         *        The instance that is being checked. The target specifies the protocol and port. The available
         *        protocols are TCP, SSL, HTTP, and HTTPS. The range of valid ports is 1 through 65535.</p>
         *        <p>
         *        For the HTTP and HTTPS protocols, the target also specifies the ping path.
         *        </p>
         *        <p>
         *        For the TCP protocol, the target is specified as <code>TCP: <i>&lt;port&gt;</i> </code>.
         *        </p>
         *        <p>
         *        For the SSL protocol, the target is specified as <code>SSL.<i>&lt;port&gt;</i> </code>.
         *        </p>
         *        <p>
         *        For the HTTP and HTTPS protocols, the target is specified as
         *        <code> <i>&lt;protocol&gt;</i>:<i>&lt;port&gt;</i>/<i>&lt;path to ping&gt;</i> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The amount of time, in seconds, during which no response means a failed health check.
         * </p>
         * 
         * @param timeout
         *        The amount of time, in seconds, during which no response means a failed health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The number of consecutive health check failures that must occur before the instance is moved to the Unhealthy
         * state.
         * </p>
         * 
         * @param unhealthyThreshold
         *        The number of consecutive health check failures that must occur before the instance is moved to the
         *        Unhealthy state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyThreshold(Integer unhealthyThreshold);
    }

    static final class BuilderImpl implements Builder {
        private Integer healthyThreshold;

        private Integer interval;

        private String target;

        private Integer timeout;

        private Integer unhealthyThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerHealthCheck model) {
            healthyThreshold(model.healthyThreshold);
            interval(model.interval);
            target(model.target);
            timeout(model.timeout);
            unhealthyThreshold(model.unhealthyThreshold);
        }

        public final Integer getHealthyThreshold() {
            return healthyThreshold;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        @Override
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public final Integer getInterval() {
            return interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Integer getUnhealthyThreshold() {
            return unhealthyThreshold;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        @Override
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        @Override
        public AwsElbLoadBalancerHealthCheck build() {
            return new AwsElbLoadBalancerHealthCheck(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
