/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon RDS DB cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbClusterDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbClusterDetails.Builder, AwsRdsDbClusterDetails> {
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(AwsRdsDbClusterDetails::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(AwsRdsDbClusterDetails::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(AwsRdsDbClusterDetails::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(AwsRdsDbClusterDetails::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRdsDbClusterDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(AwsRdsDbClusterDetails::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> READER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReaderEndpoint").getter(getter(AwsRdsDbClusterDetails::readerEndpoint))
            .setter(setter(Builder::readerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderEndpoint").build()).build();

    private static final SdkField<List<String>> CUSTOM_ENDPOINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomEndpoints")
            .getter(getter(AwsRdsDbClusterDetails::customEndpoints))
            .setter(setter(Builder::customEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAz").getter(getter(AwsRdsDbClusterDetails::multiAz)).setter(setter(Builder::multiAz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAz").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(AwsRdsDbClusterDetails::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(AwsRdsDbClusterDetails::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(AwsRdsDbClusterDetails::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(AwsRdsDbClusterDetails::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(AwsRdsDbClusterDetails::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(AwsRdsDbClusterDetails::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<List<String>> READ_REPLICA_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadReplicaIdentifiers")
            .getter(getter(AwsRdsDbClusterDetails::readReplicaIdentifiers))
            .setter(setter(Builder::readReplicaIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsRdsDbInstanceVpcSecurityGroup>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<AwsRdsDbInstanceVpcSecurityGroup>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(AwsRdsDbClusterDetails::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbInstanceVpcSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbInstanceVpcSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId").getter(getter(AwsRdsDbClusterDetails::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(AwsRdsDbClusterDetails::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsRdsDbClusterDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> DB_CLUSTER_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterResourceId").getter(getter(AwsRdsDbClusterDetails::dbClusterResourceId))
            .setter(setter(Builder::dbClusterResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterResourceId").build())
            .build();

    private static final SdkField<List<AwsRdsDbClusterAssociatedRole>> ASSOCIATED_ROLES_FIELD = SdkField
            .<List<AwsRdsDbClusterAssociatedRole>> builder(MarshallingType.LIST)
            .memberName("AssociatedRoles")
            .getter(getter(AwsRdsDbClusterDetails::associatedRoles))
            .setter(setter(Builder::associatedRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbClusterAssociatedRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbClusterAssociatedRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterCreateTime").getter(getter(AwsRdsDbClusterDetails::clusterCreateTime))
            .setter(setter(Builder::clusterCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()).build();

    private static final SdkField<List<String>> ENABLED_CLOUD_WATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledCloudWatchLogsExports")
            .getter(getter(AwsRdsDbClusterDetails::enabledCloudWatchLogsExports))
            .setter(setter(Builder::enabledCloudWatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudWatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineMode").getter(getter(AwsRdsDbClusterDetails::engineMode)).setter(setter(Builder::engineMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(AwsRdsDbClusterDetails::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Boolean> HTTP_ENDPOINT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HttpEndpointEnabled").getter(getter(AwsRdsDbClusterDetails::httpEndpointEnabled))
            .setter(setter(Builder::httpEndpointEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpointEnabled").build())
            .build();

    private static final SdkField<String> ACTIVITY_STREAM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivityStreamStatus").getter(getter(AwsRdsDbClusterDetails::activityStreamStatus))
            .setter(setter(Builder::activityStreamStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStreamStatus").build())
            .build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(AwsRdsDbClusterDetails::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Boolean> CROSS_ACCOUNT_CLONE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrossAccountClone").getter(getter(AwsRdsDbClusterDetails::crossAccountClone))
            .setter(setter(Builder::crossAccountClone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountClone").build()).build();

    private static final SdkField<List<AwsRdsDbDomainMembership>> DOMAIN_MEMBERSHIPS_FIELD = SdkField
            .<List<AwsRdsDbDomainMembership>> builder(MarshallingType.LIST)
            .memberName("DomainMemberships")
            .getter(getter(AwsRdsDbClusterDetails::domainMemberships))
            .setter(setter(Builder::domainMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbDomainMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbDomainMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterParameterGroup").getter(getter(AwsRdsDbClusterDetails::dbClusterParameterGroup))
            .setter(setter(Builder::dbClusterParameterGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterParameterGroup").build())
            .build();

    private static final SdkField<String> DB_SUBNET_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbSubnetGroup").getter(getter(AwsRdsDbClusterDetails::dbSubnetGroup))
            .setter(setter(Builder::dbSubnetGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSubnetGroup").build()).build();

    private static final SdkField<List<AwsRdsDbClusterOptionGroupMembership>> DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD = SdkField
            .<List<AwsRdsDbClusterOptionGroupMembership>> builder(MarshallingType.LIST)
            .memberName("DbClusterOptionGroupMemberships")
            .getter(getter(AwsRdsDbClusterDetails::dbClusterOptionGroupMemberships))
            .setter(setter(Builder::dbClusterOptionGroupMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterOptionGroupMemberships")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbClusterOptionGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbClusterOptionGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterIdentifier").getter(getter(AwsRdsDbClusterDetails::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterIdentifier").build())
            .build();

    private static final SdkField<List<AwsRdsDbClusterMember>> DB_CLUSTER_MEMBERS_FIELD = SdkField
            .<List<AwsRdsDbClusterMember>> builder(MarshallingType.LIST)
            .memberName("DbClusterMembers")
            .getter(getter(AwsRdsDbClusterDetails::dbClusterMembers))
            .setter(setter(Builder::dbClusterMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbClusterMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbClusterMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IamDatabaseAuthenticationEnabled")
            .getter(getter(AwsRdsDbClusterDetails::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(AwsRdsDbClusterDetails::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_STORAGE_FIELD,
            AVAILABILITY_ZONES_FIELD, BACKUP_RETENTION_PERIOD_FIELD, DATABASE_NAME_FIELD, STATUS_FIELD, ENDPOINT_FIELD,
            READER_ENDPOINT_FIELD, CUSTOM_ENDPOINTS_FIELD, MULTI_AZ_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, PORT_FIELD,
            MASTER_USERNAME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            READ_REPLICA_IDENTIFIERS_FIELD, VPC_SECURITY_GROUPS_FIELD, HOSTED_ZONE_ID_FIELD, STORAGE_ENCRYPTED_FIELD,
            KMS_KEY_ID_FIELD, DB_CLUSTER_RESOURCE_ID_FIELD, ASSOCIATED_ROLES_FIELD, CLUSTER_CREATE_TIME_FIELD,
            ENABLED_CLOUD_WATCH_LOGS_EXPORTS_FIELD, ENGINE_MODE_FIELD, DELETION_PROTECTION_FIELD, HTTP_ENDPOINT_ENABLED_FIELD,
            ACTIVITY_STREAM_STATUS_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, CROSS_ACCOUNT_CLONE_FIELD, DOMAIN_MEMBERSHIPS_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_FIELD, DB_SUBNET_GROUP_FIELD, DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD,
            DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_MEMBERS_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer allocatedStorage;

    private final List<String> availabilityZones;

    private final Integer backupRetentionPeriod;

    private final String databaseName;

    private final String status;

    private final String endpoint;

    private final String readerEndpoint;

    private final List<String> customEndpoints;

    private final Boolean multiAz;

    private final String engine;

    private final String engineVersion;

    private final Integer port;

    private final String masterUsername;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final List<String> readReplicaIdentifiers;

    private final List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups;

    private final String hostedZoneId;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final String dbClusterResourceId;

    private final List<AwsRdsDbClusterAssociatedRole> associatedRoles;

    private final String clusterCreateTime;

    private final List<String> enabledCloudWatchLogsExports;

    private final String engineMode;

    private final Boolean deletionProtection;

    private final Boolean httpEndpointEnabled;

    private final String activityStreamStatus;

    private final Boolean copyTagsToSnapshot;

    private final Boolean crossAccountClone;

    private final List<AwsRdsDbDomainMembership> domainMemberships;

    private final String dbClusterParameterGroup;

    private final String dbSubnetGroup;

    private final List<AwsRdsDbClusterOptionGroupMembership> dbClusterOptionGroupMemberships;

    private final String dbClusterIdentifier;

    private final List<AwsRdsDbClusterMember> dbClusterMembers;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private final Boolean autoMinorVersionUpgrade;

    private AwsRdsDbClusterDetails(BuilderImpl builder) {
        this.allocatedStorage = builder.allocatedStorage;
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.databaseName = builder.databaseName;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.customEndpoints = builder.customEndpoints;
        this.multiAz = builder.multiAz;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.readReplicaIdentifiers = builder.readReplicaIdentifiers;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.hostedZoneId = builder.hostedZoneId;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.associatedRoles = builder.associatedRoles;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.enabledCloudWatchLogsExports = builder.enabledCloudWatchLogsExports;
        this.engineMode = builder.engineMode;
        this.deletionProtection = builder.deletionProtection;
        this.httpEndpointEnabled = builder.httpEndpointEnabled;
        this.activityStreamStatus = builder.activityStreamStatus;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.crossAccountClone = builder.crossAccountClone;
        this.domainMemberships = builder.domainMemberships;
        this.dbClusterParameterGroup = builder.dbClusterParameterGroup;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.dbClusterOptionGroupMemberships = builder.dbClusterOptionGroupMemberships;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterMembers = builder.dbClusterMembers;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * For all database engines except Aurora, specifies the allocated storage size in gibibytes (GiB).
     * </p>
     * 
     * @return For all database engines except Aurora, specifies the allocated storage size in gibibytes (GiB).
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of Availability Zones (AZs) where instances in the DB cluster can be created.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The number of days for which automated backups are retained.
     * </p>
     * 
     * @return The number of days for which automated backups are retained.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @return The name of the database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The current status of this DB cluster.
     * </p>
     * 
     * @return The current status of this DB cluster.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The connection endpoint for the primary instance of the DB cluster.
     * </p>
     * 
     * @return The connection endpoint for the primary instance of the DB cluster.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The reader endpoint for the DB cluster.
     * </p>
     * 
     * @return The reader endpoint for the DB cluster.
     */
    public final String readerEndpoint() {
        return readerEndpoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomEndpoints() {
        return customEndpoints != null && !(customEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom endpoints for the DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomEndpoints} method.
     * </p>
     * 
     * @return A list of custom endpoints for the DB cluster.
     */
    public final List<String> customEndpoints() {
        return customEndpoints;
    }

    /**
     * <p>
     * Whether the DB cluster has instances in multiple Availability Zones.
     * </p>
     * 
     * @return Whether the DB cluster has instances in multiple Availability Zones.
     */
    public final Boolean multiAz() {
        return multiAz;
    }

    /**
     * <p>
     * The name of the database engine to use for this DB cluster. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aurora</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-mysql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-postgresql</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the database engine to use for this DB cluster. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>aurora</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-mysql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-postgresql</code>
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the database engine to use.
     * </p>
     * 
     * @return The version number of the database engine to use.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The port number on which the DB instances in the DB cluster accept connections.
     * </p>
     * 
     * @return The port number on which the DB instances in the DB cluster accept connections.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The name of the master user for the DB cluster.
     * </p>
     * 
     * @return The name of the master user for the DB cluster.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The range of time each day when automated backups are created, if automated backups are enabled.
     * </p>
     * <p>
     * Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.
     * </p>
     * 
     * @return The range of time each day when automated backups are created, if automated backups are enabled.</p>
     *         <p>
     *         Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.
     * </p>
     * <p>
     * For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|<code>fri</code>|
     * <code>sat</code>|<code>sun</code>.
     * </p>
     * <p>
     * For example, <code>sun:09:32-sun:10:02</code>.
     * </p>
     * 
     * @return The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.
     *         </p>
     *         <p>
     *         For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|
     *         <code>fri</code>|<code>sat</code>|<code>sun</code>.
     *         </p>
     *         <p>
     *         For example, <code>sun:09:32-sun:10:02</code>.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadReplicaIdentifiers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReadReplicaIdentifiers() {
        return readReplicaIdentifiers != null && !(readReplicaIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the read replicas that are associated with this DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadReplicaIdentifiers} method.
     * </p>
     * 
     * @return The identifiers of the read replicas that are associated with this DB cluster.
     */
    public final List<String> readReplicaIdentifiers() {
        return readReplicaIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups that the DB cluster belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroups} method.
     * </p>
     * 
     * @return A list of VPC security groups that the DB cluster belongs to.
     */
    public final List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    /**
     * <p>
     * Specifies the identifier that Amazon Route 53 assigns when you create a hosted zone.
     * </p>
     * 
     * @return Specifies the identifier that Amazon Route 53 assigns when you create a hosted zone.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * Whether the DB cluster is encrypted.
     * </p>
     * 
     * @return Whether the DB cluster is encrypted.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
     * </p>
     * 
     * @return The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The identifier of the DB cluster. The identifier must be unique within each Amazon Web Services Region and is
     * immutable.
     * </p>
     * 
     * @return The identifier of the DB cluster. The identifier must be unique within each Amazon Web Services Region
     *         and is immutable.
     */
    public final String dbClusterResourceId() {
        return dbClusterResourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedRoles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedRoles() {
        return associatedRoles != null && !(associatedRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the IAM roles that are associated with the DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedRoles} method.
     * </p>
     * 
     * @return A list of the IAM roles that are associated with the DB cluster.
     */
    public final List<AwsRdsDbClusterAssociatedRole> associatedRoles() {
        return associatedRoles;
    }

    /**
     * <p>
     * Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String clusterCreateTime() {
        return clusterCreateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledCloudWatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledCloudWatchLogsExports() {
        return enabledCloudWatchLogsExports != null && !(enabledCloudWatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledCloudWatchLogsExports} method.
     * </p>
     * 
     * @return A list of log types that this DB cluster is configured to export to CloudWatch Logs.
     */
    public final List<String> enabledCloudWatchLogsExports() {
        return enabledCloudWatchLogsExports;
    }

    /**
     * <p>
     * The database engine mode of the DB cluster.Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>global</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>multimaster</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>parallelquery</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>provisioned</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>serverless</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The database engine mode of the DB cluster.Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>global</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>multimaster</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>parallelquery</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>provisioned</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>serverless</code>
     *         </p>
     *         </li>
     */
    public final String engineMode() {
        return engineMode;
    }

    /**
     * <p>
     * Whether the DB cluster has deletion protection enabled.
     * </p>
     * 
     * @return Whether the DB cluster has deletion protection enabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
     * </p>
     * 
     * @return Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
     */
    public final Boolean httpEndpointEnabled() {
        return httpEndpointEnabled;
    }

    /**
     * <p>
     * The status of the database activity stream. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>started</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>starting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopped</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopping</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the database activity stream. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>started</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>starting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopped</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopping</code>
     *         </p>
     *         </li>
     */
    public final String activityStreamStatus() {
        return activityStreamStatus;
    }

    /**
     * <p>
     * Whether tags are copied from the DB cluster to snapshots of the DB cluster.
     * </p>
     * 
     * @return Whether tags are copied from the DB cluster to snapshots of the DB cluster.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * Whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
     * </p>
     * 
     * @return Whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
     */
    public final Boolean crossAccountClone() {
        return crossAccountClone;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainMemberships property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainMemberships() {
        return domainMemberships != null && !(domainMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Active Directory domain membership records that are associated with the DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainMemberships} method.
     * </p>
     * 
     * @return The Active Directory domain membership records that are associated with the DB cluster.
     */
    public final List<AwsRdsDbDomainMembership> domainMemberships() {
        return domainMemberships;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group for the DB cluster.
     * </p>
     * 
     * @return The name of the DB cluster parameter group for the DB cluster.
     */
    public final String dbClusterParameterGroup() {
        return dbClusterParameterGroup;
    }

    /**
     * <p>
     * The subnet group that is associated with the DB cluster, including the name, description, and subnets in the
     * subnet group.
     * </p>
     * 
     * @return The subnet group that is associated with the DB cluster, including the name, description, and subnets in
     *         the subnet group.
     */
    public final String dbSubnetGroup() {
        return dbSubnetGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbClusterOptionGroupMemberships
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDbClusterOptionGroupMemberships() {
        return dbClusterOptionGroupMemberships != null && !(dbClusterOptionGroupMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of option group memberships for this DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbClusterOptionGroupMemberships}
     * method.
     * </p>
     * 
     * @return The list of option group memberships for this DB cluster.
     */
    public final List<AwsRdsDbClusterOptionGroupMembership> dbClusterOptionGroupMemberships() {
        return dbClusterOptionGroupMemberships;
    }

    /**
     * <p>
     * The DB cluster identifier that the user assigned to the cluster. This identifier is the unique key that
     * identifies a DB cluster.
     * </p>
     * 
     * @return The DB cluster identifier that the user assigned to the cluster. This identifier is the unique key that
     *         identifies a DB cluster.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbClusterMembers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbClusterMembers() {
        return dbClusterMembers != null && !(dbClusterMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of instances that make up the DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbClusterMembers} method.
     * </p>
     * 
     * @return The list of instances that make up the DB cluster.
     */
    public final List<AwsRdsDbClusterMember> dbClusterMembers() {
        return dbClusterMembers;
    }

    /**
     * <p>
     * Whether the mapping of IAM accounts to database accounts is enabled.
     * </p>
     * 
     * @return Whether the mapping of IAM accounts to database accounts is enabled.
     */
    public final Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    /**
     * <p>
     * Indicates if minor version upgrades are automatically applied to the cluster.
     * </p>
     * 
     * @return Indicates if minor version upgrades are automatically applied to the cluster.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomEndpoints() ? customEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiAz());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadReplicaIdentifiers() ? readReplicaIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedRoles() ? associatedRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledCloudWatchLogsExports() ? enabledCloudWatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpointEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(activityStreamStatus());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountClone());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainMemberships() ? domainMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroup());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDbClusterOptionGroupMemberships() ? dbClusterOptionGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbClusterMembers() ? dbClusterMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbClusterDetails)) {
            return false;
        }
        AwsRdsDbClusterDetails other = (AwsRdsDbClusterDetails) obj;
        return Objects.equals(allocatedStorage(), other.allocatedStorage())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(status(), other.status())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(readerEndpoint(), other.readerEndpoint())
                && hasCustomEndpoints() == other.hasCustomEndpoints()
                && Objects.equals(customEndpoints(), other.customEndpoints()) && Objects.equals(multiAz(), other.multiAz())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(port(), other.port()) && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && hasReadReplicaIdentifiers() == other.hasReadReplicaIdentifiers()
                && Objects.equals(readReplicaIdentifiers(), other.readReplicaIdentifiers())
                && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups())
                && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dbClusterResourceId(), other.dbClusterResourceId())
                && hasAssociatedRoles() == other.hasAssociatedRoles()
                && Objects.equals(associatedRoles(), other.associatedRoles())
                && Objects.equals(clusterCreateTime(), other.clusterCreateTime())
                && hasEnabledCloudWatchLogsExports() == other.hasEnabledCloudWatchLogsExports()
                && Objects.equals(enabledCloudWatchLogsExports(), other.enabledCloudWatchLogsExports())
                && Objects.equals(engineMode(), other.engineMode())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(httpEndpointEnabled(), other.httpEndpointEnabled())
                && Objects.equals(activityStreamStatus(), other.activityStreamStatus())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(crossAccountClone(), other.crossAccountClone())
                && hasDomainMemberships() == other.hasDomainMemberships()
                && Objects.equals(domainMemberships(), other.domainMemberships())
                && Objects.equals(dbClusterParameterGroup(), other.dbClusterParameterGroup())
                && Objects.equals(dbSubnetGroup(), other.dbSubnetGroup())
                && hasDbClusterOptionGroupMemberships() == other.hasDbClusterOptionGroupMemberships()
                && Objects.equals(dbClusterOptionGroupMemberships(), other.dbClusterOptionGroupMemberships())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && hasDbClusterMembers() == other.hasDbClusterMembers()
                && Objects.equals(dbClusterMembers(), other.dbClusterMembers())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AwsRdsDbClusterDetails")
                .add("AllocatedStorage", allocatedStorage())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("DatabaseName", databaseName())
                .add("Status", status())
                .add("Endpoint", endpoint())
                .add("ReaderEndpoint", readerEndpoint())
                .add("CustomEndpoints", hasCustomEndpoints() ? customEndpoints() : null)
                .add("MultiAz", multiAz())
                .add("Engine", engine())
                .add("EngineVersion", engineVersion())
                .add("Port", port())
                .add("MasterUsername", masterUsername())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("ReadReplicaIdentifiers", hasReadReplicaIdentifiers() ? readReplicaIdentifiers() : null)
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null)
                .add("HostedZoneId", hostedZoneId())
                .add("StorageEncrypted", storageEncrypted())
                .add("KmsKeyId", kmsKeyId())
                .add("DbClusterResourceId", dbClusterResourceId())
                .add("AssociatedRoles", hasAssociatedRoles() ? associatedRoles() : null)
                .add("ClusterCreateTime", clusterCreateTime())
                .add("EnabledCloudWatchLogsExports", hasEnabledCloudWatchLogsExports() ? enabledCloudWatchLogsExports() : null)
                .add("EngineMode", engineMode())
                .add("DeletionProtection", deletionProtection())
                .add("HttpEndpointEnabled", httpEndpointEnabled())
                .add("ActivityStreamStatus", activityStreamStatus())
                .add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("CrossAccountClone", crossAccountClone())
                .add("DomainMemberships", hasDomainMemberships() ? domainMemberships() : null)
                .add("DbClusterParameterGroup", dbClusterParameterGroup())
                .add("DbSubnetGroup", dbSubnetGroup())
                .add("DbClusterOptionGroupMemberships",
                        hasDbClusterOptionGroupMemberships() ? dbClusterOptionGroupMemberships() : null)
                .add("DbClusterIdentifier", dbClusterIdentifier())
                .add("DbClusterMembers", hasDbClusterMembers() ? dbClusterMembers() : null)
                .add("IamDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "ReaderEndpoint":
            return Optional.ofNullable(clazz.cast(readerEndpoint()));
        case "CustomEndpoints":
            return Optional.ofNullable(clazz.cast(customEndpoints()));
        case "MultiAz":
            return Optional.ofNullable(clazz.cast(multiAz()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "ReadReplicaIdentifiers":
            return Optional.ofNullable(clazz.cast(readReplicaIdentifiers()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "DbClusterResourceId":
            return Optional.ofNullable(clazz.cast(dbClusterResourceId()));
        case "AssociatedRoles":
            return Optional.ofNullable(clazz.cast(associatedRoles()));
        case "ClusterCreateTime":
            return Optional.ofNullable(clazz.cast(clusterCreateTime()));
        case "EnabledCloudWatchLogsExports":
            return Optional.ofNullable(clazz.cast(enabledCloudWatchLogsExports()));
        case "EngineMode":
            return Optional.ofNullable(clazz.cast(engineMode()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "HttpEndpointEnabled":
            return Optional.ofNullable(clazz.cast(httpEndpointEnabled()));
        case "ActivityStreamStatus":
            return Optional.ofNullable(clazz.cast(activityStreamStatus()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "CrossAccountClone":
            return Optional.ofNullable(clazz.cast(crossAccountClone()));
        case "DomainMemberships":
            return Optional.ofNullable(clazz.cast(domainMemberships()));
        case "DbClusterParameterGroup":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroup()));
        case "DbSubnetGroup":
            return Optional.ofNullable(clazz.cast(dbSubnetGroup()));
        case "DbClusterOptionGroupMemberships":
            return Optional.ofNullable(clazz.cast(dbClusterOptionGroupMemberships()));
        case "DbClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DbClusterMembers":
            return Optional.ofNullable(clazz.cast(dbClusterMembers()));
        case "IamDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbClusterDetails, T> g) {
        return obj -> g.apply((AwsRdsDbClusterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbClusterDetails> {
        /**
         * <p>
         * For all database engines except Aurora, specifies the allocated storage size in gibibytes (GiB).
         * </p>
         * 
         * @param allocatedStorage
         *        For all database engines except Aurora, specifies the allocated storage size in gibibytes (GiB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones (AZs) where instances in the DB cluster can be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones (AZs) where instances in the DB cluster can be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The number of days for which automated backups are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automated backups are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The name of the database.
         * </p>
         * 
         * @param databaseName
         *        The name of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The current status of this DB cluster.
         * </p>
         * 
         * @param status
         *        The current status of this DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The connection endpoint for the primary instance of the DB cluster.
         * </p>
         * 
         * @param endpoint
         *        The connection endpoint for the primary instance of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The reader endpoint for the DB cluster.
         * </p>
         * 
         * @param readerEndpoint
         *        The reader endpoint for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readerEndpoint(String readerEndpoint);

        /**
         * <p>
         * A list of custom endpoints for the DB cluster.
         * </p>
         * 
         * @param customEndpoints
         *        A list of custom endpoints for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEndpoints(Collection<String> customEndpoints);

        /**
         * <p>
         * A list of custom endpoints for the DB cluster.
         * </p>
         * 
         * @param customEndpoints
         *        A list of custom endpoints for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEndpoints(String... customEndpoints);

        /**
         * <p>
         * Whether the DB cluster has instances in multiple Availability Zones.
         * </p>
         * 
         * @param multiAz
         *        Whether the DB cluster has instances in multiple Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAz(Boolean multiAz);

        /**
         * <p>
         * The name of the database engine to use for this DB cluster. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>aurora</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-mysql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-postgresql</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The name of the database engine to use for this DB cluster. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>aurora</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-mysql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-postgresql</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the database engine to use.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The port number on which the DB instances in the DB cluster accept connections.
         * </p>
         * 
         * @param port
         *        The port number on which the DB instances in the DB cluster accept connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The name of the master user for the DB cluster.
         * </p>
         * 
         * @param masterUsername
         *        The name of the master user for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The range of time each day when automated backups are created, if automated backups are enabled.
         * </p>
         * <p>
         * Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.
         * </p>
         * 
         * @param preferredBackupWindow
         *        The range of time each day when automated backups are created, if automated backups are enabled.</p>
         *        <p>
         *        Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.
         * </p>
         * <p>
         * For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|<code>fri</code>|
         * <code>sat</code>|<code>sun</code>.
         * </p>
         * <p>
         * For example, <code>sun:09:32-sun:10:02</code>.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC).</p>
         *        <p>
         *        Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.
         *        </p>
         *        <p>
         *        For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|
         *        <code>fri</code>|<code>sat</code>|<code>sun</code>.
         *        </p>
         *        <p>
         *        For example, <code>sun:09:32-sun:10:02</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The identifiers of the read replicas that are associated with this DB cluster.
         * </p>
         * 
         * @param readReplicaIdentifiers
         *        The identifiers of the read replicas that are associated with this DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers);

        /**
         * <p>
         * The identifiers of the read replicas that are associated with this DB cluster.
         * </p>
         * 
         * @param readReplicaIdentifiers
         *        The identifiers of the read replicas that are associated with this DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaIdentifiers(String... readReplicaIdentifiers);

        /**
         * <p>
         * A list of VPC security groups that the DB cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        A list of VPC security groups that the DB cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups);

        /**
         * <p>
         * A list of VPC security groups that the DB cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        A list of VPC security groups that the DB cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup... vpcSecurityGroups);

        /**
         * <p>
         * A list of VPC security groups that the DB cluster belongs to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #vpcSecurityGroups(List<AwsRdsDbInstanceVpcSecurityGroup>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(java.util.Collection<AwsRdsDbInstanceVpcSecurityGroup>)
         */
        Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder>... vpcSecurityGroups);

        /**
         * <p>
         * Specifies the identifier that Amazon Route 53 assigns when you create a hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        Specifies the identifier that Amazon Route 53 assigns when you create a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * Whether the DB cluster is encrypted.
         * </p>
         * 
         * @param storageEncrypted
         *        Whether the DB cluster is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The identifier of the DB cluster. The identifier must be unique within each Amazon Web Services Region and is
         * immutable.
         * </p>
         * 
         * @param dbClusterResourceId
         *        The identifier of the DB cluster. The identifier must be unique within each Amazon Web Services Region
         *        and is immutable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterResourceId(String dbClusterResourceId);

        /**
         * <p>
         * A list of the IAM roles that are associated with the DB cluster.
         * </p>
         * 
         * @param associatedRoles
         *        A list of the IAM roles that are associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(Collection<AwsRdsDbClusterAssociatedRole> associatedRoles);

        /**
         * <p>
         * A list of the IAM roles that are associated with the DB cluster.
         * </p>
         * 
         * @param associatedRoles
         *        A list of the IAM roles that are associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(AwsRdsDbClusterAssociatedRole... associatedRoles);

        /**
         * <p>
         * A list of the IAM roles that are associated with the DB cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole.Builder#build()} is
         * called immediately and its result is passed to {@link #associatedRoles(List<AwsRdsDbClusterAssociatedRole>)}.
         * 
         * @param associatedRoles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedRoles(java.util.Collection<AwsRdsDbClusterAssociatedRole>)
         */
        Builder associatedRoles(Consumer<AwsRdsDbClusterAssociatedRole.Builder>... associatedRoles);

        /**
         * <p>
         * Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param clusterCreateTime
         *        Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCreateTime(String clusterCreateTime);

        /**
         * <p>
         * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudWatchLogsExports
         *        A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudWatchLogsExports(Collection<String> enabledCloudWatchLogsExports);

        /**
         * <p>
         * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudWatchLogsExports
         *        A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudWatchLogsExports(String... enabledCloudWatchLogsExports);

        /**
         * <p>
         * The database engine mode of the DB cluster.Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>global</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>multimaster</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parallelquery</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>provisioned</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>serverless</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineMode
         *        The database engine mode of the DB cluster.Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>global</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>multimaster</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>parallelquery</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>provisioned</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>serverless</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineMode(String engineMode);

        /**
         * <p>
         * Whether the DB cluster has deletion protection enabled.
         * </p>
         * 
         * @param deletionProtection
         *        Whether the DB cluster has deletion protection enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
         * </p>
         * 
         * @param httpEndpointEnabled
         *        Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpEndpointEnabled(Boolean httpEndpointEnabled);

        /**
         * <p>
         * The status of the database activity stream. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>started</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>starting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopped</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopping</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param activityStreamStatus
         *        The status of the database activity stream. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>started</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>starting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopped</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopping</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityStreamStatus(String activityStreamStatus);

        /**
         * <p>
         * Whether tags are copied from the DB cluster to snapshots of the DB cluster.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        Whether tags are copied from the DB cluster to snapshots of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * Whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
         * </p>
         * 
         * @param crossAccountClone
         *        Whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountClone(Boolean crossAccountClone);

        /**
         * <p>
         * The Active Directory domain membership records that are associated with the DB cluster.
         * </p>
         * 
         * @param domainMemberships
         *        The Active Directory domain membership records that are associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainMemberships(Collection<AwsRdsDbDomainMembership> domainMemberships);

        /**
         * <p>
         * The Active Directory domain membership records that are associated with the DB cluster.
         * </p>
         * 
         * @param domainMemberships
         *        The Active Directory domain membership records that are associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainMemberships(AwsRdsDbDomainMembership... domainMemberships);

        /**
         * <p>
         * The Active Directory domain membership records that are associated with the DB cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership.Builder#build()} is called
         * immediately and its result is passed to {@link #domainMemberships(List<AwsRdsDbDomainMembership>)}.
         * 
         * @param domainMemberships
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainMemberships(java.util.Collection<AwsRdsDbDomainMembership>)
         */
        Builder domainMemberships(Consumer<AwsRdsDbDomainMembership.Builder>... domainMemberships);

        /**
         * <p>
         * The name of the DB cluster parameter group for the DB cluster.
         * </p>
         * 
         * @param dbClusterParameterGroup
         *        The name of the DB cluster parameter group for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroup(String dbClusterParameterGroup);

        /**
         * <p>
         * The subnet group that is associated with the DB cluster, including the name, description, and subnets in the
         * subnet group.
         * </p>
         * 
         * @param dbSubnetGroup
         *        The subnet group that is associated with the DB cluster, including the name, description, and subnets
         *        in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroup(String dbSubnetGroup);

        /**
         * <p>
         * The list of option group memberships for this DB cluster.
         * </p>
         * 
         * @param dbClusterOptionGroupMemberships
         *        The list of option group memberships for this DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterOptionGroupMemberships(Collection<AwsRdsDbClusterOptionGroupMembership> dbClusterOptionGroupMemberships);

        /**
         * <p>
         * The list of option group memberships for this DB cluster.
         * </p>
         * 
         * @param dbClusterOptionGroupMemberships
         *        The list of option group memberships for this DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterOptionGroupMemberships(AwsRdsDbClusterOptionGroupMembership... dbClusterOptionGroupMemberships);

        /**
         * <p>
         * The list of option group memberships for this DB cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dbClusterOptionGroupMemberships(List<AwsRdsDbClusterOptionGroupMembership>)}.
         * 
         * @param dbClusterOptionGroupMemberships
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterOptionGroupMemberships(java.util.Collection<AwsRdsDbClusterOptionGroupMembership>)
         */
        Builder dbClusterOptionGroupMemberships(
                Consumer<AwsRdsDbClusterOptionGroupMembership.Builder>... dbClusterOptionGroupMemberships);

        /**
         * <p>
         * The DB cluster identifier that the user assigned to the cluster. This identifier is the unique key that
         * identifies a DB cluster.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier that the user assigned to the cluster. This identifier is the unique key
         *        that identifies a DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The list of instances that make up the DB cluster.
         * </p>
         * 
         * @param dbClusterMembers
         *        The list of instances that make up the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterMembers(Collection<AwsRdsDbClusterMember> dbClusterMembers);

        /**
         * <p>
         * The list of instances that make up the DB cluster.
         * </p>
         * 
         * @param dbClusterMembers
         *        The list of instances that make up the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterMembers(AwsRdsDbClusterMember... dbClusterMembers);

        /**
         * <p>
         * The list of instances that make up the DB cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember.Builder#build()} is called
         * immediately and its result is passed to {@link #dbClusterMembers(List<AwsRdsDbClusterMember>)}.
         * 
         * @param dbClusterMembers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterMembers(java.util.Collection<AwsRdsDbClusterMember>)
         */
        Builder dbClusterMembers(Consumer<AwsRdsDbClusterMember.Builder>... dbClusterMembers);

        /**
         * <p>
         * Whether the mapping of IAM accounts to database accounts is enabled.
         * </p>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        Whether the mapping of IAM accounts to database accounts is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);

        /**
         * <p>
         * Indicates if minor version upgrades are automatically applied to the cluster.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Indicates if minor version upgrades are automatically applied to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);
    }

    static final class BuilderImpl implements Builder {
        private Integer allocatedStorage;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private Integer backupRetentionPeriod;

        private String databaseName;

        private String status;

        private String endpoint;

        private String readerEndpoint;

        private List<String> customEndpoints = DefaultSdkAutoConstructList.getInstance();

        private Boolean multiAz;

        private String engine;

        private String engineVersion;

        private Integer port;

        private String masterUsername;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private List<String> readReplicaIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String hostedZoneId;

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private String dbClusterResourceId;

        private List<AwsRdsDbClusterAssociatedRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();

        private String clusterCreateTime;

        private List<String> enabledCloudWatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private String engineMode;

        private Boolean deletionProtection;

        private Boolean httpEndpointEnabled;

        private String activityStreamStatus;

        private Boolean copyTagsToSnapshot;

        private Boolean crossAccountClone;

        private List<AwsRdsDbDomainMembership> domainMemberships = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterParameterGroup;

        private String dbSubnetGroup;

        private List<AwsRdsDbClusterOptionGroupMembership> dbClusterOptionGroupMemberships = DefaultSdkAutoConstructList
                .getInstance();

        private String dbClusterIdentifier;

        private List<AwsRdsDbClusterMember> dbClusterMembers = DefaultSdkAutoConstructList.getInstance();

        private Boolean iamDatabaseAuthenticationEnabled;

        private Boolean autoMinorVersionUpgrade;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbClusterDetails model) {
            allocatedStorage(model.allocatedStorage);
            availabilityZones(model.availabilityZones);
            backupRetentionPeriod(model.backupRetentionPeriod);
            databaseName(model.databaseName);
            status(model.status);
            endpoint(model.endpoint);
            readerEndpoint(model.readerEndpoint);
            customEndpoints(model.customEndpoints);
            multiAz(model.multiAz);
            engine(model.engine);
            engineVersion(model.engineVersion);
            port(model.port);
            masterUsername(model.masterUsername);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            readReplicaIdentifiers(model.readReplicaIdentifiers);
            vpcSecurityGroups(model.vpcSecurityGroups);
            hostedZoneId(model.hostedZoneId);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            dbClusterResourceId(model.dbClusterResourceId);
            associatedRoles(model.associatedRoles);
            clusterCreateTime(model.clusterCreateTime);
            enabledCloudWatchLogsExports(model.enabledCloudWatchLogsExports);
            engineMode(model.engineMode);
            deletionProtection(model.deletionProtection);
            httpEndpointEnabled(model.httpEndpointEnabled);
            activityStreamStatus(model.activityStreamStatus);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            crossAccountClone(model.crossAccountClone);
            domainMemberships(model.domainMemberships);
            dbClusterParameterGroup(model.dbClusterParameterGroup);
            dbSubnetGroup(model.dbSubnetGroup);
            dbClusterOptionGroupMemberships(model.dbClusterOptionGroupMemberships);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbClusterMembers(model.dbClusterMembers);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getReaderEndpoint() {
            return readerEndpoint;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        @Override
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final Collection<String> getCustomEndpoints() {
            if (customEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return customEndpoints;
        }

        public final void setCustomEndpoints(Collection<String> customEndpoints) {
            this.customEndpoints = StringListCopier.copy(customEndpoints);
        }

        @Override
        public final Builder customEndpoints(Collection<String> customEndpoints) {
            this.customEndpoints = StringListCopier.copy(customEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEndpoints(String... customEndpoints) {
            customEndpoints(Arrays.asList(customEndpoints));
            return this;
        }

        public final Boolean getMultiAz() {
            return multiAz;
        }

        public final void setMultiAz(Boolean multiAz) {
            this.multiAz = multiAz;
        }

        @Override
        public final Builder multiAz(Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Collection<String> getReadReplicaIdentifiers() {
            if (readReplicaIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return readReplicaIdentifiers;
        }

        public final void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = StringListCopier.copy(readReplicaIdentifiers);
        }

        @Override
        public final Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = StringListCopier.copy(readReplicaIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaIdentifiers(String... readReplicaIdentifiers) {
            readReplicaIdentifiers(Arrays.asList(readReplicaIdentifiers));
            return this;
        }

        public final List<AwsRdsDbInstanceVpcSecurityGroup.Builder> getVpcSecurityGroups() {
            List<AwsRdsDbInstanceVpcSecurityGroup.Builder> result = AwsRdsDbInstanceVpcSecurityGroupsCopier
                    .copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> AwsRdsDbInstanceVpcSecurityGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDbClusterResourceId() {
            return dbClusterResourceId;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        @Override
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final List<AwsRdsDbClusterAssociatedRole.Builder> getAssociatedRoles() {
            List<AwsRdsDbClusterAssociatedRole.Builder> result = AwsRdsDbClusterAssociatedRolesCopier
                    .copyToBuilder(this.associatedRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedRoles(Collection<AwsRdsDbClusterAssociatedRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = AwsRdsDbClusterAssociatedRolesCopier.copyFromBuilder(associatedRoles);
        }

        @Override
        public final Builder associatedRoles(Collection<AwsRdsDbClusterAssociatedRole> associatedRoles) {
            this.associatedRoles = AwsRdsDbClusterAssociatedRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(AwsRdsDbClusterAssociatedRole... associatedRoles) {
            associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<AwsRdsDbClusterAssociatedRole.Builder>... associatedRoles) {
            associatedRoles(Stream.of(associatedRoles).map(c -> AwsRdsDbClusterAssociatedRole.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClusterCreateTime() {
            return clusterCreateTime;
        }

        public final void setClusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final Collection<String> getEnabledCloudWatchLogsExports() {
            if (enabledCloudWatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledCloudWatchLogsExports;
        }

        public final void setEnabledCloudWatchLogsExports(Collection<String> enabledCloudWatchLogsExports) {
            this.enabledCloudWatchLogsExports = StringListCopier.copy(enabledCloudWatchLogsExports);
        }

        @Override
        public final Builder enabledCloudWatchLogsExports(Collection<String> enabledCloudWatchLogsExports) {
            this.enabledCloudWatchLogsExports = StringListCopier.copy(enabledCloudWatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledCloudWatchLogsExports(String... enabledCloudWatchLogsExports) {
            enabledCloudWatchLogsExports(Arrays.asList(enabledCloudWatchLogsExports));
            return this;
        }

        public final String getEngineMode() {
            return engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getHttpEndpointEnabled() {
            return httpEndpointEnabled;
        }

        public final void setHttpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
        }

        @Override
        public final Builder httpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
            return this;
        }

        public final String getActivityStreamStatus() {
            return activityStreamStatus;
        }

        public final void setActivityStreamStatus(String activityStreamStatus) {
            this.activityStreamStatus = activityStreamStatus;
        }

        @Override
        public final Builder activityStreamStatus(String activityStreamStatus) {
            this.activityStreamStatus = activityStreamStatus;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Boolean getCrossAccountClone() {
            return crossAccountClone;
        }

        public final void setCrossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
        }

        @Override
        public final Builder crossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
            return this;
        }

        public final List<AwsRdsDbDomainMembership.Builder> getDomainMemberships() {
            List<AwsRdsDbDomainMembership.Builder> result = AwsRdsDbDomainMembershipsCopier.copyToBuilder(this.domainMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainMemberships(Collection<AwsRdsDbDomainMembership.BuilderImpl> domainMemberships) {
            this.domainMemberships = AwsRdsDbDomainMembershipsCopier.copyFromBuilder(domainMemberships);
        }

        @Override
        public final Builder domainMemberships(Collection<AwsRdsDbDomainMembership> domainMemberships) {
            this.domainMemberships = AwsRdsDbDomainMembershipsCopier.copy(domainMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(AwsRdsDbDomainMembership... domainMemberships) {
            domainMemberships(Arrays.asList(domainMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(Consumer<AwsRdsDbDomainMembership.Builder>... domainMemberships) {
            domainMemberships(Stream.of(domainMemberships).map(c -> AwsRdsDbDomainMembership.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDbClusterParameterGroup() {
            return dbClusterParameterGroup;
        }

        public final void setDbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
        }

        @Override
        public final Builder dbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
            return this;
        }

        public final String getDbSubnetGroup() {
            return dbSubnetGroup;
        }

        public final void setDbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
        }

        @Override
        public final Builder dbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final List<AwsRdsDbClusterOptionGroupMembership.Builder> getDbClusterOptionGroupMemberships() {
            List<AwsRdsDbClusterOptionGroupMembership.Builder> result = AwsRdsDbClusterOptionGroupMembershipsCopier
                    .copyToBuilder(this.dbClusterOptionGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterOptionGroupMemberships(
                Collection<AwsRdsDbClusterOptionGroupMembership.BuilderImpl> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = AwsRdsDbClusterOptionGroupMembershipsCopier
                    .copyFromBuilder(dbClusterOptionGroupMemberships);
        }

        @Override
        public final Builder dbClusterOptionGroupMemberships(
                Collection<AwsRdsDbClusterOptionGroupMembership> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = AwsRdsDbClusterOptionGroupMembershipsCopier
                    .copy(dbClusterOptionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(
                AwsRdsDbClusterOptionGroupMembership... dbClusterOptionGroupMemberships) {
            dbClusterOptionGroupMemberships(Arrays.asList(dbClusterOptionGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(
                Consumer<AwsRdsDbClusterOptionGroupMembership.Builder>... dbClusterOptionGroupMemberships) {
            dbClusterOptionGroupMemberships(Stream.of(dbClusterOptionGroupMemberships)
                    .map(c -> AwsRdsDbClusterOptionGroupMembership.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final List<AwsRdsDbClusterMember.Builder> getDbClusterMembers() {
            List<AwsRdsDbClusterMember.Builder> result = AwsRdsDbClusterMembersCopier.copyToBuilder(this.dbClusterMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterMembers(Collection<AwsRdsDbClusterMember.BuilderImpl> dbClusterMembers) {
            this.dbClusterMembers = AwsRdsDbClusterMembersCopier.copyFromBuilder(dbClusterMembers);
        }

        @Override
        public final Builder dbClusterMembers(Collection<AwsRdsDbClusterMember> dbClusterMembers) {
            this.dbClusterMembers = AwsRdsDbClusterMembersCopier.copy(dbClusterMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(AwsRdsDbClusterMember... dbClusterMembers) {
            dbClusterMembers(Arrays.asList(dbClusterMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(Consumer<AwsRdsDbClusterMember.Builder>... dbClusterMembers) {
            dbClusterMembers(Stream.of(dbClusterMembers).map(c -> AwsRdsDbClusterMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        @Override
        public AwsRdsDbClusterDetails build() {
            return new AwsRdsDbClusterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
