/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the logging status of the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterLoggingStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterLoggingStatus.Builder, AwsRedshiftClusterLoggingStatus> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(AwsRedshiftClusterLoggingStatus::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastFailureMessage").getter(getter(AwsRedshiftClusterLoggingStatus::lastFailureMessage))
            .setter(setter(Builder::lastFailureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build())
            .build();

    private static final SdkField<String> LAST_FAILURE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastFailureTime").getter(getter(AwsRedshiftClusterLoggingStatus::lastFailureTime))
            .setter(setter(Builder::lastFailureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureTime").build()).build();

    private static final SdkField<String> LAST_SUCCESSFUL_DELIVERY_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastSuccessfulDeliveryTime")
            .getter(getter(AwsRedshiftClusterLoggingStatus::lastSuccessfulDeliveryTime))
            .setter(setter(Builder::lastSuccessfulDeliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulDeliveryTime").build())
            .build();

    private static final SdkField<Boolean> LOGGING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LoggingEnabled").getter(getter(AwsRedshiftClusterLoggingStatus::loggingEnabled))
            .setter(setter(Builder::loggingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingEnabled").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KeyPrefix").getter(getter(AwsRedshiftClusterLoggingStatus::s3KeyPrefix))
            .setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            LAST_FAILURE_MESSAGE_FIELD, LAST_FAILURE_TIME_FIELD, LAST_SUCCESSFUL_DELIVERY_TIME_FIELD, LOGGING_ENABLED_FIELD,
            S3_KEY_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String lastFailureMessage;

    private final String lastFailureTime;

    private final String lastSuccessfulDeliveryTime;

    private final Boolean loggingEnabled;

    private final String s3KeyPrefix;

    private AwsRedshiftClusterLoggingStatus(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.lastFailureTime = builder.lastFailureTime;
        this.lastSuccessfulDeliveryTime = builder.lastSuccessfulDeliveryTime;
        this.loggingEnabled = builder.loggingEnabled;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    /**
     * <p>
     * The name of the S3 bucket where the log files are stored.
     * </p>
     * 
     * @return The name of the S3 bucket where the log files are stored.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The message indicating that the logs failed to be delivered.
     * </p>
     * 
     * @return The message indicating that the logs failed to be delivered.
     */
    public final String lastFailureMessage() {
        return lastFailureMessage;
    }

    /**
     * <p>
     * The last time when logs failed to be delivered.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The last time when logs failed to be delivered.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String lastFailureTime() {
        return lastFailureTime;
    }

    /**
     * <p>
     * The last time that logs were delivered successfully.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The last time that logs were delivered successfully.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String lastSuccessfulDeliveryTime() {
        return lastSuccessfulDeliveryTime;
    }

    /**
     * <p>
     * Indicates whether logging is enabled.
     * </p>
     * 
     * @return Indicates whether logging is enabled.
     */
    public final Boolean loggingEnabled() {
        return loggingEnabled;
    }

    /**
     * <p>
     * Provides the prefix applied to the log file names.
     * </p>
     * 
     * @return Provides the prefix applied to the log file names.
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailureTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulDeliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(loggingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterLoggingStatus)) {
            return false;
        }
        AwsRedshiftClusterLoggingStatus other = (AwsRedshiftClusterLoggingStatus) obj;
        return Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(lastFailureMessage(), other.lastFailureMessage())
                && Objects.equals(lastFailureTime(), other.lastFailureTime())
                && Objects.equals(lastSuccessfulDeliveryTime(), other.lastSuccessfulDeliveryTime())
                && Objects.equals(loggingEnabled(), other.loggingEnabled()) && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterLoggingStatus").add("BucketName", bucketName())
                .add("LastFailureMessage", lastFailureMessage()).add("LastFailureTime", lastFailureTime())
                .add("LastSuccessfulDeliveryTime", lastSuccessfulDeliveryTime()).add("LoggingEnabled", loggingEnabled())
                .add("S3KeyPrefix", s3KeyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "LastFailureMessage":
            return Optional.ofNullable(clazz.cast(lastFailureMessage()));
        case "LastFailureTime":
            return Optional.ofNullable(clazz.cast(lastFailureTime()));
        case "LastSuccessfulDeliveryTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulDeliveryTime()));
        case "LoggingEnabled":
            return Optional.ofNullable(clazz.cast(loggingEnabled()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterLoggingStatus, T> g) {
        return obj -> g.apply((AwsRedshiftClusterLoggingStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterLoggingStatus> {
        /**
         * <p>
         * The name of the S3 bucket where the log files are stored.
         * </p>
         * 
         * @param bucketName
         *        The name of the S3 bucket where the log files are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The message indicating that the logs failed to be delivered.
         * </p>
         * 
         * @param lastFailureMessage
         *        The message indicating that the logs failed to be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailureMessage(String lastFailureMessage);

        /**
         * <p>
         * The last time when logs failed to be delivered.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param lastFailureTime
         *        The last time when logs failed to be delivered.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailureTime(String lastFailureTime);

        /**
         * <p>
         * The last time that logs were delivered successfully.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param lastSuccessfulDeliveryTime
         *        The last time that logs were delivered successfully.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulDeliveryTime(String lastSuccessfulDeliveryTime);

        /**
         * <p>
         * Indicates whether logging is enabled.
         * </p>
         * 
         * @param loggingEnabled
         *        Indicates whether logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingEnabled(Boolean loggingEnabled);

        /**
         * <p>
         * Provides the prefix applied to the log file names.
         * </p>
         * 
         * @param s3KeyPrefix
         *        Provides the prefix applied to the log file names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String lastFailureMessage;

        private String lastFailureTime;

        private String lastSuccessfulDeliveryTime;

        private Boolean loggingEnabled;

        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterLoggingStatus model) {
            bucketName(model.bucketName);
            lastFailureMessage(model.lastFailureMessage);
            lastFailureTime(model.lastFailureTime);
            lastSuccessfulDeliveryTime(model.lastSuccessfulDeliveryTime);
            loggingEnabled(model.loggingEnabled);
            s3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getLastFailureMessage() {
            return lastFailureMessage;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final String getLastFailureTime() {
            return lastFailureTime;
        }

        public final void setLastFailureTime(String lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
        }

        @Override
        public final Builder lastFailureTime(String lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
            return this;
        }

        public final String getLastSuccessfulDeliveryTime() {
            return lastSuccessfulDeliveryTime;
        }

        public final void setLastSuccessfulDeliveryTime(String lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
        }

        @Override
        public final Builder lastSuccessfulDeliveryTime(String lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
            return this;
        }

        public final Boolean getLoggingEnabled() {
            return loggingEnabled;
        }

        public final void setLoggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
        }

        @Override
        public final Builder loggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
            return this;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        @Override
        public AwsRedshiftClusterLoggingStatus build() {
            return new AwsRedshiftClusterLoggingStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
