/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A combination of <code>ByteMatchSet</code>, <code>IPSet</code>, and/or <code>SqlInjectionMatchSet</code> objects that
 * identify the web requests that you want to allow, block, or count.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafRegionalWebAclRulesListDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafRegionalWebAclRulesListDetails.Builder, AwsWafRegionalWebAclRulesListDetails> {
    private static final SdkField<AwsWafRegionalWebAclRulesListActionDetails> ACTION_FIELD = SdkField
            .<AwsWafRegionalWebAclRulesListActionDetails> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(AwsWafRegionalWebAclRulesListDetails::action)).setter(setter(Builder::action))
            .constructor(AwsWafRegionalWebAclRulesListActionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<AwsWafRegionalWebAclRulesListOverrideActionDetails> OVERRIDE_ACTION_FIELD = SdkField
            .<AwsWafRegionalWebAclRulesListOverrideActionDetails> builder(MarshallingType.SDK_POJO).memberName("OverrideAction")
            .getter(getter(AwsWafRegionalWebAclRulesListDetails::overrideAction)).setter(setter(Builder::overrideAction))
            .constructor(AwsWafRegionalWebAclRulesListOverrideActionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideAction").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(AwsWafRegionalWebAclRulesListDetails::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(AwsWafRegionalWebAclRulesListDetails::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsWafRegionalWebAclRulesListDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            OVERRIDE_ACTION_FIELD, PRIORITY_FIELD, RULE_ID_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsWafRegionalWebAclRulesListActionDetails action;

    private final AwsWafRegionalWebAclRulesListOverrideActionDetails overrideAction;

    private final Integer priority;

    private final String ruleId;

    private final String type;

    private AwsWafRegionalWebAclRulesListDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.overrideAction = builder.overrideAction;
        this.priority = builder.priority;
        this.ruleId = builder.ruleId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The action that WAF takes when a web request matches all conditions in the rule, such as allow, block, or count
     * the request.
     * </p>
     * 
     * @return The action that WAF takes when a web request matches all conditions in the rule, such as allow, block, or
     *         count the request.
     */
    public final AwsWafRegionalWebAclRulesListActionDetails action() {
        return action;
    }

    /**
     * <p>
     * Overrides the rule evaluation result in the rule group.
     * </p>
     * 
     * @return Overrides the rule evaluation result in the rule group.
     */
    public final AwsWafRegionalWebAclRulesListOverrideActionDetails overrideAction() {
        return overrideAction;
    }

    /**
     * <p>
     * The order in which WAF evaluates the rules in a web ACL.
     * </p>
     * 
     * @return The order in which WAF evaluates the rules in a web ACL.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The ID of an WAF Regional rule to associate with a web ACL.
     * </p>
     * 
     * @return The ID of an WAF Regional rule to associate with a web ACL.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * For actions that are associated with a rule, the action that WAF takes when a web request matches all conditions
     * in a rule.
     * </p>
     * 
     * @return For actions that are associated with a rule, the action that WAF takes when a web request matches all
     *         conditions in a rule.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(overrideAction());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRegionalWebAclRulesListDetails)) {
            return false;
        }
        AwsWafRegionalWebAclRulesListDetails other = (AwsWafRegionalWebAclRulesListDetails) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(overrideAction(), other.overrideAction())
                && Objects.equals(priority(), other.priority()) && Objects.equals(ruleId(), other.ruleId())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafRegionalWebAclRulesListDetails").add("Action", action())
                .add("OverrideAction", overrideAction()).add("Priority", priority()).add("RuleId", ruleId()).add("Type", type())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "OverrideAction":
            return Optional.ofNullable(clazz.cast(overrideAction()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRegionalWebAclRulesListDetails, T> g) {
        return obj -> g.apply((AwsWafRegionalWebAclRulesListDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafRegionalWebAclRulesListDetails> {
        /**
         * <p>
         * The action that WAF takes when a web request matches all conditions in the rule, such as allow, block, or
         * count the request.
         * </p>
         * 
         * @param action
         *        The action that WAF takes when a web request matches all conditions in the rule, such as allow, block,
         *        or count the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(AwsWafRegionalWebAclRulesListActionDetails action);

        /**
         * <p>
         * The action that WAF takes when a web request matches all conditions in the rule, such as allow, block, or
         * count the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsWafRegionalWebAclRulesListActionDetails.Builder} avoiding the need to create one manually via
         * {@link AwsWafRegionalWebAclRulesListActionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafRegionalWebAclRulesListActionDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #action(AwsWafRegionalWebAclRulesListActionDetails)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link AwsWafRegionalWebAclRulesListActionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(AwsWafRegionalWebAclRulesListActionDetails)
         */
        default Builder action(Consumer<AwsWafRegionalWebAclRulesListActionDetails.Builder> action) {
            return action(AwsWafRegionalWebAclRulesListActionDetails.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * Overrides the rule evaluation result in the rule group.
         * </p>
         * 
         * @param overrideAction
         *        Overrides the rule evaluation result in the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideAction(AwsWafRegionalWebAclRulesListOverrideActionDetails overrideAction);

        /**
         * <p>
         * Overrides the rule evaluation result in the rule group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsWafRegionalWebAclRulesListOverrideActionDetails.Builder} avoiding the need to create one manually
         * via {@link AwsWafRegionalWebAclRulesListOverrideActionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsWafRegionalWebAclRulesListOverrideActionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #overrideAction(AwsWafRegionalWebAclRulesListOverrideActionDetails)}.
         * 
         * @param overrideAction
         *        a consumer that will call methods on
         *        {@link AwsWafRegionalWebAclRulesListOverrideActionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideAction(AwsWafRegionalWebAclRulesListOverrideActionDetails)
         */
        default Builder overrideAction(Consumer<AwsWafRegionalWebAclRulesListOverrideActionDetails.Builder> overrideAction) {
            return overrideAction(AwsWafRegionalWebAclRulesListOverrideActionDetails.builder().applyMutation(overrideAction)
                    .build());
        }

        /**
         * <p>
         * The order in which WAF evaluates the rules in a web ACL.
         * </p>
         * 
         * @param priority
         *        The order in which WAF evaluates the rules in a web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The ID of an WAF Regional rule to associate with a web ACL.
         * </p>
         * 
         * @param ruleId
         *        The ID of an WAF Regional rule to associate with a web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * For actions that are associated with a rule, the action that WAF takes when a web request matches all
         * conditions in a rule.
         * </p>
         * 
         * @param type
         *        For actions that are associated with a rule, the action that WAF takes when a web request matches all
         *        conditions in a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private AwsWafRegionalWebAclRulesListActionDetails action;

        private AwsWafRegionalWebAclRulesListOverrideActionDetails overrideAction;

        private Integer priority;

        private String ruleId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRegionalWebAclRulesListDetails model) {
            action(model.action);
            overrideAction(model.overrideAction);
            priority(model.priority);
            ruleId(model.ruleId);
            type(model.type);
        }

        public final AwsWafRegionalWebAclRulesListActionDetails.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(AwsWafRegionalWebAclRulesListActionDetails.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(AwsWafRegionalWebAclRulesListActionDetails action) {
            this.action = action;
            return this;
        }

        public final AwsWafRegionalWebAclRulesListOverrideActionDetails.Builder getOverrideAction() {
            return overrideAction != null ? overrideAction.toBuilder() : null;
        }

        public final void setOverrideAction(AwsWafRegionalWebAclRulesListOverrideActionDetails.BuilderImpl overrideAction) {
            this.overrideAction = overrideAction != null ? overrideAction.build() : null;
        }

        @Override
        public final Builder overrideAction(AwsWafRegionalWebAclRulesListOverrideActionDetails overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsWafRegionalWebAclRulesListDetails build() {
            return new AwsWafRegionalWebAclRulesListDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
