/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The severity of the finding.
 * </p>
 * <p>
 * The finding provider can provide the initial severity. The finding provider can only update the severity if it hasn't
 * been updated using <code>BatchUpdateFindings</code>.
 * </p>
 * <p>
 * The finding must have either <code>Label</code> or <code>Normalized</code> populated. If only one of these attributes
 * is populated, then Security Hub automatically populates the other one. If neither attribute is populated, then the
 * finding is invalid. <code>Label</code> is the preferred attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Severity implements SdkPojo, Serializable, ToCopyableBuilder<Severity.Builder, Severity> {
    private static final SdkField<Double> PRODUCT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Product")
            .getter(getter(Severity::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(Severity::labelAsString)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<Integer> NORMALIZED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Normalized").getter(getter(Severity::normalized)).setter(setter(Builder::normalized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Normalized").build()).build();

    private static final SdkField<String> ORIGINAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Original").getter(getter(Severity::original)).setter(setter(Builder::original))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Original").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_FIELD, LABEL_FIELD,
            NORMALIZED_FIELD, ORIGINAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double product;

    private final String label;

    private final Integer normalized;

    private final String original;

    private Severity(BuilderImpl builder) {
        this.product = builder.product;
        this.label = builder.label;
        this.normalized = builder.normalized;
        this.original = builder.original;
    }

    /**
     * <p>
     * Deprecated. This attribute isn't included in findings. Instead of providing <code>Product</code>, provide
     * <code>Original</code>.
     * </p>
     * <p>
     * The native severity as defined by the Amazon Web Services service or integrated partner product that generated
     * the finding.
     * </p>
     * 
     * @return Deprecated. This attribute isn't included in findings. Instead of providing <code>Product</code>, provide
     *         <code>Original</code>.</p>
     *         <p>
     *         The native severity as defined by the Amazon Web Services service or integrated partner product that
     *         generated the finding.
     */
    public final Double product() {
        return product;
    }

    /**
     * <p>
     * The severity value of the finding. The allowed values are the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code> - No issue was found.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOW</code> - The issue does not require action on its own.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code> - The issue must be addressed but not urgently.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HIGH</code> - The issue must be addressed as a priority.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code> is set
     * automatically as follows.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 0 - <code>INFORMATIONAL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 1–39 - <code>LOW</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 40–69 - <code>MEDIUM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 70–89 - <code>HIGH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 90–100 - <code>CRITICAL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #label} will return
     * {@link SeverityLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelAsString}.
     * </p>
     * 
     * @return The severity value of the finding. The allowed values are the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code> - No issue was found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOW</code> - The issue does not require action on its own.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code> - The issue must be addressed but not urgently.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HIGH</code> - The issue must be addressed as a priority.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code> is
     *         set automatically as follows.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         0 - <code>INFORMATIONAL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1–39 - <code>LOW</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         40–69 - <code>MEDIUM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         70–89 - <code>HIGH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         90–100 - <code>CRITICAL</code>
     *         </p>
     *         </li>
     * @see SeverityLabel
     */
    public final SeverityLabel label() {
        return SeverityLabel.fromValue(label);
    }

    /**
     * <p>
     * The severity value of the finding. The allowed values are the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code> - No issue was found.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOW</code> - The issue does not require action on its own.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code> - The issue must be addressed but not urgently.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HIGH</code> - The issue must be addressed as a priority.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code> is set
     * automatically as follows.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 0 - <code>INFORMATIONAL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 1–39 - <code>LOW</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 40–69 - <code>MEDIUM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 70–89 - <code>HIGH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * 90–100 - <code>CRITICAL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #label} will return
     * {@link SeverityLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelAsString}.
     * </p>
     * 
     * @return The severity value of the finding. The allowed values are the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code> - No issue was found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOW</code> - The issue does not require action on its own.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code> - The issue must be addressed but not urgently.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HIGH</code> - The issue must be addressed as a priority.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code> is
     *         set automatically as follows.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         0 - <code>INFORMATIONAL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1–39 - <code>LOW</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         40–69 - <code>MEDIUM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         70–89 - <code>HIGH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         90–100 - <code>CRITICAL</code>
     *         </p>
     *         </li>
     * @see SeverityLabel
     */
    public final String labelAsString() {
        return label;
    }

    /**
     * <p>
     * Deprecated. The normalized severity of a finding. Instead of providing <code>Normalized</code>, provide
     * <code>Label</code>.
     * </p>
     * <p>
     * If you provide <code>Label</code> and do not provide <code>Normalized</code>, then <code>Normalized</code> is set
     * automatically as follows.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code> - 0
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOW</code> - 1
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code> - 40
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HIGH</code> - 70
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CRITICAL</code> - 90
     * </p>
     * </li>
     * </ul>
     * 
     * @return Deprecated. The normalized severity of a finding. Instead of providing <code>Normalized</code>, provide
     *         <code>Label</code>.</p>
     *         <p>
     *         If you provide <code>Label</code> and do not provide <code>Normalized</code>, then
     *         <code>Normalized</code> is set automatically as follows.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code> - 0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOW</code> - 1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code> - 40
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HIGH</code> - 70
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CRITICAL</code> - 90
     *         </p>
     *         </li>
     */
    public final Integer normalized() {
        return normalized;
    }

    /**
     * <p>
     * The native severity from the finding product that generated the finding.
     * </p>
     * 
     * @return The native severity from the finding product that generated the finding.
     */
    public final String original() {
        return original;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(product());
        hashCode = 31 * hashCode + Objects.hashCode(labelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(normalized());
        hashCode = 31 * hashCode + Objects.hashCode(original());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Severity)) {
            return false;
        }
        Severity other = (Severity) obj;
        return Objects.equals(product(), other.product()) && Objects.equals(labelAsString(), other.labelAsString())
                && Objects.equals(normalized(), other.normalized()) && Objects.equals(original(), other.original());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Severity").add("Product", product()).add("Label", labelAsString())
                .add("Normalized", normalized()).add("Original", original()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        case "Label":
            return Optional.ofNullable(clazz.cast(labelAsString()));
        case "Normalized":
            return Optional.ofNullable(clazz.cast(normalized()));
        case "Original":
            return Optional.ofNullable(clazz.cast(original()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Severity, T> g) {
        return obj -> g.apply((Severity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Severity> {
        /**
         * <p>
         * Deprecated. This attribute isn't included in findings. Instead of providing <code>Product</code>, provide
         * <code>Original</code>.
         * </p>
         * <p>
         * The native severity as defined by the Amazon Web Services service or integrated partner product that
         * generated the finding.
         * </p>
         * 
         * @param product
         *        Deprecated. This attribute isn't included in findings. Instead of providing <code>Product</code>,
         *        provide <code>Original</code>.</p>
         *        <p>
         *        The native severity as defined by the Amazon Web Services service or integrated partner product that
         *        generated the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(Double product);

        /**
         * <p>
         * The severity value of the finding. The allowed values are the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code> - No issue was found.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOW</code> - The issue does not require action on its own.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code> - The issue must be addressed but not urgently.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HIGH</code> - The issue must be addressed as a priority.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code> is set
         * automatically as follows.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 0 - <code>INFORMATIONAL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 1–39 - <code>LOW</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 40–69 - <code>MEDIUM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 70–89 - <code>HIGH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 90–100 - <code>CRITICAL</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param label
         *        The severity value of the finding. The allowed values are the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code> - No issue was found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOW</code> - The issue does not require action on its own.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code> - The issue must be addressed but not urgently.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HIGH</code> - The issue must be addressed as a priority.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code>
         *        is set automatically as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        0 - <code>INFORMATIONAL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1–39 - <code>LOW</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        40–69 - <code>MEDIUM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        70–89 - <code>HIGH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        90–100 - <code>CRITICAL</code>
         *        </p>
         *        </li>
         * @see SeverityLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityLabel
         */
        Builder label(String label);

        /**
         * <p>
         * The severity value of the finding. The allowed values are the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code> - No issue was found.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOW</code> - The issue does not require action on its own.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code> - The issue must be addressed but not urgently.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HIGH</code> - The issue must be addressed as a priority.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code> is set
         * automatically as follows.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 0 - <code>INFORMATIONAL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 1–39 - <code>LOW</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 40–69 - <code>MEDIUM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 70–89 - <code>HIGH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * 90–100 - <code>CRITICAL</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param label
         *        The severity value of the finding. The allowed values are the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code> - No issue was found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOW</code> - The issue does not require action on its own.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code> - The issue must be addressed but not urgently.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HIGH</code> - The issue must be addressed as a priority.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code>
         *        is set automatically as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        0 - <code>INFORMATIONAL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1–39 - <code>LOW</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        40–69 - <code>MEDIUM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        70–89 - <code>HIGH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        90–100 - <code>CRITICAL</code>
         *        </p>
         *        </li>
         * @see SeverityLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityLabel
         */
        Builder label(SeverityLabel label);

        /**
         * <p>
         * Deprecated. The normalized severity of a finding. Instead of providing <code>Normalized</code>, provide
         * <code>Label</code>.
         * </p>
         * <p>
         * If you provide <code>Label</code> and do not provide <code>Normalized</code>, then <code>Normalized</code> is
         * set automatically as follows.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code> - 0
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOW</code> - 1
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code> - 40
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HIGH</code> - 70
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CRITICAL</code> - 90
         * </p>
         * </li>
         * </ul>
         * 
         * @param normalized
         *        Deprecated. The normalized severity of a finding. Instead of providing <code>Normalized</code>,
         *        provide <code>Label</code>.</p>
         *        <p>
         *        If you provide <code>Label</code> and do not provide <code>Normalized</code>, then
         *        <code>Normalized</code> is set automatically as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code> - 0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOW</code> - 1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code> - 40
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HIGH</code> - 70
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CRITICAL</code> - 90
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normalized(Integer normalized);

        /**
         * <p>
         * The native severity from the finding product that generated the finding.
         * </p>
         * 
         * @param original
         *        The native severity from the finding product that generated the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder original(String original);
    }

    static final class BuilderImpl implements Builder {
        private Double product;

        private String label;

        private Integer normalized;

        private String original;

        private BuilderImpl() {
        }

        private BuilderImpl(Severity model) {
            product(model.product);
            label(model.label);
            normalized(model.normalized);
            original(model.original);
        }

        public final Double getProduct() {
            return product;
        }

        public final void setProduct(Double product) {
            this.product = product;
        }

        @Override
        public final Builder product(Double product) {
            this.product = product;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        @Override
        public final Builder label(SeverityLabel label) {
            this.label(label == null ? null : label.toString());
            return this;
        }

        public final Integer getNormalized() {
            return normalized;
        }

        public final void setNormalized(Integer normalized) {
            this.normalized = normalized;
        }

        @Override
        public final Builder normalized(Integer normalized) {
            this.normalized = normalized;
            return this;
        }

        public final String getOriginal() {
            return original;
        }

        public final void setOriginal(String original) {
            this.original = original;
        }

        @Override
        public final Builder original(String original) {
            this.original = original;
            return this;
        }

        @Override
        public Severity build() {
            return new Severity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
