/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartConfigurationPolicyAssociationRequest extends SecurityHubRequest implements
        ToCopyableBuilder<StartConfigurationPolicyAssociationRequest.Builder, StartConfigurationPolicyAssociationRequest> {
    private static final SdkField<String> CONFIGURATION_POLICY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationPolicyIdentifier")
            .getter(getter(StartConfigurationPolicyAssociationRequest::configurationPolicyIdentifier))
            .setter(setter(Builder::configurationPolicyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicyIdentifier")
                    .build()).build();

    private static final SdkField<Target> TARGET_FIELD = SdkField.<Target> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(StartConfigurationPolicyAssociationRequest::target)).setter(setter(Builder::target))
            .constructor(Target::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_POLICY_IDENTIFIER_FIELD, TARGET_FIELD));

    private final String configurationPolicyIdentifier;

    private final Target target;

    private StartConfigurationPolicyAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationPolicyIdentifier = builder.configurationPolicyIdentifier;
        this.target = builder.target;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy.
     */
    public final String configurationPolicyIdentifier() {
        return configurationPolicyIdentifier;
    }

    /**
     * <p>
     * The identifier of the target account, organizational unit, or the root to associate with the specified
     * configuration.
     * </p>
     * 
     * @return The identifier of the target account, organizational unit, or the root to associate with the specified
     *         configuration.
     */
    public final Target target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationPolicyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigurationPolicyAssociationRequest)) {
            return false;
        }
        StartConfigurationPolicyAssociationRequest other = (StartConfigurationPolicyAssociationRequest) obj;
        return Objects.equals(configurationPolicyIdentifier(), other.configurationPolicyIdentifier())
                && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartConfigurationPolicyAssociationRequest")
                .add("ConfigurationPolicyIdentifier", configurationPolicyIdentifier()).add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationPolicyIdentifier":
            return Optional.ofNullable(clazz.cast(configurationPolicyIdentifier()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartConfigurationPolicyAssociationRequest, T> g) {
        return obj -> g.apply((StartConfigurationPolicyAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartConfigurationPolicyAssociationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy.
         * </p>
         * 
         * @param configurationPolicyIdentifier
         *        The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicyIdentifier(String configurationPolicyIdentifier);

        /**
         * <p>
         * The identifier of the target account, organizational unit, or the root to associate with the specified
         * configuration.
         * </p>
         * 
         * @param target
         *        The identifier of the target account, organizational unit, or the root to associate with the specified
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Target target);

        /**
         * <p>
         * The identifier of the target account, organizational unit, or the root to associate with the specified
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Target.Builder} avoiding the need to
         * create one manually via {@link Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Target.Builder#build()} is called immediately and its result is
         * passed to {@link #target(Target)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(Target)
         */
        default Builder target(Consumer<Target.Builder> target) {
            return target(Target.builder().applyMutation(target).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String configurationPolicyIdentifier;

        private Target target;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigurationPolicyAssociationRequest model) {
            super(model);
            configurationPolicyIdentifier(model.configurationPolicyIdentifier);
            target(model.target);
        }

        public final String getConfigurationPolicyIdentifier() {
            return configurationPolicyIdentifier;
        }

        public final void setConfigurationPolicyIdentifier(String configurationPolicyIdentifier) {
            this.configurationPolicyIdentifier = configurationPolicyIdentifier;
        }

        @Override
        public final Builder configurationPolicyIdentifier(String configurationPolicyIdentifier) {
            this.configurationPolicyIdentifier = configurationPolicyIdentifier;
            return this;
        }

        public final Target.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConfigurationPolicyAssociationRequest build() {
            return new StartConfigurationPolicyAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
