/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartConfigurationPolicyAssociationResponse extends SecurityHubResponse implements
        ToCopyableBuilder<StartConfigurationPolicyAssociationResponse.Builder, StartConfigurationPolicyAssociationResponse> {
    private static final SdkField<String> CONFIGURATION_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationPolicyId")
            .getter(getter(StartConfigurationPolicyAssociationResponse::configurationPolicyId))
            .setter(setter(Builder::configurationPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicyId").build())
            .build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(StartConfigurationPolicyAssociationResponse::targetId))
            .setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(StartConfigurationPolicyAssociationResponse::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationType").getter(getter(StartConfigurationPolicyAssociationResponse::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(StartConfigurationPolicyAssociationResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationStatus")
            .getter(getter(StartConfigurationPolicyAssociationResponse::associationStatusAsString))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()).build();

    private static final SdkField<String> ASSOCIATION_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationStatusMessage")
            .getter(getter(StartConfigurationPolicyAssociationResponse::associationStatusMessage))
            .setter(setter(Builder::associationStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatusMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_POLICY_ID_FIELD,
            TARGET_ID_FIELD, TARGET_TYPE_FIELD, ASSOCIATION_TYPE_FIELD, UPDATED_AT_FIELD, ASSOCIATION_STATUS_FIELD,
            ASSOCIATION_STATUS_MESSAGE_FIELD));

    private final String configurationPolicyId;

    private final String targetId;

    private final String targetType;

    private final String associationType;

    private final Instant updatedAt;

    private final String associationStatus;

    private final String associationStatusMessage;

    private StartConfigurationPolicyAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.configurationPolicyId = builder.configurationPolicyId;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.associationType = builder.associationType;
        this.updatedAt = builder.updatedAt;
        this.associationStatus = builder.associationStatus;
        this.associationStatusMessage = builder.associationStatusMessage;
    }

    /**
     * <p>
     * The UUID of the configuration policy.
     * </p>
     * 
     * @return The UUID of the configuration policy.
     */
    public final String configurationPolicyId() {
        return configurationPolicyId;
    }

    /**
     * <p>
     * The identifier of the target account, organizational unit, or the organization root with which the configuration
     * is associated.
     * </p>
     * 
     * @return The identifier of the target account, organizational unit, or the organization root with which the
     *         configuration is associated.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * Indicates whether the target is an Amazon Web Services account, organizational unit, or the organization root.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the target is an Amazon Web Services account, organizational unit, or the organization
     *         root.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * Indicates whether the target is an Amazon Web Services account, organizational unit, or the organization root.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the target is an Amazon Web Services account, organizational unit, or the organization
     *         root.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * Indicates whether the association between the specified target and the configuration was directly applied by the
     * Security Hub delegated administrator or inherited from a parent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the association between the specified target and the configuration was directly applied
     *         by the Security Hub delegated administrator or inherited from a parent.
     * @see AssociationType
     */
    public final AssociationType associationType() {
        return AssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * Indicates whether the association between the specified target and the configuration was directly applied by the
     * Security Hub delegated administrator or inherited from a parent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the association between the specified target and the configuration was directly applied
     *         by the Security Hub delegated administrator or inherited from a parent.
     * @see AssociationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    /**
     * <p>
     * The date and time, in UTC and ISO 8601 format, that the configuration policy association was last updated.
     * </p>
     * 
     * @return The date and time, in UTC and ISO 8601 format, that the configuration policy association was last
     *         updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current status of the association between the specified target and the configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ConfigurationPolicyAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The current status of the association between the specified target and the configuration.
     * @see ConfigurationPolicyAssociationStatus
     */
    public final ConfigurationPolicyAssociationStatus associationStatus() {
        return ConfigurationPolicyAssociationStatus.fromValue(associationStatus);
    }

    /**
     * <p>
     * The current status of the association between the specified target and the configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link ConfigurationPolicyAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The current status of the association between the specified target and the configuration.
     * @see ConfigurationPolicyAssociationStatus
     */
    public final String associationStatusAsString() {
        return associationStatus;
    }

    /**
     * <p>
     * An explanation for a <code>FAILED</code> value for <code>AssociationStatus</code>.
     * </p>
     * 
     * @return An explanation for a <code>FAILED</code> value for <code>AssociationStatus</code>.
     */
    public final String associationStatusMessage() {
        return associationStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigurationPolicyAssociationResponse)) {
            return false;
        }
        StartConfigurationPolicyAssociationResponse other = (StartConfigurationPolicyAssociationResponse) obj;
        return Objects.equals(configurationPolicyId(), other.configurationPolicyId())
                && Objects.equals(targetId(), other.targetId())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(associationStatusAsString(), other.associationStatusAsString())
                && Objects.equals(associationStatusMessage(), other.associationStatusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartConfigurationPolicyAssociationResponse")
                .add("ConfigurationPolicyId", configurationPolicyId()).add("TargetId", targetId())
                .add("TargetType", targetTypeAsString()).add("AssociationType", associationTypeAsString())
                .add("UpdatedAt", updatedAt()).add("AssociationStatus", associationStatusAsString())
                .add("AssociationStatusMessage", associationStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationPolicyId":
            return Optional.ofNullable(clazz.cast(configurationPolicyId()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "AssociationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "AssociationStatus":
            return Optional.ofNullable(clazz.cast(associationStatusAsString()));
        case "AssociationStatusMessage":
            return Optional.ofNullable(clazz.cast(associationStatusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartConfigurationPolicyAssociationResponse, T> g) {
        return obj -> g.apply((StartConfigurationPolicyAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartConfigurationPolicyAssociationResponse> {
        /**
         * <p>
         * The UUID of the configuration policy.
         * </p>
         * 
         * @param configurationPolicyId
         *        The UUID of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicyId(String configurationPolicyId);

        /**
         * <p>
         * The identifier of the target account, organizational unit, or the organization root with which the
         * configuration is associated.
         * </p>
         * 
         * @param targetId
         *        The identifier of the target account, organizational unit, or the organization root with which the
         *        configuration is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * Indicates whether the target is an Amazon Web Services account, organizational unit, or the organization
         * root.
         * </p>
         * 
         * @param targetType
         *        Indicates whether the target is an Amazon Web Services account, organizational unit, or the
         *        organization root.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * Indicates whether the target is an Amazon Web Services account, organizational unit, or the organization
         * root.
         * </p>
         * 
         * @param targetType
         *        Indicates whether the target is an Amazon Web Services account, organizational unit, or the
         *        organization root.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);

        /**
         * <p>
         * Indicates whether the association between the specified target and the configuration was directly applied by
         * the Security Hub delegated administrator or inherited from a parent.
         * </p>
         * 
         * @param associationType
         *        Indicates whether the association between the specified target and the configuration was directly
         *        applied by the Security Hub delegated administrator or inherited from a parent.
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * Indicates whether the association between the specified target and the configuration was directly applied by
         * the Security Hub delegated administrator or inherited from a parent.
         * </p>
         * 
         * @param associationType
         *        Indicates whether the association between the specified target and the configuration was directly
         *        applied by the Security Hub delegated administrator or inherited from a parent.
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(AssociationType associationType);

        /**
         * <p>
         * The date and time, in UTC and ISO 8601 format, that the configuration policy association was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time, in UTC and ISO 8601 format, that the configuration policy association was last
         *        updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current status of the association between the specified target and the configuration.
         * </p>
         * 
         * @param associationStatus
         *        The current status of the association between the specified target and the configuration.
         * @see ConfigurationPolicyAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationPolicyAssociationStatus
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * The current status of the association between the specified target and the configuration.
         * </p>
         * 
         * @param associationStatus
         *        The current status of the association between the specified target and the configuration.
         * @see ConfigurationPolicyAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationPolicyAssociationStatus
         */
        Builder associationStatus(ConfigurationPolicyAssociationStatus associationStatus);

        /**
         * <p>
         * An explanation for a <code>FAILED</code> value for <code>AssociationStatus</code>.
         * </p>
         * 
         * @param associationStatusMessage
         *        An explanation for a <code>FAILED</code> value for <code>AssociationStatus</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationStatusMessage(String associationStatusMessage);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String configurationPolicyId;

        private String targetId;

        private String targetType;

        private String associationType;

        private Instant updatedAt;

        private String associationStatus;

        private String associationStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigurationPolicyAssociationResponse model) {
            super(model);
            configurationPolicyId(model.configurationPolicyId);
            targetId(model.targetId);
            targetType(model.targetType);
            associationType(model.associationType);
            updatedAt(model.updatedAt);
            associationStatus(model.associationStatus);
            associationStatusMessage(model.associationStatusMessage);
        }

        public final String getConfigurationPolicyId() {
            return configurationPolicyId;
        }

        public final void setConfigurationPolicyId(String configurationPolicyId) {
            this.configurationPolicyId = configurationPolicyId;
        }

        @Override
        public final Builder configurationPolicyId(String configurationPolicyId) {
            this.configurationPolicyId = configurationPolicyId;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(ConfigurationPolicyAssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getAssociationStatusMessage() {
            return associationStatusMessage;
        }

        public final void setAssociationStatusMessage(String associationStatusMessage) {
            this.associationStatusMessage = associationStatusMessage;
        }

        @Override
        public final Builder associationStatusMessage(String associationStatusMessage) {
            this.associationStatusMessage = associationStatusMessage;
            return this;
        }

        @Override
        public StartConfigurationPolicyAssociationResponse build() {
            return new StartConfigurationPolicyAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
