/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ThreatIntelIndicatorType {
    DOMAIN("DOMAIN"),

    EMAIL_ADDRESS("EMAIL_ADDRESS"),

    HASH_MD5("HASH_MD5"),

    HASH_SHA1("HASH_SHA1"),

    HASH_SHA256("HASH_SHA256"),

    HASH_SHA512("HASH_SHA512"),

    IPV4_ADDRESS("IPV4_ADDRESS"),

    IPV6_ADDRESS("IPV6_ADDRESS"),

    MUTEX("MUTEX"),

    PROCESS("PROCESS"),

    URL("URL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ThreatIntelIndicatorType> VALUE_MAP = EnumUtils.uniqueIndex(ThreatIntelIndicatorType.class,
            ThreatIntelIndicatorType::toString);

    private final String value;

    private ThreatIntelIndicatorType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ThreatIntelIndicatorType corresponding to the value
     */
    public static ThreatIntelIndicatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ThreatIntelIndicatorType}s
     */
    public static Set<ThreatIntelIndicatorType> knownValues() {
        Set<ThreatIntelIndicatorType> knownValues = EnumSet.allOf(ThreatIntelIndicatorType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
