/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the build artifacts for the CodeBuild project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectArtifactsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectArtifactsDetails.Builder, AwsCodeBuildProjectArtifactsDetails> {
    private static final SdkField<String> ARTIFACT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactIdentifier").getter(getter(AwsCodeBuildProjectArtifactsDetails::artifactIdentifier))
            .setter(setter(Builder::artifactIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactIdentifier").build())
            .build();

    private static final SdkField<Boolean> ENCRYPTION_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EncryptionDisabled").getter(getter(AwsCodeBuildProjectArtifactsDetails::encryptionDisabled))
            .setter(setter(Builder::encryptionDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionDisabled").build())
            .build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(AwsCodeBuildProjectArtifactsDetails::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsCodeBuildProjectArtifactsDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NAMESPACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamespaceType").getter(getter(AwsCodeBuildProjectArtifactsDetails::namespaceType))
            .setter(setter(Builder::namespaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceType").build()).build();

    private static final SdkField<Boolean> OVERRIDE_ARTIFACT_NAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OverrideArtifactName").getter(getter(AwsCodeBuildProjectArtifactsDetails::overrideArtifactName))
            .setter(setter(Builder::overrideArtifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideArtifactName").build())
            .build();

    private static final SdkField<String> PACKAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Packaging").getter(getter(AwsCodeBuildProjectArtifactsDetails::packaging))
            .setter(setter(Builder::packaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Packaging").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(AwsCodeBuildProjectArtifactsDetails::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsCodeBuildProjectArtifactsDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_IDENTIFIER_FIELD,
            ENCRYPTION_DISABLED_FIELD, LOCATION_FIELD, NAME_FIELD, NAMESPACE_TYPE_FIELD, OVERRIDE_ARTIFACT_NAME_FIELD,
            PACKAGING_FIELD, PATH_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String artifactIdentifier;

    private final Boolean encryptionDisabled;

    private final String location;

    private final String name;

    private final String namespaceType;

    private final Boolean overrideArtifactName;

    private final String packaging;

    private final String path;

    private final String type;

    private AwsCodeBuildProjectArtifactsDetails(BuilderImpl builder) {
        this.artifactIdentifier = builder.artifactIdentifier;
        this.encryptionDisabled = builder.encryptionDisabled;
        this.location = builder.location;
        this.name = builder.name;
        this.namespaceType = builder.namespaceType;
        this.overrideArtifactName = builder.overrideArtifactName;
        this.packaging = builder.packaging;
        this.path = builder.path;
        this.type = builder.type;
    }

    /**
     * <p>
     * An identifier for the artifact definition.
     * </p>
     * 
     * @return An identifier for the artifact definition.
     */
    public final String artifactIdentifier() {
        return artifactIdentifier;
    }

    /**
     * <p>
     * Indicates whether to disable encryption on the artifact. Only valid when <code>Type</code> is <code>S3</code>.
     * </p>
     * 
     * @return Indicates whether to disable encryption on the artifact. Only valid when <code>Type</code> is
     *         <code>S3</code>.
     */
    public final Boolean encryptionDisabled() {
        return encryptionDisabled;
    }

    /**
     * <p>
     * Only used when <code>Type</code> is <code>S3</code>. The name of the S3 bucket where the artifact is located.
     * </p>
     * 
     * @return Only used when <code>Type</code> is <code>S3</code>. The name of the S3 bucket where the artifact is
     *         located.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * Only used when Type is S3. The name of the artifact. Used with <code>NamepaceType</code> and <code>Path</code> to
     * determine the pattern for storing the artifact.
     * </p>
     * 
     * @return Only used when Type is S3. The name of the artifact. Used with <code>NamepaceType</code> and
     *         <code>Path</code> to determine the pattern for storing the artifact.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Only used when <code>Type</code> is <code>S3</code>. The value to use for the namespace. Used with
     * <code>Name</code> and <code>Path</code> to determine the pattern for storing the artifact.
     * </p>
     * 
     * @return Only used when <code>Type</code> is <code>S3</code>. The value to use for the namespace. Used with
     *         <code>Name</code> and <code>Path</code> to determine the pattern for storing the artifact.
     */
    public final String namespaceType() {
        return namespaceType;
    }

    /**
     * <p>
     * Whether the name specified in the buildspec file overrides the artifact name.
     * </p>
     * 
     * @return Whether the name specified in the buildspec file overrides the artifact name.
     */
    public final Boolean overrideArtifactName() {
        return overrideArtifactName;
    }

    /**
     * <p>
     * Only used when <code>Type</code> is <code>S3</code>. The type of output artifact to create.
     * </p>
     * 
     * @return Only used when <code>Type</code> is <code>S3</code>. The type of output artifact to create.
     */
    public final String packaging() {
        return packaging;
    }

    /**
     * <p>
     * Only used when <code>Type</code> is <code>S3</code>. The path to the artifact. Used with <code>Name</code> and
     * <code>NamespaceType</code> to determine the pattern for storing the artifact.
     * </p>
     * 
     * @return Only used when <code>Type</code> is <code>S3</code>. The path to the artifact. Used with
     *         <code>Name</code> and <code>NamespaceType</code> to determine the pattern for storing the artifact.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The type of build artifact.
     * </p>
     * 
     * @return The type of build artifact.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(artifactIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceType());
        hashCode = 31 * hashCode + Objects.hashCode(overrideArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(packaging());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectArtifactsDetails)) {
            return false;
        }
        AwsCodeBuildProjectArtifactsDetails other = (AwsCodeBuildProjectArtifactsDetails) obj;
        return Objects.equals(artifactIdentifier(), other.artifactIdentifier())
                && Objects.equals(encryptionDisabled(), other.encryptionDisabled())
                && Objects.equals(location(), other.location()) && Objects.equals(name(), other.name())
                && Objects.equals(namespaceType(), other.namespaceType())
                && Objects.equals(overrideArtifactName(), other.overrideArtifactName())
                && Objects.equals(packaging(), other.packaging()) && Objects.equals(path(), other.path())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCodeBuildProjectArtifactsDetails").add("ArtifactIdentifier", artifactIdentifier())
                .add("EncryptionDisabled", encryptionDisabled()).add("Location", location()).add("Name", name())
                .add("NamespaceType", namespaceType()).add("OverrideArtifactName", overrideArtifactName())
                .add("Packaging", packaging()).add("Path", path()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactIdentifier":
            return Optional.ofNullable(clazz.cast(artifactIdentifier()));
        case "EncryptionDisabled":
            return Optional.ofNullable(clazz.cast(encryptionDisabled()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NamespaceType":
            return Optional.ofNullable(clazz.cast(namespaceType()));
        case "OverrideArtifactName":
            return Optional.ofNullable(clazz.cast(overrideArtifactName()));
        case "Packaging":
            return Optional.ofNullable(clazz.cast(packaging()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectArtifactsDetails, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectArtifactsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectArtifactsDetails> {
        /**
         * <p>
         * An identifier for the artifact definition.
         * </p>
         * 
         * @param artifactIdentifier
         *        An identifier for the artifact definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactIdentifier(String artifactIdentifier);

        /**
         * <p>
         * Indicates whether to disable encryption on the artifact. Only valid when <code>Type</code> is <code>S3</code>
         * .
         * </p>
         * 
         * @param encryptionDisabled
         *        Indicates whether to disable encryption on the artifact. Only valid when <code>Type</code> is
         *        <code>S3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionDisabled(Boolean encryptionDisabled);

        /**
         * <p>
         * Only used when <code>Type</code> is <code>S3</code>. The name of the S3 bucket where the artifact is located.
         * </p>
         * 
         * @param location
         *        Only used when <code>Type</code> is <code>S3</code>. The name of the S3 bucket where the artifact is
         *        located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * Only used when Type is S3. The name of the artifact. Used with <code>NamepaceType</code> and
         * <code>Path</code> to determine the pattern for storing the artifact.
         * </p>
         * 
         * @param name
         *        Only used when Type is S3. The name of the artifact. Used with <code>NamepaceType</code> and
         *        <code>Path</code> to determine the pattern for storing the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Only used when <code>Type</code> is <code>S3</code>. The value to use for the namespace. Used with
         * <code>Name</code> and <code>Path</code> to determine the pattern for storing the artifact.
         * </p>
         * 
         * @param namespaceType
         *        Only used when <code>Type</code> is <code>S3</code>. The value to use for the namespace. Used with
         *        <code>Name</code> and <code>Path</code> to determine the pattern for storing the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceType(String namespaceType);

        /**
         * <p>
         * Whether the name specified in the buildspec file overrides the artifact name.
         * </p>
         * 
         * @param overrideArtifactName
         *        Whether the name specified in the buildspec file overrides the artifact name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideArtifactName(Boolean overrideArtifactName);

        /**
         * <p>
         * Only used when <code>Type</code> is <code>S3</code>. The type of output artifact to create.
         * </p>
         * 
         * @param packaging
         *        Only used when <code>Type</code> is <code>S3</code>. The type of output artifact to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packaging(String packaging);

        /**
         * <p>
         * Only used when <code>Type</code> is <code>S3</code>. The path to the artifact. Used with <code>Name</code>
         * and <code>NamespaceType</code> to determine the pattern for storing the artifact.
         * </p>
         * 
         * @param path
         *        Only used when <code>Type</code> is <code>S3</code>. The path to the artifact. Used with
         *        <code>Name</code> and <code>NamespaceType</code> to determine the pattern for storing the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The type of build artifact.
         * </p>
         * 
         * @param type
         *        The type of build artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String artifactIdentifier;

        private Boolean encryptionDisabled;

        private String location;

        private String name;

        private String namespaceType;

        private Boolean overrideArtifactName;

        private String packaging;

        private String path;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectArtifactsDetails model) {
            artifactIdentifier(model.artifactIdentifier);
            encryptionDisabled(model.encryptionDisabled);
            location(model.location);
            name(model.name);
            namespaceType(model.namespaceType);
            overrideArtifactName(model.overrideArtifactName);
            packaging(model.packaging);
            path(model.path);
            type(model.type);
        }

        public final String getArtifactIdentifier() {
            return artifactIdentifier;
        }

        public final void setArtifactIdentifier(String artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        @Override
        public final Builder artifactIdentifier(String artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
            return this;
        }

        public final Boolean getEncryptionDisabled() {
            return encryptionDisabled;
        }

        public final void setEncryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
        }

        @Override
        public final Builder encryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespaceType() {
            return namespaceType;
        }

        public final void setNamespaceType(String namespaceType) {
            this.namespaceType = namespaceType;
        }

        @Override
        public final Builder namespaceType(String namespaceType) {
            this.namespaceType = namespaceType;
            return this;
        }

        public final Boolean getOverrideArtifactName() {
            return overrideArtifactName;
        }

        public final void setOverrideArtifactName(Boolean overrideArtifactName) {
            this.overrideArtifactName = overrideArtifactName;
        }

        @Override
        public final Builder overrideArtifactName(Boolean overrideArtifactName) {
            this.overrideArtifactName = overrideArtifactName;
            return this;
        }

        public final String getPackaging() {
            return packaging;
        }

        public final void setPackaging(String packaging) {
            this.packaging = packaging;
        }

        @Override
        public final Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsCodeBuildProjectArtifactsDetails build() {
            return new AwsCodeBuildProjectArtifactsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
