/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a replica of a DynamoDB table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableReplica implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableReplica.Builder, AwsDynamoDbTableReplica> {
    private static final SdkField<List<AwsDynamoDbTableReplicaGlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<AwsDynamoDbTableReplicaGlobalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexes")
            .getter(getter(AwsDynamoDbTableReplica::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsDynamoDbTableReplicaGlobalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsDynamoDbTableReplicaGlobalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsMasterKeyId").getter(getter(AwsDynamoDbTableReplica::kmsMasterKeyId))
            .setter(setter(Builder::kmsMasterKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsMasterKeyId").build()).build();

    private static final SdkField<AwsDynamoDbTableProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField
            .<AwsDynamoDbTableProvisionedThroughputOverride> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedThroughputOverride")
            .getter(getter(AwsDynamoDbTableReplica::provisionedThroughputOverride))
            .setter(setter(Builder::provisionedThroughputOverride))
            .constructor(AwsDynamoDbTableProvisionedThroughputOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride")
                    .build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(AwsDynamoDbTableReplica::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> REPLICA_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicaStatus").getter(getter(AwsDynamoDbTableReplica::replicaStatus))
            .setter(setter(Builder::replicaStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatus").build()).build();

    private static final SdkField<String> REPLICA_STATUS_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicaStatusDescription").getter(getter(AwsDynamoDbTableReplica::replicaStatusDescription))
            .setter(setter(Builder::replicaStatusDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatusDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_SECONDARY_INDEXES_FIELD, KMS_MASTER_KEY_ID_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, REGION_NAME_FIELD,
            REPLICA_STATUS_FIELD, REPLICA_STATUS_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsDynamoDbTableReplicaGlobalSecondaryIndex> globalSecondaryIndexes;

    private final String kmsMasterKeyId;

    private final AwsDynamoDbTableProvisionedThroughputOverride provisionedThroughputOverride;

    private final String regionName;

    private final String replicaStatus;

    private final String replicaStatusDescription;

    private AwsDynamoDbTableReplica(BuilderImpl builder) {
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.regionName = builder.regionName;
        this.replicaStatus = builder.replicaStatus;
        this.replicaStatusDescription = builder.replicaStatusDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of global secondary indexes for the replica.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalSecondaryIndexes} method.
     * </p>
     * 
     * @return List of global secondary indexes for the replica.
     */
    public final List<AwsDynamoDbTableReplicaGlobalSecondaryIndex> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * <p>
     * The identifier of the KMS key that will be used for KMS encryption for the replica.
     * </p>
     * 
     * @return The identifier of the KMS key that will be used for KMS encryption for the replica.
     */
    public final String kmsMasterKeyId() {
        return kmsMasterKeyId;
    }

    /**
     * <p>
     * Replica-specific configuration for the provisioned throughput.
     * </p>
     * 
     * @return Replica-specific configuration for the provisioned throughput.
     */
    public final AwsDynamoDbTableProvisionedThroughputOverride provisionedThroughputOverride() {
        return provisionedThroughputOverride;
    }

    /**
     * <p>
     * The name of the Region where the replica is located.
     * </p>
     * 
     * @return The name of the Region where the replica is located.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The current status of the replica. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current status of the replica. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code>
     *         </p>
     *         </li>
     */
    public final String replicaStatus() {
        return replicaStatus;
    }

    /**
     * <p>
     * Detailed information about the replica status.
     * </p>
     * 
     * @return Detailed information about the replica status.
     */
    public final String replicaStatusDescription() {
        return replicaStatusDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(replicaStatus());
        hashCode = 31 * hashCode + Objects.hashCode(replicaStatusDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableReplica)) {
            return false;
        }
        AwsDynamoDbTableReplica other = (AwsDynamoDbTableReplica) obj;
        return hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes()
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes())
                && Objects.equals(kmsMasterKeyId(), other.kmsMasterKeyId())
                && Objects.equals(provisionedThroughputOverride(), other.provisionedThroughputOverride())
                && Objects.equals(regionName(), other.regionName()) && Objects.equals(replicaStatus(), other.replicaStatus())
                && Objects.equals(replicaStatusDescription(), other.replicaStatusDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableReplica")
                .add("GlobalSecondaryIndexes", hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null)
                .add("KmsMasterKeyId", kmsMasterKeyId()).add("ProvisionedThroughputOverride", provisionedThroughputOverride())
                .add("RegionName", regionName()).add("ReplicaStatus", replicaStatus())
                .add("ReplicaStatusDescription", replicaStatusDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        case "KmsMasterKeyId":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyId()));
        case "ProvisionedThroughputOverride":
            return Optional.ofNullable(clazz.cast(provisionedThroughputOverride()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "ReplicaStatus":
            return Optional.ofNullable(clazz.cast(replicaStatus()));
        case "ReplicaStatusDescription":
            return Optional.ofNullable(clazz.cast(replicaStatusDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableReplica, T> g) {
        return obj -> g.apply((AwsDynamoDbTableReplica) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableReplica> {
        /**
         * <p>
         * List of global secondary indexes for the replica.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        List of global secondary indexes for the replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<AwsDynamoDbTableReplicaGlobalSecondaryIndex> globalSecondaryIndexes);

        /**
         * <p>
         * List of global secondary indexes for the replica.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        List of global secondary indexes for the replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(AwsDynamoDbTableReplicaGlobalSecondaryIndex... globalSecondaryIndexes);

        /**
         * <p>
         * List of global secondary indexes for the replica.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #globalSecondaryIndexes(List<AwsDynamoDbTableReplicaGlobalSecondaryIndex>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(java.util.Collection<AwsDynamoDbTableReplicaGlobalSecondaryIndex>)
         */
        Builder globalSecondaryIndexes(Consumer<AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder>... globalSecondaryIndexes);

        /**
         * <p>
         * The identifier of the KMS key that will be used for KMS encryption for the replica.
         * </p>
         * 
         * @param kmsMasterKeyId
         *        The identifier of the KMS key that will be used for KMS encryption for the replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyId(String kmsMasterKeyId);

        /**
         * <p>
         * Replica-specific configuration for the provisioned throughput.
         * </p>
         * 
         * @param provisionedThroughputOverride
         *        Replica-specific configuration for the provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputOverride(AwsDynamoDbTableProvisionedThroughputOverride provisionedThroughputOverride);

        /**
         * <p>
         * Replica-specific configuration for the provisioned throughput.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsDynamoDbTableProvisionedThroughputOverride.Builder} avoiding the need to create one manually via
         * {@link AwsDynamoDbTableProvisionedThroughputOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableProvisionedThroughputOverride.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #provisionedThroughputOverride(AwsDynamoDbTableProvisionedThroughputOverride)}.
         * 
         * @param provisionedThroughputOverride
         *        a consumer that will call methods on {@link AwsDynamoDbTableProvisionedThroughputOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughputOverride(AwsDynamoDbTableProvisionedThroughputOverride)
         */
        default Builder provisionedThroughputOverride(
                Consumer<AwsDynamoDbTableProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return provisionedThroughputOverride(AwsDynamoDbTableProvisionedThroughputOverride.builder()
                    .applyMutation(provisionedThroughputOverride).build());
        }

        /**
         * <p>
         * The name of the Region where the replica is located.
         * </p>
         * 
         * @param regionName
         *        The name of the Region where the replica is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The current status of the replica. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicaStatus
         *        The current status of the replica. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaStatus(String replicaStatus);

        /**
         * <p>
         * Detailed information about the replica status.
         * </p>
         * 
         * @param replicaStatusDescription
         *        Detailed information about the replica status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaStatusDescription(String replicaStatusDescription);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsDynamoDbTableReplicaGlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList
                .getInstance();

        private String kmsMasterKeyId;

        private AwsDynamoDbTableProvisionedThroughputOverride provisionedThroughputOverride;

        private String regionName;

        private String replicaStatus;

        private String replicaStatusDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableReplica model) {
            globalSecondaryIndexes(model.globalSecondaryIndexes);
            kmsMasterKeyId(model.kmsMasterKeyId);
            provisionedThroughputOverride(model.provisionedThroughputOverride);
            regionName(model.regionName);
            replicaStatus(model.replicaStatus);
            replicaStatusDescription(model.replicaStatusDescription);
        }

        public final List<AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            List<AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder> result = AwsDynamoDbTableReplicaGlobalSecondaryIndexListCopier
                    .copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(
                Collection<AwsDynamoDbTableReplicaGlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = AwsDynamoDbTableReplicaGlobalSecondaryIndexListCopier
                    .copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<AwsDynamoDbTableReplicaGlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = AwsDynamoDbTableReplicaGlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(AwsDynamoDbTableReplicaGlobalSecondaryIndex... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(
                Consumer<AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> AwsDynamoDbTableReplicaGlobalSecondaryIndex.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getKmsMasterKeyId() {
            return kmsMasterKeyId;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final AwsDynamoDbTableProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return provisionedThroughputOverride != null ? provisionedThroughputOverride.toBuilder() : null;
        }

        public final void setProvisionedThroughputOverride(
                AwsDynamoDbTableProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build()
                    : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(
                AwsDynamoDbTableProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getReplicaStatus() {
            return replicaStatus;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        public final String getReplicaStatusDescription() {
            return replicaStatusDescription;
        }

        public final void setReplicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
        }

        @Override
        public final Builder replicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
            return this;
        }

        @Override
        public AwsDynamoDbTableReplica build() {
            return new AwsDynamoDbTableReplica(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
